//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_MODEL uint64

const (
	// Unknown gopro model.
	GOPRO_MODEL_UNKNOWN GOPRO_MODEL = 0
	// Hero 3+ Silver (HeroBus not supported by GoPro).
	GOPRO_MODEL_HERO_3_PLUS_SILVER GOPRO_MODEL = 1
	// Hero 3+ Black.
	GOPRO_MODEL_HERO_3_PLUS_BLACK GOPRO_MODEL = 2
	// Hero 4 Silver.
	GOPRO_MODEL_HERO_4_SILVER GOPRO_MODEL = 3
	// Hero 4 Black.
	GOPRO_MODEL_HERO_4_BLACK GOPRO_MODEL = 4
)

var value_to_label_GOPRO_MODEL = map[GOPRO_MODEL]string{
	GOPRO_MODEL_UNKNOWN:            "GOPRO_MODEL_UNKNOWN",
	GOPRO_MODEL_HERO_3_PLUS_SILVER: "GOPRO_MODEL_HERO_3_PLUS_SILVER",
	GOPRO_MODEL_HERO_3_PLUS_BLACK:  "GOPRO_MODEL_HERO_3_PLUS_BLACK",
	GOPRO_MODEL_HERO_4_SILVER:      "GOPRO_MODEL_HERO_4_SILVER",
	GOPRO_MODEL_HERO_4_BLACK:       "GOPRO_MODEL_HERO_4_BLACK",
}

var label_to_value_GOPRO_MODEL = map[string]GOPRO_MODEL{
	"GOPRO_MODEL_UNKNOWN":            GOPRO_MODEL_UNKNOWN,
	"GOPRO_MODEL_HERO_3_PLUS_SILVER": GOPRO_MODEL_HERO_3_PLUS_SILVER,
	"GOPRO_MODEL_HERO_3_PLUS_BLACK":  GOPRO_MODEL_HERO_3_PLUS_BLACK,
	"GOPRO_MODEL_HERO_4_SILVER":      GOPRO_MODEL_HERO_4_SILVER,
	"GOPRO_MODEL_HERO_4_BLACK":       GOPRO_MODEL_HERO_4_BLACK,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_MODEL) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_GOPRO_MODEL[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_MODEL) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_GOPRO_MODEL[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_MODEL(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_MODEL) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
