//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type PID_TUNING_AXIS uint64

const (
	PID_TUNING_ROLL    PID_TUNING_AXIS = 1
	PID_TUNING_PITCH   PID_TUNING_AXIS = 2
	PID_TUNING_YAW     PID_TUNING_AXIS = 3
	PID_TUNING_ACCZ    PID_TUNING_AXIS = 4
	PID_TUNING_STEER   PID_TUNING_AXIS = 5
	PID_TUNING_LANDING PID_TUNING_AXIS = 6
)

var value_to_label_PID_TUNING_AXIS = map[PID_TUNING_AXIS]string{
	PID_TUNING_ROLL:    "PID_TUNING_ROLL",
	PID_TUNING_PITCH:   "PID_TUNING_PITCH",
	PID_TUNING_YAW:     "PID_TUNING_YAW",
	PID_TUNING_ACCZ:    "PID_TUNING_ACCZ",
	PID_TUNING_STEER:   "PID_TUNING_STEER",
	PID_TUNING_LANDING: "PID_TUNING_LANDING",
}

var label_to_value_PID_TUNING_AXIS = map[string]PID_TUNING_AXIS{
	"PID_TUNING_ROLL":    PID_TUNING_ROLL,
	"PID_TUNING_PITCH":   PID_TUNING_PITCH,
	"PID_TUNING_YAW":     PID_TUNING_YAW,
	"PID_TUNING_ACCZ":    PID_TUNING_ACCZ,
	"PID_TUNING_STEER":   PID_TUNING_STEER,
	"PID_TUNING_LANDING": PID_TUNING_LANDING,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e PID_TUNING_AXIS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_PID_TUNING_AXIS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *PID_TUNING_AXIS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_PID_TUNING_AXIS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = PID_TUNING_AXIS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e PID_TUNING_AXIS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
