//autogenerated:yes
//nolint:revive,misspell,govet,lll
package marsh

// State report specific for eMotion Motion System by Bosch Rexroth B.V. Values applicable to motion platforms in general are sent in MOTION_PLATFORM_STATE with the same timestamp. Actuators are numbered in a clockwise direction when looking from above, starting from the front right. Actuator position is 0 when actuator is in mid-stroke.
type MessageRexrothMotionPlatform struct {
	// Timestamp (time since system boot).
	TimeBootMs uint32
	// Number of message as sent by the Motion System.
	FrameCount uint32
	// Motion Status variable as sent by the system.
	MotionStatus uint32
	// Error code extracted from motion status.
	ErrorCode uint8
	// Current actuator 1 position.
	Actuator1 float32
	// Current actuator 2 position.
	Actuator2 float32
	// Current actuator 3 position.
	Actuator3 float32
	// Current actuator 4 position.
	Actuator4 float32
	// Current actuator 5 position.
	Actuator5 float32
	// Current actuator 6 position.
	Actuator6 float32
	// X axis (surge) platform setpoint, positive forward.
	PlatformSetpointX float32
	// Y axis (sway) platform setpoint, positive right.
	PlatformSetpointY float32
	// Z axis (heave) platform setpoint, positive down.
	PlatformSetpointZ float32
	// Roll platform setpoint, positive right.
	PlatformSetpointRoll float32
	// Pitch platform setpoint, positive nose up.
	PlatformSetpointPitch float32
	// Yaw platform setpoint, positive right.
	PlatformSetpointYaw float32
	// X axis (surge) special effect setpoint, positive forward.
	EffectSetpointX float32
	// Y axis (sway) special effect setpoint, positive right.
	EffectSetpointY float32
	// Z axis (heave) special effect setpoint, positive down.
	EffectSetpointZ float32
	// Roll special effect setpoint, positive right.
	EffectSetpointRoll float32
	// Pitch special effect setpoint, positive nose up.
	EffectSetpointPitch float32
	// Yaw special effect setpoint, positive right.
	EffectSetpointYaw float32
}

// GetID implements the message.Message interface.
func (*MessageRexrothMotionPlatform) GetID() uint32 {
	return 52503
}
