// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/managedidentities/v1/managed_identities_service.proto

package managedidentitiespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the metadata of the long-running operation.
type OpMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,5,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,6,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OpMetadata) Reset() {
	*x = OpMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpMetadata) ProtoMessage() {}

func (x *OpMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpMetadata.ProtoReflect.Descriptor instead.
func (*OpMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{0}
}

func (x *OpMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OpMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OpMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OpMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OpMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OpMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request message for
// [CreateMicrosoftAdDomain][google.cloud.managedidentities.v1.CreateMicrosoftAdDomain]
type CreateMicrosoftAdDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource project name and location using the form:
	// `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The fully qualified domain name.
	// e.g. mydomain.myorganization.com, with the following restrictions:
	//
	//   - Must contain only lowercase letters, numbers, periods and hyphens.
	//   - Must start with a letter.
	//   - Must contain between 2-64 characters.
	//   - Must end with a number or a letter.
	//   - Must not start with period.
	//   - First segement length (mydomain form example above) shouldn't exceed
	//     15 chars.
	//   - The last segment cannot be fully numeric.
	//   - Must be unique within the customer project.
	DomainName string `protobuf:"bytes,2,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Required. A Managed Identity domain resource.
	Domain *Domain `protobuf:"bytes,3,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *CreateMicrosoftAdDomainRequest) Reset() {
	*x = CreateMicrosoftAdDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMicrosoftAdDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMicrosoftAdDomainRequest) ProtoMessage() {}

func (x *CreateMicrosoftAdDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMicrosoftAdDomainRequest.ProtoReflect.Descriptor instead.
func (*CreateMicrosoftAdDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMicrosoftAdDomainRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMicrosoftAdDomainRequest) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *CreateMicrosoftAdDomainRequest) GetDomain() *Domain {
	if x != nil {
		return x.Domain
	}
	return nil
}

// Request message for
// [ResetAdminPassword][google.cloud.managedidentities.v1.ResetAdminPassword]
type ResetAdminPasswordRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResetAdminPasswordRequest) Reset() {
	*x = ResetAdminPasswordRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetAdminPasswordRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetAdminPasswordRequest) ProtoMessage() {}

func (x *ResetAdminPasswordRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetAdminPasswordRequest.ProtoReflect.Descriptor instead.
func (*ResetAdminPasswordRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{2}
}

func (x *ResetAdminPasswordRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for
// [ResetAdminPassword][google.cloud.managedidentities.v1.ResetAdminPassword]
type ResetAdminPasswordResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A random password. See [admin][google.cloud.managedidentities.v1.Domain.admin] for more information.
	Password string `protobuf:"bytes,1,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *ResetAdminPasswordResponse) Reset() {
	*x = ResetAdminPasswordResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetAdminPasswordResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetAdminPasswordResponse) ProtoMessage() {}

func (x *ResetAdminPasswordResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetAdminPasswordResponse.ProtoReflect.Descriptor instead.
func (*ResetAdminPasswordResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{3}
}

func (x *ResetAdminPasswordResponse) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// Request message for
// [ListDomains][google.cloud.managedidentities.v1.ListDomains]
type ListDomainsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the domain location using the form:
	// `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If not specified, a default value of 1000 will be used.
	// Regardless of the page_size value, the response may include a partial list.
	// Callers should rely on a response's
	// [next_page_token][google.cloud.managedidentities.v1.ListDomainsResponse.next_page_token]
	// to determine if there are additional results to list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The `next_page_token` value returned from a previous ListDomainsRequest
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter specifying constraints of a list operation.
	// For example, `Domain.fqdn="mydomain.myorginization"`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results. See
	// [Sorting
	// order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
	// for more information.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDomainsRequest) Reset() {
	*x = ListDomainsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDomainsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDomainsRequest) ProtoMessage() {}

func (x *ListDomainsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDomainsRequest.ProtoReflect.Descriptor instead.
func (*ListDomainsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListDomainsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDomainsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDomainsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDomainsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDomainsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [ListDomains][google.cloud.managedidentities.v1.ListDomains]
type ListDomainsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Managed Identities Service domains in the project.
	Domains []*Domain `protobuf:"bytes,1,rep,name=domains,proto3" json:"domains,omitempty"`
	// A token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDomainsResponse) Reset() {
	*x = ListDomainsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDomainsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDomainsResponse) ProtoMessage() {}

func (x *ListDomainsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDomainsResponse.ProtoReflect.Descriptor instead.
func (*ListDomainsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListDomainsResponse) GetDomains() []*Domain {
	if x != nil {
		return x.Domains
	}
	return nil
}

func (x *ListDomainsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDomainsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [GetDomain][google.cloud.managedidentities.v1.GetDomain]
type GetDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDomainRequest) Reset() {
	*x = GetDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDomainRequest) ProtoMessage() {}

func (x *GetDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDomainRequest.ProtoReflect.Descriptor instead.
func (*GetDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{6}
}

func (x *GetDomainRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [UpdateDomain][google.cloud.managedidentities.v1.UpdateDomain]
type UpdateDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in this
	// field. The elements of the repeated paths field may only include
	// fields from [Domain][google.cloud.managedidentities.v1.Domain]:
	//   - `labels`
	//   - `locations`
	//   - `authorized_networks`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Domain message with updated fields. Only supported fields specified in
	// update_mask are updated.
	Domain *Domain `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *UpdateDomainRequest) Reset() {
	*x = UpdateDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDomainRequest) ProtoMessage() {}

func (x *UpdateDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDomainRequest.ProtoReflect.Descriptor instead.
func (*UpdateDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateDomainRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDomainRequest) GetDomain() *Domain {
	if x != nil {
		return x.Domain
	}
	return nil
}

// Request message for
// [DeleteDomain][google.cloud.managedidentities.v1.DeleteDomain]
type DeleteDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDomainRequest) Reset() {
	*x = DeleteDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDomainRequest) ProtoMessage() {}

func (x *DeleteDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDomainRequest.ProtoReflect.Descriptor instead.
func (*DeleteDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteDomainRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [AttachTrust][google.cloud.managedidentities.v1.AttachTrust]
type AttachTrustRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource domain name, project name and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust resource.
	Trust *Trust `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
}

func (x *AttachTrustRequest) Reset() {
	*x = AttachTrustRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachTrustRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachTrustRequest) ProtoMessage() {}

func (x *AttachTrustRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachTrustRequest.ProtoReflect.Descriptor instead.
func (*AttachTrustRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{9}
}

func (x *AttachTrustRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttachTrustRequest) GetTrust() *Trust {
	if x != nil {
		return x.Trust
	}
	return nil
}

// Request message for
// [ReconfigureTrust][google.cloud.managedidentities.v1.ReconfigureTrust]
type ReconfigureTrustRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource domain name, project name and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The fully-qualified target domain name which will be in trust with current
	// domain.
	TargetDomainName string `protobuf:"bytes,2,opt,name=target_domain_name,json=targetDomainName,proto3" json:"target_domain_name,omitempty"`
	// Required. The target DNS server IP addresses to resolve the remote domain involved
	// in the trust.
	TargetDnsIpAddresses []string `protobuf:"bytes,3,rep,name=target_dns_ip_addresses,json=targetDnsIpAddresses,proto3" json:"target_dns_ip_addresses,omitempty"`
}

func (x *ReconfigureTrustRequest) Reset() {
	*x = ReconfigureTrustRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReconfigureTrustRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReconfigureTrustRequest) ProtoMessage() {}

func (x *ReconfigureTrustRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReconfigureTrustRequest.ProtoReflect.Descriptor instead.
func (*ReconfigureTrustRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{10}
}

func (x *ReconfigureTrustRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReconfigureTrustRequest) GetTargetDomainName() string {
	if x != nil {
		return x.TargetDomainName
	}
	return ""
}

func (x *ReconfigureTrustRequest) GetTargetDnsIpAddresses() []string {
	if x != nil {
		return x.TargetDnsIpAddresses
	}
	return nil
}

// Request message for
// [DetachTrust][google.cloud.managedidentities.v1.DetachTrust]
type DetachTrustRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource domain name, project name, and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust resource to removed.
	Trust *Trust `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
}

func (x *DetachTrustRequest) Reset() {
	*x = DetachTrustRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetachTrustRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetachTrustRequest) ProtoMessage() {}

func (x *DetachTrustRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetachTrustRequest.ProtoReflect.Descriptor instead.
func (*DetachTrustRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{11}
}

func (x *DetachTrustRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DetachTrustRequest) GetTrust() *Trust {
	if x != nil {
		return x.Trust
	}
	return nil
}

// Request message for
// [ValidateTrust][google.cloud.managedidentities.v1.ValidateTrust]
type ValidateTrustRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource domain name, project name, and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust to validate trust state for.
	Trust *Trust `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
}

func (x *ValidateTrustRequest) Reset() {
	*x = ValidateTrustRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateTrustRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateTrustRequest) ProtoMessage() {}

func (x *ValidateTrustRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateTrustRequest.ProtoReflect.Descriptor instead.
func (*ValidateTrustRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP(), []int{12}
}

func (x *ValidateTrustRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValidateTrustRequest) GetTrust() *Trust {
	if x != nil {
		return x.Trust
	}
	return nil
}

var File_google_cloud_managedidentities_v1_managed_identities_service_proto protoreflect.FileDescriptor

var file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x02, 0x0a, 0x0a, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61,
	0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd7, 0x01, 0x0a, 0x1e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x41, 0x64, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x22, 0x60, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x64, 0x6d, 0x69,
	0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x38, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22,
	0xe0, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x07, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x46, 0x0a, 0x06,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x22, 0x5a, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x0a, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x9e, 0x01, 0x0a, 0x12, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x05,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x72, 0x75, 0x73,
	0x74, 0x22, 0xcd, 0x01, 0x0a, 0x17, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x64, 0x6e, 0x73, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x22, 0x9e, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x05, 0x74, 0x72, 0x75, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x72, 0x75,
	0x73, 0x74, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x0a, 0x27, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x43, 0x0a, 0x05, 0x74, 0x72, 0x75, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x32, 0xf2, 0x11, 0x0a, 0x18, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xf0, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x63,
	0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x41, 0x64, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f,
	0x66, 0x74, 0x41, 0x64, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x73, 0xca, 0x41, 0x14, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x0a, 0x4f,
	0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x06, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0xe8, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0xbf, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xda, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x14, 0x0a, 0x06,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x0a, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x12, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc,
	0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0xca, 0x41, 0x23, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x0a, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd0, 0x01,
	0x0a, 0x0b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x14, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x12, 0x0a, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0a, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x74, 0x72, 0x75, 0x73, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a,
	0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74,
	0x12, 0x85, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x95, 0x01, 0xca, 0x41, 0x14, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x0a,
	0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x6e, 0x73, 0x5f,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0xd0, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x74,
	0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74,
	0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b,
	0xca, 0x41, 0x14, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x0a, 0x4f, 0x70, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74,
	0x72, 0x75, 0x73, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x64, 0x65, 0x74, 0x61, 0x63, 0x68, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0xd6, 0x01, 0x0a, 0x0d,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x14, 0x0a, 0x06, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x12, 0x0a, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x72, 0x75, 0x73, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x72, 0x75, 0x73, 0x74, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x93, 0x02, 0x0a, 0x25, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x1d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x70, 0x62, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x4d,
	0x49, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescOnce sync.Once
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescData = file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDesc
)

func file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescGZIP() []byte {
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescData)
	})
	return file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDescData
}

var file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_managedidentities_v1_managed_identities_service_proto_goTypes = []any{
	(*OpMetadata)(nil),                     // 0: google.cloud.managedidentities.v1.OpMetadata
	(*CreateMicrosoftAdDomainRequest)(nil), // 1: google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest
	(*ResetAdminPasswordRequest)(nil),      // 2: google.cloud.managedidentities.v1.ResetAdminPasswordRequest
	(*ResetAdminPasswordResponse)(nil),     // 3: google.cloud.managedidentities.v1.ResetAdminPasswordResponse
	(*ListDomainsRequest)(nil),             // 4: google.cloud.managedidentities.v1.ListDomainsRequest
	(*ListDomainsResponse)(nil),            // 5: google.cloud.managedidentities.v1.ListDomainsResponse
	(*GetDomainRequest)(nil),               // 6: google.cloud.managedidentities.v1.GetDomainRequest
	(*UpdateDomainRequest)(nil),            // 7: google.cloud.managedidentities.v1.UpdateDomainRequest
	(*DeleteDomainRequest)(nil),            // 8: google.cloud.managedidentities.v1.DeleteDomainRequest
	(*AttachTrustRequest)(nil),             // 9: google.cloud.managedidentities.v1.AttachTrustRequest
	(*ReconfigureTrustRequest)(nil),        // 10: google.cloud.managedidentities.v1.ReconfigureTrustRequest
	(*DetachTrustRequest)(nil),             // 11: google.cloud.managedidentities.v1.DetachTrustRequest
	(*ValidateTrustRequest)(nil),           // 12: google.cloud.managedidentities.v1.ValidateTrustRequest
	(*timestamppb.Timestamp)(nil),          // 13: google.protobuf.Timestamp
	(*Domain)(nil),                         // 14: google.cloud.managedidentities.v1.Domain
	(*fieldmaskpb.FieldMask)(nil),          // 15: google.protobuf.FieldMask
	(*Trust)(nil),                          // 16: google.cloud.managedidentities.v1.Trust
	(*longrunningpb.Operation)(nil),        // 17: google.longrunning.Operation
}
var file_google_cloud_managedidentities_v1_managed_identities_service_proto_depIdxs = []int32{
	13, // 0: google.cloud.managedidentities.v1.OpMetadata.create_time:type_name -> google.protobuf.Timestamp
	13, // 1: google.cloud.managedidentities.v1.OpMetadata.end_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest.domain:type_name -> google.cloud.managedidentities.v1.Domain
	14, // 3: google.cloud.managedidentities.v1.ListDomainsResponse.domains:type_name -> google.cloud.managedidentities.v1.Domain
	15, // 4: google.cloud.managedidentities.v1.UpdateDomainRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 5: google.cloud.managedidentities.v1.UpdateDomainRequest.domain:type_name -> google.cloud.managedidentities.v1.Domain
	16, // 6: google.cloud.managedidentities.v1.AttachTrustRequest.trust:type_name -> google.cloud.managedidentities.v1.Trust
	16, // 7: google.cloud.managedidentities.v1.DetachTrustRequest.trust:type_name -> google.cloud.managedidentities.v1.Trust
	16, // 8: google.cloud.managedidentities.v1.ValidateTrustRequest.trust:type_name -> google.cloud.managedidentities.v1.Trust
	1,  // 9: google.cloud.managedidentities.v1.ManagedIdentitiesService.CreateMicrosoftAdDomain:input_type -> google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest
	2,  // 10: google.cloud.managedidentities.v1.ManagedIdentitiesService.ResetAdminPassword:input_type -> google.cloud.managedidentities.v1.ResetAdminPasswordRequest
	4,  // 11: google.cloud.managedidentities.v1.ManagedIdentitiesService.ListDomains:input_type -> google.cloud.managedidentities.v1.ListDomainsRequest
	6,  // 12: google.cloud.managedidentities.v1.ManagedIdentitiesService.GetDomain:input_type -> google.cloud.managedidentities.v1.GetDomainRequest
	7,  // 13: google.cloud.managedidentities.v1.ManagedIdentitiesService.UpdateDomain:input_type -> google.cloud.managedidentities.v1.UpdateDomainRequest
	8,  // 14: google.cloud.managedidentities.v1.ManagedIdentitiesService.DeleteDomain:input_type -> google.cloud.managedidentities.v1.DeleteDomainRequest
	9,  // 15: google.cloud.managedidentities.v1.ManagedIdentitiesService.AttachTrust:input_type -> google.cloud.managedidentities.v1.AttachTrustRequest
	10, // 16: google.cloud.managedidentities.v1.ManagedIdentitiesService.ReconfigureTrust:input_type -> google.cloud.managedidentities.v1.ReconfigureTrustRequest
	11, // 17: google.cloud.managedidentities.v1.ManagedIdentitiesService.DetachTrust:input_type -> google.cloud.managedidentities.v1.DetachTrustRequest
	12, // 18: google.cloud.managedidentities.v1.ManagedIdentitiesService.ValidateTrust:input_type -> google.cloud.managedidentities.v1.ValidateTrustRequest
	17, // 19: google.cloud.managedidentities.v1.ManagedIdentitiesService.CreateMicrosoftAdDomain:output_type -> google.longrunning.Operation
	3,  // 20: google.cloud.managedidentities.v1.ManagedIdentitiesService.ResetAdminPassword:output_type -> google.cloud.managedidentities.v1.ResetAdminPasswordResponse
	5,  // 21: google.cloud.managedidentities.v1.ManagedIdentitiesService.ListDomains:output_type -> google.cloud.managedidentities.v1.ListDomainsResponse
	14, // 22: google.cloud.managedidentities.v1.ManagedIdentitiesService.GetDomain:output_type -> google.cloud.managedidentities.v1.Domain
	17, // 23: google.cloud.managedidentities.v1.ManagedIdentitiesService.UpdateDomain:output_type -> google.longrunning.Operation
	17, // 24: google.cloud.managedidentities.v1.ManagedIdentitiesService.DeleteDomain:output_type -> google.longrunning.Operation
	17, // 25: google.cloud.managedidentities.v1.ManagedIdentitiesService.AttachTrust:output_type -> google.longrunning.Operation
	17, // 26: google.cloud.managedidentities.v1.ManagedIdentitiesService.ReconfigureTrust:output_type -> google.longrunning.Operation
	17, // 27: google.cloud.managedidentities.v1.ManagedIdentitiesService.DetachTrust:output_type -> google.longrunning.Operation
	17, // 28: google.cloud.managedidentities.v1.ManagedIdentitiesService.ValidateTrust:output_type -> google.longrunning.Operation
	19, // [19:29] is the sub-list for method output_type
	9,  // [9:19] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_managedidentities_v1_managed_identities_service_proto_init() }
func file_google_cloud_managedidentities_v1_managed_identities_service_proto_init() {
	if File_google_cloud_managedidentities_v1_managed_identities_service_proto != nil {
		return
	}
	file_google_cloud_managedidentities_v1_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*OpMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CreateMicrosoftAdDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ResetAdminPasswordRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ResetAdminPasswordResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ListDomainsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ListDomainsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GetDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*AttachTrustRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ReconfigureTrustRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*DetachTrustRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ValidateTrustRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_managedidentities_v1_managed_identities_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_managedidentities_v1_managed_identities_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_managedidentities_v1_managed_identities_service_proto_msgTypes,
	}.Build()
	File_google_cloud_managedidentities_v1_managed_identities_service_proto = out.File
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_rawDesc = nil
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_goTypes = nil
	file_google_cloud_managedidentities_v1_managed_identities_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ManagedIdentitiesServiceClient is the client API for ManagedIdentitiesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ManagedIdentitiesServiceClient interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a domain.
	DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes an AD trust.
	DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type managedIdentitiesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedIdentitiesServiceClient(cc grpc.ClientConnInterface) ManagedIdentitiesServiceClient {
	return &managedIdentitiesServiceClient{cc}
}

func (c *managedIdentitiesServiceClient) CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/CreateMicrosoftAdDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error) {
	out := new(ResetAdminPasswordResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ResetAdminPassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error) {
	out := new(ListDomainsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ListDomains", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error) {
	out := new(Domain)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/GetDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/UpdateDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DeleteDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/AttachTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ReconfigureTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DetachTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ValidateTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedIdentitiesServiceServer is the server API for ManagedIdentitiesService service.
type ManagedIdentitiesServiceServer interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(context.Context, *CreateMicrosoftAdDomainRequest) (*longrunningpb.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(context.Context, *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(context.Context, *ListDomainsRequest) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(context.Context, *GetDomainRequest) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(context.Context, *UpdateDomainRequest) (*longrunningpb.Operation, error)
	// Deletes a domain.
	DeleteDomain(context.Context, *DeleteDomainRequest) (*longrunningpb.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(context.Context, *AttachTrustRequest) (*longrunningpb.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(context.Context, *ReconfigureTrustRequest) (*longrunningpb.Operation, error)
	// Removes an AD trust.
	DetachTrust(context.Context, *DetachTrustRequest) (*longrunningpb.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(context.Context, *ValidateTrustRequest) (*longrunningpb.Operation, error)
}

// UnimplementedManagedIdentitiesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedManagedIdentitiesServiceServer struct {
}

func (*UnimplementedManagedIdentitiesServiceServer) CreateMicrosoftAdDomain(context.Context, *CreateMicrosoftAdDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMicrosoftAdDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ResetAdminPassword(context.Context, *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetAdminPassword not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ListDomains(context.Context, *ListDomainsRequest) (*ListDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDomains not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) GetDomain(context.Context, *GetDomainRequest) (*Domain, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) UpdateDomain(context.Context, *UpdateDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) DeleteDomain(context.Context, *DeleteDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) AttachTrust(context.Context, *AttachTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ReconfigureTrust(context.Context, *ReconfigureTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconfigureTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) DetachTrust(context.Context, *DetachTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ValidateTrust(context.Context, *ValidateTrustRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateTrust not implemented")
}

func RegisterManagedIdentitiesServiceServer(s *grpc.Server, srv ManagedIdentitiesServiceServer) {
	s.RegisterService(&_ManagedIdentitiesService_serviceDesc, srv)
}

func _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMicrosoftAdDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/CreateMicrosoftAdDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, req.(*CreateMicrosoftAdDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ResetAdminPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetAdminPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ResetAdminPassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, req.(*ResetAdminPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ListDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ListDomains",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, req.(*ListDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_GetDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/GetDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, req.(*GetDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_UpdateDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/UpdateDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, req.(*UpdateDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DeleteDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DeleteDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, req.(*DeleteDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_AttachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/AttachTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, req.(*AttachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ReconfigureTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReconfigureTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ReconfigureTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, req.(*ReconfigureTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DetachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DetachTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, req.(*DetachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ValidateTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ValidateTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, req.(*ValidateTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ManagedIdentitiesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.managedidentities.v1.ManagedIdentitiesService",
	HandlerType: (*ManagedIdentitiesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMicrosoftAdDomain",
			Handler:    _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler,
		},
		{
			MethodName: "ResetAdminPassword",
			Handler:    _ManagedIdentitiesService_ResetAdminPassword_Handler,
		},
		{
			MethodName: "ListDomains",
			Handler:    _ManagedIdentitiesService_ListDomains_Handler,
		},
		{
			MethodName: "GetDomain",
			Handler:    _ManagedIdentitiesService_GetDomain_Handler,
		},
		{
			MethodName: "UpdateDomain",
			Handler:    _ManagedIdentitiesService_UpdateDomain_Handler,
		},
		{
			MethodName: "DeleteDomain",
			Handler:    _ManagedIdentitiesService_DeleteDomain_Handler,
		},
		{
			MethodName: "AttachTrust",
			Handler:    _ManagedIdentitiesService_AttachTrust_Handler,
		},
		{
			MethodName: "ReconfigureTrust",
			Handler:    _ManagedIdentitiesService_ReconfigureTrust_Handler,
		},
		{
			MethodName: "DetachTrust",
			Handler:    _ManagedIdentitiesService_DetachTrust_Handler,
		},
		{
			MethodName: "ValidateTrust",
			Handler:    _ManagedIdentitiesService_ValidateTrust_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/managedidentities/v1/managed_identities_service.proto",
}
