//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Enumeration of battery types
type MAV_BATTERY_TYPE uint64

const (
	// Not specified.
	MAV_BATTERY_TYPE_UNKNOWN MAV_BATTERY_TYPE = 0
	// Lithium polymer battery
	MAV_BATTERY_TYPE_LIPO MAV_BATTERY_TYPE = 1
	// Lithium-iron-phosphate battery
	MAV_BATTERY_TYPE_LIFE MAV_BATTERY_TYPE = 2
	// Lithium-ION battery
	MAV_BATTERY_TYPE_LION MAV_BATTERY_TYPE = 3
	// Nickel metal hydride battery
	MAV_BATTERY_TYPE_NIMH MAV_BATTERY_TYPE = 4
)

var value_to_label_MAV_BATTERY_TYPE = map[MAV_BATTERY_TYPE]string{
	MAV_BATTERY_TYPE_UNKNOWN: "MAV_BATTERY_TYPE_UNKNOWN",
	MAV_BATTERY_TYPE_LIPO:    "MAV_BATTERY_TYPE_LIPO",
	MAV_BATTERY_TYPE_LIFE:    "MAV_BATTERY_TYPE_LIFE",
	MAV_BATTERY_TYPE_LION:    "MAV_BATTERY_TYPE_LION",
	MAV_BATTERY_TYPE_NIMH:    "MAV_BATTERY_TYPE_NIMH",
}

var label_to_value_MAV_BATTERY_TYPE = map[string]MAV_BATTERY_TYPE{
	"MAV_BATTERY_TYPE_UNKNOWN": MAV_BATTERY_TYPE_UNKNOWN,
	"MAV_BATTERY_TYPE_LIPO":    MAV_BATTERY_TYPE_LIPO,
	"MAV_BATTERY_TYPE_LIFE":    MAV_BATTERY_TYPE_LIFE,
	"MAV_BATTERY_TYPE_LION":    MAV_BATTERY_TYPE_LION,
	"MAV_BATTERY_TYPE_NIMH":    MAV_BATTERY_TYPE_NIMH,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_BATTERY_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_BATTERY_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_BATTERY_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_BATTERY_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_BATTERY_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_BATTERY_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
