
variable "ssh_host" {
  type = string
}

variable "ssh_password" {
  type = string
}

variable "ssh_username" {
  type = string
}

variable "version_tag" {
  type = string
}

source "null" "autogenerated_1" {
  communicator = "ssh"
  ssh_host     = "${var.ssh_host}"
  ssh_password = "${var.ssh_password}"
  ssh_username = "${var.ssh_username}"
}

build {
  sources = ["source.null.autogenerated_1"]

  provisioner "shell-local" {
    inline       = ["echo ${var.version_tag} > provision.txt"]
    pause_before = "20s"
  }

}
