/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the BucketUpdate type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &BucketUpdate{}

// BucketUpdate struct for BucketUpdate
type BucketUpdate struct {
	EdgeAccess EdgeAccessEnum `json:"edge_access"`
}

type _BucketUpdate BucketUpdate

// NewBucketUpdate instantiates a new BucketUpdate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBucketUpdate(edgeAccess EdgeAccessEnum) *BucketUpdate {
	this := BucketUpdate{}
	this.EdgeAccess = edgeAccess
	return &this
}

// NewBucketUpdateWithDefaults instantiates a new BucketUpdate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBucketUpdateWithDefaults() *BucketUpdate {
	this := BucketUpdate{}
	return &this
}

// GetEdgeAccess returns the EdgeAccess field value
func (o *BucketUpdate) GetEdgeAccess() EdgeAccessEnum {
	if o == nil {
		var ret EdgeAccessEnum
		return ret
	}

	return o.EdgeAccess
}

// GetEdgeAccessOk returns a tuple with the EdgeAccess field value
// and a boolean to check if the value has been set.
func (o *BucketUpdate) GetEdgeAccessOk() (*EdgeAccessEnum, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EdgeAccess, true
}

// SetEdgeAccess sets field value
func (o *BucketUpdate) SetEdgeAccess(v EdgeAccessEnum) {
	o.EdgeAccess = v
}

func (o BucketUpdate) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o BucketUpdate) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["edge_access"] = o.EdgeAccess
	return toSerialize, nil
}

func (o *BucketUpdate) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"edge_access",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBucketUpdate := _BucketUpdate{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBucketUpdate)

	if err != nil {
		return err
	}

	*o = BucketUpdate(varBucketUpdate)

	return err
}

type NullableBucketUpdate struct {
	value *BucketUpdate
	isSet bool
}

func (v NullableBucketUpdate) Get() *BucketUpdate {
	return v.value
}

func (v *NullableBucketUpdate) Set(val *BucketUpdate) {
	v.value = val
	v.isSet = true
}

func (v NullableBucketUpdate) IsSet() bool {
	return v.isSet
}

func (v *NullableBucketUpdate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBucketUpdate(val *BucketUpdate) *NullableBucketUpdate {
	return &NullableBucketUpdate{value: val, isSet: true}
}

func (v NullableBucketUpdate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBucketUpdate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


