// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySpan(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSpan()
				CopySpan(dest, src)
				assert.Equal(t, src, dest)
				CopySpan(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySpanSlice(t *testing.T) {
	src := []Span{}
	dest := []Span{}
	// Test CopyTo empty
	dest = CopySpanSlice(dest, src)
	assert.Equal(t, []Span{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanSlice()
	dest = CopySpanSlice(dest, src)
	assert.Equal(t, GenTestSpanSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanSlice(dest, src)
	assert.Equal(t, GenTestSpanSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanSlice(dest, []Span{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanSlice(dest, src)
	assert.Equal(t, GenTestSpanSlice(), dest)
}

func TestCopySpanPtrSlice(t *testing.T) {
	src := []*Span{}
	dest := []*Span{}
	// Test CopyTo empty
	dest = CopySpanPtrSlice(dest, src)
	assert.Equal(t, []*Span{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanPtrSlice()
	dest = CopySpanPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanPtrSlice(dest, []*Span{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSpanUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSpan()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSpan(), dest)
}

func TestMarshalAndUnmarshalJSONSpan(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSpan()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSpan(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSpanFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSpan() {
		t.Run(name, func(t *testing.T) {
			dest := NewSpan()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSpanUnknown(t *testing.T) {
	dest := NewSpan()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSpan(), dest)
}

func TestMarshalAndUnmarshalProtoSpan(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSpan()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSpan(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSpan(t *testing.T) {
	for name, src := range genTestEncodingValuesSpan() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.Span{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSpan()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSpan() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"TraceId/wrong_wire_type":                {0xc},
		"TraceId/missing_value":                  {0xa},
		"SpanId/wrong_wire_type":                 {0x14},
		"SpanId/missing_value":                   {0x12},
		"TraceState/wrong_wire_type":             {0x1c},
		"TraceState/missing_value":               {0x1a},
		"ParentSpanId/wrong_wire_type":           {0x24},
		"ParentSpanId/missing_value":             {0x22},
		"Flags/wrong_wire_type":                  {0x84, 0x1},
		"Flags/missing_value":                    {0x85, 0x1},
		"Name/wrong_wire_type":                   {0x2c},
		"Name/missing_value":                     {0x2a},
		"Kind/wrong_wire_type":                   {0x34},
		"Kind/missing_value":                     {0x30},
		"StartTimeUnixNano/wrong_wire_type":      {0x3c},
		"StartTimeUnixNano/missing_value":        {0x39},
		"EndTimeUnixNano/wrong_wire_type":        {0x44},
		"EndTimeUnixNano/missing_value":          {0x41},
		"Attributes/wrong_wire_type":             {0x4c},
		"Attributes/missing_value":               {0x4a},
		"DroppedAttributesCount/wrong_wire_type": {0x54},
		"DroppedAttributesCount/missing_value":   {0x50},
		"Events/wrong_wire_type":                 {0x5c},
		"Events/missing_value":                   {0x5a},
		"DroppedEventsCount/wrong_wire_type":     {0x64},
		"DroppedEventsCount/missing_value":       {0x60},
		"Links/wrong_wire_type":                  {0x6c},
		"Links/missing_value":                    {0x6a},
		"DroppedLinksCount/wrong_wire_type":      {0x74},
		"DroppedLinksCount/missing_value":        {0x70},
		"Status/wrong_wire_type":                 {0x7c},
		"Status/missing_value":                   {0x7a},
	}
}

func genTestEncodingValuesSpan() map[string]*Span {
	return map[string]*Span{
		"empty":                       NewSpan(),
		"TraceId/test":                {TraceId: *GenTestTraceID()},
		"SpanId/test":                 {SpanId: *GenTestSpanID()},
		"TraceState/test":             {TraceState: "test_tracestate"},
		"ParentSpanId/test":           {ParentSpanId: *GenTestSpanID()},
		"Flags/test":                  {Flags: uint32(13)},
		"Name/test":                   {Name: "test_name"},
		"Kind/test":                   {Kind: SpanKind(13)},
		"StartTimeUnixNano/test":      {StartTimeUnixNano: uint64(13)},
		"EndTimeUnixNano/test":        {EndTimeUnixNano: uint64(13)},
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
		"Events/test":                 {Events: []*SpanEvent{{}, GenTestSpanEvent()}},
		"DroppedEventsCount/test":     {DroppedEventsCount: uint32(13)},
		"Links/test":                  {Links: []*SpanLink{{}, GenTestSpanLink()}},
		"DroppedLinksCount/test":      {DroppedLinksCount: uint32(13)},
		"Status/test":                 {Status: *GenTestStatus()},
	}
}
