// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/routing/v2/routes_service.proto

package routingpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Routes_ComputeRoutes_FullMethodName      = "/google.maps.routing.v2.Routes/ComputeRoutes"
	Routes_ComputeRouteMatrix_FullMethodName = "/google.maps.routing.v2.Routes/ComputeRouteMatrix"
)

// RoutesClient is the client API for Routes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RoutesClient interface {
	// Returns the primary route along with optional alternate routes, given a set
	// of terminal and intermediate waypoints.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using URL parameter
	// `$fields` or `fields`, or by using an HTTP/gRPC header `X-Goog-FieldMask`
	// (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)). The value
	// is a comma separated list of field paths. See detailed documentation about
	// [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of Route-level duration, distance, and polyline (an example
	//
	// production setup):
	//
	//	`X-Goog-FieldMask:
	//	routes.duration,routes.distanceMeters,routes.polyline.encodedPolyline`
	//
	// Google discourage the use of the wildcard (`*`) response field mask, or
	// specifying the field mask at the top level (`routes`), because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need
	// in your production job ensures stable latency performance. We might add
	// more response fields in the future, and those new fields might require
	// extra computation time. If you select all fields, or if you select all
	// fields at the top level, then you might experience performance degradation
	// because any new field we add will be automatically included in the
	// response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRoutes(ctx context.Context, in *ComputeRoutesRequest, opts ...grpc.CallOption) (*ComputeRoutesResponse, error)
	// Takes in a list of origins and destinations and returns a stream containing
	// route information for each combination of origin and destination.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using the URL
	// parameter `$fields` or `fields`, or by using the HTTP/gRPC header
	// `X-Goog-FieldMask` (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)).
	// The value is a comma separated list of field paths. See this detailed
	// documentation about [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of route durations, distances, element status, condition, and
	//     element indices (an example production setup):
	//     `X-Goog-FieldMask:
	//     originIndex,destinationIndex,status,condition,distanceMeters,duration`
	//
	// It is critical that you include `status` in your field mask as otherwise
	// all messages will appear to be OK. Google discourages the use of the
	// wildcard (`*`) response field mask, because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need in your production job ensures
	// stable latency performance. We might add more response fields in the
	// future, and those new fields might require extra computation time. If you
	// select all fields, or if you select all fields at the top level, then you
	// might experience performance degradation because any new field we add will
	// be automatically included in the response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRouteMatrix(ctx context.Context, in *ComputeRouteMatrixRequest, opts ...grpc.CallOption) (Routes_ComputeRouteMatrixClient, error)
}

type routesClient struct {
	cc grpc.ClientConnInterface
}

func NewRoutesClient(cc grpc.ClientConnInterface) RoutesClient {
	return &routesClient{cc}
}

func (c *routesClient) ComputeRoutes(ctx context.Context, in *ComputeRoutesRequest, opts ...grpc.CallOption) (*ComputeRoutesResponse, error) {
	out := new(ComputeRoutesResponse)
	err := c.cc.Invoke(ctx, Routes_ComputeRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routesClient) ComputeRouteMatrix(ctx context.Context, in *ComputeRouteMatrixRequest, opts ...grpc.CallOption) (Routes_ComputeRouteMatrixClient, error) {
	stream, err := c.cc.NewStream(ctx, &Routes_ServiceDesc.Streams[0], Routes_ComputeRouteMatrix_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &routesComputeRouteMatrixClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Routes_ComputeRouteMatrixClient interface {
	Recv() (*RouteMatrixElement, error)
	grpc.ClientStream
}

type routesComputeRouteMatrixClient struct {
	grpc.ClientStream
}

func (x *routesComputeRouteMatrixClient) Recv() (*RouteMatrixElement, error) {
	m := new(RouteMatrixElement)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// RoutesServer is the server API for Routes service.
// All implementations should embed UnimplementedRoutesServer
// for forward compatibility
type RoutesServer interface {
	// Returns the primary route along with optional alternate routes, given a set
	// of terminal and intermediate waypoints.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using URL parameter
	// `$fields` or `fields`, or by using an HTTP/gRPC header `X-Goog-FieldMask`
	// (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)). The value
	// is a comma separated list of field paths. See detailed documentation about
	// [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of Route-level duration, distance, and polyline (an example
	//
	// production setup):
	//
	//	`X-Goog-FieldMask:
	//	routes.duration,routes.distanceMeters,routes.polyline.encodedPolyline`
	//
	// Google discourage the use of the wildcard (`*`) response field mask, or
	// specifying the field mask at the top level (`routes`), because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need
	// in your production job ensures stable latency performance. We might add
	// more response fields in the future, and those new fields might require
	// extra computation time. If you select all fields, or if you select all
	// fields at the top level, then you might experience performance degradation
	// because any new field we add will be automatically included in the
	// response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRoutes(context.Context, *ComputeRoutesRequest) (*ComputeRoutesResponse, error)
	// Takes in a list of origins and destinations and returns a stream containing
	// route information for each combination of origin and destination.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using the URL
	// parameter `$fields` or `fields`, or by using the HTTP/gRPC header
	// `X-Goog-FieldMask` (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)).
	// The value is a comma separated list of field paths. See this detailed
	// documentation about [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of route durations, distances, element status, condition, and
	//     element indices (an example production setup):
	//     `X-Goog-FieldMask:
	//     originIndex,destinationIndex,status,condition,distanceMeters,duration`
	//
	// It is critical that you include `status` in your field mask as otherwise
	// all messages will appear to be OK. Google discourages the use of the
	// wildcard (`*`) response field mask, because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need in your production job ensures
	// stable latency performance. We might add more response fields in the
	// future, and those new fields might require extra computation time. If you
	// select all fields, or if you select all fields at the top level, then you
	// might experience performance degradation because any new field we add will
	// be automatically included in the response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRouteMatrix(*ComputeRouteMatrixRequest, Routes_ComputeRouteMatrixServer) error
}

// UnimplementedRoutesServer should be embedded to have forward compatible implementations.
type UnimplementedRoutesServer struct {
}

func (UnimplementedRoutesServer) ComputeRoutes(context.Context, *ComputeRoutesRequest) (*ComputeRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeRoutes not implemented")
}
func (UnimplementedRoutesServer) ComputeRouteMatrix(*ComputeRouteMatrixRequest, Routes_ComputeRouteMatrixServer) error {
	return status.Errorf(codes.Unimplemented, "method ComputeRouteMatrix not implemented")
}

// UnsafeRoutesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RoutesServer will
// result in compilation errors.
type UnsafeRoutesServer interface {
	mustEmbedUnimplementedRoutesServer()
}

func RegisterRoutesServer(s grpc.ServiceRegistrar, srv RoutesServer) {
	s.RegisterService(&Routes_ServiceDesc, srv)
}

func _Routes_ComputeRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoutesServer).ComputeRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Routes_ComputeRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoutesServer).ComputeRoutes(ctx, req.(*ComputeRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Routes_ComputeRouteMatrix_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ComputeRouteMatrixRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RoutesServer).ComputeRouteMatrix(m, &routesComputeRouteMatrixServer{stream})
}

type Routes_ComputeRouteMatrixServer interface {
	Send(*RouteMatrixElement) error
	grpc.ServerStream
}

type routesComputeRouteMatrixServer struct {
	grpc.ServerStream
}

func (x *routesComputeRouteMatrixServer) Send(m *RouteMatrixElement) error {
	return x.ServerStream.SendMsg(m)
}

// Routes_ServiceDesc is the grpc.ServiceDesc for Routes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Routes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.routing.v2.Routes",
	HandlerType: (*RoutesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeRoutes",
			Handler:    _Routes_ComputeRoutes_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ComputeRouteMatrix",
			Handler:       _Routes_ComputeRouteMatrix_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/maps/routing/v2/routes_service.proto",
}
