// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: third_party/tink/proto/kms_envelope.proto

package kms_envelope_go_proto

import (
	tink_go_proto "github.com/tink-crypto/tink-go/v2/proto/tink_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type KmsEnvelopeAeadKeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	// The location of the KEK in a remote KMS.
	// With Google Cloud KMS, valid values have this format:
	// gcp-kms://projects/*/locations/*/keyRings/*/cryptoKeys/*.
	// With AWS KMS, valid values have this format:
	// aws-kms://arn:aws:kms:<region>:<account-id>:key/<key-id>
	KekUri string `protobuf:"bytes,1,opt,name=kek_uri,json=kekUri,proto3" json:"kek_uri,omitempty"`
	// Key template of the Data Encryption Key, e.g., AesCtrHmacAeadKeyFormat.
	// Required.
	DekTemplate *tink_go_proto.KeyTemplate `protobuf:"bytes,2,opt,name=dek_template,json=dekTemplate,proto3" json:"dek_template,omitempty"`
}

func (x *KmsEnvelopeAeadKeyFormat) Reset() {
	*x = KmsEnvelopeAeadKeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_kms_envelope_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KmsEnvelopeAeadKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsEnvelopeAeadKeyFormat) ProtoMessage() {}

func (x *KmsEnvelopeAeadKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_kms_envelope_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsEnvelopeAeadKeyFormat.ProtoReflect.Descriptor instead.
func (*KmsEnvelopeAeadKeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_kms_envelope_proto_rawDescGZIP(), []int{0}
}

func (x *KmsEnvelopeAeadKeyFormat) GetKekUri() string {
	if x != nil {
		return x.KekUri
	}
	return ""
}

func (x *KmsEnvelopeAeadKeyFormat) GetDekTemplate() *tink_go_proto.KeyTemplate {
	if x != nil {
		return x.DekTemplate
	}
	return nil
}

// There is no actual key material in the key.
type KmsEnvelopeAeadKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The key format also contains the params.
	Params *KmsEnvelopeAeadKeyFormat `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
}

func (x *KmsEnvelopeAeadKey) Reset() {
	*x = KmsEnvelopeAeadKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_kms_envelope_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KmsEnvelopeAeadKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsEnvelopeAeadKey) ProtoMessage() {}

func (x *KmsEnvelopeAeadKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_kms_envelope_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsEnvelopeAeadKey.ProtoReflect.Descriptor instead.
func (*KmsEnvelopeAeadKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_kms_envelope_proto_rawDescGZIP(), []int{1}
}

func (x *KmsEnvelopeAeadKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *KmsEnvelopeAeadKey) GetParams() *KmsEnvelopeAeadKeyFormat {
	if x != nil {
		return x.Params
	}
	return nil
}

var File_third_party_tink_proto_kms_envelope_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_kms_envelope_proto_rawDesc = []byte{
	0x0a, 0x29, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6b, 0x6d, 0x73, 0x5f, 0x65, 0x6e, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x1a,
	0x21, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69, 0x6e,
	0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x77, 0x0a, 0x18, 0x4b, 0x6d, 0x73, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x41, 0x65, 0x61, 0x64, 0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x17,
	0x0a, 0x07, 0x6b, 0x65, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x6b, 0x65, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x42, 0x0a, 0x0c, 0x64, 0x65, 0x6b, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0b,
	0x64, 0x65, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x74, 0x0a, 0x12, 0x4b,
	0x6d, 0x73, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x41, 0x65, 0x61, 0x64, 0x4b, 0x65,
	0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b,
	0x2e, 0x4b, 0x6d, 0x73, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x41, 0x65, 0x61, 0x64,
	0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x42, 0x57, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x35, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x67, 0x6f, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6b, 0x6d, 0x73, 0x5f, 0x65, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_third_party_tink_proto_kms_envelope_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_kms_envelope_proto_rawDescData = file_third_party_tink_proto_kms_envelope_proto_rawDesc
)

func file_third_party_tink_proto_kms_envelope_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_kms_envelope_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_kms_envelope_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_kms_envelope_proto_rawDescData)
	})
	return file_third_party_tink_proto_kms_envelope_proto_rawDescData
}

var file_third_party_tink_proto_kms_envelope_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_third_party_tink_proto_kms_envelope_proto_goTypes = []interface{}{
	(*KmsEnvelopeAeadKeyFormat)(nil),  // 0: google.crypto.tink.KmsEnvelopeAeadKeyFormat
	(*KmsEnvelopeAeadKey)(nil),        // 1: google.crypto.tink.KmsEnvelopeAeadKey
	(*tink_go_proto.KeyTemplate)(nil), // 2: google.crypto.tink.KeyTemplate
}
var file_third_party_tink_proto_kms_envelope_proto_depIdxs = []int32{
	2, // 0: google.crypto.tink.KmsEnvelopeAeadKeyFormat.dek_template:type_name -> google.crypto.tink.KeyTemplate
	0, // 1: google.crypto.tink.KmsEnvelopeAeadKey.params:type_name -> google.crypto.tink.KmsEnvelopeAeadKeyFormat
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_kms_envelope_proto_init() }
func file_third_party_tink_proto_kms_envelope_proto_init() {
	if File_third_party_tink_proto_kms_envelope_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_kms_envelope_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KmsEnvelopeAeadKeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_kms_envelope_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KmsEnvelopeAeadKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_kms_envelope_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_kms_envelope_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_kms_envelope_proto_depIdxs,
		MessageInfos:      file_third_party_tink_proto_kms_envelope_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_kms_envelope_proto = out.File
	file_third_party_tink_proto_kms_envelope_proto_rawDesc = nil
	file_third_party_tink_proto_kms_envelope_proto_goTypes = nil
	file_third_party_tink_proto_kms_envelope_proto_depIdxs = nil
}
