/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CRC16CCITTChecksumAlgorithm
extends ChecksumAlgorithm {
    public CRC16CCITTChecksumAlgorithm() {
        super("CRC-16-CCITT");
    }

    @Override
    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, ComputeChecksumsProvider provider) throws MemoryAccessException, CancelledException {
        if (provider == null) {
            this.updateChecksum(memory, addrSet, monitor, false, false);
        } else {
            this.updateChecksum(memory, addrSet, monitor, provider.isOnes(), provider.isTwos());
        }
    }

    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, boolean onesComp, boolean twosComp) throws MemoryAccessException, CancelledException {
        int entry = 0;
        int[] ccitt_table = new int[256];
        for (int i = 0; i < 256; ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            entry = i << 8;
            for (int j = 0; j < 8; ++j) {
                if ((entry & 0x8000) > 0) {
                    entry = entry << 1 ^ 0x1021;
                    continue;
                }
                entry <<= 1;
            }
            String value = Integer.toHexString(entry);
            if (value.length() > 4) {
                value = value.substring(value.length() - 4);
            }
            ccitt_table[i] = Integer.parseInt(value, 16);
        }
        long sum = 65535L;
        MemoryByteIterator it = new MemoryByteIterator(memory, addrSet);
        while (it.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            int b = it.next();
            int value = 0;
            value = b < 0 ? b + 256 : b;
            int element = (int)(sum >>> 8 & 0xFFL) ^ value;
            String loworder = Long.toHexString(sum);
            if (loworder.length() >= 2) {
                loworder = loworder.substring(loworder.length() - 2);
            }
            sum = (long)ccitt_table[element] ^ NumericUtilities.parseHexLong((String)loworder) << 8;
        }
        if (onesComp) {
            sum ^= 0xFFFFFFFFFFFFFFFFL;
        } else if (twosComp) {
            sum = -sum;
        }
        this.checksum = CRC16CCITTChecksumAlgorithm.toArray(sum, 2);
    }

    @Override
    public boolean supportsDecimal() {
        return true;
    }
}

