/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.FunctionUtils;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldStringInfo;
import ghidra.app.util.viewer.field.FunctionSignatureFieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.field.VariableTypeFieldFactory;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;

abstract class DataTypeLocationDescriptor
extends LocationDescriptor {
    protected DataType originalDataType;
    protected DataType baseDataType;
    protected String dataTypeName;

    DataTypeLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        this.originalDataType = this.getSourceDataType();
        this.homeAddress = location.getAddress();
        this.baseDataType = this.loadDataType();
        this.label = this.generateLabel();
        this.dataTypeName = this.getDataTypeName();
    }

    @Override
    public String getTypeName() {
        return this.dataTypeName;
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        this.findDataTypeReferences(accumulator, monitor);
    }

    protected abstract DataType getSourceDataType();

    protected abstract String generateLabel();

    protected abstract String getDataTypeName();

    protected DataType getBaseDataType() {
        return this.getSourceDataType();
    }

    private void findDataTypeReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        DataType currentDataType = this.getDataType();
        ReferenceUtils.findDataTypeReferences(accumulator, currentDataType, null, this.program, this.useDynamicSearching, monitor);
    }

    private DataType loadDataType() {
        if (this.baseDataType == null) {
            this.baseDataType = this.getBaseDataType();
        }
        return this.baseDataType;
    }

    protected DataType getDataType() {
        Data data;
        if (this.baseDataType instanceof Structure && (data = this.getData(this.getLocation())) != null) {
            return ReferenceUtils.getBaseDataType(data.getDataType());
        }
        return ReferenceUtils.getBaseDataType(this.baseDataType);
    }

    protected Data getData(ProgramLocation location) {
        Address address;
        Listing listing = this.program.getListing();
        Data data = listing.getDataContaining(address = location.getAddress());
        if (data != null) {
            return data.getComponent(location.getComponentPath());
        }
        return null;
    }

    @Override
    protected boolean domainObjectChanged(DomainObjectChangedEvent changeEvent) {
        block5: for (int i = 0; i < changeEvent.numRecords(); ++i) {
            DomainObjectChangeRecord domainObjectRecord = changeEvent.getChangeRecord(i);
            int eventType = domainObjectRecord.getEventType();
            switch (eventType) {
                case 152: {
                    ProgramChangeRecord changeRecord = (ProgramChangeRecord)domainObjectRecord;
                    Address functionAddress = changeRecord.getStart();
                    if (!this.referencesContain(functionAddress) || !this.functionContainsDataType(functionAddress)) continue block5;
                    return this.checkForAddressChange((DomainObjectChangeRecord)changeRecord);
                }
                case 4: 
                case 21: 
                case 23: 
                case 31: 
                case 41: 
                case 61: 
                case 151: 
                case 154: {
                    return this.checkForAddressChange(domainObjectRecord);
                }
                case 20: 
                case 30: 
                case 40: 
                case 60: 
                case 106: 
                case 110: 
                case 150: 
                case 153: {
                    if (this.modelFreshnessListener != null) {
                        this.modelFreshnessListener.stateChanged(new ChangeEvent(this));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean functionContainsDataType(Address functionAddress) {
        FunctionManager functionManager = this.program.getFunctionManager();
        Function function = functionManager.getFunctionAt(functionAddress);
        DataType currentDataType = this.getDataType();
        if (function != null) {
            List<Variable> allVariables = ReferenceUtils.getVariables(function, true);
            for (Variable variable : allVariables) {
                DataType variableDataType = variable.getDataType();
                if (!ReferenceUtils.getBaseDataType(variableDataType).isEquivalent(currentDataType)) continue;
                return true;
            }
            DataType returnType = function.getReturnType();
            if (ReferenceUtils.getBaseDataType(returnType).isEquivalent(currentDataType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (MnemonicFieldFactory.class.isAssignableFrom(fieldFactoryClass) && object instanceof Data) {
            Data data = (Data)object;
            DataType otherBaseDataType = ReferenceUtils.getBaseDataType(data.getDataType());
            if (otherBaseDataType.isEquivalent(this.baseDataType)) {
                Highlight[] dtHighlights = this.getMnemonicDataTypeHighlights(text, highlightColor);
                return dtHighlights;
            }
        } else if (MnemonicFieldFactory.class.isAssignableFrom(fieldFactoryClass) || OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass) || VariableTypeFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            String highlightText = this.getHighlightStringForDataTypeName(text);
            if (highlightText != null) {
                return new Highlight[]{new Highlight(0, highlightText.length() - 1, highlightColor)};
            }
        } else if (FunctionSignatureFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            FieldStringInfo[] parameterStringInfos;
            ArrayList<Highlight> list = new ArrayList<Highlight>();
            Function function = (Function)object;
            FieldStringInfo returnTypeStringInfo = FunctionUtils.getFunctionReturnTypeStringInfo(function, text);
            String returnTypeString = returnTypeStringInfo.getFieldString();
            if (this.label.equals(returnTypeString)) {
                int offset = returnTypeStringInfo.getOffset();
                list.add(new Highlight(offset, offset + returnTypeString.length() - 1, highlightColor));
            }
            for (FieldStringInfo info : parameterStringInfos = FunctionUtils.getFunctionParameterStringInfos(function, text)) {
                String paramString = info.getFieldString();
                String highlightText = this.getHighlightStringForParameterDeclaration(paramString);
                if (highlightText == null) continue;
                int offset = info.getOffset();
                int length = offset + highlightText.length() - 1;
                list.add(new Highlight(offset, length, highlightColor));
            }
            return list.toArray(new Highlight[list.size()]);
        }
        return this.EMPTY_HIGHLIGHTS;
    }

    protected Highlight[] getMnemonicDataTypeHighlights(String mnemonicText, Color highlightColor) {
        return new Highlight[]{new Highlight(0, mnemonicText.length() - 1, highlightColor)};
    }

    private String getHighlightStringForParameterDeclaration(String parameterDeclaration) {
        String[] paramParts = parameterDeclaration.split("\\s");
        String paramName = paramParts[0];
        if (this.label.equals(paramName)) {
            return paramName;
        }
        if (this.label.endsWith("*") && this.label.startsWith(paramName)) {
            if (paramParts.length == 1) {
                return paramName;
            }
            String variableName = paramParts[paramParts.length - 1];
            int variableNameOffset = parameterDeclaration.indexOf(variableName);
            if (this.label.length() > variableNameOffset) {
                return this.label.substring(0, variableNameOffset - 1);
            }
            return this.label;
        }
        return null;
    }

    private String getHighlightStringForDataTypeName(String listingDisplayText) {
        if (this.dataTypeName.equals(listingDisplayText)) {
            return listingDisplayText;
        }
        if (this.dataTypeName.endsWith("*") && this.dataTypeName.startsWith(listingDisplayText)) {
            return listingDisplayText;
        }
        if (listingDisplayText.startsWith(this.dataTypeName) && listingDisplayText.endsWith("*")) {
            return this.dataTypeName;
        }
        return null;
    }
}

