/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.DialogComponentProvider;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionListener;
import ghidra.app.util.OptionValidator;
import ghidra.app.util.OptionsEditorPanel;
import java.util.ArrayList;
import java.util.List;

public class OptionsDialog
extends DialogComponentProvider
implements OptionListener {
    private OptionsEditorPanel optionRenderer;
    private List<Option> options = new ArrayList<Option>();
    private boolean cancelled = false;
    private OptionValidator validator;

    public OptionsDialog(List<Option> originalOptions, OptionValidator validator, AddressFactoryService addressFactoryService) {
        super("Options");
        this.validator = validator;
        for (Option originalOption : originalOptions) {
            Option option = originalOption.copy();
            option.setOptionListener(this);
            this.options.add(option);
        }
        this.optionRenderer = new OptionsEditorPanel(this.options, addressFactoryService);
        this.addOKButton();
        this.addCancelButton();
        this.addWorkPanel(this.optionRenderer);
        this.setRememberSize(false);
    }

    @Override
    public void optionChanged(Option option) {
        String message = this.validator.validateOptions(this.options);
        if (message != null) {
            this.setStatusText(message);
            this.setOkEnabled(false);
        } else {
            this.setStatusText("");
            this.setOkEnabled(true);
        }
    }

    protected void okCallback() {
        this.close();
    }

    protected void cancelCallback() {
        this.cancelled = true;
        super.cancelCallback();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public void close() {
        super.close();
        for (Option option : this.options) {
            option.setOptionListener(null);
        }
    }

    public List<Option> getOptions() {
        return this.options;
    }
}

