/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.DataConverter;
import java.io.IOException;
import java.util.ArrayList;

public class ElfRelocationTable
implements ElfFileSection,
ByteArrayConverter {
    private ElfSectionHeader sectionToBeRelocated;
    private ElfSymbolTable symbolTable;
    private ElfSectionHeader relocTableSection;
    private long fileOffset;
    private long addrOffset;
    private long length;
    private long entrySize;
    private boolean addendTypeReloc;
    private GenericFactory factory;
    private ElfHeader elfHeader;
    private ElfRelocation[] relocs;

    static ElfRelocationTable createElfRelocationTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader relocTableSection, long fileOffset, long addrOffset, long length, long entrySize, boolean addendTypeReloc, ElfSymbolTable symbolTable, ElfSectionHeader sectionToBeRelocated) throws IOException {
        ElfRelocationTable elfRelocationTable = (ElfRelocationTable)reader.getFactory().create(ElfRelocationTable.class, new Object[0]);
        elfRelocationTable.initElfRelocationTable(reader, header, relocTableSection, fileOffset, addrOffset, length, entrySize, addendTypeReloc, symbolTable, sectionToBeRelocated);
        return elfRelocationTable;
    }

    private void initElfRelocationTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader relocTableSection, long fileOffset, long addrOffset, long length, long entrySize, boolean addendTypeReloc, ElfSymbolTable symbolTable, ElfSectionHeader sectionToBeRelocated) throws IOException {
        this.relocTableSection = relocTableSection;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        this.length = length;
        this.entrySize = entrySize;
        this.addendTypeReloc = addendTypeReloc;
        this.elfHeader = header;
        this.factory = reader.getFactory();
        this.sectionToBeRelocated = sectionToBeRelocated;
        this.symbolTable = symbolTable;
        long ptr = reader.getPointerIndex();
        reader.setPointerIndex(fileOffset);
        ArrayList<ElfRelocation> relocList = new ArrayList<ElfRelocation>();
        int nRelocs = (int)(length / entrySize);
        for (int relocationIndex = 0; relocationIndex < nRelocs; ++relocationIndex) {
            relocList.add(ElfRelocation.createElfRelocation(reader, header, relocationIndex, addendTypeReloc));
        }
        reader.setPointerIndex(ptr);
        this.relocs = new ElfRelocation[relocList.size()];
        relocList.toArray(this.relocs);
    }

    public boolean hasAddendRelocations() {
        return this.addendTypeReloc;
    }

    public ElfSectionHeader getSectionToBeRelocated() {
        return this.sectionToBeRelocated;
    }

    public ElfRelocation[] getRelocations() {
        return this.relocs;
    }

    public int getRelocationCount() {
        return this.relocs.length;
    }

    public ElfSymbolTable getAssociatedSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.relocs.length * this.relocs[0].sizeof()];
        int index = 0;
        for (int i = 0; i < this.relocs.length; ++i) {
            byte[] relocBytes = this.relocs[i].toBytes(dc);
            System.arraycopy(relocBytes, 0, bytes, index, relocBytes.length);
            index += relocBytes.length;
        }
        return bytes;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddressOffset() {
        return this.addrOffset;
    }

    public ElfSectionHeader getTableSectionHeader() {
        return this.relocTableSection;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public int getEntrySize() {
        return (int)this.entrySize;
    }

    @Override
    public DataType toDataType() {
        ElfRelocation relocationRepresentative = ElfRelocation.createElfRelocation(this.factory, this.elfHeader, -1, this.addendTypeReloc);
        DataType relocEntryDataType = relocationRepresentative.toDataType();
        return new ArrayDataType(relocEntryDataType, (int)(this.length / this.entrySize), (int)this.entrySize);
    }
}

