/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RelocSetPosition
extends Relocation {
    private int offset;

    RelocSetPosition(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xFC00) >> 10 & 0x3F;
        this.offset = (value & 0x3FF) << 16;
        this.offset |= reader.readNextShort() & 0xFFFF;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 40;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        Address offsetAddress = relocState.getSectionToBeRelocated().add((long)(this.offset & 0xFFFFFFFF));
        relocState.setRelocationAddress(offsetAddress);
    }
}

