/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DataTypeDropDownSelectionDataModel
implements DropDownTextFieldDataModel<DataType> {
    private final DataTypeManagerService dataTypeService;

    public DataTypeDropDownSelectionDataModel(ServiceProvider serviceProvider) {
        this.dataTypeService = this.getDataTypeService(serviceProvider);
    }

    public DataTypeDropDownSelectionDataModel(DataTypeManagerService dataTypeService) {
        this.dataTypeService = dataTypeService;
    }

    private DataTypeManagerService getDataTypeService(ServiceProvider serviceProvider) {
        DataTypeManagerService service = (DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class);
        if (service == null) {
            throw new AssertException("Unable to find required DataTypeManagerService.");
        }
        return service;
    }

    public ListCellRenderer<DataType> getListRenderer() {
        return new DataTypeDropDownRenderer();
    }

    public String getDescription(DataType value) {
        return ToolTipUtils.getToolTipText(value);
    }

    public String getDisplayText(DataType value) {
        return value.getName();
    }

    public List<DataType> getMatchingData(String searchText) {
        if (searchText == null || searchText.length() == 0) {
            return Collections.emptyList();
        }
        List<DataType> dataTypeList = DataTypeUtils.getStartsWithMatchingDataTypes(searchText, this.dataTypeService);
        return this.filterDataTypeList(dataTypeList);
    }

    private List<DataType> filterDataTypeList(List<DataType> dataTypeList) {
        ArrayList<DataType> matchingList = new ArrayList<DataType>(dataTypeList.size());
        for (DataType dataType : dataTypeList) {
            if (dataType instanceof Array) continue;
            matchingList.add(dataType);
        }
        return matchingList;
    }

    public int getIndexOfFirstMatchingEntry(List<DataType> data, String text) {
        text = DataTypeUtils.prepareSearchText(text);
        int lastPreferredMatchIndex = -1;
        int i = 0;
        while (i < data.size()) {
            DataType dataType = data.get(i);
            String dataTypeName = dataType.getName();
            if ((dataTypeName = dataTypeName.replaceAll(" ", "")).equals(text)) {
                return i;
            }
            if (!dataTypeName.equalsIgnoreCase(text)) {
                return lastPreferredMatchIndex;
            }
            lastPreferredMatchIndex = i++;
        }
        return -1;
    }

    private class DataTypeDropDownRenderer
    extends GListCellRenderer<DataType> {
        private DataTypeDropDownRenderer() {
        }

        protected String getItemText(DataType dt) {
            DataTypeManager dtm = dt.getDataTypeManager();
            String dtmName = dtm != null ? dtm.getName() : "";
            return dt.getName() + " - " + dtmName + dt.getPathName();
        }

        public Component getListCellRendererComponent(JList<? extends DataType> list, DataType value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            this.setIcon(DataTypeUtils.getIconForDataType(value, false));
            this.setVerticalAlignment(1);
            return this;
        }
    }
}

