/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ImproperUseException;
import ghidra.app.util.headless.HeadlessAnalyzer;
import ghidra.framework.model.DomainFolder;
import ghidra.util.InvalidNameException;
import java.io.IOException;
import java.util.List;

public abstract class HeadlessScript
extends GhidraScript {
    private HeadlessAnalyzer headless = null;
    private HeadlessContinuationOption currentOption = HeadlessContinuationOption.CONTINUE;
    private HeadlessContinuationOption scriptSetOption = null;
    private boolean runningInnerScript = false;

    private void setRunningInnerScript(boolean b) {
        this.runningInnerScript = b;
    }

    void setHeadlessInstance(HeadlessAnalyzer ha) {
        this.headless = ha;
    }

    void setInitialContinuationOption(HeadlessContinuationOption option) {
        this.currentOption = option;
    }

    HeadlessContinuationOption getContinuationOption() {
        return this.currentOption;
    }

    private void checkHeadlessStatus() throws ImproperUseException {
        if (this.headless == null || !this.isRunningHeadless()) {
            throw new ImproperUseException("This method can only be used in the headless case!");
        }
    }

    public void storeHeadlessValue(String key, Object value) throws ImproperUseException {
        this.checkHeadlessStatus();
        this.headless.addVariableToStorage(key, value);
    }

    public Object getStoredHeadlessValue(String key) throws ImproperUseException {
        this.checkHeadlessStatus();
        return this.headless.getVariableFromStorage(key);
    }

    public boolean headlessStorageContainsKey(String key) throws ImproperUseException {
        this.checkHeadlessStatus();
        return this.headless.storageContainsKey(key);
    }

    public void setHeadlessContinuationOption(HeadlessContinuationOption option) {
        this.scriptSetOption = option;
    }

    public HeadlessContinuationOption getHeadlessContinuationOption() {
        if (this.scriptSetOption == null) {
            return HeadlessContinuationOption.CONTINUE;
        }
        return this.scriptSetOption;
    }

    public void enableHeadlessAnalysis(boolean b) throws ImproperUseException {
        this.checkHeadlessStatus();
        this.headless.getOptions().enableAnalysis(b);
    }

    public boolean isHeadlessAnalysisEnabled() throws ImproperUseException {
        this.checkHeadlessStatus();
        return this.headless.getOptions().analyze;
    }

    public boolean isImporting() throws ImproperUseException {
        this.checkHeadlessStatus();
        return !this.headless.getOptions().runScriptsNoImport;
    }

    public void setHeadlessImportDirectory(String importDir) throws ImproperUseException, IOException, InvalidNameException {
        this.checkHeadlessStatus();
        if (!this.headless.getOptions().runScriptsNoImport) {
            DomainFolder saveFolder = null;
            if (importDir != null) {
                if (!((String)importDir).startsWith("/")) {
                    importDir = "/" + (String)importDir;
                }
                if (!((String)importDir).endsWith("/")) {
                    importDir = (String)importDir + "/";
                }
                saveFolder = this.headless.getDomainFolder((String)importDir, true);
            }
            this.headless.setSaveFolder(saveFolder);
        }
    }

    public boolean analysisTimeoutOccurred() throws ImproperUseException {
        this.checkHeadlessStatus();
        return this.headless.checkAnalysisTimedOut();
    }

    @Override
    public void runScript(String scriptName, String[] scriptArguments, GhidraState scriptState) throws Exception {
        boolean isHeadlessScript = false;
        if (this.scriptSetOption != null) {
            this.resolveContinuationOptionWith(this.scriptSetOption);
            this.scriptSetOption = null;
        }
        List<ResourceFile> dirs = GhidraScriptUtil.getScriptSourceDirectories();
        for (ResourceFile dir : dirs) {
            ResourceFile scriptSource = new ResourceFile(dir, scriptName);
            if (!scriptSource.exists()) continue;
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider(scriptSource);
            if (provider == null) {
                throw new IOException("Attempting to run subscript '" + scriptName + "': unable to run this script type.");
            }
            GhidraScript script = provider.getScriptInstance(scriptSource, this.writer);
            boolean bl = isHeadlessScript = script instanceof HeadlessScript;
            if (this.potentialPropertiesFileLocs.size() > 0) {
                script.setPotentialPropertiesFileLocations(this.potentialPropertiesFileLocs);
            }
            if (scriptState == this.state) {
                this.updateStateFromVariables();
            }
            if (isHeadlessScript) {
                ((HeadlessScript)script).setHeadlessInstance(this.headless);
                ((HeadlessScript)script).setRunningInnerScript(true);
            }
            script.setScriptArgs(scriptArguments);
            script.execute(scriptState, this.monitor, this.writer);
            if (scriptState == this.state) {
                this.loadVariablesFromState();
            }
            if (isHeadlessScript) {
                HeadlessContinuationOption innerScriptOpt = ((HeadlessScript)script).getHeadlessContinuationOption();
                if (innerScriptOpt != null) {
                    this.resolveContinuationOptionWith(innerScriptOpt);
                }
                ((HeadlessScript)script).setRunningInnerScript(false);
            }
            return;
        }
        throw new IllegalArgumentException("Script does not exist: " + scriptName);
    }

    @Override
    public void cleanup(boolean success) {
        this.resolveContinuationOption();
        if (!this.runningInnerScript) {
            this.scriptSetOption = null;
        }
    }

    private void resolveContinuationOption() {
        this.resolveContinuationOptionWith(this.scriptSetOption);
    }

    private void resolveContinuationOptionWith(HeadlessContinuationOption opt) {
        if (opt == null) {
            return;
        }
        block0 : switch (this.currentOption) {
            case CONTINUE: {
                this.currentOption = opt;
                break;
            }
            case CONTINUE_THEN_DELETE: {
                switch (opt) {
                    case ABORT: 
                    case ABORT_AND_DELETE: {
                        this.currentOption = HeadlessContinuationOption.ABORT_AND_DELETE;
                        break block0;
                    }
                }
                break;
            }
            case ABORT_AND_DELETE: {
                break;
            }
        }
    }

    public static enum HeadlessContinuationOption {
        CONTINUE,
        CONTINUE_THEN_DELETE,
        ABORT_AND_DELETE,
        ABORT;

    }
}

