/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.diff.DiffApplySettingsOptionManager;
import ghidra.app.plugin.core.diff.DiffApplySettingsProvider;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.ResourceManager;

class SaveApplySettingsAction
extends DockingAction {
    private static final String ACTION_NAME = "Save Default Diff Apply Settings";
    private static final String GROUP_NAME = "DEFAULTS";
    private static final String DESCRIPTION = "Save Current Diff Apply Settings As The Default.";
    private DiffApplySettingsProvider settingsProvider;
    private DiffApplySettingsOptionManager settingsOptionMgr;

    SaveApplySettingsAction(DiffApplySettingsProvider settingsProvider, DiffApplySettingsOptionManager settingsOptionMgr) {
        super(ACTION_NAME, settingsProvider.getPlugin().getName());
        this.settingsProvider = settingsProvider;
        this.settingsOptionMgr = settingsOptionMgr;
        this.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/disk.png"), GROUP_NAME));
        this.setEnabled(true);
        this.setDescription(DESCRIPTION);
        this.setHelpLocation(new HelpLocation("Diff", ACTION_NAME));
    }

    public boolean isEnabledForContext(ActionContext context) {
        JComponent applySettingsComponent;
        Object contextObject = context.getContextObject();
        return contextObject == (applySettingsComponent = this.settingsProvider.getComponent());
    }

    public void actionPerformed(ActionContext context) {
        this.settingsOptionMgr.saveDefaultApplyFilter(this.settingsProvider.getApplyFilter());
        this.settingsProvider.getPlugin().getTool().setStatusInfo("Diff Apply Settings have been saved to the tool as the new defaults.");
    }
}

