/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.util.painting;

import ghidra.docking.util.painting.Graphics2DWrapper;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import javax.swing.RepaintManager;
import sun.awt.image.SurfaceManager;

public class GRepaintManager
extends RepaintManager {
    private VolatileImageWrapper imageWrapper = new VolatileImageWrapper();

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        Image image = super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        if (!(image instanceof VolatileImage)) {
            Msg.debug((Object)this, (Object)("Cannot install Graphics2D color inverter.  Non-volatile image found: " + image.getClass().getName()));
            return image;
        }
        this.imageWrapper.setImage((VolatileImage)image);
        return this.imageWrapper;
    }

    private class VolatileImageWrapper
    extends VolatileImage {
        private Graphics2DWrapper wrapper = new Graphics2DWrapper();
        private VolatileImage image = this;

        private VolatileImageWrapper() {
        }

        void setImage(VolatileImage image) {
            this.image = image;
            SurfaceManager manager = SurfaceManager.getManager(image);
            SurfaceManager.setManager(this, manager);
        }

        @Override
        public Graphics getGraphics() {
            Graphics g = this.image.getGraphics();
            this.wrapper.setDelegate((Graphics2D)g);
            return this.wrapper;
        }

        @Override
        public BufferedImage getSnapshot() {
            return this.image.getSnapshot();
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public Graphics2D createGraphics() {
            return this.image.createGraphics();
        }

        @Override
        public int validate(GraphicsConfiguration gc) {
            return this.image.validate(gc);
        }

        @Override
        public boolean contentsLost() {
            return this.image.contentsLost();
        }

        @Override
        public ImageCapabilities getCapabilities() {
            return this.image.getCapabilities();
        }

        @Override
        public int getTransparency() {
            if (this.image == null) {
                return super.getTransparency();
            }
            return this.image.getTransparency();
        }

        @Override
        public int getWidth(ImageObserver observer) {
            return this.image.getWidth(observer);
        }

        public int hashCode() {
            return this.image.hashCode();
        }

        @Override
        public int getHeight(ImageObserver observer) {
            return this.image.getHeight(observer);
        }

        @Override
        public ImageProducer getSource() {
            return this.image.getSource();
        }

        public boolean equals(Object obj) {
            return this.image.equals(obj);
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            return this.image.getProperty(name, observer);
        }

        @Override
        public Image getScaledInstance(int width, int height, int hints) {
            return this.image.getScaledInstance(width, height, hints);
        }

        @Override
        public void flush() {
            this.image.flush();
        }

        public String toString() {
            return this.image.toString();
        }

        @Override
        public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
            return this.image.getCapabilities(gc);
        }

        @Override
        public void setAccelerationPriority(float priority) {
            this.image.setAccelerationPriority(priority);
        }

        @Override
        public float getAccelerationPriority() {
            return this.image.getAccelerationPriority();
        }
    }
}

