/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;

class RttiUtil {
    static final String CONST_PREFIX = "const ";

    private RttiUtil() {
    }

    static Symbol createSymbolFromDemangledType(Program program, Address rttiAddress, TypeDescriptorModel typeDescriptorModel, String rttiSuffix) {
        Symbol[] symbols;
        Symbol matchingSymbol;
        rttiSuffix = SymbolUtilities.replaceInvalidChars((String)rttiSuffix, (boolean)true);
        Namespace classNamespace = typeDescriptorModel.getDescriptorAsNamespace();
        String refType = typeDescriptorModel.getRefType();
        boolean makeClass = "class".equals(refType) || "struct".equals(refType);
        SymbolTable symbolTable = program.getSymbolTable();
        if (makeClass && classNamespace != null && !(classNamespace instanceof GhidraClass)) {
            try {
                classNamespace = NamespaceUtils.convertNamespaceToClass((Namespace)classNamespace);
            }
            catch (InvalidInputException iie) {
                Msg.error(RttiUtil.class, (Object)("Unable to convert namespace to class for namespace " + classNamespace + "."), (Throwable)iie);
            }
        }
        if ((matchingSymbol = symbolTable.getSymbol(rttiSuffix, rttiAddress, classNamespace)) != null) {
            return matchingSymbol;
        }
        for (Symbol symbol : symbols = symbolTable.getSymbols(rttiAddress)) {
            String name = symbol.getName();
            if (!name.contains(rttiSuffix)) continue;
            return symbol;
        }
        try {
            return symbolTable.createLabel(rttiAddress, rttiSuffix, classNamespace, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            Msg.error(RttiUtil.class, (Object)("Unable to create label for " + rttiSuffix + " at " + rttiAddress + "."), (Throwable)e);
            return null;
        }
    }

    static int getVfTableCount(Program program, Address vfTableBaseAddress) {
        Address referencedAddress;
        Memory memory = program.getMemory();
        MemoryBlock textBlock = memory.getBlock(".text");
        AddressSetView initializedAddresses = memory.getLoadedAndInitializedAddressSet();
        PseudoDisassembler pseudoDisassembler = new PseudoDisassembler(program);
        int tableSize = 0;
        Address currentVfPointerAddress = vfTableBaseAddress;
        int defaultPointerSize = program.getDefaultPointerSize();
        while ((referencedAddress = MSDataTypeUtils.getAbsoluteAddress((Program)program, (Address)currentVfPointerAddress)) != null && referencedAddress.getOffset() != 0L && initializedAddresses.contains(referencedAddress) && (textBlock == null || textBlock.equals(memory.getBlock(referencedAddress))) && pseudoDisassembler.isValidSubroutine(referencedAddress, true)) {
            ++tableSize;
            currentVfPointerAddress = currentVfPointerAddress.add((long)defaultPointerSize);
        }
        return tableSize;
    }

    static String getDescriptorTypeNamespace(TypeDescriptorModel rtti0Model) {
        String descriptorTypeNamespace = rtti0Model.getDescriptorTypeNamespace();
        if (descriptorTypeNamespace == null) {
            descriptorTypeNamespace = "";
        }
        return descriptorTypeNamespace;
    }
}

