/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import java.awt.event.MouseEvent;

public interface VisualGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>> {
    default public VisualizationViewer<V, E> getViewer(MouseEvent e) {
        GraphViewer<V, E> viewer = this.getGraphViewer(e);
        return viewer;
    }

    default public GraphViewer<V, E> getGraphViewer(MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        if (viewer instanceof SatelliteGraphViewer) {
            return (GraphViewer)((SatelliteGraphViewer)viewer).getMaster();
        }
        if (viewer instanceof GraphViewer) {
            GraphViewer graphViewer = (GraphViewer)viewer;
            return graphViewer;
        }
        throw new IllegalStateException("Do not have a master or satellite GraphViewer");
    }

    default public SatelliteGraphViewer<V, E> getSatelliteGraphViewer(MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        if (viewer instanceof SatelliteGraphViewer) {
            return (SatelliteGraphViewer)viewer;
        }
        throw new IllegalStateException("Do not have a satellite GraphViewer");
    }

    default public VisualGraphViewUpdater<V, E> getViewUpdater(MouseEvent e) {
        GraphViewer<V, E> viewer = this.getGraphViewer(e);
        VisualGraphViewUpdater<V, E> updater = viewer.getViewUpdater();
        return updater;
    }

    default public VisualGraphViewUpdater<V, E> getViewUpdater(GraphViewer<V, E> viewer) {
        VisualGraphViewUpdater<V, E> updater = viewer.getViewUpdater();
        return updater;
    }

    default public void dispose() {
    }
}

