/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import generic.jar.ResourceFile;
import ghidra.app.util.demangler.DemangledAddressTable;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.gnu.GnuDemanglerNativeProcess;
import ghidra.app.util.demangler.gnu.GnuDemanglerParser;
import ghidra.framework.Application;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.IOException;

public class GnuDemangler
implements Demangler {
    private static final String DWARF_REF = "DW.ref.";
    private static final String GLOBAL_PREFIX = "_GLOBAL_";

    public boolean canDemangle(Program program) {
        String executableFormat = program.getExecutableFormat();
        if (this.isELF(executableFormat) || this.isMacho(executableFormat)) {
            return true;
        }
        CompilerSpec compilerSpec = program.getCompilerSpec();
        return compilerSpec.getCompilerSpecID().getIdAsString().toLowerCase().indexOf("windows") == -1;
    }

    public DemangledObject demangle(String mangled, boolean demangleOnlyKnownPatterns) throws DemangledException {
        if (this.skip(mangled, demangleOnlyKnownPatterns)) {
            return null;
        }
        String originalMangled = mangled;
        String globalPrefix = null;
        if (mangled.startsWith(GLOBAL_PREFIX)) {
            int index = mangled.indexOf("_Z");
            if (index > 0) {
                globalPrefix = mangled.substring(0, index);
                mangled = mangled.substring(index);
            }
        } else if (mangled.startsWith("__Z")) {
            mangled = mangled.substring(1);
        }
        boolean isDwarf = false;
        if (mangled.startsWith(DWARF_REF)) {
            int len = DWARF_REF.length();
            mangled = mangled.substring(len);
            isDwarf = true;
        }
        try {
            GnuDemanglerNativeProcess process = GnuDemanglerNativeProcess.getDemanglerNativeProcess();
            String demangled = process.demangle(mangled).trim();
            if (mangled.equals(demangled) || demangled.length() == 0) {
                throw new DemangledException(true);
            }
            DemangledObject demangledObject = this.parse(mangled, process, demangled, demangleOnlyKnownPatterns);
            if (demangledObject == null) {
                return demangledObject;
            }
            if (globalPrefix != null) {
                DemangledFunction dfunc = new DemangledFunction(globalPrefix + demangledObject.getName());
                dfunc.setNamespace(demangledObject.getNamespace());
                demangledObject = dfunc;
            } else {
                demangledObject.setSignature(demangled);
            }
            demangledObject.setOriginalMangled(originalMangled);
            if (isDwarf) {
                DemangledAddressTable dat = new DemangledAddressTable((String)null, 1);
                dat.setSpecialPrefix("DWARF Debug ");
                dat.setName(demangledObject.getName());
                dat.setNamespace(demangledObject.getNamespace());
                dat.setOriginalMangled(originalMangled);
                return dat;
            }
            return demangledObject;
        }
        catch (IOException e) {
            if (e.getMessage().endsWith("14001")) {
                ResourceFile installationDir = Application.getInstallationDirectory();
                throw new DemangledException("Missing runtime libraries. Please install " + installationDir + File.separatorChar + "support" + File.separatorChar + "install_windows_runtime_libraries.exe.");
            }
            throw new DemangledException((Exception)e);
        }
    }

    private boolean skip(String mangled, boolean demangleOnlyKnownPatterns) {
        if (mangled.indexOf("@") > 0) {
            return true;
        }
        if (mangled.startsWith("___")) {
            return true;
        }
        if (!demangleOnlyKnownPatterns) {
            return false;
        }
        if (mangled.startsWith("_Z")) {
            return false;
        }
        if (mangled.startsWith("__Z")) {
            return false;
        }
        if (mangled.startsWith("h__")) {
            return false;
        }
        if (mangled.startsWith("?")) {
            return false;
        }
        return !this.isGnu2Or3Pattern(mangled);
    }

    private DemangledObject parse(String mangled, GnuDemanglerNativeProcess process, String demangled, boolean demangleOnlyKnownPatterns) {
        if (demangleOnlyKnownPatterns && !this.isMangledString(mangled, demangled)) {
            return null;
        }
        GnuDemanglerParser parser = new GnuDemanglerParser(process);
        DemangledObject demangledObject = parser.parse(mangled, demangled);
        return demangledObject;
    }

    private boolean isMangledString(String mangled, String demangled) {
        return !this.isInvalidDoubleUnderscoreString(mangled, demangled);
    }

    private boolean isInvalidDoubleUnderscoreString(String mangled, String demangled) {
        int index = mangled.indexOf("__");
        if (index == -1) {
            return false;
        }
        String leadingText = mangled.substring(0, index);
        return demangled.contains(leadingText);
    }

    private boolean isGnu2Or3Pattern(String mangled) {
        return mangled.startsWith("_GLOBAL_.I.") || mangled.startsWith("_GLOBAL_.D.") || mangled.startsWith("_GLOBAL__I__Z") || mangled.startsWith("_GLOBAL__D__Z");
    }

    private boolean isELF(String executableFormat) {
        return executableFormat != null && executableFormat.indexOf("Executable and Linking Format (ELF)") != -1;
    }

    private boolean isMacho(String executableFormat) {
        return executableFormat != null && executableFormat.indexOf("Mac OS X Mach-O") != -1;
    }
}

