/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.NewProjectPanelManager;
import ghidra.framework.main.SaveDataDialog;
import ghidra.framework.main.ViewInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.Tool;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.store.LockException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.InvokeInSwingTask;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

class FileActionManager {
    private static final int NEW_ACCELERATOR = 78;
    private static final int OPEN_ACCELERATOR = 79;
    private static final int CLOSE_ACCELERATOR = 87;
    private static final int SAVE_ACCELERATOR = 83;
    private static final Icon NEW_PROJECT_ICON = ResourceManager.loadImage((String)"images/folder_add.png");
    private static final String LAST_SELECTED_PROJECT_DIRECTORY = "LastSelectedProjectDirectory";
    private static final String DISPLAY_DATA = "DISPLAY_DATA";
    private FrontEndTool tool;
    private FrontEndPlugin plugin;
    private DockingAction newAction;
    private DockingAction openAction;
    private DockingAction closeProjectAction;
    private DockingAction deleteAction;
    private DockingAction saveAction;
    private List<ViewInfo> reopenList;
    private GhidraFileChooser fileChooser;
    private boolean firingProjectOpened;

    FileActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = (FrontEndTool)plugin.getTool();
        this.reopenList = new ArrayList<ViewInfo>();
        this.createActions();
    }

    private void createActions() {
        this.newAction = new DockingAction("New Project", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.newProject();
            }
        };
        this.newAction.setEnabled(true);
        this.newAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(78, 2)));
        this.newAction.setMenuBarData(new MenuData(new String[]{"&File", "New Project..."}, "AProject"));
        this.tool.addAction((DockingActionIf)this.newAction);
        this.openAction = new DockingAction("Open Project", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.openProject();
            }
        };
        this.openAction.setEnabled(true);
        this.openAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(79, 2)));
        this.openAction.setMenuBarData(new MenuData(new String[]{"&File", "Open Project..."}, "AProject"));
        this.tool.addAction((DockingActionIf)this.openAction);
        this.saveAction = new DockingAction("Save Project", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.saveProject();
                FileActionManager.this.tool.saveToolConfigurationToDisk();
            }
        };
        this.saveAction.setEnabled(false);
        this.saveAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(83, 2)));
        this.saveAction.setMenuBarData(new MenuData(new String[]{"&File", "Save Project"}, "BProject"));
        this.tool.addAction((DockingActionIf)this.saveAction);
        this.closeProjectAction = new DockingAction("Close Project", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.closeProject(false);
            }
        };
        this.closeProjectAction.setEnabled(false);
        this.closeProjectAction.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(87, 2)));
        this.closeProjectAction.setMenuBarData(new MenuData(new String[]{"&File", "Close Project"}, "BProject"));
        this.tool.addAction((DockingActionIf)this.closeProjectAction);
        this.deleteAction = new DockingAction("Delete Project", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FileActionManager.this.deleteProject();
            }
        };
        this.deleteAction.setEnabled(true);
        this.deleteAction.setMenuBarData(new MenuData(new String[]{"&File", "Delete Project..."}, "CProject"));
        this.tool.addAction((DockingActionIf)this.deleteAction);
    }

    void buildRecentProjectsMenu() {
        ProjectLocator[] recentProjects;
        for (ViewInfo info : this.reopenList) {
            this.tool.removeAction((DockingActionIf)info.getAction());
        }
        this.reopenList.clear();
        for (ProjectLocator projectLocator : recentProjects = this.plugin.getRecentProjects()) {
            String filename = projectLocator.toString();
            ReopenProjectAction action = new ReopenProjectAction(projectLocator, filename);
            this.reopenList.add(new ViewInfo(action, projectLocator.getURL()));
            this.tool.addAction((DockingActionIf)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newProject() {
        NewProjectPanelManager panelManager = new NewProjectPanelManager(this.tool);
        WizardManager wm = new WizardManager("New Project", true, (PanelManager)panelManager, NEW_PROJECT_ICON);
        wm.showWizard((Component)this.tool.getToolFrame());
        ProjectLocator newProjectLocator = panelManager.getNewProjectLocation();
        RepositoryAdapter newRepo = panelManager.getProjectRepository();
        if (newProjectLocator == null) {
            return;
        }
        Project newProject = null;
        try {
            Project activeProject = this.plugin.getActiveProject();
            if (activeProject != null && !this.closeProject(false)) {
                return;
            }
            if (newRepo != null) {
                try {
                    if (newRepo.getServer().isConnected()) {
                        newRepo.connect();
                    }
                }
                catch (IOException e) {
                    ClientUtil.handleException((RepositoryAdapter)newRepo, (Exception)e, (String)"Repository Connection", (Component)this.tool.getToolFrame());
                }
            }
            newProject = this.tool.getProjectManager().createProject(newProjectLocator, newRepo, true);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Create Project Failed", (Object)("Failed to create new project '" + newProjectLocator.getName() + "': " + msg), (Throwable)e);
        }
        finally {
            if (newProject == null && newRepo != null) {
                newRepo.disconnect();
            }
        }
        this.tool.setActiveProject(newProject);
        this.plugin.rebuildRecentMenus();
        if (newProject != null) {
            this.openProjectAndNotify(newProject);
        }
    }

    private void openProject() {
        ProjectLocator projectLocator;
        ProjectLocator currentProjectLocator = null;
        Project activeProject = this.plugin.getActiveProject();
        if (activeProject != null) {
            currentProjectLocator = activeProject.getProjectLocator();
        }
        if (this.fileChooser == null) {
            this.fileChooser = this.plugin.createFileChooser(LAST_SELECTED_PROJECT_DIRECTORY);
        }
        if ((projectLocator = this.plugin.chooseProject(this.fileChooser, "Open", LAST_SELECTED_PROJECT_DIRECTORY)) != null && !this.doOpenProject(projectLocator) && currentProjectLocator != null) {
            this.doOpenProject(currentProjectLocator);
        }
    }

    final boolean openProject(ProjectLocator projectLocator) {
        OpenTaskRunnable openRunnable = new OpenTaskRunnable(projectLocator);
        InvokeInSwingTask task = new InvokeInSwingTask("Opening Project", (Runnable)openRunnable);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame(), 0);
        return openRunnable.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean doOpenProject(ProjectLocator projectLocator) {
        String status = "Opened project: " + projectLocator.getName();
        Project project = null;
        boolean openStatus = false;
        try {
            if (!this.closeProject(false)) {
                boolean bl = true;
                return bl;
            }
            ProjectManager pm = this.plugin.getProjectManager();
            project = pm.openProject(projectLocator, true, false);
            if (project == null) {
                status = "Error opening project: " + projectLocator.toString();
            } else {
                this.firingProjectOpened = true;
                this.tool.setActiveProject(project);
                this.openProjectAndNotify(project);
                openStatus = true;
                this.firingProjectOpened = false;
            }
        }
        catch (NotFoundException nfe) {
            status = "Project not found for " + projectLocator.toString();
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Opening Project", (Object)status);
        }
        catch (NotOwnerException e) {
            status = "Cannot open project: " + e.getMessage();
            Msg.showError((Object)this, null, (String)"Not Project Owner", (Object)("Cannot open project " + projectLocator + "\n" + e.getMessage() + "\n \nEach user must create their own project. If needed, another user's project may be viewed\nand files copied, using the View Other action from your own open project.  Alternatively, \ncreating a \"Shared Project\" will allow a group of users to use a shared server-based repository."));
        }
        catch (LockException e) {
            status = "Project is already open for update: " + projectLocator.toString();
            Msg.showError((Object)this, null, (String)"Open Project Failed", (Object)status);
        }
        catch (Exception e) {
            status = "Error opening project: " + projectLocator.toString();
            Msg.showError((Object)this, null, (String)"Open Project Failed", (Object)status, (Throwable)e);
        }
        finally {
            this.plugin.rebuildRecentMenus();
        }
        if (!openStatus) {
            Msg.error((Object)this, (Object)status);
        } else {
            Msg.info((Object)this, (Object)status);
        }
        return openStatus;
    }

    private DomainObject[] lockDomainObjects(List<DomainFile> files) {
        int lastIndex;
        DomainObject[] objs = new DomainObject[files.size()];
        boolean locked = true;
        for (lastIndex = 0; lastIndex < files.size(); ++lastIndex) {
            try {
                objs[lastIndex] = files.get(lastIndex).getDomainObject(this, false, false, null);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Failed to aqcuire domain object instance", (Throwable)t);
                locked = false;
                break;
            }
            if (objs[lastIndex].lock(null)) continue;
            String title = "Exit Ghidra";
            StringBuffer buf = new StringBuffer();
            UndoableDomainObject udo = (UndoableDomainObject)objs[lastIndex];
            buf.append("The File " + files.get(lastIndex).getPathname() + " is currently being modified by the\n");
            buf.append("the following actions:\n \n");
            Transaction t = udo.getCurrentTransaction();
            ArrayList<String> list = t.getOpenSubTransactions();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                buf.append("\n     ");
                buf.append((String)it.next());
            }
            buf.append("\n \n");
            buf.append("You may exit Ghidra, but the above action(s) will be aborted and all\n");
            buf.append("changes made by those actions (and all changes made since those\n");
            buf.append("actions started),will be lost!  You will still have the option of \n");
            buf.append("saving any changes made before those actions began.\n \n");
            buf.append("Do you want to abort the action(s) and exit Ghidra?");
            int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)title, (String)buf.toString(), (String)"Exit Ghidra", (int)2);
            if (result == 0) {
                locked = false;
                objs[lastIndex].release(this);
                break;
            }
            udo.forceLock(true, null);
        }
        if (!locked) {
            for (int i = 0; i < lastIndex; ++i) {
                objs[i].unlock();
                objs[i].release(this);
            }
            return null;
        }
        return objs;
    }

    boolean closeProject(boolean isExiting) {
        Project activeProject = this.plugin.getActiveProject();
        if (activeProject == null) {
            return true;
        }
        Tool[] runningTools = activeProject.getToolManager().getRunningTools();
        for (int i = 0; i < runningTools.length; ++i) {
            if (runningTools[i].canClose(isExiting)) continue;
            return false;
        }
        boolean saveSuccessful = this.saveChangedData(activeProject);
        if (!saveSuccessful) {
            return false;
        }
        if (!activeProject.saveSessionTools()) {
            return false;
        }
        this.doSaveProject(activeProject);
        String name = activeProject.getName();
        ProjectLocator projectLocator = activeProject.getProjectLocator();
        activeProject.close();
        this.fireProjectClosed(activeProject);
        if (!isExiting) {
            this.tool.setActiveProject(null);
            Msg.info((Object)this, (Object)("Closed project: " + name));
            this.plugin.rebuildRecentMenus();
            this.plugin.getProjectManager().setLastOpenedProject(null);
        } else {
            this.plugin.getProjectManager().setLastOpenedProject(projectLocator);
        }
        if (this.tool.getManagePluginsDialog() != null) {
            this.tool.getManagePluginsDialog().close();
        }
        return true;
    }

    private void doSaveProject(Project project) {
        project.setSaveableData(DISPLAY_DATA, this.tool.getSaveableDisplayData());
        project.save();
    }

    private void openProjectAndNotify(Project project) {
        this.doRestoreProject(project);
        this.fireProjectOpened(project);
    }

    private void doRestoreProject(Project project) {
        SaveState saveState = project.getSaveableData(DISPLAY_DATA);
        if (saveState == null) {
            return;
        }
        this.tool.setSaveableDisplayData(saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveChangedData(Project activeProject) {
        List<DomainFile> data = activeProject.getOpenData();
        if (data.isEmpty()) {
            return true;
        }
        DomainObject[] lockedObjects = this.lockDomainObjects(data);
        if (lockedObjects == null) {
            return false;
        }
        List<DomainFile> changedFiles = this.getChangedFiles(data);
        try {
            if (!this.checkReadOnlyFiles(lockedObjects)) {
                boolean bl = false;
                return bl;
            }
            SaveDataDialog saveDialog = new SaveDataDialog(this.tool);
            if (!saveDialog.showDialog(changedFiles)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            for (DomainObject lockedObject : lockedObjects) {
                lockedObject.unlock();
                lockedObject.release(this);
            }
        }
        return true;
    }

    private List<DomainFile> getChangedFiles(List<DomainFile> data) {
        ArrayList<DomainFile> changedFiles = new ArrayList<DomainFile>();
        for (DomainFile domainFile : data) {
            if (!domainFile.isChanged()) continue;
            changedFiles.add(domainFile);
        }
        return changedFiles;
    }

    void setActiveProject(Project activeProject) {
        this.plugin.rebuildRecentMenus();
        if (!this.firingProjectOpened && activeProject != null) {
            this.openProjectAndNotify(activeProject);
        }
    }

    void saveProject() {
        Project project = this.plugin.getActiveProject();
        if (project == null) {
            return;
        }
        this.doSaveProject(project);
        Msg.info((Object)this, (Object)("Saved project: " + project.getName()));
    }

    private boolean allowDelete(Project activeProject) {
        if (activeProject != null) {
            Msg.showWarn(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Cannot Delete Active Project", (Object)"You must close your project to delete it.");
            return false;
        }
        return true;
    }

    private void deleteProject() {
        ProjectLocator projectLocator;
        if (this.fileChooser == null) {
            this.fileChooser = this.plugin.createFileChooser(LAST_SELECTED_PROJECT_DIRECTORY);
        }
        if ((projectLocator = this.plugin.chooseProject(this.fileChooser, "Delete", LAST_SELECTED_PROJECT_DIRECTORY)) == null) {
            return;
        }
        ProjectManager pm = this.plugin.getProjectManager();
        if (!pm.projectExists(projectLocator)) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Project Does Not Exist", (Object)("Project " + projectLocator.getName() + " was not found."));
            return;
        }
        Project activeProject = this.plugin.getActiveProject();
        StringBuffer confirmMsg = new StringBuffer("Project: ");
        confirmMsg.append(projectLocator.toString());
        confirmMsg.append(" ?\n");
        boolean isActiveProject = activeProject != null && activeProject.getProjectLocator().equals(projectLocator);
        boolean isOpenProjectView = this.isOpenProjectView(projectLocator);
        if (!this.allowDelete(isActiveProject ? activeProject : null)) {
            return;
        }
        confirmMsg.append(" \n");
        confirmMsg.append("WARNING: Delete CANNOT be undone!");
        if (!this.plugin.confirmDelete(confirmMsg.toString())) {
            return;
        }
        String projectName = projectLocator.getName();
        try {
            if (!pm.deleteProject(projectLocator)) {
                Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Deleting Project", (Object)("All files from project " + projectName + " were not deleted."));
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error deleting project: " + projectName + ", " + e.getMessage()), (Throwable)e);
            return;
        }
        if (isActiveProject) {
            activeProject.close();
            this.fireProjectClosed(activeProject);
            this.tool.setActiveProject(null);
        } else if (isOpenProjectView) {
            this.plugin.getProjectActionManager().closeView(projectLocator.getURL());
        }
        this.plugin.rebuildRecentMenus();
        Msg.info((Object)this, (Object)("Deleted project: " + projectName));
    }

    private boolean isOpenProjectView(ProjectLocator projectLocator) {
        boolean isOpenView = false;
        ProjectLocator[] openViews = this.plugin.getProjectDataPanel().getProjectViews();
        for (int v = 0; !isOpenView && v < openViews.length; ++v) {
            isOpenView = openViews[v].equals(projectLocator);
        }
        return isOpenView;
    }

    final void enableActions(boolean enabled) {
        this.closeProjectAction.setEnabled(enabled);
        this.saveAction.setEnabled(enabled);
    }

    private boolean checkReadOnlyFiles(DomainObject[] objs) {
        ArrayList<DomainObject> list = new ArrayList<DomainObject>(10);
        for (DomainObject domainObject : objs) {
            try {
                if (!domainObject.isChanged() || domainObject.getDomainFile().canSave()) continue;
                list.add(domainObject);
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, null, null, (Throwable)e);
            }
        }
        if (list.size() == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The following files are Read-Only and cannot be\n saved 'As Is.' You must do a manual 'Save As' for these\n files: \n \n");
        for (int i = 0; i < list.size(); ++i) {
            DomainObject obj = (DomainObject)list.get(i);
            sb.append(obj.getDomainFile().getPathname());
            sb.append("\n");
        }
        sb.append(" \nChoose 'Cancel' to cancel Close Project, or \n");
        sb.append("'Lose Changes' to continue.");
        return OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Read-Only Files", (String)sb.toString(), (String)"Lose Changes", (int)3) == 1;
    }

    private void fireProjectOpened(Project project) {
        for (ProjectListener listener : this.tool.getListeners()) {
            listener.projectOpened(project);
        }
    }

    private void fireProjectClosed(Project project) {
        for (ProjectListener listener : this.tool.getListeners()) {
            listener.projectClosed(project);
        }
    }

    private class ReopenProjectAction
    extends DockingAction {
        private ProjectLocator projectLocator;

        private ReopenProjectAction(ProjectLocator projectLocator, String filename) {
            super(filename, FileActionManager.this.plugin.getName(), false);
            this.projectLocator = projectLocator;
            this.setMenuBarData(new MenuData(new String[]{"&File", "Reopen", filename}, null, "AProject"));
            FileActionManager.this.tool.setMenuGroup(new String[]{"&File", "Reopen"}, "AProject");
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation(FileActionManager.this.plugin.getName(), "Reopen_Project"));
        }

        public void actionPerformed(ActionContext context) {
            FileActionManager.this.doOpenProject(this.projectLocator);
        }
    }

    private class OpenTaskRunnable
    implements Runnable {
        private final ProjectLocator newProjectLocator;
        private boolean result = false;

        OpenTaskRunnable(ProjectLocator newProjectLocator) {
            this.newProjectLocator = newProjectLocator;
        }

        @Override
        public void run() {
            this.result = FileActionManager.this.doOpenProject(this.newProjectLocator);
        }

        boolean getResult() {
            return this.result;
        }
    }
}

