/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.IOUtil;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.fs.ResourceForkReader;
import org.catacombae.hfsexplorer.gui.DisplayTextFilePanel;
import org.catacombae.hfsexplorer.types.resff.ReferenceListEntry;
import org.catacombae.hfsexplorer.types.resff.ResourceMap;
import org.catacombae.hfsexplorer.types.resff.ResourceName;
import org.catacombae.hfsexplorer.types.resff.ResourceType;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.util.Util;
import org.jdesktop.layout.GroupLayout;

public class ResourceForkViewPanel
extends JPanel {
    private ResourceForkReader reader = null;
    private JTextField attributesField;
    private JLabel attributesLabel;
    private JButton extractButton;
    private JPanel fieldsPanel;
    private JTextField idField;
    private JLabel idLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JList resourceList;
    private JLabel resourceListLabel;
    private JScrollPane resourceListScroller;
    private JTextField sizeField;
    private JLabel sizeLabel;
    private JTextField typeField;
    private JLabel typeLabel;
    private JButton viewButton;

    public ResourceForkViewPanel(ResourceForkReader startupReader) {
        this.initComponents();
        this.resourceList.setSelectionMode(0);
        this.loadResourceFork(startupReader);
        this.resourceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object o = ResourceForkViewPanel.this.resourceList.getSelectedValue();
                if (o instanceof ListItem) {
                    ResourceForkViewPanel.this.setSelectedItem((ListItem)o);
                } else if (o != null) {
                    JOptionPane.showMessageDialog(ResourceForkViewPanel.this.resourceList, "Unexpected type in list: " + o.getClass());
                }
            }
        });
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object selection = ResourceForkViewPanel.this.resourceList.getSelectedValue();
                if (selection != null && selection instanceof ListItem) {
                    ListItem selectedItem = (ListItem)selection;
                    JDialog d = new JDialog(JOptionPane.getFrameForComponent(ResourceForkViewPanel.this), selection.toString(), true);
                    DisplayTextFilePanel dtfp = new DisplayTextFilePanel();
                    dtfp.loadStream((Readable)ResourceForkViewPanel.this.reader.getResourceStream(selectedItem.entry));
                    d.add(dtfp);
                    d.pack();
                    d.setLocationRelativeTo(null);
                    d.setVisible(true);
                }
            }
        });
        this.extractButton.addActionListener(new ActionListener(){
            private JFileChooser fileChooser = new JFileChooser();
            {
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setMultiSelectionEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Object selection = ResourceForkViewPanel.this.resourceList.getSelectedValue();
                if (selection != null && selection instanceof ListItem) {
                    ListItem selectedItem = (ListItem)selection;
                    if (this.fileChooser.showSaveDialog(ResourceForkViewPanel.this) == 0) {
                        int res;
                        File saveFile = this.fileChooser.getSelectedFile();
                        if (saveFile.exists() && (res = JOptionPane.showConfirmDialog(ResourceForkViewPanel.this, "The file already exists. Do you want to overwrite?", "Confirm overwrite", 0, 3)) != 0) {
                            return;
                        }
                        ReadableRandomAccessStream in = null;
                        FileOutputStream fos = null;
                        try {
                            in = ResourceForkViewPanel.this.reader.getResourceStream(selectedItem.entry);
                            fos = new FileOutputStream(saveFile);
                            IOUtil.streamCopy((Readable)in, (OutputStream)fos, 65536);
                        }
                        catch (FileNotFoundException fnfe) {
                            JOptionPane.showMessageDialog(ResourceForkViewPanel.this, "Could not open file \"" + saveFile.getPath() + "\" for writing...", "Error", 0);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            GUIUtil.displayExceptionDialog((Throwable)ioe, (Component)ResourceForkViewPanel.this);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                    GUIUtil.displayExceptionDialog((Throwable)ex, (Component)ResourceForkViewPanel.this);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public void loadResourceFork(ResourceForkReader reader) {
        if (reader != null) {
            ListItem[] allItems = this.listAllItems(reader);
            this.resourceList.setEnabled(true);
            this.resourceList.setListData(allItems);
            this.resourceListLabel.setText("Resource list (" + allItems.length + " items):");
        } else {
            this.resourceList.setEnabled(false);
            this.resourceList.setListData(new Object[0]);
            this.resourceListLabel.setText("Resource list:");
        }
        this.setSelectedItem(null);
        this.reader = reader;
    }

    private ListItem[] listAllItems(ResourceForkReader reader) {
        ResourceMap resMap = reader.getResourceMap();
        LinkedList<ListItem> result = new LinkedList<ListItem>();
        List<Util.Pair<ResourceType, ReferenceListEntry[]>> refList = resMap.getReferenceList();
        for (Util.Pair<ResourceType, ReferenceListEntry[]> p : refList) {
            ResourceType type = (ResourceType)p.getA();
            for (ReferenceListEntry entry : (ReferenceListEntry[])p.getB()) {
                ResourceName name = resMap.getNameByReferenceListEntry(entry);
                long size = reader.getDataLength(entry);
                result.add(new ListItem(type, entry, name, size));
            }
        }
        return result.toArray(new ListItem[result.size()]);
    }

    private void setSelectedItem(ListItem li) {
        boolean enabled = li != null;
        this.extractButton.setEnabled(enabled);
        this.viewButton.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
        this.typeField.setEnabled(enabled);
        this.idField.setEnabled(enabled);
        this.sizeField.setEnabled(enabled);
        this.attributesField.setEnabled(enabled);
        if (!enabled) {
            this.nameField.setText("");
            this.typeField.setText("");
            this.idField.setText("");
            this.sizeField.setText("");
            this.attributesField.setText("");
        } else {
            String typeString;
            String nameString;
            if (li.name != null) {
                try {
                    nameString = new String(li.name.getName(), "MacRoman");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    nameString = "[Could not decode: " + e.toString() + "]";
                }
            } else {
                nameString = null;
            }
            try {
                typeString = new String(li.type.getType(), "MacRoman");
            }
            catch (Exception e) {
                e.printStackTrace();
                typeString = "[Could not decode: " + e.toString() + "]";
            }
            if (this.nameField == null) {
                this.nameField.setEnabled(false);
                this.nameField.setName("");
            } else {
                this.nameField.setText(nameString);
            }
            this.typeField.setText(typeString);
            this.idField.setText("" + li.entry.getResourceID());
            this.sizeField.setText(li.size + " bytes");
            this.attributesField.setText("0x" + Util.toHexStringBE((byte)li.entry.getResourceAttributes()));
        }
    }

    private void initComponents() {
        this.resourceListLabel = new JLabel();
        this.resourceListScroller = new JScrollPane();
        this.resourceList = new JList();
        this.fieldsPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeField = new JTextField();
        this.idLabel = new JLabel();
        this.idField = new JTextField();
        this.sizeLabel = new JLabel();
        this.sizeField = new JTextField();
        this.attributesLabel = new JLabel();
        this.attributesField = new JTextField();
        this.extractButton = new JButton();
        this.viewButton = new JButton();
        this.resourceListLabel.setText("[This label is set programmatically]");
        this.resourceList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.resourceListScroller.setViewportView(this.resourceList);
        this.nameLabel.setText("Name:");
        this.nameField.setEditable(false);
        this.nameField.setText("jTextField1");
        this.nameField.setOpaque(false);
        this.typeLabel.setText("Type:");
        this.typeField.setEditable(false);
        this.typeField.setText("jTextField2");
        this.typeField.setOpaque(false);
        this.idLabel.setText("ID:");
        this.idField.setEditable(false);
        this.idField.setText("jTextField3");
        this.idField.setOpaque(false);
        this.sizeLabel.setText("Size:");
        this.sizeField.setEditable(false);
        this.sizeField.setText("jTextField4");
        this.sizeField.setOpaque(false);
        this.attributesLabel.setText("Attributes:");
        this.attributesField.setEditable(false);
        this.attributesField.setText("jTextField5");
        this.attributesField.setOpaque(false);
        GroupLayout fieldsPanelLayout = new GroupLayout((Container)this.fieldsPanel);
        this.fieldsPanel.setLayout((LayoutManager)fieldsPanelLayout);
        fieldsPanelLayout.setHorizontalGroup((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)fieldsPanelLayout.createSequentialGroup().add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((Component)this.nameLabel).add((Component)this.typeLabel).add((Component)this.idLabel).add((Component)this.sizeLabel).add((Component)this.attributesLabel)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((Component)this.attributesField, -1, 227, Short.MAX_VALUE).add((Component)this.sizeField, -1, 227, Short.MAX_VALUE).add((Component)this.idField, -1, 227, Short.MAX_VALUE).add((Component)this.nameField, -1, 227, Short.MAX_VALUE).add((Component)this.typeField, -1, 227, Short.MAX_VALUE))));
        fieldsPanelLayout.setVerticalGroup((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)fieldsPanelLayout.createSequentialGroup().add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.typeLabel).add((Component)this.typeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.idLabel).add((Component)this.idField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.sizeLabel).add((Component)this.sizeField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.attributesLabel).add((Component)this.attributesField, -2, -1, -2))));
        this.extractButton.setText("Save to file...");
        this.viewButton.setText("View as text");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.resourceListScroller, -1, 283, Short.MAX_VALUE).add(1, (Component)this.resourceListLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.viewButton).addPreferredGap(0).add((Component)this.extractButton)).add(1, (Component)this.fieldsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.resourceListLabel).addPreferredGap(0).add((Component)this.resourceListScroller, -1, 99, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.fieldsPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.extractButton).add((Component)this.viewButton)).addContainerGap()));
    }

    private class ListItem {
        ResourceType type;
        ReferenceListEntry entry;
        ResourceName name;
        long size;

        public ListItem(ResourceType type, ReferenceListEntry entry, ResourceName name, long size) {
            this.type = type;
            this.entry = entry;
            this.name = name;
            this.size = size;
        }

        public String toString() {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(new String(this.type.getType(), "MacRoman"));
                if (this.name != null) {
                    sb.append(" \"").append(new String(this.name.getName(), "MacRoman")).append("\"");
                }
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "{" + e.getClass().getSimpleName() + " in resource id " + this.entry.getResourceID() + "}";
            }
        }
    }
}

