/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.function.FunctionTagAdapter;
import ghidra.program.database.function.FunctionTagDB;
import ghidra.program.database.function.FunctionTagMappingAdapter;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FunctionTagManagerDB
implements FunctionTagManager,
ErrorHandler {
    private ProgramDB program;
    private FunctionTagAdapter functionTagAdapter;
    private FunctionTagMappingAdapter functionTagMappingAdapter;
    private DBObjectCache<FunctionTagDB> cache;
    protected final Lock lock;

    FunctionTagManagerDB(DBHandle handle, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        this.lock = lock;
        this.functionTagAdapter = FunctionTagAdapter.getAdapter(handle, openMode, monitor);
        this.functionTagMappingAdapter = FunctionTagMappingAdapter.getAdapter(handle, openMode, monitor);
        this.cache = new DBObjectCache(100);
    }

    @Override
    public void setProgram(Program program) {
        this.program = (ProgramDB)program;
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag getFunctionTag(String name) {
        this.lock.acquire();
        try {
            Record rec = this.functionTagAdapter.getRecord(name);
            if (rec != null) {
                FunctionTag functionTag = this.getFunctionTagFromCache(rec);
                return functionTag;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag getFunctionTag(long id) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.cache.get(id);
            if (tag != null) {
                FunctionTag functionTag = tag;
                return functionTag;
            }
            Record rec = this.functionTagAdapter.getRecord(id);
            if (rec != null) {
                FunctionTagDB functionTagDB = new FunctionTagDB(this, this.cache, rec);
                return functionTagDB;
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTagAssigned(String name) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(name);
            if (tag == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.functionTagMappingAdapter.isTagAssigned(tag.getId());
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionTag createFunctionTag(String name, String comment) {
        this.lock.acquire();
        try {
            FunctionTag tag = this.getFunctionTag(name);
            if (tag != null) {
                FunctionTag functionTag = tag;
                return functionTag;
            }
            Record record = this.functionTagAdapter.createTagRecord(name, comment);
            tag = this.getFunctionTagFromCache(record);
            this.fireTagCreatedNotification(148, tag);
            FunctionTag functionTag = tag;
            return functionTag;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    void updateFunctionTag(FunctionTagDB tag) throws IOException {
        this.functionTagAdapter.updateRecord(tag.getRecord());
        this.fireTagChangedNotification(147, tag);
        this.invalidateFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends FunctionTag> getAllFunctionTags() {
        this.lock.acquire();
        try {
            ArrayList<FunctionTag> tags = new ArrayList<FunctionTag>();
            RecordIterator records = this.functionTagAdapter.getRecords();
            while (records.hasNext()) {
                Record record = records.next();
                tags.add(this.getFunctionTagFromCache(record));
            }
            ArrayList<FunctionTag> arrayList = tags;
            return arrayList;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return Collections.emptyList();
    }

    public FunctionTagAdapter getFunctionTagAdapter() {
        return this.functionTagAdapter;
    }

    public FunctionTagMappingAdapter getFunctionTagMappingAdapter() {
        return this.functionTagMappingAdapter;
    }

    private void fireTagChangedNotification(int type, FunctionTag tag) throws IOException {
        this.program.tagChanged(tag, type, null, null);
    }

    private void fireTagCreatedNotification(int type, FunctionTag tag) throws IOException {
        this.program.tagCreated(tag, type);
    }

    private void fireTagDeletedNotification(int type, FunctionTag tag) throws IOException {
        this.program.tagChanged(tag, type, null, null);
    }

    private FunctionTag getFunctionTagFromCache(Record tagRecord) {
        FunctionTagDB tag = this.cache.get(tagRecord);
        if (tag == null) {
            tag = new FunctionTagDB(this, this.cache, tagRecord);
        }
        return tag;
    }

    void doDeleteTag(FunctionTag tag) throws IOException {
        this.functionTagMappingAdapter.removeFunctionTagRecord(tag.getId());
        this.functionTagAdapter.removeTagRecord(tag.getId());
        this.cache.delete(tag.getId());
        this.fireTagDeletedNotification(149, tag);
        this.invalidateFunctions();
    }

    private void invalidateFunctions() {
        FunctionManagerDB functionManager = (FunctionManagerDB)this.program.getFunctionManager();
        functionManager.functionTagsChanged();
    }

    Set<FunctionTag> getFunctionTagsByFunctionID(long functionId) throws IOException {
        HashSet<FunctionTag> tags = new HashSet<FunctionTag>();
        RecordIterator functionTagMappingRecords = this.functionTagMappingAdapter.getRecordsByFunctionID(functionId);
        while (functionTagMappingRecords.hasNext()) {
            Record mappingRecord = functionTagMappingRecords.next();
            Record tagRecord = this.functionTagAdapter.getRecord(mappingRecord.getLongValue(1));
            tags.add(this.getFunctionTagFromCache(tagRecord));
        }
        return tags;
    }
}

