// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/appengine/v1/appengine.proto

package appenginepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Applications_GetApplication_FullMethodName    = "/google.appengine.v1.Applications/GetApplication"
	Applications_CreateApplication_FullMethodName = "/google.appengine.v1.Applications/CreateApplication"
	Applications_UpdateApplication_FullMethodName = "/google.appengine.v1.Applications/UpdateApplication"
	Applications_RepairApplication_FullMethodName = "/google.appengine.v1.Applications/RepairApplication"
)

// ApplicationsClient is the client API for Applications service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ApplicationsClient interface {
	// Gets information about an application.
	GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Creates an App Engine application for a Google Cloud Platform project.
	// Required fields:
	//
	// * `id` - The ID of the target Cloud Platform project.
	// * *location* - The [region](https://cloud.google.com/appengine/docs/locations) where you want the App Engine application located.
	//
	// For more information about App Engine applications, see [Managing Projects, Applications, and Billing](https://cloud.google.com/appengine/docs/standard/python/console/).
	CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified Application resource.
	// You can update the following fields:
	//
	// * `auth_domain` - Google authentication domain for controlling user access to the application.
	// * `default_cookie_expiration` - Cookie expiration policy for the application.
	// * `iap` - Identity-Aware Proxy properties for the application.
	UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Recreates the required App Engine features for the specified App Engine
	// application, for example a Cloud Storage bucket or App Engine service
	// account.
	// Use this method if you receive an error message about a missing feature,
	// for example, *Error retrieving the App Engine service account*.
	// If you have deleted your App Engine service account, this will
	// not be able to recreate it. Instead, you should attempt to use the
	// IAM undelete API if possible at https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts/undelete?apix_params=%7B"name"%3A"projects%2F-%2FserviceAccounts%2Funique_id"%2C"resource"%3A%7B%7D%7D .
	// If the deletion was recent, the numeric ID can be found in the Cloud
	// Console Activity Log.
	RepairApplication(ctx context.Context, in *RepairApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type applicationsClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationsClient(cc grpc.ClientConnInterface) ApplicationsClient {
	return &applicationsClient{cc}
}

func (c *applicationsClient) GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := c.cc.Invoke(ctx, Applications_GetApplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationsClient) CreateApplication(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Applications_CreateApplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationsClient) UpdateApplication(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Applications_UpdateApplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationsClient) RepairApplication(ctx context.Context, in *RepairApplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Applications_RepairApplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationsServer is the server API for Applications service.
// All implementations should embed UnimplementedApplicationsServer
// for forward compatibility
type ApplicationsServer interface {
	// Gets information about an application.
	GetApplication(context.Context, *GetApplicationRequest) (*Application, error)
	// Creates an App Engine application for a Google Cloud Platform project.
	// Required fields:
	//
	// * `id` - The ID of the target Cloud Platform project.
	// * *location* - The [region](https://cloud.google.com/appengine/docs/locations) where you want the App Engine application located.
	//
	// For more information about App Engine applications, see [Managing Projects, Applications, and Billing](https://cloud.google.com/appengine/docs/standard/python/console/).
	CreateApplication(context.Context, *CreateApplicationRequest) (*longrunningpb.Operation, error)
	// Updates the specified Application resource.
	// You can update the following fields:
	//
	// * `auth_domain` - Google authentication domain for controlling user access to the application.
	// * `default_cookie_expiration` - Cookie expiration policy for the application.
	// * `iap` - Identity-Aware Proxy properties for the application.
	UpdateApplication(context.Context, *UpdateApplicationRequest) (*longrunningpb.Operation, error)
	// Recreates the required App Engine features for the specified App Engine
	// application, for example a Cloud Storage bucket or App Engine service
	// account.
	// Use this method if you receive an error message about a missing feature,
	// for example, *Error retrieving the App Engine service account*.
	// If you have deleted your App Engine service account, this will
	// not be able to recreate it. Instead, you should attempt to use the
	// IAM undelete API if possible at https://cloud.google.com/iam/reference/rest/v1/projects.serviceAccounts/undelete?apix_params=%7B"name"%3A"projects%2F-%2FserviceAccounts%2Funique_id"%2C"resource"%3A%7B%7D%7D .
	// If the deletion was recent, the numeric ID can be found in the Cloud
	// Console Activity Log.
	RepairApplication(context.Context, *RepairApplicationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedApplicationsServer should be embedded to have forward compatible implementations.
type UnimplementedApplicationsServer struct {
}

func (UnimplementedApplicationsServer) GetApplication(context.Context, *GetApplicationRequest) (*Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApplication not implemented")
}
func (UnimplementedApplicationsServer) CreateApplication(context.Context, *CreateApplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateApplication not implemented")
}
func (UnimplementedApplicationsServer) UpdateApplication(context.Context, *UpdateApplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateApplication not implemented")
}
func (UnimplementedApplicationsServer) RepairApplication(context.Context, *RepairApplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepairApplication not implemented")
}

// UnsafeApplicationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ApplicationsServer will
// result in compilation errors.
type UnsafeApplicationsServer interface {
	mustEmbedUnimplementedApplicationsServer()
}

func RegisterApplicationsServer(s grpc.ServiceRegistrar, srv ApplicationsServer) {
	s.RegisterService(&Applications_ServiceDesc, srv)
}

func _Applications_GetApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).GetApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Applications_GetApplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).GetApplication(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Applications_CreateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).CreateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Applications_CreateApplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).CreateApplication(ctx, req.(*CreateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Applications_UpdateApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).UpdateApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Applications_UpdateApplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).UpdateApplication(ctx, req.(*UpdateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Applications_RepairApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepairApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).RepairApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Applications_RepairApplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).RepairApplication(ctx, req.(*RepairApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Applications_ServiceDesc is the grpc.ServiceDesc for Applications service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Applications_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Applications",
	HandlerType: (*ApplicationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetApplication",
			Handler:    _Applications_GetApplication_Handler,
		},
		{
			MethodName: "CreateApplication",
			Handler:    _Applications_CreateApplication_Handler,
		},
		{
			MethodName: "UpdateApplication",
			Handler:    _Applications_UpdateApplication_Handler,
		},
		{
			MethodName: "RepairApplication",
			Handler:    _Applications_RepairApplication_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	Services_ListServices_FullMethodName  = "/google.appengine.v1.Services/ListServices"
	Services_GetService_FullMethodName    = "/google.appengine.v1.Services/GetService"
	Services_UpdateService_FullMethodName = "/google.appengine.v1.Services/UpdateService"
	Services_DeleteService_FullMethodName = "/google.appengine.v1.Services/DeleteService"
)

// ServicesClient is the client API for Services service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServicesClient interface {
	// Lists all the services in the application.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets the current configuration of the specified service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Updates the configuration of the specified service.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified service and all enclosed versions.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type servicesClient struct {
	cc grpc.ClientConnInterface
}

func NewServicesClient(cc grpc.ClientConnInterface) ServicesClient {
	return &servicesClient{cc}
}

func (c *servicesClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, Services_ListServices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, Services_GetService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Services_UpdateService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Services_DeleteService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServicesServer is the server API for Services service.
// All implementations should embed UnimplementedServicesServer
// for forward compatibility
type ServicesServer interface {
	// Lists all the services in the application.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets the current configuration of the specified service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Updates the configuration of the specified service.
	UpdateService(context.Context, *UpdateServiceRequest) (*longrunningpb.Operation, error)
	// Deletes the specified service and all enclosed versions.
	DeleteService(context.Context, *DeleteServiceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedServicesServer should be embedded to have forward compatible implementations.
type UnimplementedServicesServer struct {
}

func (UnimplementedServicesServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (UnimplementedServicesServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (UnimplementedServicesServer) UpdateService(context.Context, *UpdateServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (UnimplementedServicesServer) DeleteService(context.Context, *DeleteServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}

// UnsafeServicesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServicesServer will
// result in compilation errors.
type UnsafeServicesServer interface {
	mustEmbedUnimplementedServicesServer()
}

func RegisterServicesServer(s grpc.ServiceRegistrar, srv ServicesServer) {
	s.RegisterService(&Services_ServiceDesc, srv)
}

func _Services_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Services_ListServices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Services_GetService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Services_UpdateService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Services_DeleteService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Services_ServiceDesc is the grpc.ServiceDesc for Services service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Services_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Services",
	HandlerType: (*ServicesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _Services_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _Services_GetService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _Services_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _Services_DeleteService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	Versions_ListVersions_FullMethodName  = "/google.appengine.v1.Versions/ListVersions"
	Versions_GetVersion_FullMethodName    = "/google.appengine.v1.Versions/GetVersion"
	Versions_CreateVersion_FullMethodName = "/google.appengine.v1.Versions/CreateVersion"
	Versions_UpdateVersion_FullMethodName = "/google.appengine.v1.Versions/UpdateVersion"
	Versions_DeleteVersion_FullMethodName = "/google.appengine.v1.Versions/DeleteVersion"
)

// VersionsClient is the client API for Versions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VersionsClient interface {
	// Lists the versions of a service.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets the specified Version resource.
	// By default, only a `BASIC_VIEW` will be returned.
	// Specify the `FULL_VIEW` parameter to get the full resource.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deploys code and resource files to a new version.
	CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified Version resource.
	// You can specify the following fields depending on the App Engine
	// environment and type of scaling that the version resource uses:
	//
	// **Standard environment**
	//
	// * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class)
	//
	// *automatic scaling* in the standard environment:
	//
	// * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automaticScaling.standard_scheduler_settings.max_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.min_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.target_cpu_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.target_throughput_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	//
	// *basic scaling* or *manual scaling* in the standard environment:
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
	// * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
	//
	// **Flexible environment**
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
	//
	// *automatic scaling* in the flexible environment:
	//
	// * [`automatic_scaling.min_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.max_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.cool_down_period_sec`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.cpu_utilization.target_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	//
	// *manual scaling* in the flexible environment:
	//
	// * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
	UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Version resource.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type versionsClient struct {
	cc grpc.ClientConnInterface
}

func NewVersionsClient(cc grpc.ClientConnInterface) VersionsClient {
	return &versionsClient{cc}
}

func (c *versionsClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, Versions_ListVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, Versions_GetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Versions_CreateVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Versions_UpdateVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Versions_DeleteVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VersionsServer is the server API for Versions service.
// All implementations should embed UnimplementedVersionsServer
// for forward compatibility
type VersionsServer interface {
	// Lists the versions of a service.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets the specified Version resource.
	// By default, only a `BASIC_VIEW` will be returned.
	// Specify the `FULL_VIEW` parameter to get the full resource.
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deploys code and resource files to a new version.
	CreateVersion(context.Context, *CreateVersionRequest) (*longrunningpb.Operation, error)
	// Updates the specified Version resource.
	// You can specify the following fields depending on the App Engine
	// environment and type of scaling that the version resource uses:
	//
	// **Standard environment**
	//
	// * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class)
	//
	// *automatic scaling* in the standard environment:
	//
	// * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automaticScaling.standard_scheduler_settings.max_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.min_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.target_cpu_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	// * [`automaticScaling.standard_scheduler_settings.target_throughput_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StandardSchedulerSettings)
	//
	// *basic scaling* or *manual scaling* in the standard environment:
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
	// * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
	//
	// **Flexible environment**
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status)
	//
	// *automatic scaling* in the flexible environment:
	//
	// * [`automatic_scaling.min_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.max_total_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.cool_down_period_sec`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	// * [`automatic_scaling.cpu_utilization.target_utilization`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling)
	//
	// *manual scaling* in the flexible environment:
	//
	// * [`manual_scaling.instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#manualscaling)
	UpdateVersion(context.Context, *UpdateVersionRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Version resource.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVersionsServer should be embedded to have forward compatible implementations.
type UnimplementedVersionsServer struct {
}

func (UnimplementedVersionsServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (UnimplementedVersionsServer) GetVersion(context.Context, *GetVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (UnimplementedVersionsServer) CreateVersion(context.Context, *CreateVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVersion not implemented")
}
func (UnimplementedVersionsServer) UpdateVersion(context.Context, *UpdateVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVersion not implemented")
}
func (UnimplementedVersionsServer) DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVersion not implemented")
}

// UnsafeVersionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VersionsServer will
// result in compilation errors.
type UnsafeVersionsServer interface {
	mustEmbedUnimplementedVersionsServer()
}

func RegisterVersionsServer(s grpc.ServiceRegistrar, srv VersionsServer) {
	s.RegisterService(&Versions_ServiceDesc, srv)
}

func _Versions_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Versions_ListVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Versions_GetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Versions_CreateVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).CreateVersion(ctx, req.(*CreateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_UpdateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).UpdateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Versions_UpdateVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).UpdateVersion(ctx, req.(*UpdateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Versions_DeleteVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Versions_ServiceDesc is the grpc.ServiceDesc for Versions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Versions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Versions",
	HandlerType: (*VersionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVersions",
			Handler:    _Versions_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _Versions_GetVersion_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _Versions_CreateVersion_Handler,
		},
		{
			MethodName: "UpdateVersion",
			Handler:    _Versions_UpdateVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _Versions_DeleteVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	Instances_ListInstances_FullMethodName  = "/google.appengine.v1.Instances/ListInstances"
	Instances_GetInstance_FullMethodName    = "/google.appengine.v1.Instances/GetInstance"
	Instances_DeleteInstance_FullMethodName = "/google.appengine.v1.Instances/DeleteInstance"
	Instances_DebugInstance_FullMethodName  = "/google.appengine.v1.Instances/DebugInstance"
)

// InstancesClient is the client API for Instances service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstancesClient interface {
	// Lists the instances of a version.
	//
	// Tip: To aggregate details about instances over time, see the
	// [Stackdriver Monitoring API](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets instance information.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Stops a running instance.
	//
	// The instance might be automatically recreated based on the scaling settings
	// of the version. For more information, see "How Instances are Managed"
	// ([standard environment](https://cloud.google.com/appengine/docs/standard/python/how-instances-are-managed) |
	// [flexible environment](https://cloud.google.com/appengine/docs/flexible/python/how-instances-are-managed)).
	//
	// To ensure that instances are not re-created and avoid getting billed, you
	// can stop all instances within the target version by changing the serving
	// status of the version to `STOPPED` with the
	// [`apps.services.versions.patch`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions/patch)
	// method.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enables debugging on a VM instance. This allows you to use the SSH
	// command to connect to the virtual machine where the instance lives.
	// While in "debug mode", the instance continues to serve live traffic.
	// You should delete the instance when you are done debugging and then
	// allow the system to take over and determine if another instance
	// should be started.
	//
	// Only applicable for instances in App Engine flexible environment.
	DebugInstance(ctx context.Context, in *DebugInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type instancesClient struct {
	cc grpc.ClientConnInterface
}

func NewInstancesClient(cc grpc.ClientConnInterface) InstancesClient {
	return &instancesClient{cc}
}

func (c *instancesClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, Instances_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, Instances_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Instances_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DebugInstance(ctx context.Context, in *DebugInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Instances_DebugInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstancesServer is the server API for Instances service.
// All implementations should embed UnimplementedInstancesServer
// for forward compatibility
type InstancesServer interface {
	// Lists the instances of a version.
	//
	// Tip: To aggregate details about instances over time, see the
	// [Stackdriver Monitoring API](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets instance information.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Stops a running instance.
	//
	// The instance might be automatically recreated based on the scaling settings
	// of the version. For more information, see "How Instances are Managed"
	// ([standard environment](https://cloud.google.com/appengine/docs/standard/python/how-instances-are-managed) |
	// [flexible environment](https://cloud.google.com/appengine/docs/flexible/python/how-instances-are-managed)).
	//
	// To ensure that instances are not re-created and avoid getting billed, you
	// can stop all instances within the target version by changing the serving
	// status of the version to `STOPPED` with the
	// [`apps.services.versions.patch`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions/patch)
	// method.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Enables debugging on a VM instance. This allows you to use the SSH
	// command to connect to the virtual machine where the instance lives.
	// While in "debug mode", the instance continues to serve live traffic.
	// You should delete the instance when you are done debugging and then
	// allow the system to take over and determine if another instance
	// should be started.
	//
	// Only applicable for instances in App Engine flexible environment.
	DebugInstance(context.Context, *DebugInstanceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedInstancesServer should be embedded to have forward compatible implementations.
type UnimplementedInstancesServer struct {
}

func (UnimplementedInstancesServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedInstancesServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedInstancesServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedInstancesServer) DebugInstance(context.Context, *DebugInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DebugInstance not implemented")
}

// UnsafeInstancesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstancesServer will
// result in compilation errors.
type UnsafeInstancesServer interface {
	mustEmbedUnimplementedInstancesServer()
}

func RegisterInstancesServer(s grpc.ServiceRegistrar, srv InstancesServer) {
	s.RegisterService(&Instances_ServiceDesc, srv)
}

func _Instances_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DebugInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DebugInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_DebugInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DebugInstance(ctx, req.(*DebugInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Instances_ServiceDesc is the grpc.ServiceDesc for Instances service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Instances_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Instances",
	HandlerType: (*InstancesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _Instances_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _Instances_GetInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _Instances_DeleteInstance_Handler,
		},
		{
			MethodName: "DebugInstance",
			Handler:    _Instances_DebugInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	Firewall_ListIngressRules_FullMethodName        = "/google.appengine.v1.Firewall/ListIngressRules"
	Firewall_BatchUpdateIngressRules_FullMethodName = "/google.appengine.v1.Firewall/BatchUpdateIngressRules"
	Firewall_CreateIngressRule_FullMethodName       = "/google.appengine.v1.Firewall/CreateIngressRule"
	Firewall_GetIngressRule_FullMethodName          = "/google.appengine.v1.Firewall/GetIngressRule"
	Firewall_UpdateIngressRule_FullMethodName       = "/google.appengine.v1.Firewall/UpdateIngressRule"
	Firewall_DeleteIngressRule_FullMethodName       = "/google.appengine.v1.Firewall/DeleteIngressRule"
)

// FirewallClient is the client API for Firewall service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FirewallClient interface {
	// Lists the firewall rules of an application.
	ListIngressRules(ctx context.Context, in *ListIngressRulesRequest, opts ...grpc.CallOption) (*ListIngressRulesResponse, error)
	// Replaces the entire firewall ruleset in one bulk operation. This overrides
	// and replaces the rules of an existing firewall with the new rules.
	//
	// If the final rule does not match traffic with the '*' wildcard IP range,
	// then an "allow all" rule is explicitly added to the end of the list.
	BatchUpdateIngressRules(ctx context.Context, in *BatchUpdateIngressRulesRequest, opts ...grpc.CallOption) (*BatchUpdateIngressRulesResponse, error)
	// Creates a firewall rule for the application.
	CreateIngressRule(ctx context.Context, in *CreateIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error)
	// Gets the specified firewall rule.
	GetIngressRule(ctx context.Context, in *GetIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error)
	// Updates the specified firewall rule.
	UpdateIngressRule(ctx context.Context, in *UpdateIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error)
	// Deletes the specified firewall rule.
	DeleteIngressRule(ctx context.Context, in *DeleteIngressRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type firewallClient struct {
	cc grpc.ClientConnInterface
}

func NewFirewallClient(cc grpc.ClientConnInterface) FirewallClient {
	return &firewallClient{cc}
}

func (c *firewallClient) ListIngressRules(ctx context.Context, in *ListIngressRulesRequest, opts ...grpc.CallOption) (*ListIngressRulesResponse, error) {
	out := new(ListIngressRulesResponse)
	err := c.cc.Invoke(ctx, Firewall_ListIngressRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallClient) BatchUpdateIngressRules(ctx context.Context, in *BatchUpdateIngressRulesRequest, opts ...grpc.CallOption) (*BatchUpdateIngressRulesResponse, error) {
	out := new(BatchUpdateIngressRulesResponse)
	err := c.cc.Invoke(ctx, Firewall_BatchUpdateIngressRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallClient) CreateIngressRule(ctx context.Context, in *CreateIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error) {
	out := new(FirewallRule)
	err := c.cc.Invoke(ctx, Firewall_CreateIngressRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallClient) GetIngressRule(ctx context.Context, in *GetIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error) {
	out := new(FirewallRule)
	err := c.cc.Invoke(ctx, Firewall_GetIngressRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallClient) UpdateIngressRule(ctx context.Context, in *UpdateIngressRuleRequest, opts ...grpc.CallOption) (*FirewallRule, error) {
	out := new(FirewallRule)
	err := c.cc.Invoke(ctx, Firewall_UpdateIngressRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallClient) DeleteIngressRule(ctx context.Context, in *DeleteIngressRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Firewall_DeleteIngressRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirewallServer is the server API for Firewall service.
// All implementations should embed UnimplementedFirewallServer
// for forward compatibility
type FirewallServer interface {
	// Lists the firewall rules of an application.
	ListIngressRules(context.Context, *ListIngressRulesRequest) (*ListIngressRulesResponse, error)
	// Replaces the entire firewall ruleset in one bulk operation. This overrides
	// and replaces the rules of an existing firewall with the new rules.
	//
	// If the final rule does not match traffic with the '*' wildcard IP range,
	// then an "allow all" rule is explicitly added to the end of the list.
	BatchUpdateIngressRules(context.Context, *BatchUpdateIngressRulesRequest) (*BatchUpdateIngressRulesResponse, error)
	// Creates a firewall rule for the application.
	CreateIngressRule(context.Context, *CreateIngressRuleRequest) (*FirewallRule, error)
	// Gets the specified firewall rule.
	GetIngressRule(context.Context, *GetIngressRuleRequest) (*FirewallRule, error)
	// Updates the specified firewall rule.
	UpdateIngressRule(context.Context, *UpdateIngressRuleRequest) (*FirewallRule, error)
	// Deletes the specified firewall rule.
	DeleteIngressRule(context.Context, *DeleteIngressRuleRequest) (*emptypb.Empty, error)
}

// UnimplementedFirewallServer should be embedded to have forward compatible implementations.
type UnimplementedFirewallServer struct {
}

func (UnimplementedFirewallServer) ListIngressRules(context.Context, *ListIngressRulesRequest) (*ListIngressRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIngressRules not implemented")
}
func (UnimplementedFirewallServer) BatchUpdateIngressRules(context.Context, *BatchUpdateIngressRulesRequest) (*BatchUpdateIngressRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateIngressRules not implemented")
}
func (UnimplementedFirewallServer) CreateIngressRule(context.Context, *CreateIngressRuleRequest) (*FirewallRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIngressRule not implemented")
}
func (UnimplementedFirewallServer) GetIngressRule(context.Context, *GetIngressRuleRequest) (*FirewallRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIngressRule not implemented")
}
func (UnimplementedFirewallServer) UpdateIngressRule(context.Context, *UpdateIngressRuleRequest) (*FirewallRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIngressRule not implemented")
}
func (UnimplementedFirewallServer) DeleteIngressRule(context.Context, *DeleteIngressRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIngressRule not implemented")
}

// UnsafeFirewallServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FirewallServer will
// result in compilation errors.
type UnsafeFirewallServer interface {
	mustEmbedUnimplementedFirewallServer()
}

func RegisterFirewallServer(s grpc.ServiceRegistrar, srv FirewallServer) {
	s.RegisterService(&Firewall_ServiceDesc, srv)
}

func _Firewall_ListIngressRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIngressRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).ListIngressRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_ListIngressRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).ListIngressRules(ctx, req.(*ListIngressRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewall_BatchUpdateIngressRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateIngressRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).BatchUpdateIngressRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_BatchUpdateIngressRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).BatchUpdateIngressRules(ctx, req.(*BatchUpdateIngressRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewall_CreateIngressRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIngressRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).CreateIngressRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_CreateIngressRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).CreateIngressRule(ctx, req.(*CreateIngressRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewall_GetIngressRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIngressRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).GetIngressRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_GetIngressRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).GetIngressRule(ctx, req.(*GetIngressRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewall_UpdateIngressRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIngressRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).UpdateIngressRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_UpdateIngressRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).UpdateIngressRule(ctx, req.(*UpdateIngressRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewall_DeleteIngressRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIngressRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallServer).DeleteIngressRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewall_DeleteIngressRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallServer).DeleteIngressRule(ctx, req.(*DeleteIngressRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Firewall_ServiceDesc is the grpc.ServiceDesc for Firewall service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Firewall_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Firewall",
	HandlerType: (*FirewallServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIngressRules",
			Handler:    _Firewall_ListIngressRules_Handler,
		},
		{
			MethodName: "BatchUpdateIngressRules",
			Handler:    _Firewall_BatchUpdateIngressRules_Handler,
		},
		{
			MethodName: "CreateIngressRule",
			Handler:    _Firewall_CreateIngressRule_Handler,
		},
		{
			MethodName: "GetIngressRule",
			Handler:    _Firewall_GetIngressRule_Handler,
		},
		{
			MethodName: "UpdateIngressRule",
			Handler:    _Firewall_UpdateIngressRule_Handler,
		},
		{
			MethodName: "DeleteIngressRule",
			Handler:    _Firewall_DeleteIngressRule_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	AuthorizedDomains_ListAuthorizedDomains_FullMethodName = "/google.appengine.v1.AuthorizedDomains/ListAuthorizedDomains"
)

// AuthorizedDomainsClient is the client API for AuthorizedDomains service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AuthorizedDomainsClient interface {
	// Lists all domains the user is authorized to administer.
	ListAuthorizedDomains(ctx context.Context, in *ListAuthorizedDomainsRequest, opts ...grpc.CallOption) (*ListAuthorizedDomainsResponse, error)
}

type authorizedDomainsClient struct {
	cc grpc.ClientConnInterface
}

func NewAuthorizedDomainsClient(cc grpc.ClientConnInterface) AuthorizedDomainsClient {
	return &authorizedDomainsClient{cc}
}

func (c *authorizedDomainsClient) ListAuthorizedDomains(ctx context.Context, in *ListAuthorizedDomainsRequest, opts ...grpc.CallOption) (*ListAuthorizedDomainsResponse, error) {
	out := new(ListAuthorizedDomainsResponse)
	err := c.cc.Invoke(ctx, AuthorizedDomains_ListAuthorizedDomains_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuthorizedDomainsServer is the server API for AuthorizedDomains service.
// All implementations should embed UnimplementedAuthorizedDomainsServer
// for forward compatibility
type AuthorizedDomainsServer interface {
	// Lists all domains the user is authorized to administer.
	ListAuthorizedDomains(context.Context, *ListAuthorizedDomainsRequest) (*ListAuthorizedDomainsResponse, error)
}

// UnimplementedAuthorizedDomainsServer should be embedded to have forward compatible implementations.
type UnimplementedAuthorizedDomainsServer struct {
}

func (UnimplementedAuthorizedDomainsServer) ListAuthorizedDomains(context.Context, *ListAuthorizedDomainsRequest) (*ListAuthorizedDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthorizedDomains not implemented")
}

// UnsafeAuthorizedDomainsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AuthorizedDomainsServer will
// result in compilation errors.
type UnsafeAuthorizedDomainsServer interface {
	mustEmbedUnimplementedAuthorizedDomainsServer()
}

func RegisterAuthorizedDomainsServer(s grpc.ServiceRegistrar, srv AuthorizedDomainsServer) {
	s.RegisterService(&AuthorizedDomains_ServiceDesc, srv)
}

func _AuthorizedDomains_ListAuthorizedDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuthorizedDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedDomainsServer).ListAuthorizedDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedDomains_ListAuthorizedDomains_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedDomainsServer).ListAuthorizedDomains(ctx, req.(*ListAuthorizedDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AuthorizedDomains_ServiceDesc is the grpc.ServiceDesc for AuthorizedDomains service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AuthorizedDomains_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.AuthorizedDomains",
	HandlerType: (*AuthorizedDomainsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAuthorizedDomains",
			Handler:    _AuthorizedDomains_ListAuthorizedDomains_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	AuthorizedCertificates_ListAuthorizedCertificates_FullMethodName  = "/google.appengine.v1.AuthorizedCertificates/ListAuthorizedCertificates"
	AuthorizedCertificates_GetAuthorizedCertificate_FullMethodName    = "/google.appengine.v1.AuthorizedCertificates/GetAuthorizedCertificate"
	AuthorizedCertificates_CreateAuthorizedCertificate_FullMethodName = "/google.appengine.v1.AuthorizedCertificates/CreateAuthorizedCertificate"
	AuthorizedCertificates_UpdateAuthorizedCertificate_FullMethodName = "/google.appengine.v1.AuthorizedCertificates/UpdateAuthorizedCertificate"
	AuthorizedCertificates_DeleteAuthorizedCertificate_FullMethodName = "/google.appengine.v1.AuthorizedCertificates/DeleteAuthorizedCertificate"
)

// AuthorizedCertificatesClient is the client API for AuthorizedCertificates service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AuthorizedCertificatesClient interface {
	// Lists all SSL certificates the user is authorized to administer.
	ListAuthorizedCertificates(ctx context.Context, in *ListAuthorizedCertificatesRequest, opts ...grpc.CallOption) (*ListAuthorizedCertificatesResponse, error)
	// Gets the specified SSL certificate.
	GetAuthorizedCertificate(ctx context.Context, in *GetAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error)
	// Uploads the specified SSL certificate.
	CreateAuthorizedCertificate(ctx context.Context, in *CreateAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error)
	// Updates the specified SSL certificate. To renew a certificate and maintain
	// its existing domain mappings, update `certificate_data` with a new
	// certificate. The new certificate must be applicable to the same domains as
	// the original certificate. The certificate `display_name` may also be
	// updated.
	UpdateAuthorizedCertificate(ctx context.Context, in *UpdateAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error)
	// Deletes the specified SSL certificate.
	DeleteAuthorizedCertificate(ctx context.Context, in *DeleteAuthorizedCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type authorizedCertificatesClient struct {
	cc grpc.ClientConnInterface
}

func NewAuthorizedCertificatesClient(cc grpc.ClientConnInterface) AuthorizedCertificatesClient {
	return &authorizedCertificatesClient{cc}
}

func (c *authorizedCertificatesClient) ListAuthorizedCertificates(ctx context.Context, in *ListAuthorizedCertificatesRequest, opts ...grpc.CallOption) (*ListAuthorizedCertificatesResponse, error) {
	out := new(ListAuthorizedCertificatesResponse)
	err := c.cc.Invoke(ctx, AuthorizedCertificates_ListAuthorizedCertificates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authorizedCertificatesClient) GetAuthorizedCertificate(ctx context.Context, in *GetAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error) {
	out := new(AuthorizedCertificate)
	err := c.cc.Invoke(ctx, AuthorizedCertificates_GetAuthorizedCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authorizedCertificatesClient) CreateAuthorizedCertificate(ctx context.Context, in *CreateAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error) {
	out := new(AuthorizedCertificate)
	err := c.cc.Invoke(ctx, AuthorizedCertificates_CreateAuthorizedCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authorizedCertificatesClient) UpdateAuthorizedCertificate(ctx context.Context, in *UpdateAuthorizedCertificateRequest, opts ...grpc.CallOption) (*AuthorizedCertificate, error) {
	out := new(AuthorizedCertificate)
	err := c.cc.Invoke(ctx, AuthorizedCertificates_UpdateAuthorizedCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authorizedCertificatesClient) DeleteAuthorizedCertificate(ctx context.Context, in *DeleteAuthorizedCertificateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AuthorizedCertificates_DeleteAuthorizedCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuthorizedCertificatesServer is the server API for AuthorizedCertificates service.
// All implementations should embed UnimplementedAuthorizedCertificatesServer
// for forward compatibility
type AuthorizedCertificatesServer interface {
	// Lists all SSL certificates the user is authorized to administer.
	ListAuthorizedCertificates(context.Context, *ListAuthorizedCertificatesRequest) (*ListAuthorizedCertificatesResponse, error)
	// Gets the specified SSL certificate.
	GetAuthorizedCertificate(context.Context, *GetAuthorizedCertificateRequest) (*AuthorizedCertificate, error)
	// Uploads the specified SSL certificate.
	CreateAuthorizedCertificate(context.Context, *CreateAuthorizedCertificateRequest) (*AuthorizedCertificate, error)
	// Updates the specified SSL certificate. To renew a certificate and maintain
	// its existing domain mappings, update `certificate_data` with a new
	// certificate. The new certificate must be applicable to the same domains as
	// the original certificate. The certificate `display_name` may also be
	// updated.
	UpdateAuthorizedCertificate(context.Context, *UpdateAuthorizedCertificateRequest) (*AuthorizedCertificate, error)
	// Deletes the specified SSL certificate.
	DeleteAuthorizedCertificate(context.Context, *DeleteAuthorizedCertificateRequest) (*emptypb.Empty, error)
}

// UnimplementedAuthorizedCertificatesServer should be embedded to have forward compatible implementations.
type UnimplementedAuthorizedCertificatesServer struct {
}

func (UnimplementedAuthorizedCertificatesServer) ListAuthorizedCertificates(context.Context, *ListAuthorizedCertificatesRequest) (*ListAuthorizedCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthorizedCertificates not implemented")
}
func (UnimplementedAuthorizedCertificatesServer) GetAuthorizedCertificate(context.Context, *GetAuthorizedCertificateRequest) (*AuthorizedCertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorizedCertificate not implemented")
}
func (UnimplementedAuthorizedCertificatesServer) CreateAuthorizedCertificate(context.Context, *CreateAuthorizedCertificateRequest) (*AuthorizedCertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAuthorizedCertificate not implemented")
}
func (UnimplementedAuthorizedCertificatesServer) UpdateAuthorizedCertificate(context.Context, *UpdateAuthorizedCertificateRequest) (*AuthorizedCertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAuthorizedCertificate not implemented")
}
func (UnimplementedAuthorizedCertificatesServer) DeleteAuthorizedCertificate(context.Context, *DeleteAuthorizedCertificateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuthorizedCertificate not implemented")
}

// UnsafeAuthorizedCertificatesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AuthorizedCertificatesServer will
// result in compilation errors.
type UnsafeAuthorizedCertificatesServer interface {
	mustEmbedUnimplementedAuthorizedCertificatesServer()
}

func RegisterAuthorizedCertificatesServer(s grpc.ServiceRegistrar, srv AuthorizedCertificatesServer) {
	s.RegisterService(&AuthorizedCertificates_ServiceDesc, srv)
}

func _AuthorizedCertificates_ListAuthorizedCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuthorizedCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedCertificatesServer).ListAuthorizedCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedCertificates_ListAuthorizedCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedCertificatesServer).ListAuthorizedCertificates(ctx, req.(*ListAuthorizedCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthorizedCertificates_GetAuthorizedCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizedCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedCertificatesServer).GetAuthorizedCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedCertificates_GetAuthorizedCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedCertificatesServer).GetAuthorizedCertificate(ctx, req.(*GetAuthorizedCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthorizedCertificates_CreateAuthorizedCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAuthorizedCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedCertificatesServer).CreateAuthorizedCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedCertificates_CreateAuthorizedCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedCertificatesServer).CreateAuthorizedCertificate(ctx, req.(*CreateAuthorizedCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthorizedCertificates_UpdateAuthorizedCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAuthorizedCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedCertificatesServer).UpdateAuthorizedCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedCertificates_UpdateAuthorizedCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedCertificatesServer).UpdateAuthorizedCertificate(ctx, req.(*UpdateAuthorizedCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthorizedCertificates_DeleteAuthorizedCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuthorizedCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthorizedCertificatesServer).DeleteAuthorizedCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthorizedCertificates_DeleteAuthorizedCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthorizedCertificatesServer).DeleteAuthorizedCertificate(ctx, req.(*DeleteAuthorizedCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AuthorizedCertificates_ServiceDesc is the grpc.ServiceDesc for AuthorizedCertificates service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AuthorizedCertificates_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.AuthorizedCertificates",
	HandlerType: (*AuthorizedCertificatesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAuthorizedCertificates",
			Handler:    _AuthorizedCertificates_ListAuthorizedCertificates_Handler,
		},
		{
			MethodName: "GetAuthorizedCertificate",
			Handler:    _AuthorizedCertificates_GetAuthorizedCertificate_Handler,
		},
		{
			MethodName: "CreateAuthorizedCertificate",
			Handler:    _AuthorizedCertificates_CreateAuthorizedCertificate_Handler,
		},
		{
			MethodName: "UpdateAuthorizedCertificate",
			Handler:    _AuthorizedCertificates_UpdateAuthorizedCertificate_Handler,
		},
		{
			MethodName: "DeleteAuthorizedCertificate",
			Handler:    _AuthorizedCertificates_DeleteAuthorizedCertificate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}

const (
	DomainMappings_ListDomainMappings_FullMethodName  = "/google.appengine.v1.DomainMappings/ListDomainMappings"
	DomainMappings_GetDomainMapping_FullMethodName    = "/google.appengine.v1.DomainMappings/GetDomainMapping"
	DomainMappings_CreateDomainMapping_FullMethodName = "/google.appengine.v1.DomainMappings/CreateDomainMapping"
	DomainMappings_UpdateDomainMapping_FullMethodName = "/google.appengine.v1.DomainMappings/UpdateDomainMapping"
	DomainMappings_DeleteDomainMapping_FullMethodName = "/google.appengine.v1.DomainMappings/DeleteDomainMapping"
)

// DomainMappingsClient is the client API for DomainMappings service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DomainMappingsClient interface {
	// Lists the domain mappings on an application.
	ListDomainMappings(ctx context.Context, in *ListDomainMappingsRequest, opts ...grpc.CallOption) (*ListDomainMappingsResponse, error)
	// Gets the specified domain mapping.
	GetDomainMapping(ctx context.Context, in *GetDomainMappingRequest, opts ...grpc.CallOption) (*DomainMapping, error)
	// Maps a domain to an application. A user must be authorized to administer a
	// domain in order to map it to an application. For a list of available
	// authorized domains, see [`AuthorizedDomains.ListAuthorizedDomains`]().
	CreateDomainMapping(ctx context.Context, in *CreateDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified domain mapping. To map an SSL certificate to a
	// domain mapping, update `certificate_id` to point to an `AuthorizedCertificate`
	// resource. A user must be authorized to administer the associated domain
	// in order to update a `DomainMapping` resource.
	UpdateDomainMapping(ctx context.Context, in *UpdateDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified domain mapping. A user must be authorized to
	// administer the associated domain in order to delete a `DomainMapping`
	// resource.
	DeleteDomainMapping(ctx context.Context, in *DeleteDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type domainMappingsClient struct {
	cc grpc.ClientConnInterface
}

func NewDomainMappingsClient(cc grpc.ClientConnInterface) DomainMappingsClient {
	return &domainMappingsClient{cc}
}

func (c *domainMappingsClient) ListDomainMappings(ctx context.Context, in *ListDomainMappingsRequest, opts ...grpc.CallOption) (*ListDomainMappingsResponse, error) {
	out := new(ListDomainMappingsResponse)
	err := c.cc.Invoke(ctx, DomainMappings_ListDomainMappings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainMappingsClient) GetDomainMapping(ctx context.Context, in *GetDomainMappingRequest, opts ...grpc.CallOption) (*DomainMapping, error) {
	out := new(DomainMapping)
	err := c.cc.Invoke(ctx, DomainMappings_GetDomainMapping_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainMappingsClient) CreateDomainMapping(ctx context.Context, in *CreateDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DomainMappings_CreateDomainMapping_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainMappingsClient) UpdateDomainMapping(ctx context.Context, in *UpdateDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DomainMappings_UpdateDomainMapping_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainMappingsClient) DeleteDomainMapping(ctx context.Context, in *DeleteDomainMappingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DomainMappings_DeleteDomainMapping_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DomainMappingsServer is the server API for DomainMappings service.
// All implementations should embed UnimplementedDomainMappingsServer
// for forward compatibility
type DomainMappingsServer interface {
	// Lists the domain mappings on an application.
	ListDomainMappings(context.Context, *ListDomainMappingsRequest) (*ListDomainMappingsResponse, error)
	// Gets the specified domain mapping.
	GetDomainMapping(context.Context, *GetDomainMappingRequest) (*DomainMapping, error)
	// Maps a domain to an application. A user must be authorized to administer a
	// domain in order to map it to an application. For a list of available
	// authorized domains, see [`AuthorizedDomains.ListAuthorizedDomains`]().
	CreateDomainMapping(context.Context, *CreateDomainMappingRequest) (*longrunningpb.Operation, error)
	// Updates the specified domain mapping. To map an SSL certificate to a
	// domain mapping, update `certificate_id` to point to an `AuthorizedCertificate`
	// resource. A user must be authorized to administer the associated domain
	// in order to update a `DomainMapping` resource.
	UpdateDomainMapping(context.Context, *UpdateDomainMappingRequest) (*longrunningpb.Operation, error)
	// Deletes the specified domain mapping. A user must be authorized to
	// administer the associated domain in order to delete a `DomainMapping`
	// resource.
	DeleteDomainMapping(context.Context, *DeleteDomainMappingRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDomainMappingsServer should be embedded to have forward compatible implementations.
type UnimplementedDomainMappingsServer struct {
}

func (UnimplementedDomainMappingsServer) ListDomainMappings(context.Context, *ListDomainMappingsRequest) (*ListDomainMappingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDomainMappings not implemented")
}
func (UnimplementedDomainMappingsServer) GetDomainMapping(context.Context, *GetDomainMappingRequest) (*DomainMapping, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDomainMapping not implemented")
}
func (UnimplementedDomainMappingsServer) CreateDomainMapping(context.Context, *CreateDomainMappingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDomainMapping not implemented")
}
func (UnimplementedDomainMappingsServer) UpdateDomainMapping(context.Context, *UpdateDomainMappingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDomainMapping not implemented")
}
func (UnimplementedDomainMappingsServer) DeleteDomainMapping(context.Context, *DeleteDomainMappingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDomainMapping not implemented")
}

// UnsafeDomainMappingsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DomainMappingsServer will
// result in compilation errors.
type UnsafeDomainMappingsServer interface {
	mustEmbedUnimplementedDomainMappingsServer()
}

func RegisterDomainMappingsServer(s grpc.ServiceRegistrar, srv DomainMappingsServer) {
	s.RegisterService(&DomainMappings_ServiceDesc, srv)
}

func _DomainMappings_ListDomainMappings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDomainMappingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainMappingsServer).ListDomainMappings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DomainMappings_ListDomainMappings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainMappingsServer).ListDomainMappings(ctx, req.(*ListDomainMappingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DomainMappings_GetDomainMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDomainMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainMappingsServer).GetDomainMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DomainMappings_GetDomainMapping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainMappingsServer).GetDomainMapping(ctx, req.(*GetDomainMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DomainMappings_CreateDomainMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDomainMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainMappingsServer).CreateDomainMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DomainMappings_CreateDomainMapping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainMappingsServer).CreateDomainMapping(ctx, req.(*CreateDomainMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DomainMappings_UpdateDomainMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDomainMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainMappingsServer).UpdateDomainMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DomainMappings_UpdateDomainMapping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainMappingsServer).UpdateDomainMapping(ctx, req.(*UpdateDomainMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DomainMappings_DeleteDomainMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDomainMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainMappingsServer).DeleteDomainMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DomainMappings_DeleteDomainMapping_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainMappingsServer).DeleteDomainMapping(ctx, req.(*DeleteDomainMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DomainMappings_ServiceDesc is the grpc.ServiceDesc for DomainMappings service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DomainMappings_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.DomainMappings",
	HandlerType: (*DomainMappingsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDomainMappings",
			Handler:    _DomainMappings_ListDomainMappings_Handler,
		},
		{
			MethodName: "GetDomainMapping",
			Handler:    _DomainMappings_GetDomainMapping_Handler,
		},
		{
			MethodName: "CreateDomainMapping",
			Handler:    _DomainMappings_CreateDomainMapping_Handler,
		},
		{
			MethodName: "UpdateDomainMapping",
			Handler:    _DomainMappings_UpdateDomainMapping_Handler,
		},
		{
			MethodName: "DeleteDomainMapping",
			Handler:    _DomainMappings_DeleteDomainMapping_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/appengine/v1/appengine.proto",
}
