// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/index_endpoint_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	IndexEndpointService_CreateIndexEndpoint_FullMethodName = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/CreateIndexEndpoint"
	IndexEndpointService_GetIndexEndpoint_FullMethodName    = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/GetIndexEndpoint"
	IndexEndpointService_ListIndexEndpoints_FullMethodName  = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/ListIndexEndpoints"
	IndexEndpointService_UpdateIndexEndpoint_FullMethodName = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/UpdateIndexEndpoint"
	IndexEndpointService_DeleteIndexEndpoint_FullMethodName = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/DeleteIndexEndpoint"
	IndexEndpointService_DeployIndex_FullMethodName         = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/DeployIndex"
	IndexEndpointService_UndeployIndex_FullMethodName       = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/UndeployIndex"
	IndexEndpointService_MutateDeployedIndex_FullMethodName = "/google.cloud.aiplatform.v1beta1.IndexEndpointService/MutateDeployedIndex"
)

// IndexEndpointServiceClient is the client API for IndexEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IndexEndpointServiceClient interface {
	// Creates an IndexEndpoint.
	CreateIndexEndpoint(ctx context.Context, in *CreateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an IndexEndpoint.
	GetIndexEndpoint(ctx context.Context, in *GetIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error)
	// Lists IndexEndpoints in a Location.
	ListIndexEndpoints(ctx context.Context, in *ListIndexEndpointsRequest, opts ...grpc.CallOption) (*ListIndexEndpointsResponse, error)
	// Updates an IndexEndpoint.
	UpdateIndexEndpoint(ctx context.Context, in *UpdateIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error)
	// Deletes an IndexEndpoint.
	DeleteIndexEndpoint(ctx context.Context, in *DeleteIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys an Index into this IndexEndpoint, creating a DeployedIndex within
	// it.
	// Only non-empty Indexes can be deployed.
	DeployIndex(ctx context.Context, in *DeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys an Index from an IndexEndpoint, removing a DeployedIndex from it,
	// and freeing all resources it's using.
	UndeployIndex(ctx context.Context, in *UndeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update an existing DeployedIndex under an IndexEndpoint.
	MutateDeployedIndex(ctx context.Context, in *MutateDeployedIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type indexEndpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIndexEndpointServiceClient(cc grpc.ClientConnInterface) IndexEndpointServiceClient {
	return &indexEndpointServiceClient{cc}
}

func (c *indexEndpointServiceClient) CreateIndexEndpoint(ctx context.Context, in *CreateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IndexEndpointService_CreateIndexEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) GetIndexEndpoint(ctx context.Context, in *GetIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error) {
	out := new(IndexEndpoint)
	err := c.cc.Invoke(ctx, IndexEndpointService_GetIndexEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) ListIndexEndpoints(ctx context.Context, in *ListIndexEndpointsRequest, opts ...grpc.CallOption) (*ListIndexEndpointsResponse, error) {
	out := new(ListIndexEndpointsResponse)
	err := c.cc.Invoke(ctx, IndexEndpointService_ListIndexEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) UpdateIndexEndpoint(ctx context.Context, in *UpdateIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error) {
	out := new(IndexEndpoint)
	err := c.cc.Invoke(ctx, IndexEndpointService_UpdateIndexEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) DeleteIndexEndpoint(ctx context.Context, in *DeleteIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IndexEndpointService_DeleteIndexEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) DeployIndex(ctx context.Context, in *DeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IndexEndpointService_DeployIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) UndeployIndex(ctx context.Context, in *UndeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IndexEndpointService_UndeployIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexEndpointServiceClient) MutateDeployedIndex(ctx context.Context, in *MutateDeployedIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IndexEndpointService_MutateDeployedIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IndexEndpointServiceServer is the server API for IndexEndpointService service.
// All implementations should embed UnimplementedIndexEndpointServiceServer
// for forward compatibility
type IndexEndpointServiceServer interface {
	// Creates an IndexEndpoint.
	CreateIndexEndpoint(context.Context, *CreateIndexEndpointRequest) (*longrunningpb.Operation, error)
	// Gets an IndexEndpoint.
	GetIndexEndpoint(context.Context, *GetIndexEndpointRequest) (*IndexEndpoint, error)
	// Lists IndexEndpoints in a Location.
	ListIndexEndpoints(context.Context, *ListIndexEndpointsRequest) (*ListIndexEndpointsResponse, error)
	// Updates an IndexEndpoint.
	UpdateIndexEndpoint(context.Context, *UpdateIndexEndpointRequest) (*IndexEndpoint, error)
	// Deletes an IndexEndpoint.
	DeleteIndexEndpoint(context.Context, *DeleteIndexEndpointRequest) (*longrunningpb.Operation, error)
	// Deploys an Index into this IndexEndpoint, creating a DeployedIndex within
	// it.
	// Only non-empty Indexes can be deployed.
	DeployIndex(context.Context, *DeployIndexRequest) (*longrunningpb.Operation, error)
	// Undeploys an Index from an IndexEndpoint, removing a DeployedIndex from it,
	// and freeing all resources it's using.
	UndeployIndex(context.Context, *UndeployIndexRequest) (*longrunningpb.Operation, error)
	// Update an existing DeployedIndex under an IndexEndpoint.
	MutateDeployedIndex(context.Context, *MutateDeployedIndexRequest) (*longrunningpb.Operation, error)
}

// UnimplementedIndexEndpointServiceServer should be embedded to have forward compatible implementations.
type UnimplementedIndexEndpointServiceServer struct {
}

func (UnimplementedIndexEndpointServiceServer) CreateIndexEndpoint(context.Context, *CreateIndexEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndexEndpoint not implemented")
}
func (UnimplementedIndexEndpointServiceServer) GetIndexEndpoint(context.Context, *GetIndexEndpointRequest) (*IndexEndpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndexEndpoint not implemented")
}
func (UnimplementedIndexEndpointServiceServer) ListIndexEndpoints(context.Context, *ListIndexEndpointsRequest) (*ListIndexEndpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexEndpoints not implemented")
}
func (UnimplementedIndexEndpointServiceServer) UpdateIndexEndpoint(context.Context, *UpdateIndexEndpointRequest) (*IndexEndpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIndexEndpoint not implemented")
}
func (UnimplementedIndexEndpointServiceServer) DeleteIndexEndpoint(context.Context, *DeleteIndexEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndexEndpoint not implemented")
}
func (UnimplementedIndexEndpointServiceServer) DeployIndex(context.Context, *DeployIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployIndex not implemented")
}
func (UnimplementedIndexEndpointServiceServer) UndeployIndex(context.Context, *UndeployIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployIndex not implemented")
}
func (UnimplementedIndexEndpointServiceServer) MutateDeployedIndex(context.Context, *MutateDeployedIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateDeployedIndex not implemented")
}

// UnsafeIndexEndpointServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IndexEndpointServiceServer will
// result in compilation errors.
type UnsafeIndexEndpointServiceServer interface {
	mustEmbedUnimplementedIndexEndpointServiceServer()
}

func RegisterIndexEndpointServiceServer(s grpc.ServiceRegistrar, srv IndexEndpointServiceServer) {
	s.RegisterService(&IndexEndpointService_ServiceDesc, srv)
}

func _IndexEndpointService_CreateIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).CreateIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_CreateIndexEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).CreateIndexEndpoint(ctx, req.(*CreateIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_GetIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).GetIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_GetIndexEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).GetIndexEndpoint(ctx, req.(*GetIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_ListIndexEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).ListIndexEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_ListIndexEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).ListIndexEndpoints(ctx, req.(*ListIndexEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_UpdateIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).UpdateIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_UpdateIndexEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).UpdateIndexEndpoint(ctx, req.(*UpdateIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_DeleteIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).DeleteIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_DeleteIndexEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).DeleteIndexEndpoint(ctx, req.(*DeleteIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_DeployIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).DeployIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_DeployIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).DeployIndex(ctx, req.(*DeployIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_UndeployIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).UndeployIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_UndeployIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).UndeployIndex(ctx, req.(*UndeployIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexEndpointService_MutateDeployedIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateDeployedIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexEndpointServiceServer).MutateDeployedIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IndexEndpointService_MutateDeployedIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexEndpointServiceServer).MutateDeployedIndex(ctx, req.(*MutateDeployedIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IndexEndpointService_ServiceDesc is the grpc.ServiceDesc for IndexEndpointService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IndexEndpointService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.IndexEndpointService",
	HandlerType: (*IndexEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIndexEndpoint",
			Handler:    _IndexEndpointService_CreateIndexEndpoint_Handler,
		},
		{
			MethodName: "GetIndexEndpoint",
			Handler:    _IndexEndpointService_GetIndexEndpoint_Handler,
		},
		{
			MethodName: "ListIndexEndpoints",
			Handler:    _IndexEndpointService_ListIndexEndpoints_Handler,
		},
		{
			MethodName: "UpdateIndexEndpoint",
			Handler:    _IndexEndpointService_UpdateIndexEndpoint_Handler,
		},
		{
			MethodName: "DeleteIndexEndpoint",
			Handler:    _IndexEndpointService_DeleteIndexEndpoint_Handler,
		},
		{
			MethodName: "DeployIndex",
			Handler:    _IndexEndpointService_DeployIndex_Handler,
		},
		{
			MethodName: "UndeployIndex",
			Handler:    _IndexEndpointService_UndeployIndex_Handler,
		},
		{
			MethodName: "MutateDeployedIndex",
			Handler:    _IndexEndpointService_MutateDeployedIndex_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/index_endpoint_service.proto",
}
