// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dialogflow provides access to the Dialogflow API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dialogflow/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/dialogflow/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dialogflow/v2beta1"
//	...
//	ctx := context.Background()
//	dialogflowService, err := dialogflow.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithScopes(dialogflow.DialogflowScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dialogflow // import "google.golang.org/api/dialogflow/v2beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dialogflow:v2beta1"
const apiName = "dialogflow"
const apiVersion = "v2beta1"
const basePath = "https://dialogflow.googleapis.com/"
const basePathTemplate = "https://dialogflow.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dialogflow.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View, manage and query your Dialogflow agents
	DialogflowScope = "https://www.googleapis.com/auth/dialogflow"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/dialogflow",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Agent = NewProjectsAgentService(s)
	rs.AnswerRecords = NewProjectsAnswerRecordsService(s)
	rs.ConversationProfiles = NewProjectsConversationProfilesService(s)
	rs.Conversations = NewProjectsConversationsService(s)
	rs.Generators = NewProjectsGeneratorsService(s)
	rs.KnowledgeBases = NewProjectsKnowledgeBasesService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	rs.PhoneNumbers = NewProjectsPhoneNumbersService(s)
	rs.Suggestions = NewProjectsSuggestionsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Agent *ProjectsAgentService

	AnswerRecords *ProjectsAnswerRecordsService

	ConversationProfiles *ProjectsConversationProfilesService

	Conversations *ProjectsConversationsService

	Generators *ProjectsGeneratorsService

	KnowledgeBases *ProjectsKnowledgeBasesService

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService

	PhoneNumbers *ProjectsPhoneNumbersService

	Suggestions *ProjectsSuggestionsService
}

func NewProjectsAgentService(s *Service) *ProjectsAgentService {
	rs := &ProjectsAgentService{s: s}
	rs.EntityTypes = NewProjectsAgentEntityTypesService(s)
	rs.Environments = NewProjectsAgentEnvironmentsService(s)
	rs.Intents = NewProjectsAgentIntentsService(s)
	rs.KnowledgeBases = NewProjectsAgentKnowledgeBasesService(s)
	rs.Sessions = NewProjectsAgentSessionsService(s)
	rs.Versions = NewProjectsAgentVersionsService(s)
	return rs
}

type ProjectsAgentService struct {
	s *Service

	EntityTypes *ProjectsAgentEntityTypesService

	Environments *ProjectsAgentEnvironmentsService

	Intents *ProjectsAgentIntentsService

	KnowledgeBases *ProjectsAgentKnowledgeBasesService

	Sessions *ProjectsAgentSessionsService

	Versions *ProjectsAgentVersionsService
}

func NewProjectsAgentEntityTypesService(s *Service) *ProjectsAgentEntityTypesService {
	rs := &ProjectsAgentEntityTypesService{s: s}
	rs.Entities = NewProjectsAgentEntityTypesEntitiesService(s)
	return rs
}

type ProjectsAgentEntityTypesService struct {
	s *Service

	Entities *ProjectsAgentEntityTypesEntitiesService
}

func NewProjectsAgentEntityTypesEntitiesService(s *Service) *ProjectsAgentEntityTypesEntitiesService {
	rs := &ProjectsAgentEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsAgentEntityTypesEntitiesService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsService(s *Service) *ProjectsAgentEnvironmentsService {
	rs := &ProjectsAgentEnvironmentsService{s: s}
	rs.Intents = NewProjectsAgentEnvironmentsIntentsService(s)
	rs.Users = NewProjectsAgentEnvironmentsUsersService(s)
	return rs
}

type ProjectsAgentEnvironmentsService struct {
	s *Service

	Intents *ProjectsAgentEnvironmentsIntentsService

	Users *ProjectsAgentEnvironmentsUsersService
}

func NewProjectsAgentEnvironmentsIntentsService(s *Service) *ProjectsAgentEnvironmentsIntentsService {
	rs := &ProjectsAgentEnvironmentsIntentsService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsIntentsService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsUsersService(s *Service) *ProjectsAgentEnvironmentsUsersService {
	rs := &ProjectsAgentEnvironmentsUsersService{s: s}
	rs.Sessions = NewProjectsAgentEnvironmentsUsersSessionsService(s)
	return rs
}

type ProjectsAgentEnvironmentsUsersService struct {
	s *Service

	Sessions *ProjectsAgentEnvironmentsUsersSessionsService
}

func NewProjectsAgentEnvironmentsUsersSessionsService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsService{s: s}
	rs.Contexts = NewProjectsAgentEnvironmentsUsersSessionsContextsService(s)
	rs.EntityTypes = NewProjectsAgentEnvironmentsUsersSessionsEntityTypesService(s)
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsService struct {
	s *Service

	Contexts *ProjectsAgentEnvironmentsUsersSessionsContextsService

	EntityTypes *ProjectsAgentEnvironmentsUsersSessionsEntityTypesService
}

func NewProjectsAgentEnvironmentsUsersSessionsContextsService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsContextsService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsContextsService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsContextsService struct {
	s *Service
}

func NewProjectsAgentEnvironmentsUsersSessionsEntityTypesService(s *Service) *ProjectsAgentEnvironmentsUsersSessionsEntityTypesService {
	rs := &ProjectsAgentEnvironmentsUsersSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsAgentEnvironmentsUsersSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsAgentIntentsService(s *Service) *ProjectsAgentIntentsService {
	rs := &ProjectsAgentIntentsService{s: s}
	return rs
}

type ProjectsAgentIntentsService struct {
	s *Service
}

func NewProjectsAgentKnowledgeBasesService(s *Service) *ProjectsAgentKnowledgeBasesService {
	rs := &ProjectsAgentKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsAgentKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsAgentKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsAgentKnowledgeBasesDocumentsService
}

func NewProjectsAgentKnowledgeBasesDocumentsService(s *Service) *ProjectsAgentKnowledgeBasesDocumentsService {
	rs := &ProjectsAgentKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsAgentKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsAgentSessionsService(s *Service) *ProjectsAgentSessionsService {
	rs := &ProjectsAgentSessionsService{s: s}
	rs.Contexts = NewProjectsAgentSessionsContextsService(s)
	rs.EntityTypes = NewProjectsAgentSessionsEntityTypesService(s)
	return rs
}

type ProjectsAgentSessionsService struct {
	s *Service

	Contexts *ProjectsAgentSessionsContextsService

	EntityTypes *ProjectsAgentSessionsEntityTypesService
}

func NewProjectsAgentSessionsContextsService(s *Service) *ProjectsAgentSessionsContextsService {
	rs := &ProjectsAgentSessionsContextsService{s: s}
	return rs
}

type ProjectsAgentSessionsContextsService struct {
	s *Service
}

func NewProjectsAgentSessionsEntityTypesService(s *Service) *ProjectsAgentSessionsEntityTypesService {
	rs := &ProjectsAgentSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsAgentSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsAgentVersionsService(s *Service) *ProjectsAgentVersionsService {
	rs := &ProjectsAgentVersionsService{s: s}
	return rs
}

type ProjectsAgentVersionsService struct {
	s *Service
}

func NewProjectsAnswerRecordsService(s *Service) *ProjectsAnswerRecordsService {
	rs := &ProjectsAnswerRecordsService{s: s}
	return rs
}

type ProjectsAnswerRecordsService struct {
	s *Service
}

func NewProjectsConversationProfilesService(s *Service) *ProjectsConversationProfilesService {
	rs := &ProjectsConversationProfilesService{s: s}
	return rs
}

type ProjectsConversationProfilesService struct {
	s *Service
}

func NewProjectsConversationsService(s *Service) *ProjectsConversationsService {
	rs := &ProjectsConversationsService{s: s}
	rs.Messages = NewProjectsConversationsMessagesService(s)
	rs.Participants = NewProjectsConversationsParticipantsService(s)
	rs.Suggestions = NewProjectsConversationsSuggestionsService(s)
	return rs
}

type ProjectsConversationsService struct {
	s *Service

	Messages *ProjectsConversationsMessagesService

	Participants *ProjectsConversationsParticipantsService

	Suggestions *ProjectsConversationsSuggestionsService
}

func NewProjectsConversationsMessagesService(s *Service) *ProjectsConversationsMessagesService {
	rs := &ProjectsConversationsMessagesService{s: s}
	return rs
}

type ProjectsConversationsMessagesService struct {
	s *Service
}

func NewProjectsConversationsParticipantsService(s *Service) *ProjectsConversationsParticipantsService {
	rs := &ProjectsConversationsParticipantsService{s: s}
	rs.Suggestions = NewProjectsConversationsParticipantsSuggestionsService(s)
	return rs
}

type ProjectsConversationsParticipantsService struct {
	s *Service

	Suggestions *ProjectsConversationsParticipantsSuggestionsService
}

func NewProjectsConversationsParticipantsSuggestionsService(s *Service) *ProjectsConversationsParticipantsSuggestionsService {
	rs := &ProjectsConversationsParticipantsSuggestionsService{s: s}
	return rs
}

type ProjectsConversationsParticipantsSuggestionsService struct {
	s *Service
}

func NewProjectsConversationsSuggestionsService(s *Service) *ProjectsConversationsSuggestionsService {
	rs := &ProjectsConversationsSuggestionsService{s: s}
	return rs
}

type ProjectsConversationsSuggestionsService struct {
	s *Service
}

func NewProjectsGeneratorsService(s *Service) *ProjectsGeneratorsService {
	rs := &ProjectsGeneratorsService{s: s}
	return rs
}

type ProjectsGeneratorsService struct {
	s *Service
}

func NewProjectsKnowledgeBasesService(s *Service) *ProjectsKnowledgeBasesService {
	rs := &ProjectsKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsKnowledgeBasesDocumentsService
}

func NewProjectsKnowledgeBasesDocumentsService(s *Service) *ProjectsKnowledgeBasesDocumentsService {
	rs := &ProjectsKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agent = NewProjectsLocationsAgentService(s)
	rs.AnswerRecords = NewProjectsLocationsAnswerRecordsService(s)
	rs.ConversationProfiles = NewProjectsLocationsConversationProfilesService(s)
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.EncryptionSpec = NewProjectsLocationsEncryptionSpecService(s)
	rs.Generators = NewProjectsLocationsGeneratorsService(s)
	rs.KnowledgeBases = NewProjectsLocationsKnowledgeBasesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PhoneNumbers = NewProjectsLocationsPhoneNumbersService(s)
	rs.SipTrunks = NewProjectsLocationsSipTrunksService(s)
	rs.StatelessSuggestion = NewProjectsLocationsStatelessSuggestionService(s)
	rs.Suggestions = NewProjectsLocationsSuggestionsService(s)
	rs.Tools = NewProjectsLocationsToolsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agent *ProjectsLocationsAgentService

	AnswerRecords *ProjectsLocationsAnswerRecordsService

	ConversationProfiles *ProjectsLocationsConversationProfilesService

	Conversations *ProjectsLocationsConversationsService

	EncryptionSpec *ProjectsLocationsEncryptionSpecService

	Generators *ProjectsLocationsGeneratorsService

	KnowledgeBases *ProjectsLocationsKnowledgeBasesService

	Operations *ProjectsLocationsOperationsService

	PhoneNumbers *ProjectsLocationsPhoneNumbersService

	SipTrunks *ProjectsLocationsSipTrunksService

	StatelessSuggestion *ProjectsLocationsStatelessSuggestionService

	Suggestions *ProjectsLocationsSuggestionsService

	Tools *ProjectsLocationsToolsService
}

func NewProjectsLocationsAgentService(s *Service) *ProjectsLocationsAgentService {
	rs := &ProjectsLocationsAgentService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentEntityTypesService(s)
	rs.Environments = NewProjectsLocationsAgentEnvironmentsService(s)
	rs.Intents = NewProjectsLocationsAgentIntentsService(s)
	rs.Sessions = NewProjectsLocationsAgentSessionsService(s)
	rs.Versions = NewProjectsLocationsAgentVersionsService(s)
	return rs
}

type ProjectsLocationsAgentService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentEntityTypesService

	Environments *ProjectsLocationsAgentEnvironmentsService

	Intents *ProjectsLocationsAgentIntentsService

	Sessions *ProjectsLocationsAgentSessionsService

	Versions *ProjectsLocationsAgentVersionsService
}

func NewProjectsLocationsAgentEntityTypesService(s *Service) *ProjectsLocationsAgentEntityTypesService {
	rs := &ProjectsLocationsAgentEntityTypesService{s: s}
	rs.Entities = NewProjectsLocationsAgentEntityTypesEntitiesService(s)
	return rs
}

type ProjectsLocationsAgentEntityTypesService struct {
	s *Service

	Entities *ProjectsLocationsAgentEntityTypesEntitiesService
}

func NewProjectsLocationsAgentEntityTypesEntitiesService(s *Service) *ProjectsLocationsAgentEntityTypesEntitiesService {
	rs := &ProjectsLocationsAgentEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsLocationsAgentEntityTypesEntitiesService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsService(s *Service) *ProjectsLocationsAgentEnvironmentsService {
	rs := &ProjectsLocationsAgentEnvironmentsService{s: s}
	rs.Intents = NewProjectsLocationsAgentEnvironmentsIntentsService(s)
	rs.Users = NewProjectsLocationsAgentEnvironmentsUsersService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsService struct {
	s *Service

	Intents *ProjectsLocationsAgentEnvironmentsIntentsService

	Users *ProjectsLocationsAgentEnvironmentsUsersService
}

func NewProjectsLocationsAgentEnvironmentsIntentsService(s *Service) *ProjectsLocationsAgentEnvironmentsIntentsService {
	rs := &ProjectsLocationsAgentEnvironmentsIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsUsersService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersService{s: s}
	rs.Sessions = NewProjectsLocationsAgentEnvironmentsUsersSessionsService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersService struct {
	s *Service

	Sessions *ProjectsLocationsAgentEnvironmentsUsersSessionsService
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsService{s: s}
	rs.Contexts = NewProjectsLocationsAgentEnvironmentsUsersSessionsContextsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsService struct {
	s *Service

	Contexts *ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService

	EntityTypes *ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsContextsService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsContextsService struct {
	s *Service
}

func NewProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentEnvironmentsUsersSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentIntentsService(s *Service) *ProjectsLocationsAgentIntentsService {
	rs := &ProjectsLocationsAgentIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentSessionsService(s *Service) *ProjectsLocationsAgentSessionsService {
	rs := &ProjectsLocationsAgentSessionsService{s: s}
	rs.Contexts = NewProjectsLocationsAgentSessionsContextsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentSessionsService struct {
	s *Service

	Contexts *ProjectsLocationsAgentSessionsContextsService

	EntityTypes *ProjectsLocationsAgentSessionsEntityTypesService
}

func NewProjectsLocationsAgentSessionsContextsService(s *Service) *ProjectsLocationsAgentSessionsContextsService {
	rs := &ProjectsLocationsAgentSessionsContextsService{s: s}
	return rs
}

type ProjectsLocationsAgentSessionsContextsService struct {
	s *Service
}

func NewProjectsLocationsAgentSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentVersionsService(s *Service) *ProjectsLocationsAgentVersionsService {
	rs := &ProjectsLocationsAgentVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentVersionsService struct {
	s *Service
}

func NewProjectsLocationsAnswerRecordsService(s *Service) *ProjectsLocationsAnswerRecordsService {
	rs := &ProjectsLocationsAnswerRecordsService{s: s}
	return rs
}

type ProjectsLocationsAnswerRecordsService struct {
	s *Service
}

func NewProjectsLocationsConversationProfilesService(s *Service) *ProjectsLocationsConversationProfilesService {
	rs := &ProjectsLocationsConversationProfilesService{s: s}
	return rs
}

type ProjectsLocationsConversationProfilesService struct {
	s *Service
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Messages = NewProjectsLocationsConversationsMessagesService(s)
	rs.Participants = NewProjectsLocationsConversationsParticipantsService(s)
	rs.Suggestions = NewProjectsLocationsConversationsSuggestionsService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Messages *ProjectsLocationsConversationsMessagesService

	Participants *ProjectsLocationsConversationsParticipantsService

	Suggestions *ProjectsLocationsConversationsSuggestionsService
}

func NewProjectsLocationsConversationsMessagesService(s *Service) *ProjectsLocationsConversationsMessagesService {
	rs := &ProjectsLocationsConversationsMessagesService{s: s}
	return rs
}

type ProjectsLocationsConversationsMessagesService struct {
	s *Service
}

func NewProjectsLocationsConversationsParticipantsService(s *Service) *ProjectsLocationsConversationsParticipantsService {
	rs := &ProjectsLocationsConversationsParticipantsService{s: s}
	rs.Suggestions = NewProjectsLocationsConversationsParticipantsSuggestionsService(s)
	return rs
}

type ProjectsLocationsConversationsParticipantsService struct {
	s *Service

	Suggestions *ProjectsLocationsConversationsParticipantsSuggestionsService
}

func NewProjectsLocationsConversationsParticipantsSuggestionsService(s *Service) *ProjectsLocationsConversationsParticipantsSuggestionsService {
	rs := &ProjectsLocationsConversationsParticipantsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsConversationsParticipantsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsConversationsSuggestionsService(s *Service) *ProjectsLocationsConversationsSuggestionsService {
	rs := &ProjectsLocationsConversationsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsConversationsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsEncryptionSpecService(s *Service) *ProjectsLocationsEncryptionSpecService {
	rs := &ProjectsLocationsEncryptionSpecService{s: s}
	return rs
}

type ProjectsLocationsEncryptionSpecService struct {
	s *Service
}

func NewProjectsLocationsGeneratorsService(s *Service) *ProjectsLocationsGeneratorsService {
	rs := &ProjectsLocationsGeneratorsService{s: s}
	rs.Evaluations = NewProjectsLocationsGeneratorsEvaluationsService(s)
	return rs
}

type ProjectsLocationsGeneratorsService struct {
	s *Service

	Evaluations *ProjectsLocationsGeneratorsEvaluationsService
}

func NewProjectsLocationsGeneratorsEvaluationsService(s *Service) *ProjectsLocationsGeneratorsEvaluationsService {
	rs := &ProjectsLocationsGeneratorsEvaluationsService{s: s}
	return rs
}

type ProjectsLocationsGeneratorsEvaluationsService struct {
	s *Service
}

func NewProjectsLocationsKnowledgeBasesService(s *Service) *ProjectsLocationsKnowledgeBasesService {
	rs := &ProjectsLocationsKnowledgeBasesService{s: s}
	rs.Documents = NewProjectsLocationsKnowledgeBasesDocumentsService(s)
	return rs
}

type ProjectsLocationsKnowledgeBasesService struct {
	s *Service

	Documents *ProjectsLocationsKnowledgeBasesDocumentsService
}

func NewProjectsLocationsKnowledgeBasesDocumentsService(s *Service) *ProjectsLocationsKnowledgeBasesDocumentsService {
	rs := &ProjectsLocationsKnowledgeBasesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsKnowledgeBasesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPhoneNumbersService(s *Service) *ProjectsLocationsPhoneNumbersService {
	rs := &ProjectsLocationsPhoneNumbersService{s: s}
	return rs
}

type ProjectsLocationsPhoneNumbersService struct {
	s *Service
}

func NewProjectsLocationsSipTrunksService(s *Service) *ProjectsLocationsSipTrunksService {
	rs := &ProjectsLocationsSipTrunksService{s: s}
	return rs
}

type ProjectsLocationsSipTrunksService struct {
	s *Service
}

func NewProjectsLocationsStatelessSuggestionService(s *Service) *ProjectsLocationsStatelessSuggestionService {
	rs := &ProjectsLocationsStatelessSuggestionService{s: s}
	return rs
}

type ProjectsLocationsStatelessSuggestionService struct {
	s *Service
}

func NewProjectsLocationsSuggestionsService(s *Service) *ProjectsLocationsSuggestionsService {
	rs := &ProjectsLocationsSuggestionsService{s: s}
	return rs
}

type ProjectsLocationsSuggestionsService struct {
	s *Service
}

func NewProjectsLocationsToolsService(s *Service) *ProjectsLocationsToolsService {
	rs := &ProjectsLocationsToolsService{s: s}
	return rs
}

type ProjectsLocationsToolsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

func NewProjectsPhoneNumbersService(s *Service) *ProjectsPhoneNumbersService {
	rs := &ProjectsPhoneNumbersService{s: s}
	return rs
}

type ProjectsPhoneNumbersService struct {
	s *Service
}

func NewProjectsSuggestionsService(s *Service) *ProjectsSuggestionsService {
	rs := &ProjectsSuggestionsService{s: s}
	return rs
}

type ProjectsSuggestionsService struct {
	s *Service
}

// GoogleCloudDialogflowCxV3AdvancedSettings: Hierarchical advanced settings
// for agent/flow/page/fulfillment/parameter. Settings exposed at lower level
// overrides the settings exposed at higher level. Overriding occurs at the
// sub-setting level. For example, the playback_interruption_settings at
// fulfillment level only overrides the playback_interruption_settings at the
// agent level, leaving other settings at the agent level unchanged. DTMF
// settings does not override each other. DTMF settings set at different levels
// define DTMF detections running in parallel. Hierarchy:
// Agent->Flow->Page->Fulfillment/Parameter.
type GoogleCloudDialogflowCxV3AdvancedSettings struct {
	// AudioExportGcsDestination: If present, incoming audio is exported by
	// Dialogflow to the configured Google Cloud Storage destination. Exposed at
	// the following levels: - Agent level - Flow level
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3GcsDestination `json:"audioExportGcsDestination,omitempty"`
	// DtmfSettings: Settings for DTMF. Exposed at the following levels: - Agent
	// level - Flow level - Page level - Parameter level.
	DtmfSettings *GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings `json:"dtmfSettings,omitempty"`
	// LoggingSettings: Settings for logging. Settings for Dialogflow History,
	// Contact Center messages, StackDriver logs, and speech logging. Exposed at
	// the following levels: - Agent level.
	LoggingSettings *GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	// SpeechSettings: Settings for speech to text detection. Exposed at the
	// following levels: - Agent level - Flow level - Page level - Parameter level
	SpeechSettings *GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings: Define behaviors for
// DTMF (dual tone multi frequency).
type GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings struct {
	// Enabled: If true, incoming audio is processed for DTMF (dual tone multi
	// frequency) events. For example, if the caller presses a button on their
	// telephone keypad and DTMF processing is enabled, Dialogflow will detect the
	// event (e.g. a "3" was pressed) in the incoming audio and pass the event to
	// the bot to drive business logic (e.g. when 3 is pressed, return the account
	// balance).
	Enabled bool `json:"enabled,omitempty"`
	// EndpointingTimeoutDuration: Endpoint timeout setting for matching dtmf input
	// to regex.
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	// FinishDigit: The digit that terminates a DTMF digit sequence.
	FinishDigit string `json:"finishDigit,omitempty"`
	// InterdigitTimeoutDuration: Interdigit timeout setting for matching dtmf
	// input to regex.
	InterdigitTimeoutDuration string `json:"interdigitTimeoutDuration,omitempty"`
	// MaxDigits: Max length of DTMF digits.
	MaxDigits int64 `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings: Define behaviors
// on logging.
type GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings struct {
	// EnableConsentBasedRedaction: Enables consent-based end-user input redaction,
	// if true, a pre-defined session parameter
	// `$session.params.conversation-redaction` will be used to determine if the
	// utterance should be redacted.
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	// EnableInteractionLogging: Enables DF Interaction logging.
	EnableInteractionLogging bool `json:"enableInteractionLogging,omitempty"`
	// EnableStackdriverLogging: Enables Google Cloud Logging.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings: Define behaviors of
// speech to text detection.
type GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings struct {
	// EndpointerSensitivity: Sensitivity of the speech model that detects the end
	// of speech. Scale from 0 to 100.
	EndpointerSensitivity int64 `json:"endpointerSensitivity,omitempty"`
	// Models: Mapping from language to Speech-to-Text model. The mapped
	// Speech-to-Text model will be selected for requests from its corresponding
	// language. For more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Models map[string]string `json:"models,omitempty"`
	// NoSpeechTimeout: Timeout before detecting no speech.
	NoSpeechTimeout string `json:"noSpeechTimeout,omitempty"`
	// UseTimeoutBasedEndpointing: Use timeout based endpointing, interpreting
	// endpointer sensitivity as seconds of timeout value.
	UseTimeoutBasedEndpointing bool `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AudioInput: Represents the natural speech audio to
// be processed.
type GoogleCloudDialogflowCxV3AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single request
	// can contain up to 2 minutes of speech audio data. The transcribed text
	// cannot contain more than 256 bytes. For non-streaming audio detect intent,
	// both `config` and `audio` must be provided. For streaming audio detect
	// intent, `config` must be provided in the first request and `audio` must be
	// provided in all following requests.
	Audio string `json:"audio,omitempty"`
	// Config: Required. Instructs the speech recognizer how to process the speech
	// audio.
	Config *GoogleCloudDialogflowCxV3InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BargeInConfig: Configuration of the barge-in
// behavior. Barge-in instructs the API to return a detected utterance at a
// proper time while the client is playing back the response audio from a
// previous request. When the client sees the utterance, it should stop the
// playback and immediately get ready for receiving the responses for the
// current request. The barge-in handling requires the client to start
// streaming audio input as soon as it starts playing back the audio from the
// previous response. The playback is modeled into two phases: * No barge-in
// phase: which goes first and during which speech detection should not be
// carried out. * Barge-in phase: which follows the no barge-in phase and
// during which the API starts speech detection and may inform the client that
// an utterance has been detected. Note that no-speech event is not expected in
// this phase. The client provides this configuration in terms of the durations
// of those two phases. The durations are measured in terms of the audio length
// from the start of the input audio. No-speech event is a response with
// END_OF_UTTERANCE without any transcript following up.
type GoogleCloudDialogflowCxV3BargeInConfig struct {
	// NoBargeInDuration: Duration that is not eligible for barge-in at the
	// beginning of the input audio.
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	// TotalDuration: Total duration for the playback at the beginning of the input
	// audio.
	TotalDuration string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata: Metadata returned for
// the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesResponse: The response message for
// TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are empty in
	// this response.
	Results []*GoogleCloudDialogflowCxV3TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ContinuousTestResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`
	// Result: The result of this continuous test run, i.e. whether all the tests
	// in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never be
	// used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`
	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`
	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationSignals: This message is used to hold
// all the Conversation Signals data, which will be converted to JSON and
// exported to BigQuery.
type GoogleCloudDialogflowCxV3ConversationSignals struct {
	// TurnSignals: Required. Turn signals for the current turn.
	TurnSignals *GoogleCloudDialogflowCxV3TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurn: One interaction between a human
// and virtual agent. The human provides some input and the virtual agent
// provides a response.
type GoogleCloudDialogflowCxV3ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3ConversationTurnUserInput `json:"userInput,omitempty"`
	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnUserInput: The input from the human
// user.
type GoogleCloudDialogflowCxV3ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`
	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`
	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3QueryInput `json:"input,omitempty"`
	// IsWebhookEnabled: If webhooks should be allowed to trigger in response to
	// the user utterance. Often if parameters are injected, webhooks should not be
	// enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput: The output from
// the virtual agent.
type GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name and
	// displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3Page `json:"currentPage,omitempty"`
	// DiagnosticInfo: Required. Input only. The diagnostic info output for the
	// turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// Differences: Output only. If this is part of a result conversation turn, the
	// list of differences between the original run and the replay for this output,
	// if any.
	Differences []*GoogleCloudDialogflowCxV3TestRunDifference `json:"differences,omitempty"`
	// SessionParameters: The session parameters available to the bot at this
	// point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`
	// Status: Response error from the agent in the test result. If set, other
	// output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3ResponseMessageText `json:"textResponses,omitempty"`
	// TriggeredIntent: The Intent that triggered the response. Only name and
	// displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3Intent `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3CreateVersionOperationMetadata: Metadata associated
// with the long running operation for Versions.CreateVersion.
type GoogleCloudDialogflowCxV3CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DataStoreConnection: A data store connection. It
// represents a data store in Discovery Engine and the type of the contents it
// contains.
type GoogleCloudDialogflowCxV3DataStoreConnection struct {
	// DataStore: The full name of the referenced data store. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStore string `json:"dataStore,omitempty"`
	// DataStoreType: The type of the connected data store.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Not specified. This value indicates that
	// the data store type is not specified, so it will not be used during search.
	//   "PUBLIC_WEB" - A data store that contains public web content.
	//   "UNSTRUCTURED" - A data store that contains unstructured private data.
	//   "STRUCTURED" - A data store that contains structured data (for example
	// FAQ).
	DataStoreType string `json:"dataStoreType,omitempty"`
	// DocumentProcessingMode: The document processing mode for the data store
	// connection. Should only be set for PUBLIC_WEB and UNSTRUCTURED data stores.
	// If not set it is considered as DOCUMENTS, as this is the legacy mode.
	//
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED" - Not specified. This should be set
	// for STRUCTURED type data stores. Due to legacy reasons this is considered as
	// DOCUMENTS for STRUCTURED and PUBLIC_WEB data stores.
	//   "DOCUMENTS" - Documents are processed as documents.
	//   "CHUNKS" - Documents are converted to chunks.
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowMetadata: Metadata returned for the
// Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowResponse: The response message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3DeployFlowResponse struct {
	// Deployment: The name of the flow version Deployment. Format:
	// `projects//locations//agents//environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`
	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DtmfInput: Represents the input for dtmf event.
type GoogleCloudDialogflowCxV3DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`
	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Environment: Represents an environment for an
// agent. You can create multiple versions of your agent and publish them to
// separate environments. When you edit an agent, you are editing the draft
// agent. At any point, you can save the draft agent as an agent version, which
// is an immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for testing, development, production, etc.
type GoogleCloudDialogflowCxV3Environment struct {
	// Description: The human-readable description of the environment. The maximum
	// length is 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the environment (unique in
	// an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`
	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionConfigs: A list of configurations for flow versions. You should
	// include version configs for all flows that are reachable from `Start Flow`
	// in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	// WebhookConfig: The webhook configuration for this environment.
	WebhookConfig *GoogleCloudDialogflowCxV3EnvironmentWebhookConfig `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig: The configuration for
// continuous tests.
type GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in TestCasesConfig.test_cases
	// periodically. Default false. If set to true, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`
	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`
	// TestCases: A list of test case names to run. They should be under the same
	// agent. Format of each test case name:
	// `projects//locations//agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentVersionConfig: Configuration for the
// version.
type GoogleCloudDialogflowCxV3EnvironmentVersionConfig struct {
	// Version: Required. Flow, playbook and tool versions are supported. Format
	// for flow version: projects//locations//agents//flows//versions/. Format for
	// playbook version: projects//locations//agents//playbooks//versions/. Format
	// for tool version: projects//locations//agents//tools//versions/.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentWebhookConfig: Configuration for
// webhooks.
type GoogleCloudDialogflowCxV3EnvironmentWebhookConfig struct {
	// WebhookOverrides: The list of webhooks to override for the agent
	// environment. The webhook must exist in the agent. You can override fields in
	// `generic_web_service` and `service_directory`.
	WebhookOverrides []*GoogleCloudDialogflowCxV3Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventHandler: An event handler specifies an event
// that can be handled during a session. When the specified event happens, the
// following actions are taken in order: * If there is a `trigger_fulfillment`
// associated with the event, it will be called. * If there is a `target_page`
// associated with the event, the session will transition into the specified
// page. * If there is a `target_flow` associated with the event, the session
// will transition into the specified flow.
type GoogleCloudDialogflowCxV3EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`
	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TargetPlaybook: The target playbook to transition to. Format:
	// `projects//locations//agents//playbooks/`.
	TargetPlaybook string `json:"targetPlaybook,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the event occurs. Handling
	// webhook errors with a fulfillment enabled with webhook could cause infinite
	// loop. It is invalid to specify such fulfillment for a handler handling
	// webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventInput: Represents the event to trigger.
type GoogleCloudDialogflowCxV3EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowCxV3ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent. This field is
	// populated if none of `agent_uri` and `git_destination` are specified in
	// ExportAgentRequest.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`
	// CommitSha: Commit SHA of the git push. This field is populated if
	// `git_destination` is specified in ExportAgentRequest.
	CommitSha string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportEntityTypesMetadata: Metadata returned for
// the EntityTypes.ExportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3ExportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportEntityTypesResponse: The response message for
// EntityTypes.ExportEntityTypes.
type GoogleCloudDialogflowCxV3ExportEntityTypesResponse struct {
	// EntityTypesContent: Uncompressed byte content for entity types. This field
	// is populated only if `entity_types_content_inline` is set to true in
	// ExportEntityTypesRequest.
	EntityTypesContent *GoogleCloudDialogflowCxV3InlineDestination `json:"entityTypesContent,omitempty"`
	// EntityTypesUri: The URI to a file containing the exported entity types. This
	// field is populated only if `entity_types_uri` is specified in
	// ExportEntityTypesRequest.
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportFlowResponse: The response message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`
	// FlowUri: The URI to a file containing the exported flow. This field is
	// populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportIntentsMetadata: Metadata returned for the
// Intents.ExportIntents long running operation.
type GoogleCloudDialogflowCxV3ExportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportIntentsResponse: The response message for
// Intents.ExportIntents.
type GoogleCloudDialogflowCxV3ExportIntentsResponse struct {
	// IntentsContent: Uncompressed byte content for intents. This field is
	// populated only if `intents_content_inline` is set to true in
	// ExportIntentsRequest.
	IntentsContent *GoogleCloudDialogflowCxV3InlineDestination `json:"intentsContent,omitempty"`
	// IntentsUri: The URI to a file containing the exported intents. This field is
	// populated only if `intents_uri` is specified in ExportIntentsRequest.
	IntentsUri string `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportTestCasesMetadata: Metadata returned for the
// TestCases.ExportTestCases long running operation. This message currently has
// no fields.
type GoogleCloudDialogflowCxV3ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportTestCasesResponse: The response message for
// TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`
	// GcsUri: The URI to a file containing the exported test cases. This field is
	// populated only if `gcs_uri` is specified in ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Form: A form is a data model that groups related
// parameters that can be collected from the user. The process in which the
// agent prompts the user and collects parameter values from the user is called
// form filling. A form can be added to a page. When form filling is done, the
// filled parameters will be written to the session.
type GoogleCloudDialogflowCxV3Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameter: Represents a form parameter.
type GoogleCloudDialogflowCxV3FormParameter struct {
	// AdvancedSettings: Hierarchical advanced settings for this parameter. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// DefaultValue: The default value of an optional parameter. If the parameter
	// is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// DisplayName: Required. The human-readable name of the parameter, unique
	// within the form.
	DisplayName string `json:"displayName,omitempty"`
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// Required: Indicates whether the parameter is required. Optional parameters
	// will not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameterFillBehavior: Configuration for how
// the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the initial
	// prompt that the agent can present to the user in order to fill the
	// parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"initialPromptFulfillment,omitempty"`
	// RepromptEventHandlers: The handlers for parameter-level events, used to
	// provide reprompt for the parameter or transition to a different page/flow.
	// The supported events are: * `sys.no-match-`, where N can be from 1 to 6 *
	// `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 *
	// `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the parameter. If
	// the user's response does not fill the parameter, a no-match/no-input event
	// will be triggered, and the fulfillment associated with the
	// `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to
	// provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined)
	// will respond to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used to
	// handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case where the
	// parameter values have been `invalidated` by webhook. For example, if the
	// user's response fill the parameter, however the parameter was invalidated by
	// webhook, the fulfillment associated with the `sys.invalid-parameter` handler
	// (if defined) will be called to provide a prompt. If the event handler for
	// the corresponding event can't be found on the parameter,
	// `initial_prompt_fulfillment` will be re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Fulfillment: A fulfillment can do one or more of
// the following actions at the same time: * Generate rich message responses. *
// Set parameter values. * Call the webhook. Fulfillments can be called at
// various stages in the Page or Form lifecycle. For example, when a
// DetectIntentRequest drives a session to enter a new page, the page's entry
// fulfillment can add a static response to the QueryResult in the returning
// DetectIntentResponse, call the webhook (for example, to load user data from
// a database), or both.
type GoogleCloudDialogflowCxV3Fulfillment struct {
	// AdvancedSettings: Hierarchical advanced settings for this fulfillment. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"conditionalCases,omitempty"`
	// EnableGenerativeFallback: If the flag is true, the agent will utilize LLM to
	// generate a text response. If LLM generation fails, the defined responses in
	// the fulfillment will be respected. This flag is only useful for fulfillments
	// associated with no-match event handlers.
	EnableGenerativeFallback bool `json:"enableGenerativeFallback,omitempty"`
	// Generators: A list of Generators to be called during this fulfillment.
	Generators []*GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings `json:"generators,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ReturnPartialResponses: Whether Dialogflow should return currently queued
	// fulfillment response messages in streaming APIs. If a webhook is specified,
	// it happens before Dialogflow invokes webhook. Warning: 1) This flag only
	// affects streaming API. Responses are still queued and returned once in
	// non-streaming API. 2) The flag can be enabled in any fulfillment but only
	// the first 3 partial responses will be returned. You may only want to apply
	// it to fulfillments that have slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`
	// SetParameterActions: Set parameter values before executing the webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	// Tag: The value of this field will be populated in the WebhookRequest
	// `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
	// called. The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes. This
	// field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`
	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCases: A list of cascading
// if-else conditions. Cases are mutually exclusive. The first one with a
// matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase: Each case has a
// Boolean condition. When it is evaluated to be True, the corresponding
// messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	// Condition: The condition to activate and select this case. Empty means the
	// condition is always true. The condition is evaluated against form parameters
	// or session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent: The
// list of messages or conditional cases to activate for this case.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3ResponseMessage `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings: Generator settings
// used by the LLM to generate a text response.
type GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings struct {
	// Generator: Required. The generator to call. Format:
	// `projects//locations//agents//generators/`.
	Generator string `json:"generator,omitempty"`
	// InputParameters: Map from placeholder parameter in the Generator to
	// corresponding session parameters. By default, Dialogflow uses the session
	// parameter with the same name to fill in the generator template. e.g. If
	// there is a placeholder parameter `city` in the Generator, Dialogflow default
	// to fill in the `$city` with `$session.params.city`. However, you may choose
	// to fill `$city` with `$session.params.desination-city`. - Map key: parameter
	// ID - Map value: session parameter name
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	// OutputParameter: Required. Output parameter which should contain the
	// generator response.
	OutputParameter string `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentSetParameterAction: Setting a parameter
// value.
type GoogleCloudDialogflowCxV3FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`
	// Value: The new value of the parameter. A null value clears the parameter.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3GcsDestination: Google Cloud Storage location for a
// Dialogflow operation that writes or exports objects (e.g. exported agent or
// transcripts) outside of Dialogflow.
type GoogleCloudDialogflowCxV3GcsDestination struct {
	// Uri: Required. The Google Cloud Storage URI for the exported objects. A URI
	// is of the form: `gs://bucket/object-name-or-prefix` Whether a full object
	// name, or just a prefix, its usage depends on the Dialogflow operation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportEntityTypesMetadata: Metadata returned for
// the EntityTypes.ImportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3ImportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3ImportEntityTypesResponse: The response message for
// EntityTypes.ImportEntityTypes.
type GoogleCloudDialogflowCxV3ImportEntityTypesResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportEntityTypesRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	// EntityTypes: The unique identifier of the imported entity types. Format:
	// `projects//locations//agents//entity_types/`.
	EntityTypes []string `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// EntityTypeDisplayNames: Display names of conflicting entity types.
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportFlowResponse: The response message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportIntentsMetadata: Metadata returned for the
// Intents.ImportIntents long running operation.
type GoogleCloudDialogflowCxV3ImportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3ImportIntentsResponse: The response message for
// Intents.ImportIntents.
type GoogleCloudDialogflowCxV3ImportIntentsResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportIntentsRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	// Intents: The unique identifier of the imported intents. Format:
	// `projects//locations//agents//intents/`.
	Intents []string `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// IntentDisplayNames: Display names of conflicting intents.
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesMetadata: Metadata returned for the
// TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesResponse: The response message for
// TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3InlineDestination: Inline destination for a
// Dialogflow operation that writes or exports objects (e.g. intents) outside
// of Dialogflow.
type GoogleCloudDialogflowCxV3InlineDestination struct {
	// Content: Output only. The uncompressed byte content for the objects. Only
	// populated in responses.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3InputAudioConfig: Instructs the speech recognizer
// on how to process the audio content.
type GoogleCloudDialogflowCxV3InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed little-endian
	// samples (Linear PCM). LINT: LEGACY_NAMES
	//   "AUDIO_ENCODING_FLAC" - [`FLAC`](https://xiph.org/flac/documentation.html)
	// (Free Lossless Audio Codec) is the recommended encoding because it is
	// lossless (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio samples
	// using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must be
	// 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is required,
	// `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has a
	// header byte in each block, as in MIME type `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in [RFC
	// 5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence of
	// blocks, one block per RTP packet. Each block starts with a byte containing
	// the length of the block, in bytes, followed by one or more frames of Speex
	// data, padded to an integral number of bytes (octets) as specified in RFC
	// 5574. In other words, each RTP header is replaced with a single byte
	// containing the block length. Only Speex wideband is supported.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio samples
	// using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// BargeInConfig: Configuration of barge-in behavior during the streaming of
	// input audio.
	BargeInConfig *GoogleCloudDialogflowCxV3BargeInConfig `json:"bargeInConfig,omitempty"`
	// EnableWordInfo: Optional. If `true`, Dialogflow returns SpeechWordInfo in
	// StreamingRecognitionResult with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`
	// Model: Optional. Which Speech model to select for the given request. For
	// more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Model string `json:"model,omitempty"`
	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In this
	// case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech model
	// that the caller is eligible for.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced model is
	// available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced variant
	// does not exist for the given model and request language, Dialogflow falls
	// back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// describes which models have enhanced variants.
	ModelVariant string `json:"modelVariant,omitempty"`
	// OptOutConformerModelMigration: If `true`, the request will opt out for STT
	// conformer model migration. This field will be deprecated once force
	// migration takes place in June 2024. Please refer to Dialogflow CX Speech
	// model migration
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-model-migration).
	OptOutConformerModelMigration bool `json:"optOutConformerModelMigration,omitempty"`
	// PhraseHints: Optional. A list of strings containing words and phrases that
	// the speech recognizer should recognize with higher likelihood. See the Cloud
	// Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details.
	PhraseHints []string `json:"phraseHints,omitempty"`
	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in the
	// query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SingleUtterance: Optional. If `false` (default), recognition does not cease
	// until the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed. Note: This setting is relevant only for
	// streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Intent: An intent represents a user's intent to
// interact with a conversational agent. You can provide information for the
// Dialogflow API to use to match user input to an intent by adding training
// phrases (i.e., examples of user input) to your intent.
type GoogleCloudDialogflowCxV3Intent struct {
	// Description: Human readable description for better understanding an intent
	// like its scope, content, result etc. Maximum character limit: 140
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the intent, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// IsFallback: Indicates whether this is a fallback intent. Currently only
	// default fallback intent is allowed in the agent, which is added upon agent
	// creation. Adding training phrases to fallback intent is useful in the case
	// of requests that are mistakenly matched, since training phrases assigned to
	// fallback intents act as negative examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`
	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets. Keys must
	// start with a letter. Keys and values can be no longer than 63 characters and
	// no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined
	// labels. Currently allowed Dialogflow defined labels include: * sys-head *
	// sys-contextual The above labels do not require value. "sys-head" means the
	// intent is a head intent. "sys.contextual" means the intent is a contextual
	// intent.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3IntentParameter `json:"parameters,omitempty"`
	// Priority: The priority of this intent. Higher numbers represent higher
	// priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// TrainingPhrases: The collection of training phrases the agent is trained on
	// to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentInput: Represents the intent to trigger
// programmatically rather than as a result of natural language processing.
type GoogleCloudDialogflowCxV3IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentParameter: Represents an intent parameter.
type GoogleCloudDialogflowCxV3IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// Id: Required. The unique identifier of the parameter. This field is used by
	// training phrases to annotate their parts.
	Id string `json:"id,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrase: Represents an example that
// the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `parameter_id` field is set.
	Parts []*GoogleCloudDialogflowCxV3IntentTrainingPhrasePart `json:"parts,omitempty"`
	// RepeatCount: Indicates how many times this example was added to the intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrasePart: Represents a part of a
// training phrase.
type GoogleCloudDialogflowCxV3IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training phrase.
	ParameterId string `json:"parameterId,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3KnowledgeConnectorSettings: The Knowledge Connector
// settings for this page or flow. This includes information such as the
// attached Knowledge Bases, and the way to execute fulfillment.
type GoogleCloudDialogflowCxV3KnowledgeConnectorSettings struct {
	// DataStoreConnections: Optional. List of related data store connections.
	DataStoreConnections []*GoogleCloudDialogflowCxV3DataStoreConnection `json:"dataStoreConnections,omitempty"`
	// Enabled: Whether Knowledge Connector is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to be triggered. When the answers from
	// the Knowledge Connector are selected by Dialogflow, you can utitlize the
	// request scoped parameter `$request.knowledge.answers` (contains up to the 5
	// highest confidence answers) and `$request.knowledge.questions` (contains the
	// corresponding questions) to construct the fulfillment.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3LanguageInfo: Represents the language information
// of the request.
type GoogleCloudDialogflowCxV3LanguageInfo struct {
	// ConfidenceScore: The confidence score of the detected language between 0 and
	// 1.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// InputLanguageCode: The language code specified in the original request.
	InputLanguageCode string `json:"inputLanguageCode,omitempty"`
	// ResolvedLanguageCode: The language code detected for this request based on
	// the user conversation.
	ResolvedLanguageCode string `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudDialogflowCxV3Page: A Dialogflow CX conversation (session) can be
// described and visualized as a state machine. The states of a CX session are
// represented by pages. For each flow, you define many pages, where your
// combined pages can handle a complete conversation on the topics the flow is
// designed for. At any given moment, exactly one page is the current page, the
// current page is considered active, and the flow associated with that page is
// considered active. Every flow has a special start page. When a flow
// initially becomes active, the start page page becomes the current page. For
// each conversational turn, the current page will either stay the same or
// transition to another page. You configure each page to collect information
// from the end-user that is relevant for the conversational state represented
// by the page. For more information, see the Page guide
// (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3Page struct {
	// AdvancedSettings: Hierarchical advanced settings for this page. The settings
	// exposed at the lower level overrides the settings exposed at the higher
	// level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// Description: The description of the page. The maximum length is 500
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the page, unique within
	// the flow.
	DisplayName string `json:"displayName,omitempty"`
	// EntryFulfillment: The fulfillment to call when the session is entering the
	// page.
	EntryFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"entryFulfillment,omitempty"`
	// EventHandlers: Handlers associated with the page to handle events such as
	// webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"eventHandlers,omitempty"`
	// Form: The form associated with the page, used for collecting parameters
	// relevant to the page.
	Form *GoogleCloudDialogflowCxV3Form `json:"form,omitempty"`
	// KnowledgeConnectorSettings: Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// Name: The unique identifier of the page. Required for the Pages.UpdatePage
	// method. Pages.CreatePage populates the name automatically. Format:
	// `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`
	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups` added to the
	// page. Transition route groups must be unique within a page. If the page
	// links both flow-level transition route groups and agent-level transition
	// route groups, the flow-level ones will have higher priority and will be put
	// before the agent-level ones. * If multiple transition routes within a page
	// scope refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's transition
	// routes. * If multiple transition route groups within a page contain the same
	// intent, then the first group in the ordered list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`
	// TransitionRoutes: A list of transitions for the transition rules of this
	// page. They route the conversation to another page in the same flow, or
	// another flow. When we are in a certain page, the TransitionRoutes are
	// evaluated in the following order: * TransitionRoutes defined in the page
	// with intent specified. * TransitionRoutes defined in the transition route
	// groups with intent specified. * TransitionRoutes defined in flow with intent
	// specified. * TransitionRoutes defined in the transition route groups with
	// intent specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups with
	// only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3TransitionRoute `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfo: Represents page information communicated
// to and from the webhook.
type GoogleCloudDialogflowCxV3PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`
	// DisplayName: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The display name of the current page.
	DisplayName string `json:"displayName,omitempty"`
	// FormInfo: Optional for both WebhookRequest and WebhookResponse. Information
	// about the form.
	FormInfo *GoogleCloudDialogflowCxV3PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfo: Represents form information.
type GoogleCloudDialogflowCxV3PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse. The
	// parameters contained in the form. Note that the webhook cannot add or remove
	// any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo: Represents parameter
// information.
type GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique within the
	// form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`
	// JustCollected: Optional for WebhookRequest. Ignored for WebhookResponse.
	// Indicates if the parameter value was just collected on the last conversation
	// turn.
	JustCollected bool `json:"justCollected,omitempty"`
	// Required: Optional for both WebhookRequest and WebhookResponse. Indicates
	// whether the parameter is required. Optional parameters will not trigger
	// prompts; however, they are filled if the user specifies them. Required
	// parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// State: Always present for WebhookRequest. Required for WebhookResponse. The
	// state of the parameter. This field can be set to INVALID by the webhook to
	// invalidate the parameter; other values set by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This field can
	// be used by the webhook to invalidate the parameter and ask the server to
	// collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`
	// Value: Optional for both WebhookRequest and WebhookResponse. The value of
	// the parameter. This field can be set by the webhook to change the parameter
	// value.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3QueryInput: Represents the query input. It can
// contain one of: 1. A conversational query in the form of text. 2. An intent
// query that specifies which intent to trigger. 3. Natural language speech
// audio to be processed. 4. An event to be triggered. 5. DTMF digits to invoke
// an intent and fill in parameter value. 6. The results of a tool executed by
// the client.
type GoogleCloudDialogflowCxV3QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3AudioInput `json:"audio,omitempty"`
	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3DtmfInput `json:"dtmf,omitempty"`
	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3EventInput `json:"event,omitempty"`
	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3IntentInput `json:"intent,omitempty"`
	// LanguageCode: Required. The language of the input. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3TextInput `json:"text,omitempty"`
	// ToolCallResult: The results of a tool executed by the client.
	ToolCallResult *GoogleCloudDialogflowCxV3ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessage: Represents a response message that
// can be returned by a conversational agent. Response messages are also used
// for output audio synthesis. The approach is as follows: * If at least one
// OutputAudioText response is present, then all OutputAudioText responses are
// linearly concatenated, and the result is used for output audio synthesis. *
// If the OutputAudioText responses are a mixture of text and SSML, then the
// concatenated result is treated as SSML; otherwise, the result is treated as
// either text or SSML as appropriate. The agent designer should ideally use
// either text or SSML consistently throughout the bot design. * Otherwise, all
// Text responses are linearly concatenated, and the result is used for output
// audio synthesis. This approach allows for more sophisticated user experience
// scenarios, where the text displayed to the user may differ from what is
// heard.
type GoogleCloudDialogflowCxV3ResponseMessage struct {
	// Channel: The channel which the response is associated with. Clients can
	// specify the channel via QueryParameters.channel, and only associated channel
	// response will be returned.
	Channel string `json:"channel,omitempty"`
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	// EndInteraction: Output only. A signal that indicates the interaction with
	// the Dialogflow agent has ended. This message is generated by Dialogflow only
	// when the conversation reaches `END_SESSION` page. It is not supposed to be
	// defined by the user. It's guaranteed that there is at most one such message
	// in each response.
	EndInteraction *GoogleCloudDialogflowCxV3ResponseMessageEndInteraction `json:"endInteraction,omitempty"`
	// KnowledgeInfoCard: Represents info card for knowledge answers, to be better
	// rendered in Dialogflow Messenger.
	KnowledgeInfoCard *GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard `json:"knowledgeInfoCard,omitempty"`
	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`
	// MixedAudio: Output only. An audio response message composed of both the
	// synthesized Dialogflow agent responses and responses defined via play_audio.
	// This message is generated by Dialogflow only and not supposed to be defined
	// by the user.
	MixedAudio *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`
	// OutputAudioText: A text or ssml response that is preferentially used for TTS
	// output audio synthesis, as described in the comment on the ResponseMessage
	// message.
	OutputAudioText *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`
	// Payload: Returns a response containing a custom, platform-specific payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// PlayAudio: Signal that the client should play an audio clip hosted at a
	// client-specific URI. Dialogflow uses this to construct mixed_audio. However,
	// Dialogflow itself does not try to read or process the URI in any way.
	PlayAudio *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio `json:"playAudio,omitempty"`
	// ResponseType: Response type.
	//
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED" - Not specified.
	//   "ENTRY_PROMPT" - The response is from an entry prompt in the page.
	//   "PARAMETER_PROMPT" - The response is from form-filling prompt in the page.
	//   "HANDLER_PROMPT" - The response is from a transition route or an event
	// handler in the page or flow or transition route group.
	ResponseType string `json:"responseType,omitempty"`
	// TelephonyTransferCall: A signal that the client should transfer the phone
	// call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3ResponseMessageText `json:"text,omitempty"`
	// ToolCall: Returns the definition of a tool call that should be executed by
	// the client.
	ToolCall *GoogleCloudDialogflowCxV3ToolCall `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess: Indicates that
// the conversation succeeded, i.e., the bot handled the issue that the
// customer talked to it about. Dialogflow only uses this to determine which
// conversations should be counted as successful and doesn't process the
// metadata in this message in any way. Note that Dialogflow also considers
// conversations that get to the conversation end page as successful even if
// they don't return ConversationSuccess. You may set this, for example: * In
// the entry_fulfillment of a Page if entering the page indicates that the
// conversation succeeded. * In a webhook response when you determine that you
// handled the customer issue.
type GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageEndInteraction: Indicates that
// interaction with the Dialogflow agent has ended. This message is generated
// by Dialogflow only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard: Represents info
// card response. If the response contains generative knowledge prediction,
// Dialogflow will return a payload with Infobot Messenger compatible info
// card. Otherwise, the info card response is skipped.
type GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard struct {
}

// GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff: Indicates that the
// conversation should be handed off to a live agent. Dialogflow only uses this
// to determine which conversations were handed off to a human agent for
// measurement purposes. What else to do with this signal is up to you and your
// handoff procedures. You may set this, for example: * In the
// entry_fulfillment of a Page if entering the page indicates something went
// extremely wrong in the conversation. * In a webhook response when you
// determine that the customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow doesn't
	// impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudio: Represents an audio
// message that is composed of both segments synthesized from the Dialogflow
// agent prompts and ones hosted externally at the specified URIs. The external
// URIs are specified via play_audio. This message is generated by Dialogflow
// only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment: Represents one
// segment of audio.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this segment
	// can be interrupted by the end user's speech and the client should then start
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Audio: Raw audio synthesized from the Dialogflow agent's response using the
	// output config specified in the request.
	Audio string `json:"audio,omitempty"`
	// Uri: Client-specific URI that points to an audio clip accessible to the
	// client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText: A text or ssml
// response that is preferentially used for TTS output audio synthesis, as
// described in the comment on the ResponseMessage message.
type GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`
	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessagePlayAudio: Specifies an audio clip
// to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose any
	// validation on this value. It is specific to the client that reads it.
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall: Represents
// the signal that telles the client to transfer the phone call connected to
// the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageText: The text response message.
type GoogleCloudDialogflowCxV3ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Text: Required. A collection of text response variants. If multiple variants
	// are defined, only one text response variant is returned at runtime.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestMetadata: Metadata returned for
// the Environments.RunContinuousTest long running operation.
type GoogleCloudDialogflowCxV3RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestResponse: The response message for
// Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunTestCaseMetadata: Metadata returned for the
// TestCases.RunTestCase long running operation. This message currently has no
// fields.
type GoogleCloudDialogflowCxV3RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3RunTestCaseResponse: The response message for
// TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3SessionInfo: Represents session information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for WebhookResponse. All
	// parameters collected from forms and intents during the session. Parameters
	// can be created, updated, or removed by the webhook. To remove a parameter
	// from the session, the webhook should explicitly set the parameter value to
	// null in WebhookResponse. The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Session: Always present for WebhookRequest. Ignored for WebhookResponse. The
	// unique identifier of the session. This field can be used by the webhook to
	// identify a session. Format: `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment is
	// specified.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`
	// DisplayName: Required. The human-readable name of the test case, unique
	// within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3TestCaseResult `json:"lastTestResult,omitempty"`
	// Name: The unique identifier of the test case. TestCases.CreateTestCase will
	// populate the name automatically. Otherwise use format:
	// `projects//locations//agents//testCases/`.
	Name string `json:"name,omitempty"`
	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`
	// Tags: Tags are short descriptions that users may apply to test cases for
	// organizational and filtering purposes. Each tag should start with "#" and
	// has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`
	// TestCaseConversationTurns: The conversation turns uttered when the test case
	// was created, in chronological order. These include the canonical set of
	// agent utterances that should occur when the agent is working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3TestConfig `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseError: Error info for importing a test.
type GoogleCloudDialogflowCxV3TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseResult: Represents a result from running a
// test case in an agent environment.
type GoogleCloudDialogflowCxV3TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test case
	// replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"conversationTurns,omitempty"`
	// Environment: Environment where the test was run. If not set, it indicates
	// the draft environment.
	Environment string `json:"environment,omitempty"`
	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases//results/`.
	Name string `json:"name,omitempty"`
	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`
	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestConfig: Represents configurations for a test
// case.
type GoogleCloudDialogflowCxV3TestConfig struct {
	// Flow: Flow name to start the test case with. Format:
	// `projects//locations//agents//flows/`. Only one of `flow` and `page` should
	// be set to indicate the starting point of the test case. If neither is set,
	// the test case will start with start page on the default start flow.
	Flow string `json:"flow,omitempty"`
	// Page: The page to start the test case with. Format:
	// `projects//locations//agents//flows//pages/`. Only one of `flow` and `page`
	// should be set to indicate the starting point of the test case. If neither is
	// set, the test case will start with start page on the default start flow.
	Page string `json:"page,omitempty"`
	// TrackingParameters: Session parameters to be compared when calculating
	// differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestError: Error info for running a test.
type GoogleCloudDialogflowCxV3TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`
	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestRunDifference: The description of differences
// between original and replayed agent output.
type GoogleCloudDialogflowCxV3TestRunDifference struct {
	// Description: A human readable description of the diff, showing the actual
	// output vs expected output.
	Description string `json:"description,omitempty"`
	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	//   "FLOW" - The flow.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TextInput: Represents the natural language text to
// be processed.
type GoogleCloudDialogflowCxV3TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be processed.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCall: Represents a call of a specific tool's
// action with the specified inputs.
type GoogleCloudDialogflowCxV3ToolCall struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCallResult: The result of calling a tool's
// action that has been executed by the client.
type GoogleCloudDialogflowCxV3ToolCallResult struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowCxV3ToolCallResultError `json:"error,omitempty"`
	// OutputParameters: The tool call's output parameters.
	OutputParameters googleapi.RawMessage `json:"outputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCallResultError: An error produced by the tool
// call.
type GoogleCloudDialogflowCxV3ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TransitionRoute: A transition route specifies a
// intent that can be matched and/or a data condition that can be evaluated
// during a session. When a specified transition is matched, the following
// actions are taken in order: * If there is a `trigger_fulfillment` associated
// with the transition, it will be called. * If there is a `target_page`
// associated with the transition, the session will transition into the
// specified page. * If there is a `target_flow` associated with the
// transition, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or session
	// parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least
	// one of `intent` or `condition` must be specified. When both `intent` and
	// `condition` are specified, the transition can only happen when both are
	// fulfilled.
	Condition string `json:"condition,omitempty"`
	// Description: Optional. The description of the transition route. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`
	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the transition can
	// only happen when the given intent is matched. At least one of `intent` or
	// `condition` must be specified. When both `intent` and `condition` are
	// specified, the transition can only happen when both are fulfilled.
	Intent string `json:"intent,omitempty"`
	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the condition is satisfied.
	// At least one of `trigger_fulfillment` and `target` must be specified. When
	// both are defined, `trigger_fulfillment` is executed first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TurnSignals: Collection of all signals that were
// extracted for a single turn of the conversation.
type GoogleCloudDialogflowCxV3TurnSignals struct {
	// AgentEscalated: Whether agent responded with LiveAgentHandoff fulfillment.
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	// DtmfUsed: Whether user was using DTMF input.
	DtmfUsed bool `json:"dtmfUsed,omitempty"`
	// FailureReasons: Failure reasons of the turn.
	//
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED" - Failure reason is not assigned.
	//   "FAILED_INTENT" - Whether NLU failed to recognize user intent.
	//   "FAILED_WEBHOOK" - Whether webhook failed during the turn.
	FailureReasons []string `json:"failureReasons,omitempty"`
	// NoMatch: Whether NLU predicted NO_MATCH.
	NoMatch bool `json:"noMatch,omitempty"`
	// NoUserInput: Whether user provided no input.
	NoUserInput bool `json:"noUserInput,omitempty"`
	// ReachedEndPage: Whether turn resulted in End Session page.
	ReachedEndPage bool `json:"reachedEndPage,omitempty"`
	// SentimentMagnitude: Sentiment magnitude of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentMagnitude float64 `json:"sentimentMagnitude,omitempty"`
	// SentimentScore: Sentiment score of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentScore float64 `json:"sentimentScore,omitempty"`
	// UserEscalated: Whether user was specifically asking for a live agent.
	UserEscalated bool `json:"userEscalated,omitempty"`
	// WebhookStatuses: Human-readable statuses of the webhooks triggered during
	// this turn.
	WebhookStatuses []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

// GoogleCloudDialogflowCxV3Webhook: Webhooks host the developer's business
// logic. During a session, webhooks allow the developer to use the data
// extracted by Dialogflow's natural language processing to generate dynamic
// responses, validate collected data, or trigger actions on the backend.
type GoogleCloudDialogflowCxV3Webhook struct {
	// Disabled: Indicates whether the webhook is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Required. The human-readable name of the webhook, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Name: The unique identifier of the webhook. Required for the
	// Webhooks.UpdateWebhook method. Webhooks.CreateWebhook populates the name
	// automatically. Format: `projects//locations//agents//webhooks/`.
	Name string `json:"name,omitempty"`
	// ServiceDirectory: Configuration for a Service Directory
	// (https://cloud.google.com/service-directory) service.
	ServiceDirectory *GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	// Timeout: Webhook execution timeout. Execution is considered failed if
	// Dialogflow doesn't receive a response from webhook at the end of the timeout
	// period. Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebService: Represents configuration
// for a generic web service.
type GoogleCloudDialogflowCxV3WebhookGenericWebService struct {
	// AllowedCaCerts: Optional. Specifies a list of allowed custom CA certificates
	// (in DER format) for HTTPS verification. This overrides the default SSL trust
	// store. If this is empty or unspecified, Dialogflow will use Google's default
	// trust store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a certificate
	// can be self-signed using the following command, ``` openssl x509 -req -days
	// 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \
	// -extfile <(printf "\nsubjectAltName='DNS:www.example.com'") ```
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// HttpMethod: Optional. HTTP method for the flexible webhook calls. Standard
	// webhook always uses POST.
	//
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED" - HTTP method not specified.
	//   "POST" - HTTP POST Method.
	//   "GET" - HTTP GET Method.
	//   "HEAD" - HTTP HEAD Method.
	//   "PUT" - HTTP PUT Method.
	//   "DELETE" - HTTP DELETE Method.
	//   "PATCH" - HTTP PATCH Method.
	//   "OPTIONS" - HTTP OPTIONS Method.
	HttpMethod string `json:"httpMethod,omitempty"`
	// OauthConfig: Optional. The OAuth configuration of the webhook. If specified,
	// Dialogflow will initiate the OAuth client credential flow to exchange an
	// access token from the 3rd party platform and put it in the auth header.
	OauthConfig *GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig `json:"oauthConfig,omitempty"`
	// ParameterMapping: Optional. Maps the values extracted from specific fields
	// of the flexible webhook response into session parameters. - Key: session
	// parameter name - Value: field path in the webhook response
	ParameterMapping map[string]string `json:"parameterMapping,omitempty"`
	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`
	// RequestBody: Optional. Defines a custom JSON object as request body to send
	// to flexible webhook.
	RequestBody string `json:"requestBody,omitempty"`
	// RequestHeaders: The HTTP request headers to send together with webhook
	// requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`
	// SecretVersionForUsernamePassword: Optional. The SecretManager secret version
	// resource storing the username:password pair for HTTP Basic authentication.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForUsernamePassword string `json:"secretVersionForUsernamePassword,omitempty"`
	// SecretVersionsForRequestHeaders: Optional. The HTTP request headers to send
	// together with webhook requests. Header values are stored in SecretManager
	// secret versions. When the same header name is specified in both
	// `request_headers` and `secret_versions_for_request_headers`, the value in
	// `secret_versions_for_request_headers` will be used.
	SecretVersionsForRequestHeaders map[string]GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	// ServiceAccountAuthConfig: Optional. Configuration for service account
	// authentication.
	ServiceAccountAuthConfig *GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig `json:"serviceAccountAuthConfig,omitempty"`
	// ServiceAgentAuth: Optional. Indicate the auth token type generated from the
	// Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	//
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED" - Service agent auth type unspecified.
	// Default to ID_TOKEN.
	//   "NONE" - No token used.
	//   "ID_TOKEN" - Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function and
	// Cloud Run after you grant Invoker role to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	//   "ACCESS_TOKEN" - Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google Cloud
	// APIs after you grant required roles to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// Uri: Required. The webhook URI for receiving POST requests. It must use
	// https protocol.
	Uri string `json:"uri,omitempty"`
	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`
	// WebhookType: Optional. Type of the webhook.
	//
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - Represents a standard webhook.
	//   "FLEXIBLE" - Represents a flexible webhook.
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig: Represents
// configuration of OAuth client credential flow for 3rd party API
// authentication.
type GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig struct {
	// ClientId: Required. The client ID provided by the 3rd party platform.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Optional. The client secret provided by the 3rd party
	// platform.
	ClientSecret string `json:"clientSecret,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// SecretVersionForClientSecret: Optional. The name of the SecretManager secret
	// version resource storing the client secret. If this field is set, the
	// `client_secret` field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `json:"secretVersionForClientSecret,omitempty"`
	// TokenEndpoint: Required. The token endpoint provided by the 3rd party
	// platform to exchange an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue:
// Represents the value of an HTTP header stored in a SecretManager secret
// version.
type GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue struct {
	// SecretVersion: Required. The SecretManager secret version resource storing
	// the header value. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig:
// Configuration for authentication using a service account.
type GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig struct {
	// ServiceAccount: Required. The email address of the service account used to
	// authenticate the webhook call. Dialogflow uses this service account to
	// exchange an access token and the access token is then sent in the
	// `Authorization` header of the webhook request. The service account must have
	// the `roles/iam.serviceAccountTokenCreator` role granted to the Dialogflow
	// service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequest: The request message for a webhook
// call. The request is sent as a JSON object and the field names will be
// presented in camel cases. You may see undocumented fields in an actual
// request. These fields are used internally by Dialogflow and should be
// ignored.
type GoogleCloudDialogflowCxV3WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`
	// DtmfDigits: If DTMF was provided as input, this field will contain the DTMF
	// digits.
	DtmfDigits string `json:"dtmfDigits,omitempty"`
	// FulfillmentInfo: Always present. Information about the fulfillment that
	// triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`
	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo `json:"intentInfo,omitempty"`
	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`
	// LanguageInfo: Information about the language of the request.
	LanguageInfo *GoogleCloudDialogflowCxV3LanguageInfo `json:"languageInfo,omitempty"`
	// Messages: The list of rich message responses to present to the user. Webhook
	// can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`
	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result of the current user
	// request. The field is filled when sentiment analysis is configured to be
	// enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain the
	// name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo: Represents
// fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The value of the Fulfillment.tag field will be
	// populated in this field by Dialogflow when the associated webhook is called.
	// The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfo: Represents intent
// information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DisplayName: Always present. The display name of the last matched intent.
	DisplayName string `json:"displayName,omitempty"`
	// LastMatchedIntent: Always present. The unique identifier of the last matched
	// intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`
	// Parameters: Parameters identified as a result of intent matching. This is a
	// map of the name of the identified parameter to the value of the parameter
	// identified from the user's utterance. All parameters defined in the matched
	// intent that are identified will be surfaced here.
	Parameters map[string]GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue:
// Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from user
	// utterance.
	OriginalValue string `json:"originalValue,omitempty"`
	// ResolvedValue: Always present. Structured value for the parameter extracted
	// from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult: Represents
// the result of sentiment analysis.
type GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookResponse: The response message for a webhook
// call.
type GoogleCloudDialogflowCxV3WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user. This
	// field can be omitted by the webhook if it does not intend to send any
	// response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	// PageInfo: Information about page status. This field can be omitted by the
	// webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`
	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SessionInfo: Information about session status. This field can be omitted by
	// the webhook if it does not intend to modify session status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse: Represents a
// fulfillment response to the user.
type GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be used.
	//   "APPEND" - `messages` will be appended to the list of messages waiting to
	// be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to be
	// sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig: Represents
// configuration for a Service Directory
// (https://cloud.google.com/service-directory) service.
type GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig struct {
	// GenericWebService: Generic Service configuration of this webhook.
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `Location ID` of the service
	// directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettings: Hierarchical advanced
// settings for agent/flow/page/fulfillment/parameter. Settings exposed at
// lower level overrides the settings exposed at higher level. Overriding
// occurs at the sub-setting level. For example, the
// playback_interruption_settings at fulfillment level only overrides the
// playback_interruption_settings at the agent level, leaving other settings at
// the agent level unchanged. DTMF settings does not override each other. DTMF
// settings set at different levels define DTMF detections running in parallel.
// Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
type GoogleCloudDialogflowCxV3beta1AdvancedSettings struct {
	// AudioExportGcsDestination: If present, incoming audio is exported by
	// Dialogflow to the configured Google Cloud Storage destination. Exposed at
	// the following levels: - Agent level - Flow level
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3beta1GcsDestination `json:"audioExportGcsDestination,omitempty"`
	// DtmfSettings: Settings for DTMF. Exposed at the following levels: - Agent
	// level - Flow level - Page level - Parameter level.
	DtmfSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings `json:"dtmfSettings,omitempty"`
	// LoggingSettings: Settings for logging. Settings for Dialogflow History,
	// Contact Center messages, StackDriver logs, and speech logging. Exposed at
	// the following levels: - Agent level.
	LoggingSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	// SpeechSettings: Settings for speech to text detection. Exposed at the
	// following levels: - Agent level - Flow level - Page level - Parameter level
	SpeechSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings: Define behaviors
// for DTMF (dual tone multi frequency).
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings struct {
	// Enabled: If true, incoming audio is processed for DTMF (dual tone multi
	// frequency) events. For example, if the caller presses a button on their
	// telephone keypad and DTMF processing is enabled, Dialogflow will detect the
	// event (e.g. a "3" was pressed) in the incoming audio and pass the event to
	// the bot to drive business logic (e.g. when 3 is pressed, return the account
	// balance).
	Enabled bool `json:"enabled,omitempty"`
	// EndpointingTimeoutDuration: Endpoint timeout setting for matching dtmf input
	// to regex.
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	// FinishDigit: The digit that terminates a DTMF digit sequence.
	FinishDigit string `json:"finishDigit,omitempty"`
	// InterdigitTimeoutDuration: Interdigit timeout setting for matching dtmf
	// input to regex.
	InterdigitTimeoutDuration string `json:"interdigitTimeoutDuration,omitempty"`
	// MaxDigits: Max length of DTMF digits.
	MaxDigits int64 `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings: Define
// behaviors on logging.
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings struct {
	// EnableConsentBasedRedaction: Enables consent-based end-user input redaction,
	// if true, a pre-defined session parameter
	// `$session.params.conversation-redaction` will be used to determine if the
	// utterance should be redacted.
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	// EnableInteractionLogging: Enables DF Interaction logging.
	EnableInteractionLogging bool `json:"enableInteractionLogging,omitempty"`
	// EnableStackdriverLogging: Enables Google Cloud Logging.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings: Define
// behaviors of speech to text detection.
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings struct {
	// EndpointerSensitivity: Sensitivity of the speech model that detects the end
	// of speech. Scale from 0 to 100.
	EndpointerSensitivity int64 `json:"endpointerSensitivity,omitempty"`
	// Models: Mapping from language to Speech-to-Text model. The mapped
	// Speech-to-Text model will be selected for requests from its corresponding
	// language. For more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Models map[string]string `json:"models,omitempty"`
	// NoSpeechTimeout: Timeout before detecting no speech.
	NoSpeechTimeout string `json:"noSpeechTimeout,omitempty"`
	// UseTimeoutBasedEndpointing: Use timeout based endpointing, interpreting
	// endpointer sensitivity as seconds of timeout value.
	UseTimeoutBasedEndpointing bool `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AudioInput: Represents the natural speech
// audio to be processed.
type GoogleCloudDialogflowCxV3beta1AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single request
	// can contain up to 2 minutes of speech audio data. The transcribed text
	// cannot contain more than 256 bytes. For non-streaming audio detect intent,
	// both `config` and `audio` must be provided. For streaming audio detect
	// intent, `config` must be provided in the first request and `audio` must be
	// provided in all following requests.
	Audio string `json:"audio,omitempty"`
	// Config: Required. Instructs the speech recognizer how to process the speech
	// audio.
	Config *GoogleCloudDialogflowCxV3beta1InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BargeInConfig: Configuration of the barge-in
// behavior. Barge-in instructs the API to return a detected utterance at a
// proper time while the client is playing back the response audio from a
// previous request. When the client sees the utterance, it should stop the
// playback and immediately get ready for receiving the responses for the
// current request. The barge-in handling requires the client to start
// streaming audio input as soon as it starts playing back the audio from the
// previous response. The playback is modeled into two phases: * No barge-in
// phase: which goes first and during which speech detection should not be
// carried out. * Barge-in phase: which follows the no barge-in phase and
// during which the API starts speech detection and may inform the client that
// an utterance has been detected. Note that no-speech event is not expected in
// this phase. The client provides this configuration in terms of the durations
// of those two phases. The durations are measured in terms of the audio length
// from the start of the input audio. No-speech event is a response with
// END_OF_UTTERANCE without any transcript following up.
type GoogleCloudDialogflowCxV3beta1BargeInConfig struct {
	// NoBargeInDuration: Duration that is not eligible for barge-in at the
	// beginning of the input audio.
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	// TotalDuration: Total duration for the playback at the beginning of the input
	// audio.
	TotalDuration string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata: Metadata returned
// for the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse: The response
// message for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are empty in
	// this response.
	Results []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ContinuousTestResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`
	// Result: The result of this continuous test run, i.e. whether all the tests
	// in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never be
	// used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`
	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`
	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationSignals: This message is used to
// hold all the Conversation Signals data, which will be converted to JSON and
// exported to BigQuery.
type GoogleCloudDialogflowCxV3beta1ConversationSignals struct {
	// TurnSignals: Required. Turn signals for the current turn.
	TurnSignals *GoogleCloudDialogflowCxV3beta1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurn: One interaction between a
// human and virtual agent. The human provides some input and the virtual agent
// provides a response.
type GoogleCloudDialogflowCxV3beta1ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput `json:"userInput,omitempty"`
	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput: The input from the
// human user.
type GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`
	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`
	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3beta1QueryInput `json:"input,omitempty"`
	// IsWebhookEnabled: If webhooks should be allowed to trigger in response to
	// the user utterance. Often if parameters are injected, webhooks should not be
	// enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput: The output
// from the virtual agent.
type GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name and
	// displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`
	// DiagnosticInfo: Required. Input only. The diagnostic info output for the
	// turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// Differences: Output only. If this is part of a result conversation turn, the
	// list of differences between the original run and the replay for this output,
	// if any.
	Differences []*GoogleCloudDialogflowCxV3beta1TestRunDifference `json:"differences,omitempty"`
	// SessionParameters: The session parameters available to the bot at this
	// point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`
	// Status: Response error from the agent in the test result. If set, other
	// output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"textResponses,omitempty"`
	// TriggeredIntent: The Intent that triggered the response. Only name and
	// displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3beta1Intent `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata: Metadata
// associated with the long running operation for Versions.CreateVersion.
type GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnection: A data store connection.
// It represents a data store in Discovery Engine and the type of the contents
// it contains.
type GoogleCloudDialogflowCxV3beta1DataStoreConnection struct {
	// DataStore: The full name of the referenced data store. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStore string `json:"dataStore,omitempty"`
	// DataStoreType: The type of the connected data store.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Not specified. This value indicates that
	// the data store type is not specified, so it will not be used during search.
	//   "PUBLIC_WEB" - A data store that contains public web content.
	//   "UNSTRUCTURED" - A data store that contains unstructured private data.
	//   "STRUCTURED" - A data store that contains structured data (for example
	// FAQ).
	DataStoreType string `json:"dataStoreType,omitempty"`
	// DocumentProcessingMode: The document processing mode for the data store
	// connection. Should only be set for PUBLIC_WEB and UNSTRUCTURED data stores.
	// If not set it is considered as DOCUMENTS, as this is the legacy mode.
	//
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED" - Not specified. This should be set
	// for STRUCTURED type data stores. Due to legacy reasons this is considered as
	// DOCUMENTS for STRUCTURED and PUBLIC_WEB data stores.
	//   "DOCUMENTS" - Documents are processed as documents.
	//   "CHUNKS" - Documents are converted to chunks.
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowMetadata: Metadata returned for the
// Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3beta1DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3beta1TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowResponse: The response message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3beta1DeployFlowResponse struct {
	// Deployment: The name of the flow version deployment. Format:
	// `projects//locations//agents//environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`
	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DtmfInput: Represents the input for dtmf
// event.
type GoogleCloudDialogflowCxV3beta1DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`
	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Environment: Represents an environment for an
// agent. You can create multiple versions of your agent and publish them to
// separate environments. When you edit an agent, you are editing the draft
// agent. At any point, you can save the draft agent as an agent version, which
// is an immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for testing, development, production, etc.
type GoogleCloudDialogflowCxV3beta1Environment struct {
	// Description: The human-readable description of the environment. The maximum
	// length is 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the environment (unique in
	// an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`
	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionConfigs: A list of configurations for flow versions. You should
	// include version configs for all flows that are reachable from `Start Flow`
	// in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	// WebhookConfig: The webhook configuration for this environment.
	WebhookConfig *GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig: The configuration
// for continuous tests.
type GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in TestCasesConfig.test_cases
	// periodically. Default false. If set to true, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`
	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`
	// TestCases: A list of test case names to run. They should be under the same
	// agent. Format of each test case name:
	// `projects//locations//agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig: Configuration for
// the version.
type GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig struct {
	// Version: Required. Flow, playbook and tool versions are supported. Format
	// for flow version: projects//locations//agents//flows//versions/. Format for
	// playbook version: projects//locations//agents//playbooks//versions/. Format
	// for tool version: projects//locations//agents//tools//versions/.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig: Configuration for
// webhooks.
type GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig struct {
	// WebhookOverrides: The list of webhooks to override for the agent
	// environment. The webhook must exist in the agent. You can override fields in
	// `generic_web_service` and `service_directory`.
	WebhookOverrides []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventHandler: An event handler specifies an
// event that can be handled during a session. When the specified event
// happens, the following actions are taken in order: * If there is a
// `trigger_fulfillment` associated with the event, it will be called. * If
// there is a `target_page` associated with the event, the session will
// transition into the specified page. * If there is a `target_flow` associated
// with the event, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`
	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TargetPlaybook: The target playbook to transition to. Format:
	// `projects//locations//agents//playbooks/`.
	TargetPlaybook string `json:"targetPlaybook,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the event occurs. Handling
	// webhook errors with a fulfillment enabled with webhook could cause infinite
	// loop. It is invalid to specify such fulfillment for a handler handling
	// webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventInput: Represents the event to trigger.
type GoogleCloudDialogflowCxV3beta1EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowCxV3beta1ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent. This field is
	// populated if none of `agent_uri` and `git_destination` are specified in
	// ExportAgentRequest.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`
	// CommitSha: Commit SHA of the git push. This field is populated if
	// `git_destination` is specified in ExportAgentRequest.
	CommitSha string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata: Metadata returned
// for the EntityTypes.ExportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse: The response
// message for EntityTypes.ExportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse struct {
	// EntityTypesContent: Uncompressed byte content for entity types. This field
	// is populated only if `entity_types_content_inline` is set to true in
	// ExportEntityTypesRequest.
	EntityTypesContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"entityTypesContent,omitempty"`
	// EntityTypesUri: The URI to a file containing the exported entity types. This
	// field is populated only if `entity_types_uri` is specified in
	// ExportEntityTypesRequest.
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportFlowResponse: The response message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3beta1ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`
	// FlowUri: The URI to a file containing the exported flow. This field is
	// populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata: Metadata returned for
// the Intents.ExportIntents long running operation.
type GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportIntentsResponse: The response message
// for Intents.ExportIntents.
type GoogleCloudDialogflowCxV3beta1ExportIntentsResponse struct {
	// IntentsContent: Uncompressed byte content for intents. This field is
	// populated only if `intents_content_inline` is set to true in
	// ExportIntentsRequest.
	IntentsContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"intentsContent,omitempty"`
	// IntentsUri: The URI to a file containing the exported intents. This field is
	// populated only if `intents_uri` is specified in ExportIntentsRequest.
	IntentsUri string `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata: Metadata returned for
// the TestCases.ExportTestCases long running operation. This message currently
// has no fields.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse: The response message
// for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`
	// GcsUri: The URI to a file containing the exported test cases. This field is
	// populated only if `gcs_uri` is specified in ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Form: A form is a data model that groups
// related parameters that can be collected from the user. The process in which
// the agent prompts the user and collects parameter values from the user is
// called form filling. A form can be added to a page. When form filling is
// done, the filled parameters will be written to the session.
type GoogleCloudDialogflowCxV3beta1Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3beta1FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameter: Represents a form parameter.
type GoogleCloudDialogflowCxV3beta1FormParameter struct {
	// AdvancedSettings: Hierarchical advanced settings for this parameter. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// DefaultValue: The default value of an optional parameter. If the parameter
	// is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// DisplayName: Required. The human-readable name of the parameter, unique
	// within the form.
	DisplayName string `json:"displayName,omitempty"`
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// Required: Indicates whether the parameter is required. Optional parameters
	// will not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior: Configuration for
// how the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the initial
	// prompt that the agent can present to the user in order to fill the
	// parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"initialPromptFulfillment,omitempty"`
	// RepromptEventHandlers: The handlers for parameter-level events, used to
	// provide reprompt for the parameter or transition to a different page/flow.
	// The supported events are: * `sys.no-match-`, where N can be from 1 to 6 *
	// `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 *
	// `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the parameter. If
	// the user's response does not fill the parameter, a no-match/no-input event
	// will be triggered, and the fulfillment associated with the
	// `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to
	// provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined)
	// will respond to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used to
	// handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case where the
	// parameter values have been `invalidated` by webhook. For example, if the
	// user's response fill the parameter, however the parameter was invalidated by
	// webhook, the fulfillment associated with the `sys.invalid-parameter` handler
	// (if defined) will be called to provide a prompt. If the event handler for
	// the corresponding event can't be found on the parameter,
	// `initial_prompt_fulfillment` will be re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Fulfillment: A fulfillment can do one or more
// of the following actions at the same time: * Generate rich message
// responses. * Set parameter values. * Call the webhook. Fulfillments can be
// called at various stages in the Page or Form lifecycle. For example, when a
// DetectIntentRequest drives a session to enter a new page, the page's entry
// fulfillment can add a static response to the QueryResult in the returning
// DetectIntentResponse, call the webhook (for example, to load user data from
// a database), or both.
type GoogleCloudDialogflowCxV3beta1Fulfillment struct {
	// AdvancedSettings: Hierarchical advanced settings for this fulfillment. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"conditionalCases,omitempty"`
	// EnableGenerativeFallback: If the flag is true, the agent will utilize LLM to
	// generate a text response. If LLM generation fails, the defined responses in
	// the fulfillment will be respected. This flag is only useful for fulfillments
	// associated with no-match event handlers.
	EnableGenerativeFallback bool `json:"enableGenerativeFallback,omitempty"`
	// Generators: A list of Generators to be called during this fulfillment.
	Generators []*GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings `json:"generators,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ReturnPartialResponses: Whether Dialogflow should return currently queued
	// fulfillment response messages in streaming APIs. If a webhook is specified,
	// it happens before Dialogflow invokes webhook. Warning: 1) This flag only
	// affects streaming API. Responses are still queued and returned once in
	// non-streaming API. 2) The flag can be enabled in any fulfillment but only
	// the first 3 partial responses will be returned. You may only want to apply
	// it to fulfillments that have slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`
	// SetParameterActions: Set parameter values before executing the webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	// Tag: The value of this field will be populated in the WebhookRequest
	// `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
	// called. The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes. This
	// field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`
	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases: A list of
// cascading if-else conditions. Cases are mutually exclusive. The first one
// with a matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase: Each case has
// a Boolean condition. When it is evaluated to be True, the corresponding
// messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	// Condition: The condition to activate and select this case. Empty means the
	// condition is always true. The condition is evaluated against form parameters
	// or session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent:
// The list of messages or conditional cases to activate for this case.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings: Generator
// settings used by the LLM to generate a text response.
type GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings struct {
	// Generator: Required. The generator to call. Format:
	// `projects//locations//agents//generators/`.
	Generator string `json:"generator,omitempty"`
	// InputParameters: Map from placeholder parameter in the Generator to
	// corresponding session parameters. By default, Dialogflow uses the session
	// parameter with the same name to fill in the generator template. e.g. If
	// there is a placeholder parameter `city` in the Generator, Dialogflow default
	// to fill in the `$city` with `$session.params.city`. However, you may choose
	// to fill `$city` with `$session.params.desination-city`. - Map key: parameter
	// ID - Map value: session parameter name
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	// OutputParameter: Required. Output parameter which should contain the
	// generator response.
	OutputParameter string `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction: Setting a
// parameter value.
type GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`
	// Value: The new value of the parameter. A null value clears the parameter.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GcsDestination: Google Cloud Storage location
// for a Dialogflow operation that writes or exports objects (e.g. exported
// agent or transcripts) outside of Dialogflow.
type GoogleCloudDialogflowCxV3beta1GcsDestination struct {
	// Uri: Required. The Google Cloud Storage URI for the exported objects. A URI
	// is of the form: `gs://bucket/object-name-or-prefix` Whether a full object
	// name, or just a prefix, its usage depends on the Dialogflow operation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata: Metadata returned
// for the EntityTypes.ImportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse: The response
// message for EntityTypes.ImportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportEntityTypesRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	// EntityTypes: The unique identifier of the imported entity types. Format:
	// `projects//locations//agents//entity_types/`.
	EntityTypes []string `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// EntityTypeDisplayNames: Display names of conflicting entity types.
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportFlowResponse: The response message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3beta1ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata: Metadata returned for
// the Intents.ImportIntents long running operation.
type GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsResponse: The response message
// for Intents.ImportIntents.
type GoogleCloudDialogflowCxV3beta1ImportIntentsResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportIntentsRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	// Intents: The unique identifier of the imported intents. Format:
	// `projects//locations//agents//intents/`.
	Intents []string `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// IntentDisplayNames: Display names of conflicting intents.
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata: Metadata returned for
// the TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3beta1TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse: The response message
// for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InlineDestination: Inline destination for a
// Dialogflow operation that writes or exports objects (e.g. intents) outside
// of Dialogflow.
type GoogleCloudDialogflowCxV3beta1InlineDestination struct {
	// Content: Output only. The uncompressed byte content for the objects. Only
	// populated in responses.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InputAudioConfig: Instructs the speech
// recognizer on how to process the audio content.
type GoogleCloudDialogflowCxV3beta1InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed little-endian
	// samples (Linear PCM). LINT: LEGACY_NAMES
	//   "AUDIO_ENCODING_FLAC" - [`FLAC`](https://xiph.org/flac/documentation.html)
	// (Free Lossless Audio Codec) is the recommended encoding because it is
	// lossless (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio samples
	// using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must be
	// 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is required,
	// `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has a
	// header byte in each block, as in MIME type `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in [RFC
	// 5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence of
	// blocks, one block per RTP packet. Each block starts with a byte containing
	// the length of the block, in bytes, followed by one or more frames of Speex
	// data, padded to an integral number of bytes (octets) as specified in RFC
	// 5574. In other words, each RTP header is replaced with a single byte
	// containing the block length. Only Speex wideband is supported.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio samples
	// using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// BargeInConfig: Configuration of barge-in behavior during the streaming of
	// input audio.
	BargeInConfig *GoogleCloudDialogflowCxV3beta1BargeInConfig `json:"bargeInConfig,omitempty"`
	// EnableWordInfo: Optional. If `true`, Dialogflow returns SpeechWordInfo in
	// StreamingRecognitionResult with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`
	// Model: Optional. Which Speech model to select for the given request. For
	// more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Model string `json:"model,omitempty"`
	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In this
	// case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech model
	// that the caller is eligible for.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced model is
	// available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced variant
	// does not exist for the given model and request language, Dialogflow falls
	// back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// describes which models have enhanced variants.
	ModelVariant string `json:"modelVariant,omitempty"`
	// OptOutConformerModelMigration: If `true`, the request will opt out for STT
	// conformer model migration. This field will be deprecated once force
	// migration takes place in June 2024. Please refer to Dialogflow CX Speech
	// model migration
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-model-migration).
	OptOutConformerModelMigration bool `json:"optOutConformerModelMigration,omitempty"`
	// PhraseHints: Optional. A list of strings containing words and phrases that
	// the speech recognizer should recognize with higher likelihood. See the Cloud
	// Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details.
	PhraseHints []string `json:"phraseHints,omitempty"`
	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in the
	// query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SingleUtterance: Optional. If `false` (default), recognition does not cease
	// until the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed. Note: This setting is relevant only for
	// streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Intent: An intent represents a user's intent
// to interact with a conversational agent. You can provide information for the
// Dialogflow API to use to match user input to an intent by adding training
// phrases (i.e., examples of user input) to your intent.
type GoogleCloudDialogflowCxV3beta1Intent struct {
	// Description: Human readable description for better understanding an intent
	// like its scope, content, result etc. Maximum character limit: 140
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the intent, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// IsFallback: Indicates whether this is a fallback intent. Currently only
	// default fallback intent is allowed in the agent, which is added upon agent
	// creation. Adding training phrases to fallback intent is useful in the case
	// of requests that are mistakenly matched, since training phrases assigned to
	// fallback intents act as negative examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`
	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets. Keys must
	// start with a letter. Keys and values can be no longer than 63 characters and
	// no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined
	// labels. Currently allowed Dialogflow defined labels include: * sys-head *
	// sys-contextual The above labels do not require value. "sys-head" means the
	// intent is a head intent. "sys-contextual" means the intent is a contextual
	// intent.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3beta1IntentParameter `json:"parameters,omitempty"`
	// Priority: The priority of this intent. Higher numbers represent higher
	// priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// TrainingPhrases: The collection of training phrases the agent is trained on
	// to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentInput: Represents the intent to trigger
// programmatically rather than as a result of natural language processing.
type GoogleCloudDialogflowCxV3beta1IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentParameter: Represents an intent
// parameter.
type GoogleCloudDialogflowCxV3beta1IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// Id: Required. The unique identifier of the parameter. This field is used by
	// training phrases to annotate their parts.
	Id string `json:"id,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase: Represents an example
// that the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `parameter_id` field is set.
	Parts []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	// RepeatCount: Indicates how many times this example was added to the intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart: Represents a part of
// a training phrase.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training phrase.
	ParameterId string `json:"parameterId,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings: The Knowledge
// Connector settings for this page or flow. This includes information such as
// the attached Knowledge Bases, and the way to execute fulfillment.
type GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings struct {
	// DataStoreConnections: Optional. List of related data store connections.
	DataStoreConnections []*GoogleCloudDialogflowCxV3beta1DataStoreConnection `json:"dataStoreConnections,omitempty"`
	// Enabled: Whether Knowledge Connector is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to be triggered. When the answers from
	// the Knowledge Connector are selected by Dialogflow, you can utitlize the
	// request scoped parameter `$request.knowledge.answers` (contains up to the 5
	// highest confidence answers) and `$request.knowledge.questions` (contains the
	// corresponding questions) to construct the fulfillment.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LanguageInfo: Represents the language
// information of the request.
type GoogleCloudDialogflowCxV3beta1LanguageInfo struct {
	// ConfidenceScore: The confidence score of the detected language between 0 and
	// 1.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// InputLanguageCode: The language code specified in the original request.
	InputLanguageCode string `json:"inputLanguageCode,omitempty"`
	// ResolvedLanguageCode: The language code detected for this request based on
	// the user conversation.
	ResolvedLanguageCode string `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1Page: A Dialogflow CX conversation (session)
// can be described and visualized as a state machine. The states of a CX
// session are represented by pages. For each flow, you define many pages,
// where your combined pages can handle a complete conversation on the topics
// the flow is designed for. At any given moment, exactly one page is the
// current page, the current page is considered active, and the flow associated
// with that page is considered active. Every flow has a special start page.
// When a flow initially becomes active, the start page page becomes the
// current page. For each conversational turn, the current page will either
// stay the same or transition to another page. You configure each page to
// collect information from the end-user that is relevant for the
// conversational state represented by the page. For more information, see the
// Page guide (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3beta1Page struct {
	// AdvancedSettings: Hierarchical advanced settings for this page. The settings
	// exposed at the lower level overrides the settings exposed at the higher
	// level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// Description: The description of the page. The maximum length is 500
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the page, unique within
	// the flow.
	DisplayName string `json:"displayName,omitempty"`
	// EntryFulfillment: The fulfillment to call when the session is entering the
	// page.
	EntryFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"entryFulfillment,omitempty"`
	// EventHandlers: Handlers associated with the page to handle events such as
	// webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandlers,omitempty"`
	// Form: The form associated with the page, used for collecting parameters
	// relevant to the page.
	Form *GoogleCloudDialogflowCxV3beta1Form `json:"form,omitempty"`
	// KnowledgeConnectorSettings: Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// Name: The unique identifier of the page. Required for the Pages.UpdatePage
	// method. Pages.CreatePage populates the name automatically. Format:
	// `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`
	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups` added to the
	// page. Transition route groups must be unique within a page. If the page
	// links both flow-level transition route groups and agent-level transition
	// route groups, the flow-level ones will have higher priority and will be put
	// before the agent-level ones. * If multiple transition routes within a page
	// scope refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's transition
	// routes. * If multiple transition route groups within a page contain the same
	// intent, then the first group in the ordered list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`
	// TransitionRoutes: A list of transitions for the transition rules of this
	// page. They route the conversation to another page in the same flow, or
	// another flow. When we are in a certain page, the TransitionRoutes are
	// evaluated in the following order: * TransitionRoutes defined in the page
	// with intent specified. * TransitionRoutes defined in the transition route
	// groups with intent specified. * TransitionRoutes defined in flow with intent
	// specified. * TransitionRoutes defined in the transition route groups with
	// intent specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups with
	// only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfo: Represents page information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`
	// DisplayName: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The display name of the current page.
	DisplayName string `json:"displayName,omitempty"`
	// FormInfo: Optional for both WebhookRequest and WebhookResponse. Information
	// about the form.
	FormInfo *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfo: Represents form information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse. The
	// parameters contained in the form. Note that the webhook cannot add or remove
	// any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo: Represents
// parameter information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique within the
	// form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`
	// JustCollected: Optional for WebhookRequest. Ignored for WebhookResponse.
	// Indicates if the parameter value was just collected on the last conversation
	// turn.
	JustCollected bool `json:"justCollected,omitempty"`
	// Required: Optional for both WebhookRequest and WebhookResponse. Indicates
	// whether the parameter is required. Optional parameters will not trigger
	// prompts; however, they are filled if the user specifies them. Required
	// parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// State: Always present for WebhookRequest. Required for WebhookResponse. The
	// state of the parameter. This field can be set to INVALID by the webhook to
	// invalidate the parameter; other values set by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This field can
	// be used by the webhook to invalidate the parameter and ask the server to
	// collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`
	// Value: Optional for both WebhookRequest and WebhookResponse. The value of
	// the parameter. This field can be set by the webhook to change the parameter
	// value.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryInput: Represents the query input. It can
// contain one of: 1. A conversational query in the form of text. 2. An intent
// query that specifies which intent to trigger. 3. Natural language speech
// audio to be processed. 4. An event to be triggered. 5. DTMF digits to invoke
// an intent and fill in parameter value. 6. The results of a tool executed by
// the client.
type GoogleCloudDialogflowCxV3beta1QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3beta1AudioInput `json:"audio,omitempty"`
	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3beta1DtmfInput `json:"dtmf,omitempty"`
	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3beta1EventInput `json:"event,omitempty"`
	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3beta1IntentInput `json:"intent,omitempty"`
	// LanguageCode: Required. The language of the input. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3beta1TextInput `json:"text,omitempty"`
	// ToolCallResult: The results of a tool executed by the client.
	ToolCallResult *GoogleCloudDialogflowCxV3beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessage: Represents a response message
// that can be returned by a conversational agent. Response messages are also
// used for output audio synthesis. The approach is as follows: * If at least
// one OutputAudioText response is present, then all OutputAudioText responses
// are linearly concatenated, and the result is used for output audio
// synthesis. * If the OutputAudioText responses are a mixture of text and
// SSML, then the concatenated result is treated as SSML; otherwise, the result
// is treated as either text or SSML as appropriate. The agent designer should
// ideally use either text or SSML consistently throughout the bot design. *
// Otherwise, all Text responses are linearly concatenated, and the result is
// used for output audio synthesis. This approach allows for more sophisticated
// user experience scenarios, where the text displayed to the user may differ
// from what is heard.
type GoogleCloudDialogflowCxV3beta1ResponseMessage struct {
	// Channel: The channel which the response is associated with. Clients can
	// specify the channel via QueryParameters.channel, and only associated channel
	// response will be returned.
	Channel string `json:"channel,omitempty"`
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	// EndInteraction: Output only. A signal that indicates the interaction with
	// the Dialogflow agent has ended. This message is generated by Dialogflow only
	// when the conversation reaches `END_SESSION` page. It is not supposed to be
	// defined by the user. It's guaranteed that there is at most one such message
	// in each response.
	EndInteraction *GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction `json:"endInteraction,omitempty"`
	// KnowledgeInfoCard: Represents info card for knowledge answers, to be better
	// rendered in Dialogflow Messenger.
	KnowledgeInfoCard *GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard `json:"knowledgeInfoCard,omitempty"`
	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`
	// MixedAudio: Output only. An audio response message composed of both the
	// synthesized Dialogflow agent responses and responses defined via play_audio.
	// This message is generated by Dialogflow only and not supposed to be defined
	// by the user.
	MixedAudio *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`
	// OutputAudioText: A text or ssml response that is preferentially used for TTS
	// output audio synthesis, as described in the comment on the ResponseMessage
	// message.
	OutputAudioText *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`
	// Payload: Returns a response containing a custom, platform-specific payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// PlayAudio: Signal that the client should play an audio clip hosted at a
	// client-specific URI. Dialogflow uses this to construct mixed_audio. However,
	// Dialogflow itself does not try to read or process the URI in any way.
	PlayAudio *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio `json:"playAudio,omitempty"`
	// TelephonyTransferCall: A signal that the client should transfer the phone
	// call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"text,omitempty"`
	// ToolCall: Returns the definition of a tool call that should be executed by
	// the client.
	ToolCall *GoogleCloudDialogflowCxV3beta1ToolCall `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess: Indicates
// that the conversation succeeded, i.e., the bot handled the issue that the
// customer talked to it about. Dialogflow only uses this to determine which
// conversations should be counted as successful and doesn't process the
// metadata in this message in any way. Note that Dialogflow also considers
// conversations that get to the conversation end page as successful even if
// they don't return ConversationSuccess. You may set this, for example: * In
// the entry_fulfillment of a Page if entering the page indicates that the
// conversation succeeded. * In a webhook response when you determine that you
// handled the customer issue.
type GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction: Indicates that
// interaction with the Dialogflow agent has ended. This message is generated
// by Dialogflow only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard: Represents
// info card response. If the response contains generative knowledge
// prediction, Dialogflow will return a payload with Infobot Messenger
// compatible info card. Otherwise, the info card response is skipped.
type GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard struct {
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff: Indicates
// that the conversation should be handed off to a live agent. Dialogflow only
// uses this to determine which conversations were handed off to a human agent
// for measurement purposes. What else to do with this signal is up to you and
// your handoff procedures. You may set this, for example: * In the
// entry_fulfillment of a Page if entering the page indicates something went
// extremely wrong in the conversation. * In a webhook response when you
// determine that the customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow doesn't
	// impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio: Represents an audio
// message that is composed of both segments synthesized from the Dialogflow
// agent prompts and ones hosted externally at the specified URIs. The external
// URIs are specified via play_audio. This message is generated by Dialogflow
// only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment: Represents
// one segment of audio.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this segment
	// can be interrupted by the end user's speech and the client should then start
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Audio: Raw audio synthesized from the Dialogflow agent's response using the
	// output config specified in the request.
	Audio string `json:"audio,omitempty"`
	// Uri: Client-specific URI that points to an audio clip accessible to the
	// client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText: A text or ssml
// response that is preferentially used for TTS output audio synthesis, as
// described in the comment on the ResponseMessage message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`
	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio: Specifies an audio
// clip to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose any
	// validation on this value. It is specific to the client that reads it.
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall:
// Represents the signal that telles the client to transfer the phone call
// connected to the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageText: The text response
// message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Text: Required. A collection of text response variants. If multiple variants
	// are defined, only one text response variant is returned at runtime.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata: Metadata returned
// for the Environments.RunContinuousTest long running operation.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse: The response
// message for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata: Metadata returned for the
// TestCases.RunTestCase long running operation. This message currently has no
// fields.
type GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseResponse: The response message for
// TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3beta1RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SessionInfo: Represents session information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for WebhookResponse. All
	// parameters collected from forms and intents during the session. Parameters
	// can be created, updated, or removed by the webhook. To remove a parameter
	// from the session, the webhook should explicitly set the parameter value to
	// null in WebhookResponse. The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Session: Always present for WebhookRequest. Ignored for WebhookResponse. The
	// unique identifier of the session. This field can be used by the webhook to
	// identify a session. Format: `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment is
	// specified.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3beta1TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`
	// DisplayName: Required. The human-readable name of the test case, unique
	// within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"lastTestResult,omitempty"`
	// Name: The unique identifier of the test case. TestCases.CreateTestCase will
	// populate the name automatically. Otherwise use format:
	// `projects//locations//agents//testCases/`.
	Name string `json:"name,omitempty"`
	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`
	// Tags: Tags are short descriptions that users may apply to test cases for
	// organizational and filtering purposes. Each tag should start with "#" and
	// has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`
	// TestCaseConversationTurns: The conversation turns uttered when the test case
	// was created, in chronological order. These include the canonical set of
	// agent utterances that should occur when the agent is working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3beta1TestConfig `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseError: Error info for importing a
// test.
type GoogleCloudDialogflowCxV3beta1TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3beta1TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test case
	// replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"conversationTurns,omitempty"`
	// Environment: Environment where the test was run. If not set, it indicates
	// the draft environment.
	Environment string `json:"environment,omitempty"`
	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases//results/`.
	Name string `json:"name,omitempty"`
	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`
	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestConfig: Represents configurations for a
// test case.
type GoogleCloudDialogflowCxV3beta1TestConfig struct {
	// Flow: Flow name to start the test case with. Format:
	// `projects//locations//agents//flows/`. Only one of `flow` and `page` should
	// be set to indicate the starting point of the test case. If neither is set,
	// the test case will start with start page on the default start flow.
	Flow string `json:"flow,omitempty"`
	// Page: The page to start the test case with. Format:
	// `projects//locations//agents//flows//pages/`. Only one of `flow` and `page`
	// should be set to indicate the starting point of the test case. If neither is
	// set, the test case will start with start page on the default start flow.
	Page string `json:"page,omitempty"`
	// TrackingParameters: Session parameters to be compared when calculating
	// differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestError: Error info for running a test.
type GoogleCloudDialogflowCxV3beta1TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`
	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestRunDifference: The description of
// differences between original and replayed agent output.
type GoogleCloudDialogflowCxV3beta1TestRunDifference struct {
	// Description: A human readable description of the diff, showing the actual
	// output vs expected output.
	Description string `json:"description,omitempty"`
	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	//   "FLOW" - The flow.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TextInput: Represents the natural language
// text to be processed.
type GoogleCloudDialogflowCxV3beta1TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be processed.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCall: Represents a call of a specific
// tool's action with the specified inputs.
type GoogleCloudDialogflowCxV3beta1ToolCall struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCallResult: The result of calling a tool's
// action that has been executed by the client.
type GoogleCloudDialogflowCxV3beta1ToolCallResult struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowCxV3beta1ToolCallResultError `json:"error,omitempty"`
	// OutputParameters: The tool call's output parameters.
	OutputParameters googleapi.RawMessage `json:"outputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCallResultError: An error produced by the
// tool call.
type GoogleCloudDialogflowCxV3beta1ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRoute: A transition route specifies
// a intent that can be matched and/or a data condition that can be evaluated
// during a session. When a specified transition is matched, the following
// actions are taken in order: * If there is a `trigger_fulfillment` associated
// with the transition, it will be called. * If there is a `target_page`
// associated with the transition, the session will transition into the
// specified page. * If there is a `target_flow` associated with the
// transition, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or session
	// parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least
	// one of `intent` or `condition` must be specified. When both `intent` and
	// `condition` are specified, the transition can only happen when both are
	// fulfilled.
	Condition string `json:"condition,omitempty"`
	// Description: Optional. The description of the transition route. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`
	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the transition can
	// only happen when the given intent is matched. At least one of `intent` or
	// `condition` must be specified. When both `intent` and `condition` are
	// specified, the transition can only happen when both are fulfilled.
	Intent string `json:"intent,omitempty"`
	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the condition is satisfied.
	// At least one of `trigger_fulfillment` and `target` must be specified. When
	// both are defined, `trigger_fulfillment` is executed first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TurnSignals: Collection of all signals that
// were extracted for a single turn of the conversation.
type GoogleCloudDialogflowCxV3beta1TurnSignals struct {
	// AgentEscalated: Whether agent responded with LiveAgentHandoff fulfillment.
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	// DtmfUsed: Whether user was using DTMF input.
	DtmfUsed bool `json:"dtmfUsed,omitempty"`
	// FailureReasons: Failure reasons of the turn.
	//
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED" - Failure reason is not assigned.
	//   "FAILED_INTENT" - Whether NLU failed to recognize user intent.
	//   "FAILED_WEBHOOK" - Whether webhook failed during the turn.
	FailureReasons []string `json:"failureReasons,omitempty"`
	// NoMatch: Whether NLU predicted NO_MATCH.
	NoMatch bool `json:"noMatch,omitempty"`
	// NoUserInput: Whether user provided no input.
	NoUserInput bool `json:"noUserInput,omitempty"`
	// ReachedEndPage: Whether turn resulted in End Session page.
	ReachedEndPage bool `json:"reachedEndPage,omitempty"`
	// SentimentMagnitude: Sentiment magnitude of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentMagnitude float64 `json:"sentimentMagnitude,omitempty"`
	// SentimentScore: Sentiment score of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentScore float64 `json:"sentimentScore,omitempty"`
	// UserEscalated: Whether user was specifically asking for a live agent.
	UserEscalated bool `json:"userEscalated,omitempty"`
	// WebhookStatuses: Human-readable statuses of the webhooks triggered during
	// this turn.
	WebhookStatuses []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1Webhook: Webhooks host the developer's
// business logic. During a session, webhooks allow the developer to use the
// data extracted by Dialogflow's natural language processing to generate
// dynamic responses, validate collected data, or trigger actions on the
// backend.
type GoogleCloudDialogflowCxV3beta1Webhook struct {
	// Disabled: Indicates whether the webhook is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Required. The human-readable name of the webhook, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Name: The unique identifier of the webhook. Required for the
	// Webhooks.UpdateWebhook method. Webhooks.CreateWebhook populates the name
	// automatically. Format: `projects//locations//agents//webhooks/`.
	Name string `json:"name,omitempty"`
	// ServiceDirectory: Configuration for a Service Directory
	// (https://cloud.google.com/service-directory) service.
	ServiceDirectory *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	// Timeout: Webhook execution timeout. Execution is considered failed if
	// Dialogflow doesn't receive a response from webhook at the end of the timeout
	// period. Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebService: Represents
// configuration for a generic web service.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebService struct {
	// AllowedCaCerts: Optional. Specifies a list of allowed custom CA certificates
	// (in DER format) for HTTPS verification. This overrides the default SSL trust
	// store. If this is empty or unspecified, Dialogflow will use Google's default
	// trust store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a certificate
	// can be self-signed using the following command, ``` openssl x509 -req -days
	// 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \
	// -extfile <(printf "\nsubjectAltName='DNS:www.example.com'") ```
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// HttpMethod: Optional. HTTP method for the flexible webhook calls. Standard
	// webhook always uses POST.
	//
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED" - HTTP method not specified.
	//   "POST" - HTTP POST Method.
	//   "GET" - HTTP GET Method.
	//   "HEAD" - HTTP HEAD Method.
	//   "PUT" - HTTP PUT Method.
	//   "DELETE" - HTTP DELETE Method.
	//   "PATCH" - HTTP PATCH Method.
	//   "OPTIONS" - HTTP OPTIONS Method.
	HttpMethod string `json:"httpMethod,omitempty"`
	// OauthConfig: Optional. The OAuth configuration of the webhook. If specified,
	// Dialogflow will initiate the OAuth client credential flow to exchange an
	// access token from the 3rd party platform and put it in the auth header.
	OauthConfig *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig `json:"oauthConfig,omitempty"`
	// ParameterMapping: Optional. Maps the values extracted from specific fields
	// of the flexible webhook response into session parameters. - Key: session
	// parameter name - Value: field path in the webhook response
	ParameterMapping map[string]string `json:"parameterMapping,omitempty"`
	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`
	// RequestBody: Optional. Defines a custom JSON object as request body to send
	// to flexible webhook.
	RequestBody string `json:"requestBody,omitempty"`
	// RequestHeaders: The HTTP request headers to send together with webhook
	// requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`
	// SecretVersionForUsernamePassword: Optional. The SecretManager secret version
	// resource storing the username:password pair for HTTP Basic authentication.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForUsernamePassword string `json:"secretVersionForUsernamePassword,omitempty"`
	// SecretVersionsForRequestHeaders: Optional. The HTTP request headers to send
	// together with webhook requests. Header values are stored in SecretManager
	// secret versions. When the same header name is specified in both
	// `request_headers` and `secret_versions_for_request_headers`, the value in
	// `secret_versions_for_request_headers` will be used.
	SecretVersionsForRequestHeaders map[string]GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	// ServiceAccountAuthConfig: Optional. Configuration for service account
	// authentication.
	ServiceAccountAuthConfig *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig `json:"serviceAccountAuthConfig,omitempty"`
	// ServiceAgentAuth: Optional. Indicate the auth token type generated from the
	// Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	//
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED" - Service agent auth type unspecified.
	// Default to ID_TOKEN.
	//   "NONE" - No token used.
	//   "ID_TOKEN" - Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function and
	// Cloud Run after you grant Invoker role to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	//   "ACCESS_TOKEN" - Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google Cloud
	// APIs after you grant required roles to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// Uri: Required. The webhook URI for receiving POST requests. It must use
	// https protocol.
	Uri string `json:"uri,omitempty"`
	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`
	// WebhookType: Optional. Type of the webhook.
	//
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - Represents a standard webhook.
	//   "FLEXIBLE" - Represents a flexible webhook.
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig:
// Represents configuration of OAuth client credential flow for 3rd party API
// authentication.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig struct {
	// ClientId: Required. The client ID provided by the 3rd party platform.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Optional. The client secret provided by the 3rd party
	// platform.
	ClientSecret string `json:"clientSecret,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// SecretVersionForClientSecret: Optional. The name of the SecretManager secret
	// version resource storing the client secret. If this field is set, the
	// `client_secret` field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `json:"secretVersionForClientSecret,omitempty"`
	// TokenEndpoint: Required. The token endpoint provided by the 3rd party
	// platform to exchange an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValu
// e: Represents the value of an HTTP header stored in a SecretManager secret
// version.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue struct {
	// SecretVersion: Required. The SecretManager secret version resource storing
	// the header value. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfi
// g: Configuration for authentication using a service account.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig struct {
	// ServiceAccount: Required. The email address of the service account used to
	// authenticate the webhook call. Dialogflow uses this service account to
	// exchange an access token and the access token is then sent in the
	// `Authorization` header of the webhook request. The service account must have
	// the `roles/iam.serviceAccountTokenCreator` role granted to the Dialogflow
	// service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequest: The request message for a
// webhook call. The request is sent as a JSON object and the field names will
// be presented in camel cases. You may see undocumented fields in an actual
// request. These fields are used internally by Dialogflow and should be
// ignored.
type GoogleCloudDialogflowCxV3beta1WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`
	// DtmfDigits: If DTMF was provided as input, this field will contain the DTMF
	// digits.
	DtmfDigits string `json:"dtmfDigits,omitempty"`
	// FulfillmentInfo: Always present. Information about the fulfillment that
	// triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`
	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo `json:"intentInfo,omitempty"`
	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`
	// LanguageInfo: Information about the language of the request.
	LanguageInfo *GoogleCloudDialogflowCxV3beta1LanguageInfo `json:"languageInfo,omitempty"`
	// Messages: The list of rich message responses to present to the user. Webhook
	// can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`
	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result of the current user
	// request. The field is filled when sentiment analysis is configured to be
	// enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain the
	// name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo: Represents
// fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The value of the Fulfillment.tag field will be
	// populated in this field by Dialogflow when the associated webhook is called.
	// The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo: Represents intent
// information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DisplayName: Always present. The display name of the last matched intent.
	DisplayName string `json:"displayName,omitempty"`
	// LastMatchedIntent: Always present. The unique identifier of the last matched
	// intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`
	// Parameters: Parameters identified as a result of intent matching. This is a
	// map of the name of the identified parameter to the value of the parameter
	// identified from the user's utterance. All parameters defined in the matched
	// intent that are identified will be surfaced here.
	Parameters map[string]GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue:
// Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from user
	// utterance.
	OriginalValue string `json:"originalValue,omitempty"`
	// ResolvedValue: Always present. Structured value for the parameter extracted
	// from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult:
// Represents the result of sentiment analysis.
type GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookResponse: The response message for a
// webhook call.
type GoogleCloudDialogflowCxV3beta1WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user. This
	// field can be omitted by the webhook if it does not intend to send any
	// response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	// PageInfo: Information about page status. This field can be omitted by the
	// webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`
	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SessionInfo: Information about session status. This field can be omitted by
	// the webhook if it does not intend to modify session status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse: Represents
// a fulfillment response to the user.
type GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be used.
	//   "APPEND" - `messages` will be appended to the list of messages waiting to
	// be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to be
	// sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig: Represents
// configuration for a Service Directory
// (https://cloud.google.com/service-directory) service.
type GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig struct {
	// GenericWebService: Generic Service configuration of this webhook.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `Location ID` of the service
	// directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingInstruction: Agent Coaching instructions
// that customer can configure.
type GoogleCloudDialogflowV2AgentCoachingInstruction struct {
	// AgentAction: Optional. The action that human agent should take. For example,
	// "apologize for the slow shipping". If the users only want to use agent
	// coaching for intent detection, agent_action can be empty
	AgentAction string `json:"agentAction,omitempty"`
	// Condition: Optional. The condition of the instruction. For example, "the
	// customer wants to cancel an order". If the users want the instruction to be
	// triggered unconditionally, the condition can be empty.
	Condition string `json:"condition,omitempty"`
	// DisplayDetails: Optional. The detailed description of this instruction.
	DisplayDetails string `json:"displayDetails,omitempty"`
	// DisplayName: Optional. Display name for the instruction.
	DisplayName string `json:"displayName,omitempty"`
	// DuplicateCheckResult: Output only. Duplication check for the
	// AgentCoachingInstruction.
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// SystemAction: Optional. The action that system should take. For example,
	// "call GetOrderTime with order_number={order number provided by the
	// customer}". If the users don't have plugins or don't want to trigger
	// plugins, the system_action can be empty
	SystemAction string `json:"systemAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult:
// Duplication check for the suggestion.
type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult struct {
	// DuplicateSuggestions: Output only. The duplicate suggestions.
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateS
// uggestion: The duplicate suggestion details.
type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	// AnswerRecord: Output only. The answer record id of the past duplicate
	// suggestion.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SimilarityScore: Output only. The similarity score of between the past and
	// current suggestion.
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	// SuggestionIndex: Output only. The index of the duplicate suggestion in the
	// past suggestion list.
	SuggestionIndex int64 `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

// GoogleCloudDialogflowV2AgentCoachingSuggestion: Suggestion for coaching
// agents.
type GoogleCloudDialogflowV2AgentCoachingSuggestion struct {
	// AgentActionSuggestions: Optional. Suggested actions for the agent to take.
	AgentActionSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	// ApplicableInstructions: Optional. Instructions applicable based on the
	// current context.
	ApplicableInstructions []*GoogleCloudDialogflowV2AgentCoachingInstruction `json:"applicableInstructions,omitempty"`
	// SampleResponses: Optional. Sample response for the Agent.
	SampleResponses []*GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion: Actions
// suggested for the agent. This is based on applicable instructions.
type GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion struct {
	// AgentAction: Optional. The suggested action for the agent.
	AgentAction string `json:"agentAction,omitempty"`
	// DuplicateCheckResult: Output only. Duplicate check result for the agent
	// action suggestion.
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// Sources: Output only. Sources for the agent action suggestion.
	Sources *GoogleCloudDialogflowV2AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult:
// Duplication check for the suggestion.
type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult struct {
	// DuplicateSuggestions: Output only. The duplicate suggestions.
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSu
// ggestion: The duplicate suggestion details. Keeping answer_record and
// sources together as they are identifiers for duplicate suggestions.
type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	// AnswerRecord: Output only. The answer record id of the past duplicate
	// suggestion.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SimilarityScore: Output only. The similarity score of between the past and
	// current suggestion.
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	// Sources: Output only. Sources for the suggestion.
	Sources *GoogleCloudDialogflowV2AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// SuggestionIndex: Output only. The index of the duplicate suggestion in the
	// past suggestion list.
	SuggestionIndex int64 `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

// GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse: Sample
// response that the agent can use. This could be based on applicable
// instructions and ingested data from other systems.
type GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse struct {
	// DuplicateCheckResult: Output only. Duplicate check result for the sample
	// response.
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// ResponseText: Optional. Sample response for Agent in text.
	ResponseText string `json:"responseText,omitempty"`
	// Sources: Output only. Sources for the Sample Response.
	Sources *GoogleCloudDialogflowV2AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AgentCoachingSuggestionSources: Sources for the
// suggestion.
type GoogleCloudDialogflowV2AgentCoachingSuggestionSources struct {
	// InstructionIndexes: Output only. Source instruction indexes for the
	// suggestion. This is the index of the applicable_instructions field.
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AnnotatedMessagePart: Represents a part of a message
// possibly annotated with an entity. The part can be an entity or purely a
// part of the message between two entities or message start/end.
type GoogleCloudDialogflowV2AnnotatedMessagePart struct {
	// EntityType: The Dialogflow system entity type
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. If this is empty, Dialogflow could not annotate the phrase
	// part with a system entity.
	EntityType string `json:"entityType,omitempty"`
	// FormattedValue: The Dialogflow system entity formatted value
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. For example for a system entity of type `@sys.unit-currency`,
	// this may contain: { "amount": 5, "currency": "USD" }
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	// Text: A part of a message possibly annotated with an entity.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ArticleAnswer: Represents article answer.
type GoogleCloudDialogflowV2ArticleAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: Article match confidence. The system's confidence score that
	// this article is a good match for this conversation, as a value from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Snippets: Article snippets.
	Snippets []string `json:"snippets,omitempty"`
	// Title: The article title.
	Title string `json:"title,omitempty"`
	// Uri: The article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2ArticleSuggestionModelMetadata: Metadata for article
// suggestion models.
type GoogleCloudDialogflowV2ArticleSuggestionModelMetadata struct {
	// TrainingModelType: Optional. Type of the article suggestion model. If not
	// provided, model_type is used.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - ModelType unspecified.
	//   "SMART_REPLY_DUAL_ENCODER_MODEL" - ModelType smart reply dual encoder
	// model.
	//   "SMART_REPLY_BERT_MODEL" - ModelType smart reply bert model.
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleSuggestionModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleSuggestionModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse: The response message
// for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse struct {
	// EntityTypes: The collection of updated or created entity types.
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2BatchUpdateIntentsResponse: The response message for
// Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2BatchUpdateIntentsResponse struct {
	// Intents: The collection of updated or created intents.
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata:
// Metadata for a ConversationProfiles.ClearSuggestionFeatureConfig operation.
type GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata struct {
	// ConversationProfile: The resource name of the conversation profile. Format:
	// `projects//locations//conversationProfiles/`
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// CreateTime: Timestamp whe the request was created. The time is measured on
	// server side.
	CreateTime string `json:"createTime,omitempty"`
	// ParticipantRole: Required. The participant role to remove the suggestion
	// feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to
	// remove.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model for chat.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Context: Dialogflow contexts are similar to natural
// language context. If a person says to you "they are orange", you need
// context in order to understand what "they" is referring to. Similarly, for
// Dialogflow to handle an end-user expression like that, it needs to be
// provided with context in order to correctly match an intent. Using contexts,
// you can control the flow of a conversation. You can configure contexts for
// an intent by setting input and output contexts, which are identified by
// string names. When an intent is matched, any configured output contexts for
// that intent become active. While any contexts are active, Dialogflow is more
// likely to match intents that are configured with input contexts that
// correspond to the currently active contexts. For more information about
// context, see the Contexts guide
// (https://cloud.google.com/dialogflow/docs/contexts-overview).
type GoogleCloudDialogflowV2Context struct {
	// LifespanCount: Optional. The number of conversational query requests after
	// which the context expires. The default is `0`. If set to `0`, the context
	// expires immediately. Contexts expire automatically after 20 minutes if there
	// are no matching queries.
	LifespanCount int64 `json:"lifespanCount,omitempty"`
	// Name: Required. The unique identifier of the context. Format:
	// `projects//agent/sessions//contexts/`, or
	// `projects//agent/environments//users//sessions//contexts/`. The `Context ID`
	// is always converted to lowercase, may only contain characters in
	// `a-zA-Z0-9_-%` and may be at most 250 bytes long. If `Environment ID` is not
	// specified, we assume default 'draft' environment. If `User ID` is not
	// specified, we assume default '-' user. The following context names are
	// reserved for internal use by Dialogflow. You should not use these contexts
	// or create contexts with these names: * `__system_counters__` *
	// `*_id_dialog_context` * `*_dialog_params_size`
	Name string `json:"name,omitempty"`
	// Parameters: Optional. The collection of parameters associated with this
	// context. Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object composed of
	// a collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ConversationEvent: Represents a notification sent to
// Pub/Sub subscribers for conversation lifecycle events.
type GoogleCloudDialogflowV2ConversationEvent struct {
	// Conversation: The unique identifier of the conversation this notification
	// refers to. Format: `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// ErrorStatus: More detailed information about an error. Only set for type
	// UNRECOVERABLE_ERROR_IN_PHONE_CALL.
	ErrorStatus *GoogleRpcStatus `json:"errorStatus,omitempty"`
	// NewMessagePayload: Payload of NEW_MESSAGE event.
	NewMessagePayload *GoogleCloudDialogflowV2Message `json:"newMessagePayload,omitempty"`
	// NewRecognitionResultPayload: Payload of NEW_RECOGNITION_RESULT event.
	NewRecognitionResultPayload *GoogleCloudDialogflowV2StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Type: The type of the event that this notification refers to.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not set.
	//   "CONVERSATION_STARTED" - A new conversation has been opened. This is fired
	// when a telephone call is answered, or a conversation is created via the API.
	//   "CONVERSATION_FINISHED" - An existing conversation has closed. This is
	// fired when a telephone call is terminated, or a conversation is closed via
	// the API. The event is fired for every CompleteConversation call, even if the
	// conversation is already closed.
	//   "HUMAN_INTERVENTION_NEEDED" - An existing conversation has received
	// notification from Dialogflow that human intervention is required.
	//   "NEW_MESSAGE" - An existing conversation has received a new message,
	// either from API or telephony. It is configured in
	// ConversationProfile.new_message_event_notification_config
	//   "NEW_RECOGNITION_RESULT" - An existing conversation has received a new
	// speech recognition result. This is mainly for delivering intermediate
	// transcripts. The notification is configured in
	// ConversationProfile.new_recognition_event_notification_config.
	//   "UNRECOVERABLE_ERROR" - Unrecoverable error during a telephone call. In
	// general non-recoverable errors only occur if something was misconfigured in
	// the ConversationProfile corresponding to the call. After a non-recoverable
	// error, Dialogflow may stop responding. We don't fire this event: * in an API
	// call because we can directly return the error, or, * when we can recover
	// from an error.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ConversationModel: Represents a conversation model.
type GoogleCloudDialogflowV2ConversationModel struct {
	// ArticleSuggestionModelMetadata: Metadata for article suggestion models.
	ArticleSuggestionModelMetadata *GoogleCloudDialogflowV2ArticleSuggestionModelMetadata `json:"articleSuggestionModelMetadata,omitempty"`
	// CreateTime: Output only. Creation time of this model.
	CreateTime string `json:"createTime,omitempty"`
	// Datasets: Required. Datasets used to create model.
	Datasets []*GoogleCloudDialogflowV2InputDataset `json:"datasets,omitempty"`
	// DisplayName: Required. The display name of the model. At most 64 bytes long.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: Language code for the conversation model. If not specified,
	// the language is en-US. Language at ConversationModel should be set for all
	// non en-us languages. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: ConversationModel resource name. Format:
	// `projects//conversationModels/`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. A read only boolean field reflecting Zone
	// Isolation status of the model.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. A read only boolean field reflecting Zone
	// Separation status of the model.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SmartReplyModelMetadata: Metadata for smart reply models.
	SmartReplyModelMetadata *GoogleCloudDialogflowV2SmartReplyModelMetadata `json:"smartReplyModelMetadata,omitempty"`
	// State: Output only. State of the model. A model can only serve prediction
	// requests after it gets deployed.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should not be used, an un-set enum has this value by
	// default.
	//   "CREATING" - Model being created.
	//   "UNDEPLOYED" - Model is not deployed but ready to deploy.
	//   "DEPLOYING" - Model is deploying.
	//   "DEPLOYED" - Model is deployed and ready to use.
	//   "UNDEPLOYING" - Model is undeploying.
	//   "DELETING" - Model is deleting.
	//   "FAILED" - Model is in error state. Not ready to deploy and use.
	//   "PENDING" - Model is being created but the training has not started, The
	// model may remain in this state until there is enough capacity to start
	// training.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ArticleSuggestionModelMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionModelMetadata")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata: Metadata
// for CreateConversationDataset.
type GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata struct {
	// ConversationDataset: The resource name of the conversation dataset that will
	// be created. Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata:
// Metadata for a ConversationModels.CreateConversationModelEvaluation
// operation.
type GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//locations//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// ConversationModelEvaluation: The resource name of the conversation model.
	// Format: `projects//locations//conversationModels//evaluations/`
	ConversationModelEvaluation string `json:"conversationModelEvaluation,omitempty"`
	// CreateTime: Timestamp when the request to create conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// State: State of CreateConversationModel operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Operation status not specified.
	//   "INITIALIZING" - The operation is being prepared.
	//   "RUNNING" - The operation is running.
	//   "CANCELLED" - The operation is cancelled.
	//   "SUCCEEDED" - The operation has succeeded.
	//   "FAILED" - The operation has failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationModelOperationMetadata: Metadata
// for a ConversationModels.CreateConversationModel operation.
type GoogleCloudDialogflowV2CreateConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when the request to create conversation model is
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// State: State of CreateConversationModel operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid.
	//   "PENDING" - Request is submitted, but training has not started yet. The
	// model may remain in this state until there is enough capacity to start
	// training.
	//   "SUCCEEDED" - The training has succeeded.
	//   "FAILED" - The training has succeeded.
	//   "CANCELLED" - The training has been cancelled.
	//   "CANCELLING" - The training is in cancelling state.
	//   "TRAINING" - Custom model is training.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata: Metadata
// for DeleteConversationDataset.
type GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata struct {
}

// GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata: Metadata
// for a ConversationModels.DeleteConversationModel operation.
type GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when delete conversation model request was created.
	// The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2DeployConversationModelOperationMetadata: Metadata
// for a ConversationModels.DeployConversationModel operation.
type GoogleCloudDialogflowV2DeployConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when request to deploy conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EncryptionSpec: A customer-managed encryption key
// specification that can be applied to all created resources (e.g.
// Conversation).
type GoogleCloudDialogflowV2EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by the default Google encryption key. Only the key in the same
	// location as this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityType: Each intent parameter has a type, called
// the entity type, which dictates exactly how data from an end-user expression
// is extracted. Dialogflow provides predefined system entities that can match
// many common types of data. For example, there are system entities for
// matching dates, times, colors, email addresses, and so on. You can also
// create your own custom entities for matching custom data. For example, you
// could define a vegetable entity that can match the types of vegetables
// available for purchase with a grocery store agent. For more information, see
// the Entity guide
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowV2EntityType struct {
	// AutoExpansionMode: Optional. Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values that
	// have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`
	// DisplayName: Required. The name of the entity type.
	DisplayName string `json:"displayName,omitempty"`
	// EnableFuzzyExtraction: Optional. Enables fuzzy entity extraction during
	// classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`
	// Entities: Optional. The collection of entity entries associated with the
	// entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms to a
	// reference value.
	//   "KIND_LIST" - List entity types contain a set of entries that do not map
	// to reference values. However, list entity types can contain references to
	// other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular expressions
	// in entries values.
	Kind string `json:"kind,omitempty"`
	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes methods.
	// Format: `projects//agent/entityTypes/`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityTypeEntity: An **entity entry** for an
// associated entity type.
type GoogleCloudDialogflowV2EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if the
	// entity type is *vegetable*, and `value` is *scallions*, a synonym could be
	// *green onions*. For `KIND_LIST` entity types: * This collection must contain
	// exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`
	// Value: Required. The primary value associated with this entity entry. For
	// example, if the entity type is *vegetable*, the value could be *scallions*.
	// For `KIND_MAP` entity types: * A reference value to be used in place of
	// synonyms. For `KIND_LIST` entity types: * A string that can contain
	// references to other entity types (with or without aliases).
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EventInput: Events allow for matching intents by
// event name instead of the natural language input. For instance, input “ can
// trigger a personalized welcome response. The parameter `name` may be used by
// the agent in the response: "Hello #welcome_event.name! What can I do for
// you today?".
type GoogleCloudDialogflowV2EventInput struct {
	// LanguageCode: Required. The language of this query. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language. This field is
	// ignored when used in the context of a WebhookResponse.followup_event_input
	// field, because the language was already defined in the originating detect
	// intent request.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Required. The unique identifier of the event.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the event.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowV2ExportAgentResponse struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated only if `agent_uri` is specified in `ExportAgentRequest`.
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ExportOperationMetadata: Metadata related to the
// Export Data Operations (e.g. ExportDocument).
type GoogleCloudDialogflowV2ExportOperationMetadata struct {
	// ExportedGcsDestination: Cloud Storage file path of the exported data.
	ExportedGcsDestination *GoogleCloudDialogflowV2GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2FaqAnswer: Represents answer from "frequently asked
// questions".
type GoogleCloudDialogflowV2FaqAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The system's confidence score that this Knowledge answer is a
	// good match for this conversational query, range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects//locations//agent/knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2FreeFormSuggestion: Suggestion generated using free
// form generator.
type GoogleCloudDialogflowV2FreeFormSuggestion struct {
	// Response: Required. Free form suggestion.
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GcsDestination: Google Cloud Storage location for the
// output.
type GoogleCloudDialogflowV2GcsDestination struct {
	// Uri: The Google Cloud Storage URIs for the output. A URI is of the form:
	// `gs://bucket/object-prefix-or-name` Whether a prefix or name is used depends
	// on the use case. The requesting user must have "write-permission" to the
	// bucket.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GenerateSuggestionsResponse: The response message for
// Conversations.GenerateSuggestions.
type GoogleCloudDialogflowV2GenerateSuggestionsResponse struct {
	// GeneratorSuggestionAnswers: The answers generated for the conversation based
	// on context.
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	// LatestMessage: The name of the latest conversation message used as context
	// for compiling suggestion. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer:
// A GeneratorSuggestion answer.
type GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	// AnswerRecord: Answer record that uniquely identifies the suggestion. This
	// can be used to provide suggestion feedback.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// GeneratorSuggestion: Suggestion details.
	GeneratorSuggestion *GoogleCloudDialogflowV2GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	// SourceGenerator: The name of the generator used to generate this suggestion.
	// Format: `projects//locations//generators/`.
	SourceGenerator string `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GeneratorSuggestion: Suggestion generated using a
// Generator.
type GoogleCloudDialogflowV2GeneratorSuggestion struct {
	// AgentCoachingSuggestion: Optional. Suggestion to coach the agent.
	AgentCoachingSuggestion *GoogleCloudDialogflowV2AgentCoachingSuggestion `json:"agentCoachingSuggestion,omitempty"`
	// FreeFormSuggestion: Optional. Free form suggestion.
	FreeFormSuggestion *GoogleCloudDialogflowV2FreeFormSuggestion `json:"freeFormSuggestion,omitempty"`
	// SummarySuggestion: Optional. Suggested summary.
	SummarySuggestion *GoogleCloudDialogflowV2SummarySuggestion `json:"summarySuggestion,omitempty"`
	// ToolCallInfo: Optional. List of request and response for tool calls
	// executed.
	ToolCallInfo []*GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo: Request and response
// for a tool call.
type GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo struct {
	// ToolCall: Required. Request for a tool call.
	ToolCall *GoogleCloudDialogflowV2ToolCall `json:"toolCall,omitempty"`
	// ToolCallResult: Required. Response for a tool call.
	ToolCallResult *GoogleCloudDialogflowV2ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2HumanAgentAssistantEvent: Represents a notification
// sent to Cloud Pub/Sub subscribers for human agent assistant events in a
// specific conversation.
type GoogleCloudDialogflowV2HumanAgentAssistantEvent struct {
	// Conversation: The conversation this notification refers to. Format:
	// `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// Participant: The participant that the suggestion is compiled for. Format:
	// `projects//conversations//participants/`. It will not be set in legacy
	// workflow.
	Participant string `json:"participant,omitempty"`
	// SuggestionResults: The suggestion results payload that this notification
	// refers to.
	SuggestionResults []*GoogleCloudDialogflowV2SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportConversationDataOperationMetadata: Metadata for
// a ConversationDatasets.ImportConversationData operation.
type GoogleCloudDialogflowV2ImportConversationDataOperationMetadata struct {
	// ConversationDataset: The resource name of the imported conversation dataset.
	// Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// CreateTime: Timestamp when import conversation data request was created. The
	// time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// PartialFailures: Partial failures are failures that don't fail the whole
	// long running operation, e.g. single files that couldn't be read.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportConversationDataOperationResponse: Response
// used for ConversationDatasets.ImportConversationData long running operation.
type GoogleCloudDialogflowV2ImportConversationDataOperationResponse struct {
	// ConversationDataset: The resource name of the imported conversation dataset.
	// Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ImportCount: Number of conversations imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportDocumentsResponse: Response message for
// Documents.ImportDocuments.
type GoogleCloudDialogflowV2ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata: Metadata for
// initializing a location-level encryption specification.
type GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata struct {
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudDialogflowV2InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InitializeEncryptionSpecRequest: The request to
// initialize a location-level encryption specification.
type GoogleCloudDialogflowV2InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the kms_key_name is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudDialogflowV2EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InputDataset: InputDataset used to create model or do
// evaluation. NextID:5
type GoogleCloudDialogflowV2InputDataset struct {
	// Dataset: Required. ConversationDataset resource name. Format:
	// `projects//locations//conversationDatasets/`
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Intent: An intent categorizes an end-user's intention
// for one conversation turn. For each agent, you define many intents, where
// your combined intents can handle a complete conversation. When an end-user
// writes or says something, referred to as an end-user expression or end-user
// input, Dialogflow matches the end-user input to the best intent in your
// agent. Matching an intent is also known as intent classification. For more
// information, see the intent guide
// (https://cloud.google.com/dialogflow/docs/intents-overview).
type GoogleCloudDialogflowV2Intent struct {
	// Action: Optional. The name of the action associated with the intent. Note:
	// The action name must not contain whitespaces.
	Action string `json:"action,omitempty"`
	// DefaultResponsePlatforms: Optional. The list of platforms for which the
	// first responses will be copied from the messages in PLATFORM_UNSPECIFIED
	// (i.e. default platform).
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	DefaultResponsePlatforms []string `json:"defaultResponsePlatforms,omitempty"`
	// DisplayName: Required. The name of this intent.
	DisplayName string `json:"displayName,omitempty"`
	// EndInteraction: Optional. Indicates that this intent ends an interaction.
	// Some integrations (e.g., Actions on Google or Dialogflow phone gateway) use
	// this information to close interaction with an end user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`
	// Events: Optional. The collection of event names that trigger the intent. If
	// the collection of input contexts is not empty, all of the contexts must be
	// present in the active user session for an event to trigger this intent.
	// Event names are limited to 150 characters.
	Events []string `json:"events,omitempty"`
	// FollowupIntentInfo: Output only. Read-only. Information about all followup
	// intents that have this intent as a direct or indirect parent. We populate
	// this field only in the output.
	FollowupIntentInfo []*GoogleCloudDialogflowV2IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	// InputContextNames: Optional. The list of context names required for this
	// intent to be triggered. Format: `projects//agent/sessions/-/contexts/`.
	InputContextNames []string `json:"inputContextNames,omitempty"`
	// IsFallback: Optional. Indicates whether this is a fallback intent.
	IsFallback bool `json:"isFallback,omitempty"`
	// LiveAgentHandoff: Optional. Indicates that a live agent should be brought in
	// to handle the interaction with the user. In most cases, when you set this
	// flag to true, you would also want to set end_interaction to true as well.
	// Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`
	// Messages: Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*GoogleCloudDialogflowV2IntentMessage `json:"messages,omitempty"`
	// MlDisabled: Optional. Indicates whether Machine Learning is disabled for the
	// intent. Note: If `ml_disabled` setting is set to true, then this intent is
	// not taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `json:"mlDisabled,omitempty"`
	// Name: Optional. The unique identifier of this intent. Required for
	// Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
	// `projects//agent/intents/`.
	Name string `json:"name,omitempty"`
	// OutputContexts: Optional. The collection of contexts that are activated when
	// the intent is matched. Context messages in this collection should not set
	// the parameters field. Setting the `lifespan_count` to 0 will reset the
	// context when the intent is matched. Format:
	// `projects//agent/sessions/-/contexts/`.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`
	// Parameters: Optional. The collection of parameters associated with the
	// intent.
	Parameters []*GoogleCloudDialogflowV2IntentParameter `json:"parameters,omitempty"`
	// ParentFollowupIntentName: Read-only after creation. The unique identifier of
	// the parent intent in the chain of followup intents. You can set this field
	// when creating an intent, for example with CreateIntent or
	// BatchUpdateIntents, in order to make this intent a followup intent. It
	// identifies the parent followup intent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// Priority: Optional. The priority of this intent. Higher numbers represent
	// higher priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// ResetContexts: Optional. Indicates whether to delete all contexts in the
	// current session when this intent is matched.
	ResetContexts bool `json:"resetContexts,omitempty"`
	// RootFollowupIntentName: Output only. Read-only. The unique identifier of the
	// root intent in the chain of followup intents. It identifies the correct
	// followup intents chain for this intent. We populate this field only in the
	// output. Format: `projects//agent/intents/`.
	RootFollowupIntentName string `json:"rootFollowupIntentName,omitempty"`
	// TrainingPhrases: Optional. The collection of examples that the agent is
	// trained on.
	TrainingPhrases []*GoogleCloudDialogflowV2IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// WebhookState: Optional. Indicates whether webhooks are enabled for the
	// intent.
	//
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED" - Webhook is disabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED" - Webhook is enabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING" - Webhook is enabled in the agent
	// and in the intent. Also, each slot filling prompt is forwarded to the
	// webhook.
	WebhookState string `json:"webhookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentFollowupIntentInfo: Represents a single
// followup intent in the chain.
type GoogleCloudDialogflowV2IntentFollowupIntentInfo struct {
	// FollowupIntentName: The unique identifier of the followup intent. Format:
	// `projects//agent/intents/`.
	FollowupIntentName string `json:"followupIntentName,omitempty"`
	// ParentFollowupIntentName: The unique identifier of the followup intent's
	// parent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessage: A rich response message. Corresponds
// to the intent `Response` field in the Dialogflow console. For more
// information, see Rich response messages
// (https://cloud.google.com/dialogflow/docs/intents-rich-messages).
type GoogleCloudDialogflowV2IntentMessage struct {
	// BasicCard: The basic card response for Actions on Google.
	BasicCard *GoogleCloudDialogflowV2IntentMessageBasicCard `json:"basicCard,omitempty"`
	// BrowseCarouselCard: Browse carousel card for Actions on Google.
	BrowseCarouselCard *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	// Card: The card response.
	Card *GoogleCloudDialogflowV2IntentMessageCard `json:"card,omitempty"`
	// CarouselSelect: The carousel card response for Actions on Google.
	CarouselSelect *GoogleCloudDialogflowV2IntentMessageCarouselSelect `json:"carouselSelect,omitempty"`
	// Image: The image response.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// LinkOutSuggestion: The link out suggestion chip for Actions on Google.
	LinkOutSuggestion *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion `json:"linkOutSuggestion,omitempty"`
	// ListSelect: The list card response for Actions on Google.
	ListSelect *GoogleCloudDialogflowV2IntentMessageListSelect `json:"listSelect,omitempty"`
	// MediaContent: The media content card for Actions on Google.
	MediaContent *GoogleCloudDialogflowV2IntentMessageMediaContent `json:"mediaContent,omitempty"`
	// Payload: A custom platform-specific response.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Platform: Optional. The platform that this message is intended for.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	Platform string `json:"platform,omitempty"`
	// QuickReplies: The quick replies response.
	QuickReplies *GoogleCloudDialogflowV2IntentMessageQuickReplies `json:"quickReplies,omitempty"`
	// SimpleResponses: The voice and text-only responses for Actions on Google.
	SimpleResponses *GoogleCloudDialogflowV2IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`
	// Suggestions: The suggestion chips for Actions on Google.
	Suggestions *GoogleCloudDialogflowV2IntentMessageSuggestions `json:"suggestions,omitempty"`
	// TableCard: Table card for Actions on Google.
	TableCard *GoogleCloudDialogflowV2IntentMessageTableCard `json:"tableCard,omitempty"`
	// Text: The text response.
	Text *GoogleCloudDialogflowV2IntentMessageText `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCard: The basic card message.
// Useful for displaying information.
type GoogleCloudDialogflowV2IntentMessageBasicCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// FormattedText: Required, unless image is present. The body text of the card.
	FormattedText string `json:"formattedText,omitempty"`
	// Image: Optional. The image for the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButton: The button object that
// appears at the bottom of a card.
type GoogleCloudDialogflowV2IntentMessageBasicCardButton struct {
	// OpenUriAction: Required. Action to take when a user taps on the button.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	// Title: Required. The title of the button.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction: Opens the
// given URI.
type GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction struct {
	// Uri: Required. The HTTP or HTTPS scheme URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard: Browse Carousel Card
// for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard struct {
	// ImageDisplayOptions: Optional. Settings for displaying the image. Applies to
	// every image in items.
	//
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED" - Fill the gaps between the image and
	// the image container with gray bars.
	//   "GRAY" - Fill the gaps between the image and the image container with gray
	// bars.
	//   "WHITE" - Fill the gaps between the image and the image container with
	// white bars.
	//   "CROPPED" - Image is scaled such that the image width and height match or
	// exceed the container dimensions. This may crop the top and bottom of the
	// image if the scaled image height is greater than the container height, or
	// crop the left and right of the image if the scaled image width is greater
	// than the container width. This is similar to "Zoom Mode" on a widescreen TV
	// when playing a 4:3 video.
	//   "BLURRED_BACKGROUND" - Pad the gaps between image and image frame with a
	// blurred copy of the same image.
	ImageDisplayOptions string `json:"imageDisplayOptions,omitempty"`
	// Items: Required. List of items in the Browse Carousel Card. Minimum of two
	// items, maximum of ten.
	Items []*GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem:
//
//	Browsing carousel tile
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	// Description: Optional. Description of the carousel item. Maximum of four
	// lines of text.
	Description string `json:"description,omitempty"`
	// Footer: Optional. Text that appears at the bottom of the Browse Carousel
	// Card. Maximum of one line of text.
	Footer string `json:"footer,omitempty"`
	// Image: Optional. Hero image for the carousel item.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// OpenUriAction: Required. Action to present to the user.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	// Title: Required. Title of the carousel item. Maximum of two lines of text.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemO
// penUrlAction: Actions on Google action to open a given url.
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	// Url: Required. URL
	Url string `json:"url,omitempty"`
	// UrlTypeHint: Optional. Specifies the type of viewer that is used when
	// opening the URL. Defaults to opening via web browser.
	//
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED" - Unspecified
	//   "AMP_ACTION" - Url would be an amp action
	//   "AMP_CONTENT" - URL that points directly to AMP content, or to a canonical
	// URL which refers to AMP content via .
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCard: The card response message.
type GoogleCloudDialogflowV2IntentMessageCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageCardButton `json:"buttons,omitempty"`
	// ImageUri: Optional. The public URI to an image file for the card.
	ImageUri string `json:"imageUri,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCardButton: Contains information about a
// button.
type GoogleCloudDialogflowV2IntentMessageCardButton struct {
	// Postback: Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback string `json:"postback,omitempty"`
	// Text: Optional. The text to show on the button.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelect: The card for presenting
// a carousel of options to select from.
type GoogleCloudDialogflowV2IntentMessageCarouselSelect struct {
	// Items: Required. Carousel items.
	Items []*GoogleCloudDialogflowV2IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelectItem: An item in the
// carousel.
type GoogleCloudDialogflowV2IntentMessageCarouselSelectItem struct {
	// Description: Optional. The body text of the card.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional info about the option item.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. Title of the carousel item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageColumnProperties: Column properties for
// TableCard.
type GoogleCloudDialogflowV2IntentMessageColumnProperties struct {
	// Header: Required. Column heading.
	Header string `json:"header,omitempty"`
	// HorizontalAlignment: Optional. Defines text alignment for all cells in this
	// column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Text is aligned to the leading edge
	// of the column.
	//   "LEADING" - Text is aligned to the leading edge of the column.
	//   "CENTER" - Text is centered in the column.
	//   "TRAILING" - Text is aligned to the trailing edge of the column.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageImage: The image response message.
type GoogleCloudDialogflowV2IntentMessageImage struct {
	// AccessibilityText: Optional. A text description of the image to be used for
	// accessibility, e.g., screen readers.
	AccessibilityText string `json:"accessibilityText,omitempty"`
	// ImageUri: Optional. The public URI to an image file.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion: The suggestion chip
// message that allows the user to jump out to the app or website associated
// with this agent.
type GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion struct {
	// DestinationName: Required. The name of the app or site this chip is linking
	// to.
	DestinationName string `json:"destinationName,omitempty"`
	// Uri: Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelect: The card for presenting a
// list of options to select from.
type GoogleCloudDialogflowV2IntentMessageListSelect struct {
	// Items: Required. List items.
	Items []*GoogleCloudDialogflowV2IntentMessageListSelectItem `json:"items,omitempty"`
	// Subtitle: Optional. Subtitle of the list.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The overall title of the list.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelectItem: An item in the list.
type GoogleCloudDialogflowV2IntentMessageListSelectItem struct {
	// Description: Optional. The main text describing the item.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional information about this option.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. The title of the list item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContent: The media content card for
// Actions on Google.
type GoogleCloudDialogflowV2IntentMessageMediaContent struct {
	// MediaObjects: Required. List of media objects.
	MediaObjects []*GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// MediaType: Optional. What type of media is the content (ie "audio").
	//
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED" - Unspecified.
	//   "AUDIO" - Response media type is audio.
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject:
// Response media object for media content card.
type GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject struct {
	// ContentUrl: Required. Url where the media is stored.
	ContentUrl string `json:"contentUrl,omitempty"`
	// Description: Optional. Description of media card.
	Description string `json:"description,omitempty"`
	// Icon: Optional. Icon to display above media content.
	Icon *GoogleCloudDialogflowV2IntentMessageImage `json:"icon,omitempty"`
	// LargeImage: Optional. Image to display above media content.
	LargeImage *GoogleCloudDialogflowV2IntentMessageImage `json:"largeImage,omitempty"`
	// Name: Required. Name of media card.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageQuickReplies: The quick replies response
// message.
type GoogleCloudDialogflowV2IntentMessageQuickReplies struct {
	// QuickReplies: Optional. The collection of quick replies.
	QuickReplies []string `json:"quickReplies,omitempty"`
	// Title: Optional. The title of the collection of quick replies.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSelectItemInfo: Additional info about
// the select item for when it is triggered in a dialog.
type GoogleCloudDialogflowV2IntentMessageSelectItemInfo struct {
	// Key: Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `json:"key,omitempty"`
	// Synonyms: Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponse: The simple response
// message containing speech or text.
type GoogleCloudDialogflowV2IntentMessageSimpleResponse struct {
	// DisplayText: Optional. The text to display.
	DisplayText string `json:"displayText,omitempty"`
	// Ssml: One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `json:"ssml,omitempty"`
	// TextToSpeech: One of text_to_speech or ssml must be provided. The plain text
	// of the speech output. Mutually exclusive with ssml.
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponses: The collection of
// simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type GoogleCloudDialogflowV2IntentMessageSimpleResponses struct {
	// SimpleResponses: Required. The list of simple responses.
	SimpleResponses []*GoogleCloudDialogflowV2IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestion: The suggestion chip message
// that the user can tap to quickly post a reply to the conversation.
type GoogleCloudDialogflowV2IntentMessageSuggestion struct {
	// Title: Required. The text shown the in the suggestion chip.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestions: The collection of
// suggestions.
type GoogleCloudDialogflowV2IntentMessageSuggestions struct {
	// Suggestions: Required. The list of suggested replies.
	Suggestions []*GoogleCloudDialogflowV2IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCard: Table card for Actions on
// Google.
type GoogleCloudDialogflowV2IntentMessageTableCard struct {
	// Buttons: Optional. List of buttons for the card.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// ColumnProperties: Optional. Display properties for the columns in this
	// table.
	ColumnProperties []*GoogleCloudDialogflowV2IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	// Image: Optional. Image which should be displayed on the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Rows: Optional. Rows in this table of data.
	Rows []*GoogleCloudDialogflowV2IntentMessageTableCardRow `json:"rows,omitempty"`
	// Subtitle: Optional. Subtitle to the title.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Required. Title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardCell: Cell of TableCardRow.
type GoogleCloudDialogflowV2IntentMessageTableCardCell struct {
	// Text: Required. Text in this cell.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardRow: Row of TableCard.
type GoogleCloudDialogflowV2IntentMessageTableCardRow struct {
	// Cells: Optional. List of cells that make up this row.
	Cells []*GoogleCloudDialogflowV2IntentMessageTableCardCell `json:"cells,omitempty"`
	// DividerAfter: Optional. Whether to add a visual divider after this row.
	DividerAfter bool `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageText: The text response message.
type GoogleCloudDialogflowV2IntentMessageText struct {
	// Text: Optional. The collection of the agent's responses.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentParameter: Represents intent parameters.
type GoogleCloudDialogflowV2IntentParameter struct {
	// DefaultValue: Optional. The default value to use when the `value` yields an
	// empty result. Default values can be extracted from contexts by using the
	// following syntax: `#context_name.parameter_name`.
	DefaultValue string `json:"defaultValue,omitempty"`
	// DisplayName: Required. The name of the parameter.
	DisplayName string `json:"displayName,omitempty"`
	// EntityTypeDisplayName: Optional. The name of the entity type, prefixed with
	// `@`, that describes values of the parameter. If the parameter is required,
	// this must be provided.
	EntityTypeDisplayName string `json:"entityTypeDisplayName,omitempty"`
	// IsList: Optional. Indicates whether the parameter represents a list of
	// values.
	IsList bool `json:"isList,omitempty"`
	// Mandatory: Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `json:"mandatory,omitempty"`
	// Name: The unique identifier of this parameter.
	Name string `json:"name,omitempty"`
	// Prompts: Optional. The collection of prompts that the agent can present to
	// the user in order to collect a value for the parameter.
	Prompts []string `json:"prompts,omitempty"`
	// Value: Optional. The definition of the parameter value. It can be: - a
	// constant string, - a parameter value defined as `$parameter_name`, - an
	// original parameter value defined as `$parameter_name.original`, - a
	// parameter value from some context defined as `#context_name.parameter_name`.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrase: Represents an example that the
// agent is trained on.
type GoogleCloudDialogflowV2IntentTrainingPhrase struct {
	// Name: Output only. The unique identifier of this training phrase.
	Name string `json:"name,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `entity_type`, `alias`, and
	// `user_defined` fields are all set.
	Parts []*GoogleCloudDialogflowV2IntentTrainingPhrasePart `json:"parts,omitempty"`
	// TimesAddedCount: Optional. Indicates how many times this example was added
	// to the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount int64 `json:"timesAddedCount,omitempty"`
	// Type: Required. The type of the training phrase.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be used.
	//   "EXAMPLE" - Examples do not contain @-prefixed entity type names, but
	// example parts can be annotated with entity types.
	//   "TEMPLATE" - Templates are not annotated with entity types, but they can
	// contain @-prefixed entity type names as substrings. Template mode has been
	// deprecated. Example mode is the only supported way to create new training
	// phrases. If you have existing training phrases that you've created in
	// template mode, those will continue to work.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrasePart: Represents a part of a
// training phrase.
type GoogleCloudDialogflowV2IntentTrainingPhrasePart struct {
	// Alias: Optional. The parameter name for the value extracted from the
	// annotated part of the example. This field is required for annotated parts of
	// the training phrase.
	Alias string `json:"alias,omitempty"`
	// EntityType: Optional. The entity type name prefixed with `@`. This field is
	// required for annotated parts of the training phrase.
	EntityType string `json:"entityType,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// UserDefined: Optional. Indicates whether the text was manually annotated.
	// This field is set to true when the Dialogflow Console is used to manually
	// annotate the part. When creating an annotated part with the API, you must
	// set this to true.
	UserDefined bool `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswer: Represents a Knowledge Assist
// answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswer struct {
	// AnswerRecord: The name of the answer record. Format:
	// `projects//locations//answer Records/`.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SuggestedQuery: The query suggested based on the context. Suggestion is made
	// only if it is different from the previous suggestion.
	SuggestedQuery *GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery `json:"suggestedQuery,omitempty"`
	// SuggestedQueryAnswer: The answer generated for the suggested query. Whether
	// or not an answer is generated depends on how confident we are about the
	// generated query.
	SuggestedQueryAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer: Represents an
// answer from Knowledge. Currently supports FAQ and Generative answers.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer struct {
	// AnswerText: The piece of text from the `source` that answers this suggested
	// query.
	AnswerText string `json:"answerText,omitempty"`
	// FaqSource: Populated if the prediction came from FAQ.
	FaqSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource `json:"faqSource,omitempty"`
	// GenerativeSource: Populated if the prediction was Generative.
	GenerativeSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource:
// Details about source of FAQ answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource:
// Details about source of Generative answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	// Snippets: All snippets used for this Generative Prediction, with their
	// source URI and data.
	Snippets []*GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSn
// ippet: Snippet Source for a Generative Prediction.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	// Metadata: Metadata of the document.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Text: Text taken from that URI.
	Text string `json:"text,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: URI the data is sourced from.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery: Represents a
// suggested query.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery struct {
	// QueryText: Suggested query text.
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeOperationMetadata: Metadata in
// google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV2KnowledgeOperationMetadata struct {
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ExportOperationMetadata: Metadata for the Export Data Operation such as the
	// destination of export.
	ExportOperationMetadata *GoogleCloudDialogflowV2ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	// KnowledgeBase: The name of the knowledge base interacted with during the
	// operation.
	KnowledgeBase string `json:"knowledgeBase,omitempty"`
	// State: Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Message: Represents a message posted into a
// conversation.
type GoogleCloudDialogflowV2Message struct {
	// Content: Required. The message content.
	Content string `json:"content,omitempty"`
	// CreateTime: Output only. The time when the message was created in Contact
	// Center AI.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: Optional. The message language. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageAnnotation: Output only. The annotation for the message.
	MessageAnnotation *GoogleCloudDialogflowV2MessageAnnotation `json:"messageAnnotation,omitempty"`
	// Name: Optional. The unique identifier of the message. Format:
	// `projects//locations//conversations//messages/`.
	Name string `json:"name,omitempty"`
	// Participant: Output only. The participant that sends this message.
	Participant string `json:"participant,omitempty"`
	// ParticipantRole: Output only. The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SendTime: Optional. The time when the message was sent. For voice messages,
	// this is the time when an utterance started.
	SendTime string `json:"sendTime,omitempty"`
	// SentimentAnalysis: Output only. The sentiment analysis result for the
	// message.
	SentimentAnalysis *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2MessageAnnotation: Represents the result of
// annotation for the message.
type GoogleCloudDialogflowV2MessageAnnotation struct {
	// ContainEntities: Indicates whether the text message contains entities.
	ContainEntities bool `json:"containEntities,omitempty"`
	// Parts: The collection of annotated message parts ordered by their position
	// in the message. You can recover the annotated message by concatenating
	// [AnnotatedMessagePart.text].
	Parts []*GoogleCloudDialogflowV2AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2OriginalDetectIntentRequest: Represents the contents
// of the original request that was passed to the `[Streaming]DetectIntent`
// call.
type GoogleCloudDialogflowV2OriginalDetectIntentRequest struct {
	// Payload: Optional. This field is set to the value of the
	// `QueryParameters.payload` field passed in the request. Some integrations
	// that query a Dialogflow agent may provide additional information in the
	// payload. In particular, for the Dialogflow Phone Gateway integration, this
	// field has the form: { "telephony": { "caller_id": "+18558363987" } } Note:
	// The caller ID field (`caller_id`) will be redacted for Trial Edition agents
	// and populated with the caller ID in E.164 format
	// (https://en.wikipedia.org/wiki/E.164) for Essentials Edition agents.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Source: The source of this request, e.g., `google`, `facebook`, `slack`. It
	// is set by Dialogflow-owned servers.
	Source string `json:"source,omitempty"`
	// Version: Optional. The version of the protocol used for this request. This
	// field is AoG-specific.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2QueryResult: Represents the result of conversational
// query or event processing.
type GoogleCloudDialogflowV2QueryResult struct {
	// Action: The action name from the matched intent.
	Action string `json:"action,omitempty"`
	// AllRequiredParamsPresent: This field is set to: - `false` if the matched
	// intent has required parameters and not all of the required parameter values
	// have been collected. - `true` if all required parameter values have been
	// collected, or if the matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `json:"allRequiredParamsPresent,omitempty"`
	// CancelsSlotFilling: Indicates whether the conversational query triggers a
	// cancellation for slot filling. For more information, see the cancel slot
	// filling documentation
	// (https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
	CancelsSlotFilling bool `json:"cancelsSlotFilling,omitempty"`
	// DiagnosticInfo: Free-form diagnostic information for the associated detect
	// intent request. The fields of this data can change without notice, so you
	// should not write code that depends on its structure. The data may contain: -
	// webhook call latency - webhook errors
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// FulfillmentMessages: The collection of rich messages to present to the user.
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage `json:"fulfillmentMessages,omitempty"`
	// FulfillmentText: The text to be pronounced to the user or shown on the
	// screen. Note: This is a legacy field, `fulfillment_messages` should be
	// preferred.
	FulfillmentText string `json:"fulfillmentText,omitempty"`
	// Intent: The intent that matched the conversational query. Some, not all
	// fields are filled in this message, including but not limited to: `name`,
	// `display_name`, `end_interaction` and `is_fallback`.
	Intent *GoogleCloudDialogflowV2Intent `json:"intent,omitempty"`
	// IntentDetectionConfidence: The intent detection confidence. Values range
	// from 0.0 (completely uncertain) to 1.0 (completely certain). This value is
	// for informational purpose only and is only used to help match the best
	// intent within the classification threshold. This value may change for the
	// same end-user expression at any time due to a model retraining or change in
	// implementation. If there are `multiple knowledge_answers` messages, this
	// value is set to the greatest `knowledgeAnswers.match_confidence` value in
	// the list.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`
	// LanguageCode: The language that was triggered during intent detection. See
	// Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`
	// OutputContexts: The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name `.original`
	// containing the original parameter values before the query.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`
	// Parameters: The collection of extracted parameters. Depending on your
	// protocol or client library language, this is a map, associative array,
	// symbol table, dictionary, or JSON object composed of a collection of
	// (MapKey, MapValue) pairs: * MapKey type: string * MapKey value: parameter
	// name * MapValue type: If parameter's entity type is a composite entity then
	// use map, otherwise, depending on the parameter value type, it could be one
	// of string, number, boolean, null, list or map. * MapValue value: If
	// parameter's entity type is a composite entity then use map from composite
	// entity property names to property values, otherwise, use parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// QueryText: The original conversational query text: - If natural language
	// text was provided as input, `query_text` contains a copy of the input. - If
	// natural language speech audio was provided as input, `query_text` contains
	// the speech recognition result. If speech recognizer produced multiple
	// alternatives, a particular one is picked. - If automatic spell correction is
	// enabled, `query_text` will contain the corrected user input.
	QueryText string `json:"queryText,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SpeechRecognitionConfidence: The Speech recognition confidence between 0.0
	// and 1.0. A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set. This field is not guaranteed to be
	// accurate or set. In particular this field isn't set for
	// StreamingDetectIntent since the streaming endpoint has separate confidence
	// estimates per portion of the audio in StreamingRecognitionResult.
	SpeechRecognitionConfidence float64 `json:"speechRecognitionConfidence,omitempty"`
	// WebhookPayload: If the query was fulfilled by a webhook call, this field is
	// set to the value of the `payload` field returned in the webhook response.
	WebhookPayload googleapi.RawMessage `json:"webhookPayload,omitempty"`
	// WebhookSource: If the query was fulfilled by a webhook call, this field is
	// set to the value of the `source` field returned in the webhook response.
	WebhookSource string `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

// GoogleCloudDialogflowV2Sentiment: The sentiment, such as positive/negative
// feeling or association, for a unit of analysis, such as the query text. See:
// https://cloud.google.com/natural-language/docs/basics#interpreting_sentiment_analysis_values
// for how to interpret the result.
type GoogleCloudDialogflowV2Sentiment struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowV2SentimentAnalysisResult: The result of sentiment
// analysis. Sentiment analysis inspects user input and identifies the
// prevailing subjective opinion, especially to determine a user's attitude as
// positive, negative, or neutral. For DetectIntent, it needs to be configured
// in DetectIntentRequest.query_params. For StreamingDetectIntent, it needs to
// be configured in StreamingDetectIntentRequest.query_params. And for
// Participants.AnalyzeContent and Participants.StreamingAnalyzeContent, it
// needs to be configured in ConversationProfile.human_agent_assistant_config
type GoogleCloudDialogflowV2SentimentAnalysisResult struct {
	// QueryTextSentiment: The sentiment analysis result for `query_text`.
	QueryTextSentiment *GoogleCloudDialogflowV2Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SessionEntityType: A session represents a
// conversation between a Dialogflow agent and an end-user. You can create
// special entities, called session entities, during a session. Session
// entities can extend or replace custom entity types and only exist during the
// session that they were created for. All session data, including session
// entities, is stored by Dialogflow for 20 minutes. For more information, see
// the session entity guide
// (https://cloud.google.com/dialogflow/docs/entities-session).
type GoogleCloudDialogflowV2SessionEntityType struct {
	// Entities: Required. The collection of entities associated with this session
	// entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// EntityOverrideMode: Required. Indicates whether the additional data should
	// override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value should be
	// never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session entities
	// overrides the collection of entities in the corresponding custom entity
	// type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session entities
	// extends the collection of entities in the corresponding custom entity type.
	// Note: Even in this override mode calls to `ListSessionEntityTypes`,
	// `GetSessionEntityType`, `CreateSessionEntityType` and
	// `UpdateSessionEntityType` only return the additional entities added in this
	// session entity type. If you want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	// Name: Required. The unique identifier of this session entity type. Format:
	// `projects//agent/sessions//entityTypes/`, or
	// `projects//agent/environments//users//sessions//entityTypes/`. If
	// `Environment ID` is not specified, we assume default 'draft' environment. If
	// `User ID` is not specified, we assume default '-' user. `` must be the
	// display name of an existing entity type in the same agent that will be
	// overridden or supplemented.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata: Metadata
// for a ConversationProfiles.SetSuggestionFeatureConfig operation.
type GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata struct {
	// ConversationProfile: The resource name of the conversation profile. Format:
	// `projects//locations//conversationProfiles/`
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// CreateTime: Timestamp whe the request was created. The time is measured on
	// server side.
	CreateTime string `json:"createTime,omitempty"`
	// ParticipantRole: Required. The participant role to add or update the
	// suggestion feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to add
	// or update.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model for chat.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SmartReplyAnswer: Represents a smart reply answer.
type GoogleCloudDialogflowV2SmartReplyAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: Smart reply confidence. The system's confidence score that this
	// reply is a good match for this conversation, as a value from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2SmartReplyModelMetadata: Metadata for smart reply
// models.
type GoogleCloudDialogflowV2SmartReplyModelMetadata struct {
	// TrainingModelType: Optional. Type of the smart reply model. If not provided,
	// model_type is used.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - ModelType unspecified.
	//   "SMART_REPLY_DUAL_ENCODER_MODEL" - ModelType smart reply dual encoder
	// model.
	//   "SMART_REPLY_BERT_MODEL" - ModelType smart reply bert model.
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SpeechWordInfo: Information for a word recognized by
// the speech recognizer.
type GoogleCloudDialogflowV2SpeechWordInfo struct {
	// Confidence: The Speech confidence between 0.0 and 1.0 for this word. A
	// higher number indicates an estimated greater likelihood that the recognized
	// word is correct. The default of 0.0 is a sentinel value indicating that
	// confidence was not set. This field is not guaranteed to be fully stable over
	// time for the same audio input. Users should also not rely on it to always be
	// provided.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset relative to the beginning of the audio that
	// corresponds to the end of the spoken word. This is an experimental feature
	// and the accuracy of the time offset can vary.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset relative to the beginning of the audio that
	// corresponds to the start of the spoken word. This is an experimental feature
	// and the accuracy of the time offset can vary.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word this info is for.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2StreamingRecognitionResult: Contains a speech
// recognition result corresponding to a portion of the audio that is currently
// being processed or an indication that this is the end of the single
// requested utterance. While end-user audio is being processed, Dialogflow
// sends a series of results. Each result may contain a `transcript` value. A
// transcript represents a portion of the utterance. While the recognizer is
// processing audio, transcript values may be interim values or finalized
// values. Once a transcript is finalized, the `is_final` value is set to true
// and processing continues for the next transcript. If
// `StreamingDetectIntentRequest.query_input.audio_config.single_utterance` was
// true, and the recognizer has completed processing audio, the `message_type`
// value is set to `END_OF_SINGLE_UTTERANCE and the following (last) result
// contains the last finalized transcript. The complete end-user utterance is
// determined by concatenating the finalized transcript values received for the
// series of results. In the following example, single utterance is enabled. In
// the case where single utterance is not enabled, result 7 would not occur.
// ``` Num | transcript | message_type | is_final --- | -----------------------
// | ----------------------- | -------- 1 | "tube" | TRANSCRIPT | false 2 | "to
// be a" | TRANSCRIPT | false 3 | "to be" | TRANSCRIPT | false 4 | "to be or
// not to be" | TRANSCRIPT | true 5 | "that's" | TRANSCRIPT | false 6 | "that
// is | TRANSCRIPT | false 7 | unset | END_OF_SINGLE_UTTERANCE | unset 8 | "
// that is the question" | TRANSCRIPT | true ``` Concatenating the finalized
// transcripts with `is_final` set to true, the complete utterance becomes "to
// be or not to be that is the question".
type GoogleCloudDialogflowV2StreamingRecognitionResult struct {
	// Confidence: The Speech confidence between 0.0 and 1.0 for the current
	// portion of audio. A higher number indicates an estimated greater likelihood
	// that the recognized words are correct. The default of 0.0 is a sentinel
	// value indicating that confidence was not set. This field is typically only
	// provided if `is_final` is true and you should not rely on it being accurate
	// or even set.
	Confidence float64 `json:"confidence,omitempty"`
	// IsFinal: If `false`, the `StreamingRecognitionResult` represents an interim
	// result that may change. If `true`, the recognizer will not return any
	// further hypotheses about this piece of the audio. May only be populated for
	// `message_type` = `TRANSCRIPT`.
	IsFinal bool `json:"isFinal,omitempty"`
	// LanguageCode: Detected language code for the transcript.
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageType: Type of the result message.
	//
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED" - Not specified. Should never be used.
	//   "TRANSCRIPT" - Message contains a (possibly partial) transcript.
	//   "END_OF_SINGLE_UTTERANCE" - This event indicates that the server has
	// detected the end of the user's speech utterance and expects no additional
	// inputs. Therefore, the server will not process additional audio (although it
	// may subsequently return additional results). The client should stop sending
	// additional audio data, half-close the gRPC connection, and wait for any
	// additional results until the server closes the gRPC connection. This message
	// is only sent if `single_utterance` was set to `true`, and is not used
	// otherwise.
	MessageType string `json:"messageType,omitempty"`
	// SpeechEndOffset: Time offset of the end of this Speech recognition result
	// relative to the beginning of the audio. Only populated for `message_type` =
	// `TRANSCRIPT`.
	SpeechEndOffset string `json:"speechEndOffset,omitempty"`
	// SpeechWordInfo: Word-specific information for the words recognized by Speech
	// in transcript. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*GoogleCloudDialogflowV2SpeechWordInfo `json:"speechWordInfo,omitempty"`
	// Transcript: Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2SuggestArticlesResponse: The response message for
// Participants.SuggestArticles.
type GoogleCloudDialogflowV2SuggestArticlesResponse struct {
	// ArticleAnswers: Articles ordered by score in descending order.
	ArticleAnswers []*GoogleCloudDialogflowV2ArticleAnswer `json:"articleAnswers,omitempty"`
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestArticlesRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestFaqAnswersResponse: The request message for
// Participants.SuggestFaqAnswers.
type GoogleCloudDialogflowV2SuggestFaqAnswersResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestFaqAnswersRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// FaqAnswers: Answers extracted from FAQ documents.
	FaqAnswers []*GoogleCloudDialogflowV2FaqAnswer `json:"faqAnswers,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse: The response message
// for Participants.SuggestKnowledgeAssist.
type GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestKnowledgeAssistRequest.context_size field in the request if there are
	// fewer messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// KnowledgeAssistAnswer: Output only. Knowledge Assist suggestion.
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestSmartRepliesResponse: The response message for
// Participants.SuggestSmartReplies.
type GoogleCloudDialogflowV2SuggestSmartRepliesResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestSmartRepliesRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// SmartReplyAnswers: Output only. Multiple reply options provided by smart
	// reply service. The order is based on the rank of the model prediction. The
	// maximum number of the returned replies is set in SmartReplyConfig.
	SmartReplyAnswers []*GoogleCloudDialogflowV2SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestionResult: One response of different type of
// suggestion response which is used in the response of
// Participants.AnalyzeContent and Participants.AnalyzeContent, as well as
// HumanAgentAssistantEvent.
type GoogleCloudDialogflowV2SuggestionResult struct {
	// Error: Error status if the request failed.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// GenerateSuggestionsResponse: Suggestions generated using generators
	// triggered by customer or agent messages.
	GenerateSuggestionsResponse *GoogleCloudDialogflowV2GenerateSuggestionsResponse `json:"generateSuggestionsResponse,omitempty"`
	// SuggestArticlesResponse: SuggestArticlesResponse if request is for
	// ARTICLE_SUGGESTION.
	SuggestArticlesResponse *GoogleCloudDialogflowV2SuggestArticlesResponse `json:"suggestArticlesResponse,omitempty"`
	// SuggestFaqAnswersResponse: SuggestFaqAnswersResponse if request is for
	// FAQ_ANSWER.
	SuggestFaqAnswersResponse *GoogleCloudDialogflowV2SuggestFaqAnswersResponse `json:"suggestFaqAnswersResponse,omitempty"`
	// SuggestKnowledgeAssistResponse: SuggestKnowledgeAssistResponse if request is
	// for KNOWLEDGE_ASSIST.
	SuggestKnowledgeAssistResponse *GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse `json:"suggestKnowledgeAssistResponse,omitempty"`
	// SuggestSmartRepliesResponse: SuggestSmartRepliesResponse if request is for
	// SMART_REPLY.
	SuggestSmartRepliesResponse *GoogleCloudDialogflowV2SuggestSmartRepliesResponse `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SummarySuggestion: Suggested summary of the
// conversation.
type GoogleCloudDialogflowV2SummarySuggestion struct {
	// SummarySections: Required. All the parts of generated summary.
	SummarySections []*GoogleCloudDialogflowV2SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SummarySuggestionSummarySection: A component of the
// generated summary.
type GoogleCloudDialogflowV2SummarySuggestionSummarySection struct {
	// Section: Required. Name of the section.
	Section string `json:"section,omitempty"`
	// Summary: Required. Summary text for the section.
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCall: Represents a call of a specific tool's
// action with the specified inputs.
type GoogleCloudDialogflowV2ToolCall struct {
	// Action: Optional. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// AnswerRecord: Optional. The answer record associated with this tool call.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// CreateTime: Output only. Create time of the tool call.
	CreateTime string `json:"createTime,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// State: Output only. State of the tool call.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "TRIGGERED" - The tool call has been triggered.
	//   "NEEDS_CONFIRMATION" - The tool call requires confirmation from a human.
	State string `json:"state,omitempty"`
	// Tool: Optional. The tool associated with this call. Format:
	// `projects//locations//tools/`.
	Tool string `json:"tool,omitempty"`
	// ToolDisplayDetails: Optional. A human readable description of the tool.
	ToolDisplayDetails string `json:"toolDisplayDetails,omitempty"`
	// ToolDisplayName: Optional. A human readable short name of the tool, to be
	// shown on the UI.
	ToolDisplayName string `json:"toolDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCallResult: The result of calling a tool's
// action.
type GoogleCloudDialogflowV2ToolCallResult struct {
	// Action: Optional. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// AnswerRecord: Optional. The answer record associated with this tool call
	// result.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Content: Only populated if the response content is utf-8 encoded.
	Content string `json:"content,omitempty"`
	// CreateTime: Output only. Create time of the tool call result.
	CreateTime string `json:"createTime,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowV2ToolCallResultError `json:"error,omitempty"`
	// RawContent: Only populated if the response content is not utf-8 encoded. (by
	// definition byte fields are base64 encoded).
	RawContent string `json:"rawContent,omitempty"`
	// Tool: Optional. The tool associated with this call. Format:
	// `projects//locations//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCallResultError: An error produced by the tool
// call.
type GoogleCloudDialogflowV2ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata: Metadata
// for a ConversationModels.UndeployConversationModel operation.
type GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when the request to undeploy conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2WebhookRequest: The request message for a webhook
// call.
type GoogleCloudDialogflowV2WebhookRequest struct {
	// OriginalDetectIntentRequest: Optional. The contents of the original request
	// that was passed to `[Streaming]DetectIntent` call.
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`
	// QueryResult: The result of the conversational query or event processing.
	// Contains the same value as `[Streaming]DetectIntentResponse.query_result`.
	QueryResult *GoogleCloudDialogflowV2QueryResult `json:"queryResult,omitempty"`
	// ResponseId: The unique identifier of the response. Contains the same value
	// as `[Streaming]DetectIntentResponse.response_id`.
	ResponseId string `json:"responseId,omitempty"`
	// Session: The unique identifier of detectIntent request session. Can be used
	// to identify end-user inside webhook implementation. Format:
	// `projects//agent/sessions/`, or
	// `projects//agent/environments//users//sessions/`.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "OriginalDetectIntentRequest") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalDetectIntentRequest") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2WebhookResponse: The response message for a webhook
// call. This response is validated by the Dialogflow server. If validation
// fails, an error will be returned in the QueryResult.diagnostic_info field.
// Setting JSON fields to an empty value with the wrong type is a common error.
// To avoid this error: - Use "" for empty strings - Use `{}` or `null` for
// empty objects - Use `[]` or `null` for empty arrays For more information,
// see the Protocol Buffers Language Guide
// (https://developers.google.com/protocol-buffers/docs/proto3#json).
type GoogleCloudDialogflowV2WebhookResponse struct {
	// FollowupEventInput: Optional. Invokes the supplied events. When this field
	// is set, Dialogflow ignores the `fulfillment_text`, `fulfillment_messages`,
	// and `payload` fields.
	FollowupEventInput *GoogleCloudDialogflowV2EventInput `json:"followupEventInput,omitempty"`
	// FulfillmentMessages: Optional. The rich response messages intended for the
	// end-user. When provided, Dialogflow uses this field to populate
	// QueryResult.fulfillment_messages sent to the integration or API caller.
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage `json:"fulfillmentMessages,omitempty"`
	// FulfillmentText: Optional. The text response message intended for the
	// end-user. It is recommended to use `fulfillment_messages.text.text[0]`
	// instead. When provided, Dialogflow uses this field to populate
	// QueryResult.fulfillment_text sent to the integration or API caller.
	FulfillmentText string `json:"fulfillmentText,omitempty"`
	// OutputContexts: Optional. The collection of output contexts that will
	// overwrite currently active contexts for the session and reset their
	// lifespans. When provided, Dialogflow uses this field to populate
	// QueryResult.output_contexts sent to the integration or API caller.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`
	// Payload: Optional. This field can be used to pass custom data from your
	// webhook to the integration or API caller. Arbitrary JSON objects are
	// supported. When provided, Dialogflow uses this field to populate
	// QueryResult.webhook_payload sent to the integration or API caller. This
	// field is also used by the Google Assistant integration
	// (https://cloud.google.com/dialogflow/docs/integrations/aog) for rich
	// response messages. See the format definition at Google Assistant Dialogflow
	// webhook format
	// (https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SessionEntityTypes: Optional. Additional session entity types to replace or
	// extend developer entity types with. The entity synonyms apply to all
	// languages and persist for the session. Setting this data from a webhook
	// overwrites the session entity types that have been set using `detectIntent`,
	// `streamingDetectIntent` or SessionEntityType management methods.
	SessionEntityTypes []*GoogleCloudDialogflowV2SessionEntityType `json:"sessionEntityTypes,omitempty"`
	// Source: Optional. A custom field used to identify the webhook source.
	// Arbitrary strings are supported. When provided, Dialogflow uses this field
	// to populate QueryResult.webhook_source sent to the integration or API
	// caller.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupEventInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupEventInput") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Agent: A Dialogflow agent is a virtual agent
// that handles conversations with your end-users. It is a natural language
// understanding module that understands the nuances of human language.
// Dialogflow translates end-user text or audio during a conversation to
// structured data that your apps and services can understand. You design and
// build a Dialogflow agent to handle the types of conversations required for
// your system. For more information about agents, see the Agent guide
// (https://cloud.google.com/dialogflow/docs/agents-overview).
type GoogleCloudDialogflowV2beta1Agent struct {
	// ApiVersion: Optional. API version displayed in Dialogflow console. If not
	// specified, V2 API is assumed. Clients are free to query different service
	// endpoints for different API versions. However, bots connectors and webhook
	// calls will follow the specified API version.
	//
	// Possible values:
	//   "API_VERSION_UNSPECIFIED" - Not specified.
	//   "API_VERSION_V1" - Legacy V1 API.
	//   "API_VERSION_V2" - V2 API.
	//   "API_VERSION_V2_BETA_1" - V2beta1 API.
	ApiVersion string `json:"apiVersion,omitempty"`
	// AvatarUri: Optional. The URI of the agent's avatar. Avatars are used
	// throughout the Dialogflow console and in the self-hosted Web Demo
	// (https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `json:"avatarUri,omitempty"`
	// ClassificationThreshold: Optional. To filter out false positive results and
	// still get variety in matched natural language inputs for your agent, you can
	// tune the machine learning classification threshold. If the returned score
	// value is less than the threshold value, then a fallback intent will be
	// triggered or, if there are no fallback intents defined, no intent will be
	// triggered. The score values range from 0.0 (completely uncertain) to 1.0
	// (completely certain). If set to 0.0, the default of 0.3 is used.
	ClassificationThreshold float64 `json:"classificationThreshold,omitempty"`
	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes. This field cannot be set by the
	// `Update` method.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Description: Optional. The description of this agent. The maximum length is
	// 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The name of this agent.
	DisplayName string `json:"displayName,omitempty"`
	// EnableLogging: Optional. Determines whether this agent should log
	// conversation queries.
	EnableLogging bool `json:"enableLogging,omitempty"`
	// MatchMode: Optional. Determines how intents are detected from user queries.
	//
	// Possible values:
	//   "MATCH_MODE_UNSPECIFIED" - Not specified.
	//   "MATCH_MODE_HYBRID" - Best for agents with a small number of examples in
	// intents and/or wide use of templates syntax and composite entities.
	//   "MATCH_MODE_ML_ONLY" - Can be used for agents with a large number of
	// examples in intents, especially the ones using @sys.any or very large custom
	// entities.
	MatchMode string `json:"matchMode,omitempty"`
	// Parent: Required. The project of this agent. Format: `projects/` or
	// `projects//locations/`
	Parent string `json:"parent,omitempty"`
	// SupportedLanguageCodes: Optional. The list of all languages supported by
	// this agent (except for the `default_language_code`).
	SupportedLanguageCodes []string `json:"supportedLanguageCodes,omitempty"`
	// Tier: Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
	//
	// Possible values:
	//   "TIER_UNSPECIFIED" - Not specified. This value should never be used.
	//   "TIER_STANDARD" - Trial Edition, previously known as Standard Edition.
	//   "TIER_ENTERPRISE" - Essentials Edition, previously known as Enterprise
	// Essential Edition.
	//   "TIER_ENTERPRISE_PLUS" - Essentials Edition (same as TIER_ENTERPRISE),
	// previously known as Enterprise Plus Edition.
	Tier string `json:"tier,omitempty"`
	// TimeZone: Required. The time zone of this agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Agent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Agent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1Agent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1Agent
	var s1 struct {
		ClassificationThreshold gensupport.JSONFloat64 `json:"classificationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClassificationThreshold = float64(s1.ClassificationThreshold)
	return nil
}

// GoogleCloudDialogflowV2beta1AgentAssistantFeedback: Detail feedback of Agent
// Assistant result.
type GoogleCloudDialogflowV2beta1AgentAssistantFeedback struct {
	// AnswerRelevance: Optional. Whether or not the suggested answer is relevant.
	// For example: * Query: "Can I change my mailing address?" * Suggested
	// document says: "Items must be returned/exchanged within 60 days of the
	// purchase date." * answer_relevance: AnswerRelevance.IRRELEVANT
	//
	// Possible values:
	//   "ANSWER_RELEVANCE_UNSPECIFIED" - Answer relevance unspecified.
	//   "IRRELEVANT" - Answer is irrelevant to query.
	//   "RELEVANT" - Answer is relevant to query.
	AnswerRelevance string `json:"answerRelevance,omitempty"`
	// DocumentCorrectness: Optional. Whether or not the information in the
	// document is correct. For example: * Query: "Can I return the package in 2
	// days once received?" * Suggested document says: "Items must be
	// returned/exchanged within 60 days of the purchase date." * Ground truth: "No
	// return or exchange is allowed." * document_correctness: INCORRECT
	//
	// Possible values:
	//   "DOCUMENT_CORRECTNESS_UNSPECIFIED" - Document correctness unspecified.
	//   "INCORRECT" - Information in document is incorrect.
	//   "CORRECT" - Information in document is correct.
	DocumentCorrectness string `json:"documentCorrectness,omitempty"`
	// DocumentEfficiency: Optional. Whether or not the suggested document is
	// efficient. For example, if the document is poorly written, hard to
	// understand, hard to use or too long to find useful information,
	// document_efficiency is DocumentEfficiency.INEFFICIENT.
	//
	// Possible values:
	//   "DOCUMENT_EFFICIENCY_UNSPECIFIED" - Document efficiency unspecified.
	//   "INEFFICIENT" - Document is inefficient.
	//   "EFFICIENT" - Document is efficient.
	DocumentEfficiency string `json:"documentEfficiency,omitempty"`
	// KnowledgeAssistFeedback: Optional. Feedback for knowledge assist.
	KnowledgeAssistFeedback *GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback `json:"knowledgeAssistFeedback,omitempty"`
	// KnowledgeSearchFeedback: Optional. Feedback for knowledge search.
	KnowledgeSearchFeedback *GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback `json:"knowledgeSearchFeedback,omitempty"`
	// SummarizationFeedback: Feedback for conversation summarization.
	SummarizationFeedback *GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback `json:"summarizationFeedback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRelevance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRelevance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentAssistantFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentAssistantFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback:
// Feedback for knowledge assist.
type GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback struct {
	// AnswerCopied: Whether the suggested answer was copied by the human agent. If
	// the value is set to be true, AnswerFeedback.clicked will be updated to be
	// true.
	AnswerCopied bool `json:"answerCopied,omitempty"`
	// ClickedUris: The URIs clicked by the human agent. The value is appended for
	// each UpdateAnswerRecordRequest. If the value is not empty,
	// AnswerFeedback.clicked will be updated to be true.
	ClickedUris []string `json:"clickedUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCopied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCopied") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback:
// Feedback for knowledge search.
type GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback struct {
	// AnswerCopied: Whether the answer was copied by the human agent or not. If
	// the value is set to be true, AnswerFeedback.clicked will be updated to be
	// true.
	AnswerCopied bool `json:"answerCopied,omitempty"`
	// ClickedUris: The URIs clicked by the human agent. The value is appended for
	// each UpdateAnswerRecordRequest. If the value is not empty,
	// AnswerFeedback.clicked will be updated to be true.
	ClickedUris []string `json:"clickedUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerCopied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerCopied") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback:
// Feedback for conversation summarization.
type GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback struct {
	// StartTimestamp: Timestamp when composing of the summary starts.
	StartTimestamp string `json:"startTimestamp,omitempty"`
	// SubmitTimestamp: Timestamp when the summary was submitted.
	SubmitTimestamp string `json:"submitTimestamp,omitempty"`
	// SummaryText: Text of actual submitted summary.
	SummaryText string `json:"summaryText,omitempty"`
	// TextSections: Optional. Actual text sections of submitted summary.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTimestamp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentAssistantRecord: Represents a record of a
// human agent assistant answer.
type GoogleCloudDialogflowV2beta1AgentAssistantRecord struct {
	// ArticleSuggestionAnswer: Output only. The article suggestion answer.
	ArticleSuggestionAnswer *GoogleCloudDialogflowV2beta1ArticleAnswer `json:"articleSuggestionAnswer,omitempty"`
	// DialogflowAssistAnswer: Output only. The Dialogflow assist answer.
	DialogflowAssistAnswer *GoogleCloudDialogflowV2beta1DialogflowAssistAnswer `json:"dialogflowAssistAnswer,omitempty"`
	// FaqAnswer: Output only. The FAQ answer.
	FaqAnswer *GoogleCloudDialogflowV2beta1FaqAnswer `json:"faqAnswer,omitempty"`
	// GeneratorSuggestion: Output only. The generator suggestion.
	GeneratorSuggestion *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleSuggestionAnswer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionAnswer") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentAssistantRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentAssistantRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingContext: Agent Coaching context
// that customer can configure.
type GoogleCloudDialogflowV2beta1AgentCoachingContext struct {
	// Instructions: Optional. Customized instructions for agent coaching.
	Instructions []*GoogleCloudDialogflowV2beta1AgentCoachingInstruction `json:"instructions,omitempty"`
	// OutputLanguageCode: Optional. Output language code.
	OutputLanguageCode string `json:"outputLanguageCode,omitempty"`
	// OverarchingGuidance: Optional. The overarching guidance for the agent
	// coaching. This should be set only for v1.5 and later versions.
	OverarchingGuidance string `json:"overarchingGuidance,omitempty"`
	// Version: Optional. Version of the feature. If not set, default to latest
	// version. Current candidates are ["2.5"].
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instructions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instructions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingInstruction: Agent Coaching
// instructions that customer can configure.
type GoogleCloudDialogflowV2beta1AgentCoachingInstruction struct {
	// AgentAction: Optional. The action that human agent should take. For example,
	// "apologize for the slow shipping". If the users only want to use agent
	// coaching for intent detection, agent_action can be empty
	AgentAction string `json:"agentAction,omitempty"`
	// Condition: Optional. The condition of the instruction. For example, "the
	// customer wants to cancel an order". If the users want the instruction to be
	// triggered unconditionally, the condition can be empty.
	Condition string `json:"condition,omitempty"`
	// DisplayDetails: Optional. The detailed description of this instruction.
	DisplayDetails string `json:"displayDetails,omitempty"`
	// DisplayName: Optional. Display name for the instruction.
	DisplayName string `json:"displayName,omitempty"`
	// DuplicateCheckResult: Output only. Duplication check for the
	// AgentCoachingInstruction.
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// SystemAction: Optional. The action that system should take. For example,
	// "call GetOrderTime with order_number={order number provided by the
	// customer}". If the users don't have plugins or don't want to trigger
	// plugins, the system_action can be empty
	SystemAction string `json:"systemAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult:
// Duplication check for the suggestion.
type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult struct {
	// DuplicateSuggestions: Output only. The duplicate suggestions.
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDupli
// cateSuggestion: The duplicate suggestion details.
type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	// AnswerRecord: Output only. The answer record id of the past duplicate
	// suggestion.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SimilarityScore: Output only. The similarity score of between the past and
	// current suggestion.
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	// SuggestionIndex: Output only. The index of the duplicate suggestion in the
	// past suggestion list.
	SuggestionIndex int64 `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestion: Suggestion for coaching
// agents.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestion struct {
	// AgentActionSuggestions: Optional. Suggested actions for the agent to take.
	AgentActionSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	// ApplicableInstructions: Optional. Instructions applicable based on the
	// current context.
	ApplicableInstructions []*GoogleCloudDialogflowV2beta1AgentCoachingInstruction `json:"applicableInstructions,omitempty"`
	// SampleResponses: Optional. Sample response for the Agent.
	SampleResponses []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion:
// Actions suggested for the agent. This is based on applicable instructions.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion struct {
	// AgentAction: Optional. The suggested action for the agent.
	AgentAction string `json:"agentAction,omitempty"`
	// DuplicateCheckResult: Output only. Duplicate check result for the agent
	// action suggestion.
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// Sources: Output only. Sources for the agent action suggestion.
	Sources *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult:
// Duplication check for the suggestion.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult struct {
	// DuplicateSuggestions: Output only. The duplicate suggestions.
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplic
// ateSuggestion: The duplicate suggestion details. Keeping answer_record and
// sources together as they are identifiers for duplicate suggestions.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	// AnswerRecord: Output only. The answer record id of the past duplicate
	// suggestion.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SimilarityScore: Output only. The similarity score of between the past and
	// current suggestion.
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	// Sources: Output only. Sources for the suggestion.
	Sources *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// SuggestionIndex: Output only. The index of the duplicate suggestion in the
	// past suggestion list.
	SuggestionIndex int64 `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse: Sample
// response that the agent can use. This could be based on applicable
// instructions and ingested data from other systems.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse struct {
	// DuplicateCheckResult: Output only. Duplicate check result for the sample
	// response.
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	// ResponseText: Optional. Sample response for Agent in text.
	ResponseText string `json:"responseText,omitempty"`
	// Sources: Output only. Sources for the Sample Response.
	Sources *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources: Sources for the
// suggestion.
type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources struct {
	// InstructionIndexes: Output only. Source instruction indexes for the
	// suggestion. This is the index of the applicable_instructions field.
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnalyzeContentRequest: The request message for
// Participants.AnalyzeContent.
type GoogleCloudDialogflowV2beta1AnalyzeContentRequest struct {
	// AssistQueryParams: Parameters for a human assist query.
	AssistQueryParams *GoogleCloudDialogflowV2beta1AssistQueryParameters `json:"assistQueryParams,omitempty"`
	// AudioInput: The natural language speech audio to be processed.
	AudioInput *GoogleCloudDialogflowV2beta1AudioInput `json:"audioInput,omitempty"`
	// CxCurrentPage: The unique identifier of the Dialogflow CX page to override
	// the `current_page` in the session. Format:
	// `projects//locations//agents//flows//pages/`. If `cx_current_page` is
	// specified, the previous state of the session will be ignored by Dialogflow
	// CX, including the previous page and the previous session parameters. In most
	// cases, `cx_current_page` and `cx_parameters` should be configured together
	// to direct a session to a specific state. Note: this field should only be
	// used if you are connecting to a Dialogflow CX agent.
	CxCurrentPage string `json:"cxCurrentPage,omitempty"`
	// CxParameters: Additional parameters to be put into Dialogflow CX session
	// parameters. To remove a parameter from the session, clients should
	// explicitly set the parameter value to null. Note: this field should only be
	// used if you are connecting to a Dialogflow CX agent.
	CxParameters googleapi.RawMessage `json:"cxParameters,omitempty"`
	// EventInput: An input event to send to Dialogflow.
	EventInput *GoogleCloudDialogflowV2beta1EventInput `json:"eventInput,omitempty"`
	// IntentInput: The intent to be triggered on V3 agent.
	IntentInput *GoogleCloudDialogflowV2beta1IntentInput `json:"intentInput,omitempty"`
	// MessageSendTime: Optional. The send time of the message from end user or
	// human agent's perspective. It is used for identifying the same message under
	// one participant. For BatchCreateMessages API only: Given two messages under
	// the same participant: * If send time are different regardless of whether the
	// content of the messages are exactly the same, the conversation will regard
	// them as two distinct messages sent by the participant. * If send time is the
	// same regardless of whether the content of the messages are exactly the same,
	// the conversation will regard them as same message, and ignore the message
	// received later. If the value is not provided, a new request will always be
	// regarded as a new message without any de-duplication.
	MessageSendTime string `json:"messageSendTime,omitempty"`
	// QueryParams: Parameters for a Dialogflow virtual-agent query.
	QueryParams *GoogleCloudDialogflowV2beta1QueryParameters `json:"queryParams,omitempty"`
	// ReplyAudioConfig: Speech synthesis configuration. The speech synthesis
	// settings for a virtual agent that may be configured for the associated
	// conversation profile are not used when calling AnalyzeContent. If this
	// configuration is not supplied, speech synthesis is disabled.
	ReplyAudioConfig *GoogleCloudDialogflowV2beta1OutputAudioConfig `json:"replyAudioConfig,omitempty"`
	// RequestId: A unique identifier for this request. Restricted to 36 ASCII
	// characters. A random UUID is recommended. This request is only idempotent if
	// a `request_id` is provided.
	RequestId string `json:"requestId,omitempty"`
	// SuggestionInput: An input representing the selection of a suggestion.
	SuggestionInput *GoogleCloudDialogflowV2beta1SuggestionInput `json:"suggestionInput,omitempty"`
	// TextInput: The natural language text to be processed.
	TextInput *GoogleCloudDialogflowV2beta1TextInput `json:"textInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssistQueryParams") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssistQueryParams") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnalyzeContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnalyzeContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnalyzeContentResponse: The response message for
// Participants.AnalyzeContent.
type GoogleCloudDialogflowV2beta1AnalyzeContentResponse struct {
	// AutomatedAgentReply: Optional. Only set if a Dialogflow automated agent has
	// responded. Note that:
	// AutomatedAgentReply.detect_intent_response.output_audio and
	// AutomatedAgentReply.detect_intent_response.output_audio_config are always
	// empty, use reply_audio instead.
	AutomatedAgentReply *GoogleCloudDialogflowV2beta1AutomatedAgentReply `json:"automatedAgentReply,omitempty"`
	// DtmfParameters: Indicates the parameters of DTMF.
	DtmfParameters *GoogleCloudDialogflowV2beta1DtmfParameters `json:"dtmfParameters,omitempty"`
	// EndUserSuggestionResults: The suggestions for end user. The order is the
	// same as HumanAgentAssistantConfig.SuggestionConfig.feature_configs of
	// HumanAgentAssistantConfig.end_user_suggestion_config. Same as
	// human_agent_suggestion_results, any failure of Agent Assist features will
	// not lead to the overall failure of an AnalyzeContent API call. Instead, the
	// features will fail silently with the error field set in the corresponding
	// SuggestionResult.
	EndUserSuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"endUserSuggestionResults,omitempty"`
	// HumanAgentSuggestionResults: The suggestions for most recent human agent.
	// The order is the same as
	// HumanAgentAssistantConfig.SuggestionConfig.feature_configs of
	// HumanAgentAssistantConfig.human_agent_suggestion_config. Note that any
	// failure of Agent Assist features will not lead to the overall failure of an
	// AnalyzeContent API call. Instead, the features will fail silently with the
	// error field set in the corresponding SuggestionResult.
	HumanAgentSuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"humanAgentSuggestionResults,omitempty"`
	// Message: Output only. Message analyzed by CCAI.
	Message *GoogleCloudDialogflowV2beta1Message `json:"message,omitempty"`
	// ReplyAudio: Optional. The audio data bytes encoded as specified in the
	// request. This field is set if: - `reply_audio_config` was specified in the
	// request, or - The automated agent responded with audio to play to the user.
	// In such case, `reply_audio.config` contains settings used to synthesize the
	// speech. In some scenarios, multiple output audio fields may be present in
	// the response structure. In these cases, only the top-most-level audio output
	// has content.
	ReplyAudio *GoogleCloudDialogflowV2beta1OutputAudio `json:"replyAudio,omitempty"`
	// ReplyText: Output only. The output text content. This field is set if the
	// automated agent responded with text to show to the user.
	ReplyText string `json:"replyText,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutomatedAgentReply") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomatedAgentReply") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnalyzeContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnalyzeContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnnotatedMessagePart: Represents a part of a
// message possibly annotated with an entity. The part can be an entity or
// purely a part of the message between two entities or message start/end.
type GoogleCloudDialogflowV2beta1AnnotatedMessagePart struct {
	// EntityType: Optional. The Dialogflow system entity type
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. If this is empty, Dialogflow could not annotate the phrase
	// part with a system entity.
	EntityType string `json:"entityType,omitempty"`
	// FormattedValue: Optional. The Dialogflow system entity formatted value
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. For example for a system entity of type `@sys.unit-currency`,
	// this may contain: { "amount": 5, "currency": "USD" }
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	// Text: Required. A part of a message possibly annotated with an entity.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnswerFeedback: Represents feedback the customer
// has about the quality & correctness of a certain answer in a conversation.
type GoogleCloudDialogflowV2beta1AnswerFeedback struct {
	// AgentAssistantDetailFeedback: Optional. Detail feedback of agent assistant
	// suggestions.
	AgentAssistantDetailFeedback *GoogleCloudDialogflowV2beta1AgentAssistantFeedback `json:"agentAssistantDetailFeedback,omitempty"`
	// ClickTime: Time when the answer/item was clicked.
	ClickTime string `json:"clickTime,omitempty"`
	// Clicked: Indicates whether the answer/item was clicked by the human agent or
	// not. Default to false. For knowledge search, the answer record is considered
	// to be clicked if the answer was copied or any URI was clicked.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of the specific answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// DisplayTime: Time when the answer/item was displayed.
	DisplayTime string `json:"displayTime,omitempty"`
	// Displayed: Indicates whether the answer/item was displayed to the human
	// agent in the agent desktop UI. Default to false.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AgentAssistantDetailFeedback") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistantDetailFeedback") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AnswerRecord: Answer records are records to
// manage answer history and feedbacks for Dialogflow. Currently, answer record
// includes: - human agent assistant article suggestion - human agent assistant
// faq article It doesn't include: - `DetectIntent` intent matching -
// `DetectIntent` knowledge Answer records are not related to the conversation
// history in the Dialogflow Console. A Record is generated even when the
// end-user disables conversation history in the console. Records are created
// when there's a human agent assistant suggestion generated. A typical
// workflow for customers provide feedback to an answer is: 1. For human agent
// assistant, customers get suggestion via ListSuggestions API. Together with
// the answers, AnswerRecord.name are returned to the customers. 2. The
// customer uses the AnswerRecord.name to call the UpdateAnswerRecord method to
// send feedback about a specific answer that they believe is wrong.
type GoogleCloudDialogflowV2beta1AnswerRecord struct {
	// AgentAssistantRecord: Output only. The record for human agent assistant.
	AgentAssistantRecord *GoogleCloudDialogflowV2beta1AgentAssistantRecord `json:"agentAssistantRecord,omitempty"`
	// AnswerFeedback: Optional. The AnswerFeedback for this record. You can set
	// this with AnswerRecords.UpdateAnswerRecord in order to give us feedback
	// about this answer.
	AnswerFeedback *GoogleCloudDialogflowV2beta1AnswerFeedback `json:"answerFeedback,omitempty"`
	// Name: The unique identifier of this answer record. Required for
	// AnswerRecords.UpdateAnswerRecord method. Format:
	// `projects//locations//answerRecords/`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentAssistantRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistantRecord") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnswerRecord) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnswerRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ArticleAnswer: Represents article answer.
type GoogleCloudDialogflowV2beta1ArticleAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Snippets: Output only. Article snippets.
	Snippets []string `json:"snippets,omitempty"`
	// Title: The article title.
	Title string `json:"title,omitempty"`
	// Uri: The article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AssistQueryParameters: Represents the parameters
// of human assist query.
type GoogleCloudDialogflowV2beta1AssistQueryParameters struct {
	// DocumentsMetadataFilters: Key-value filters on the metadata of documents
	// returned by article suggestion. If specified, article suggestion only
	// returns suggested documents that match all filters in their
	// Document.metadata. Multiple values for a metadata key should be concatenated
	// by comma. For example, filters to match all documents that have 'US' or 'CA'
	// in their market metadata values and 'agent' in their user metadata values
	// will be ``` documents_metadata_filters { key: "market" value: "US,CA" }
	// documents_metadata_filters { key: "user" value: "agent" } ```
	DocumentsMetadataFilters map[string]string `json:"documentsMetadataFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentsMetadataFilters")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentsMetadataFilters") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AssistQueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AssistQueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AudioInput: Represents the natural language
// speech audio to be processed.
type GoogleCloudDialogflowV2beta1AudioInput struct {
	// Audio: Required. The natural language speech audio to be processed. A single
	// request can contain up to 2 minutes of speech audio data. The transcribed
	// text cannot contain more than 256 bytes for virtual agent interactions.
	Audio string `json:"audio,omitempty"`
	// Config: Required. Instructs the speech recognizer how to process the speech
	// audio.
	Config *GoogleCloudDialogflowV2beta1InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AutomatedAgentConfig: Defines the Automated
// Agent to connect to a conversation.
type GoogleCloudDialogflowV2beta1AutomatedAgentConfig struct {
	// Agent: Required. ID of the Dialogflow agent environment to use. This project
	// needs to either be the same project as the conversation or you need to grant
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
	// Service Agent` role in this project. - For ES agents, use format:
	// `projects//locations//agent/environments/`. If environment is not specified,
	// the default `draft` environment is used. Refer to DetectIntentRequest
	// (/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2beta1#google.cloud.
	// dialogflow.v2beta1.DetectIntentRequest) for more details. - For CX agents,
	// use format `projects//locations//agents//environments/`. If environment is
	// not specified, the default `draft` environment is used.
	Agent string `json:"agent,omitempty"`
	// SessionTtl: Optional. Configure lifetime of the Dialogflow session. By
	// default, a Dialogflow CX session remains active and its data is stored for
	// 30 minutes after the last request is sent for the session. This value should
	// be no longer than 1 day.
	SessionTtl string `json:"sessionTtl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AutomatedAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AutomatedAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1AutomatedAgentReply: Represents a response from
// an automated agent.
type GoogleCloudDialogflowV2beta1AutomatedAgentReply struct {
	// AllowCancellation: Indicates whether the partial automated agent reply is
	// interruptible when a later reply message arrives. e.g. if the agent
	// specified some music as partial response, it can be cancelled.
	AllowCancellation bool `json:"allowCancellation,omitempty"`
	// AutomatedAgentReplyType: AutomatedAgentReply type.
	//
	// Possible values:
	//   "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED" - Not specified. This should
	// never happen.
	//   "PARTIAL" - Partial reply. e.g. Aggregated responses in a `Fulfillment`
	// that enables `return_partial_response` can be returned as partial reply.
	// WARNING: partial reply is not eligible for barge-in.
	//   "FINAL" - Final reply.
	AutomatedAgentReplyType string `json:"automatedAgentReplyType,omitempty"`
	// CallCompanionAuthCode: The auth code for accessing Call Companion UI.
	CallCompanionAuthCode string `json:"callCompanionAuthCode,omitempty"`
	// CxCurrentPage: The unique identifier of the current Dialogflow CX
	// conversation page. Format: `projects//locations//agents//flows//pages/`.
	CxCurrentPage string `json:"cxCurrentPage,omitempty"`
	// CxSessionParameters: The collection of current Dialogflow CX agent session
	// parameters at the time of this response. Deprecated: Use `parameters`
	// instead.
	CxSessionParameters googleapi.RawMessage `json:"cxSessionParameters,omitempty"`
	// DetectIntentResponse: Response of the Dialogflow Sessions.DetectIntent call.
	DetectIntentResponse *GoogleCloudDialogflowV2beta1DetectIntentResponse `json:"detectIntentResponse,omitempty"`
	// Event: Event name if an event is triggered for the query.
	Event string `json:"event,omitempty"`
	// Intent: Name of the intent if an intent is matched for the query. For a V2
	// query, the value format is `projects//locations/ /agent/intents/`. For a V3
	// query, the value format is `projects//locations/ /agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// MatchConfidence: The confidence of the match. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain). This value is for
	// informational purpose only and is only used to help match the best intent
	// within the classification threshold. This value may change for the same
	// end-user expression at any time due to a model retraining or change in
	// implementation.
	MatchConfidence float64 `json:"matchConfidence,omitempty"`
	// Parameters: The collection of current parameters at the time of this
	// response.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ResponseMessages: Response messages from the automated agent.
	ResponseMessages []*GoogleCloudDialogflowV2beta1ResponseMessage `json:"responseMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowCancellation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCancellation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AutomatedAgentReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AutomatedAgentReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AutomatedAgentReply) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AutomatedAgentReply
	var s1 struct {
		MatchConfidence gensupport.JSONFloat64 `json:"matchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchConfidence = float64(s1.MatchConfidence)
	return nil
}

// GoogleCloudDialogflowV2beta1BargeInConfig: Configuration of the barge-in
// behavior. Barge-in instructs the API to return a detected utterance at a
// proper time while the client is playing back the response audio from a
// previous request. When the client sees the utterance, it should stop the
// playback and immediately get ready for receiving the responses for the
// current request. The barge-in handling requires the client to start
// streaming audio input as soon as it starts playing back the audio from the
// previous response. The playback is modeled into two phases: * No barge-in
// phase: which goes first and during which speech detection should not be
// carried out. * Barge-in phase: which follows the no barge-in phase and
// during which the API starts speech detection and may inform the client that
// an utterance has been detected. Note that no-speech event is not expected in
// this phase. The client provides this configuration in terms of the durations
// of those two phases. The durations are measured in terms of the audio length
// from the start of the input audio. The flow goes like below: ``` --> Time
// without speech detection | utterance only | utterance or no-speech event | |
// +-------------+ | +------------+ | +---------------+ ----------+ no barge-in
// +-|-+ barge-in +-|-+ normal period +----------- +-------------+ |
// +------------+ | +---------------+ ``` No-speech event is a response with
// END_OF_UTTERANCE without any transcript following up.
type GoogleCloudDialogflowV2beta1BargeInConfig struct {
	// NoBargeInDuration: Duration that is not eligible for barge-in at the
	// beginning of the input audio.
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	// TotalDuration: Total duration for the playback at the beginning of the input
	// audio.
	TotalDuration string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest: The request message
// for EntityTypes.BatchCreateEntities.
type GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest struct {
	// Entities: Required. The entities to create.
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// LanguageCode: Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used. For more
	// information, see Multilingual intent and entity data
	// (https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest: The request message
// for Conversations.BatchCreateMessagesRequest.
type GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest struct {
	// Requests: Required. A maximum of 300 messages can be created in a batch.
	// CreateMessageRequest.message.send_time is required. All created messages
	// will have identical Message.create_time.
	Requests []*GoogleCloudDialogflowV2beta1CreateMessageRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse: The request message
// for Conversations.BatchCreateMessagesResponse.
type GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse struct {
	// Messages: Messages created.
	Messages []*GoogleCloudDialogflowV2beta1Message `json:"messages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest: The request message
// for EntityTypes.BatchDeleteEntities.
type GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest struct {
	// EntityValues: Required. The reference `values` of the entities to delete.
	// Note that these are not fully-qualified names, i.e. they don't start with
	// `projects/`.
	EntityValues []string `json:"entityValues,omitempty"`
	// LanguageCode: Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used. For more
	// information, see Multilingual intent and entity data
	// (https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest: The request
// message for EntityTypes.BatchDeleteEntityTypes.
type GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest struct {
	// EntityTypeNames: Required. The names entity types to delete. All names must
	// point to the same agent as `parent`.
	EntityTypeNames []string `json:"entityTypeNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeNames") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest: The request message
// for Intents.BatchDeleteIntents.
type GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest struct {
	// Intents: Required. The collection of intents to delete. Only intent `name`
	// must be filled in.
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest: The request message
// for EntityTypes.BatchUpdateEntities.
type GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest struct {
	// Entities: Required. The entities to update or create.
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// LanguageCode: Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used. For more
	// information, see Multilingual intent and entity data
	// (https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `json:"languageCode,omitempty"`
	// UpdateMask: Optional. The mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest: The request
// message for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest struct {
	// EntityTypeBatchInline: The collection of entity types to update or create.
	EntityTypeBatchInline *GoogleCloudDialogflowV2beta1EntityTypeBatch `json:"entityTypeBatchInline,omitempty"`
	// EntityTypeBatchUri: The URI to a Google Cloud Storage file containing entity
	// types to update or create. The file format can either be a serialized proto
	// (of EntityBatch type) or a JSON object. Note: The URI must start with
	// "gs://".
	EntityTypeBatchUri string `json:"entityTypeBatchUri,omitempty"`
	// LanguageCode: Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used. For more
	// information, see Multilingual intent and entity data
	// (https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `json:"languageCode,omitempty"`
	// UpdateMask: Optional. The mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeBatchInline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeBatchInline") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse: The response
// message for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse struct {
	// EntityTypes: The collection of updated or created entity types.
	EntityTypes []*GoogleCloudDialogflowV2beta1EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest: The request message
// for Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest struct {
	// IntentBatchInline: The collection of intents to update or create.
	IntentBatchInline *GoogleCloudDialogflowV2beta1IntentBatch `json:"intentBatchInline,omitempty"`
	// IntentBatchUri: The URI to a Google Cloud Storage file containing intents to
	// update or create. The file format can either be a serialized proto (of
	// IntentBatch type) or JSON object. Note: The URI must start with "gs://".
	IntentBatchUri string `json:"intentBatchUri,omitempty"`
	// IntentView: Optional. The resource view to apply to the returned intent.
	//
	// Possible values:
	//   "INTENT_VIEW_UNSPECIFIED" - Training phrases field is not populated in the
	// response.
	//   "INTENT_VIEW_FULL" - All fields are populated.
	IntentView string `json:"intentView,omitempty"`
	// LanguageCode: Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used. For more
	// information, see Multilingual intent and entity data
	// (https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `json:"languageCode,omitempty"`
	// UpdateMask: Optional. The mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentBatchInline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentBatchInline") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse: The response message
// for Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse struct {
	// Intents: The collection of updated or created intents.
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata:
// Metadata for a ConversationProfile.ClearSuggestionFeatureConfig operation.
type GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata struct {
	// ConversationProfile: The resource name of the conversation profile. Format:
	// `projects//locations//conversationProfiles/`
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// CreateTime: Timestamp whe the request was created. The time is measured on
	// server side.
	CreateTime string `json:"createTime,omitempty"`
	// ParticipantRole: Required. The participant role to remove the suggestion
	// feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to
	// remove.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "DIALOGFLOW_ASSIST" - Run Dialogflow assist model for chat, which will
	// return automated agent response as suggestion.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest: The request
// message for ConversationProfiles.ClearFeature.
type GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest struct {
	// ParticipantRole: Required. The participant role to remove the suggestion
	// feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to
	// remove.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "DIALOGFLOW_ASSIST" - Run Dialogflow assist model for chat, which will
	// return automated agent response as suggestion.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParticipantRole") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParticipantRole") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1CompileSuggestionRequest: The request message
// for Participants.CompileSuggestion.
type GoogleCloudDialogflowV2beta1CompileSuggestionRequest struct {
	// ContextSize: Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the suggestion. If zero or
	// less than zero, 20 is used.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: Optional. The name of the latest conversation message to
	// compile suggestion for. If empty, it will be the latest message of the
	// conversation. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1CompileSuggestionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1CompileSuggestionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1CompileSuggestionResponse: The response message
// for Participants.CompileSuggestion.
type GoogleCloudDialogflowV2beta1CompileSuggestionResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// CompileSuggestionRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// Suggestion: The compiled suggestion.
	Suggestion *GoogleCloudDialogflowV2beta1Suggestion `json:"suggestion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1CompileSuggestionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1CompileSuggestionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1CompleteConversationRequest: The request message
// for Conversations.CompleteConversation.
type GoogleCloudDialogflowV2beta1CompleteConversationRequest struct {
}

// GoogleCloudDialogflowV2beta1Connection: Represents a connection for SIP
// Trunk.
type GoogleCloudDialogflowV2beta1Connection struct {
	// ConnectionId: Output only. The unique identifier of the SIP Trunk
	// connection.
	ConnectionId string `json:"connectionId,omitempty"`
	// ErrorDetails: Output only. The error details for the connection. Only
	// populated when authentication errors occur.
	ErrorDetails *GoogleCloudDialogflowV2beta1ConnectionErrorDetails `json:"errorDetails,omitempty"`
	// State: Output only. State of the connection.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - SIP Trunk connection state is Not specified.
	//   "CONNECTED" - SIP Trunk connection is connected.
	//   "DISCONNECTED" - SIP Trunk connection is disconnected.
	//   "AUTHENTICATION_FAILED" - SIP Trunk connection has authentication error.
	//   "KEEPALIVE" - SIP Trunk connection is keepalive.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. When the connection status changed.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Connection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Connection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConnectionErrorDetails: The error details of Sip
// Trunk connection authentication.
type GoogleCloudDialogflowV2beta1ConnectionErrorDetails struct {
	// CertificateState: Output only. The status of the certificate authentication.
	//
	// Possible values:
	//   "CERTIFICATE_STATE_UNSPECIFIED" - Certificate state is not specified.
	//   "CERTIFICATE_VALID" - Certificate is valid.
	//   "CERTIFICATE_INVALID" - Catch all for any error not specified.
	//   "CERTIFICATE_EXPIRED" - Certificate leaf node has expired.
	//   "CERTIFICATE_HOSTNAME_NOT_FOUND" - There is no hostname defined to
	// authenticate in SipTrunkingServer.
	//   "CERTIFICATE_UNAUTHENTICATED" - No path found from the leaf certificate to
	// any root.
	//   "CERTIFICATE_TRUST_STORE_NOT_FOUND" - Trust store does not exist.
	//   "CERTIFICATE_HOSTNAME_INVALID_FORMAT" - Hostname has invalid format.
	//   "CERTIFICATE_QUOTA_EXCEEDED" - Certificate has exhausted its quota.
	CertificateState string `json:"certificateState,omitempty"`
	// ErrorMessage: The error message provided from SIP trunking auth service
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConnectionErrorDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConnectionErrorDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Context: Dialogflow contexts are similar to
// natural language context. If a person says to you "they are orange", you
// need context in order to understand what "they" is referring to. Similarly,
// for Dialogflow to handle an end-user expression like that, it needs to be
// provided with context in order to correctly match an intent. Using contexts,
// you can control the flow of a conversation. You can configure contexts for
// an intent by setting input and output contexts, which are identified by
// string names. When an intent is matched, any configured output contexts for
// that intent become active. While any contexts are active, Dialogflow is more
// likely to match intents that are configured with input contexts that
// correspond to the currently active contexts. For more information about
// context, see the Contexts guide
// (https://cloud.google.com/dialogflow/docs/contexts-overview).
type GoogleCloudDialogflowV2beta1Context struct {
	// LifespanCount: Optional. The number of conversational query requests after
	// which the context expires. The default is `0`. If set to `0`, the context
	// expires immediately. Contexts expire automatically after 20 minutes if there
	// are no matching queries.
	LifespanCount int64 `json:"lifespanCount,omitempty"`
	// Name: Required. The unique identifier of the context. Supported formats: -
	// `projects//agent/sessions//contexts/`, -
	// `projects//locations//agent/sessions//contexts/`, -
	// `projects//agent/environments//users//sessions//contexts/`, -
	// `projects//locations//agent/environments//users//sessions//contexts/`, The
	// `Context ID` is always converted to lowercase, may only contain characters
	// in `a-zA-Z0-9_-%` and may be at most 250 bytes long. If `Environment ID` is
	// not specified, we assume default 'draft' environment. If `User ID` is not
	// specified, we assume default '-' user. The following context names are
	// reserved for internal use by Dialogflow. You should not use these contexts
	// or create contexts with these names: * `__system_counters__` *
	// `*_id_dialog_context` * `*_dialog_params_size`
	Name string `json:"name,omitempty"`
	// Parameters: Optional. The collection of parameters associated with this
	// context. Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object composed of
	// a collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Conversation: Represents a conversation. A
// conversation is an interaction between an agent, including live agents and
// Dialogflow agents, and a support customer. Conversations can include phone
// calls and text-based chat sessions.
type GoogleCloudDialogflowV2beta1Conversation struct {
	// ConversationProfile: Required. The Conversation Profile to be used to
	// configure this Conversation. This field cannot be updated. Format:
	// `projects//locations//conversationProfiles/`.
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// ConversationStage: Optional. The stage of a conversation. It indicates
	// whether the virtual agent or a human agent is handling the conversation. If
	// the conversation is created with the conversation profile that has
	// Dialogflow config set, defaults to ConversationStage.VIRTUAL_AGENT_STAGE;
	// Otherwise, defaults to ConversationStage.HUMAN_ASSIST_STAGE. If the
	// conversation is created with the conversation profile that has Dialogflow
	// config set but explicitly sets conversation_stage to
	// ConversationStage.HUMAN_ASSIST_STAGE, it skips
	// ConversationStage.VIRTUAL_AGENT_STAGE stage and directly goes to
	// ConversationStage.HUMAN_ASSIST_STAGE.
	//
	// Possible values:
	//   "CONVERSATION_STAGE_UNSPECIFIED" - Unknown. Should never be used after a
	// conversation is successfully created.
	//   "VIRTUAL_AGENT_STAGE" - The conversation should return virtual agent
	// responses into the conversation.
	//   "HUMAN_ASSIST_STAGE" - The conversation should not provide responses, just
	// listen and provide suggestions.
	ConversationStage string `json:"conversationStage,omitempty"`
	// EndTime: Output only. The time the conversation was finished.
	EndTime string `json:"endTime,omitempty"`
	// IngestedContextReferences: Output only. The context reference updates
	// provided by external systems.
	IngestedContextReferences map[string]GoogleCloudDialogflowV2beta1ConversationContextReference `json:"ingestedContextReferences,omitempty"`
	// LifecycleState: Output only. The current state of the Conversation.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Conversation is currently open for media analysis.
	//   "COMPLETED" - Conversation has been completed.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// Name: Output only. Identifier. The unique identifier of this conversation.
	// Format: `projects//locations//conversations/`.
	Name string `json:"name,omitempty"`
	// PhoneNumber: Output only. Required if the conversation is to be connected
	// over telephony.
	PhoneNumber *GoogleCloudDialogflowV2beta1ConversationPhoneNumber `json:"phoneNumber,omitempty"`
	// StartTime: Output only. The time the conversation was started.
	StartTime string `json:"startTime,omitempty"`
	// TelephonyConnectionInfo: Output only. The telephony connection information.
	TelephonyConnectionInfo *GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo `json:"telephonyConnectionInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationContext: Context of the
// conversation, including transcripts.
type GoogleCloudDialogflowV2beta1ConversationContext struct {
	// MessageEntries: Optional. List of message transcripts in the conversation.
	MessageEntries []*GoogleCloudDialogflowV2beta1MessageEntry `json:"messageEntries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MessageEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MessageEntries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationContextReference: Represents a piece
// of ingested context information.
type GoogleCloudDialogflowV2beta1ConversationContextReference struct {
	// ContextContents: Required. The list of content updates for a context
	// reference.
	ContextContents []*GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent `json:"contextContents,omitempty"`
	// CreateTime: Output only. The time the context reference was first created.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: Optional. The language of the information ingested, defaults
	// to "en-US" if not set.
	LanguageCode string `json:"languageCode,omitempty"`
	// UpdateMode: Required. The mode in which context reference contents are
	// updated.
	//
	// Possible values:
	//   "UPDATE_MODE_UNSPECIFIED" - Unspecified update mode.
	//   "APPEND" - Context content updates are applied in append mode.
	//   "OVERWRITE" - Context content updates are applied in overwrite mode.
	UpdateMode string `json:"updateMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextContents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationContextReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationContextReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent:
// Contents ingested.
type GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent struct {
	// AnswerRecord: If the context content was generated from a tool call, specify
	// the answer record associated with the tool call. Format:
	// `projects//locations//answerRecords/`.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Content: Required. The information ingested in a single request.
	Content string `json:"content,omitempty"`
	// ContentFormat: Required. The format of the ingested string.
	//
	// Possible values:
	//   "CONTENT_FORMAT_UNSPECIFIED" - Unspecified content format.
	//   "JSON" - Content was provided in JSON format.
	//   "PLAIN_TEXT" - Content was provided as plain text.
	ContentFormat string `json:"contentFormat,omitempty"`
	// IngestionTime: Output only. The time when this information was incorporated
	// into the relevant context reference.
	IngestionTime string `json:"ingestionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationEvent: Represents a notification
// sent to Pub/Sub subscribers for conversation lifecycle events.
type GoogleCloudDialogflowV2beta1ConversationEvent struct {
	// Conversation: Required. The unique identifier of the conversation this
	// notification refers to. Format: `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// ErrorStatus: Optional. More detailed information about an error. Only set
	// for type UNRECOVERABLE_ERROR_IN_PHONE_CALL.
	ErrorStatus *GoogleRpcStatus `json:"errorStatus,omitempty"`
	// NewMessagePayload: Payload of NEW_MESSAGE event.
	NewMessagePayload *GoogleCloudDialogflowV2beta1Message `json:"newMessagePayload,omitempty"`
	// NewRecognitionResultPayload: Payload of NEW_RECOGNITION_RESULT event.
	NewRecognitionResultPayload *GoogleCloudDialogflowV2beta1StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Type: Required. The type of the event that this notification refers to.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not set.
	//   "CONVERSATION_STARTED" - A new conversation has been opened. This is fired
	// when a telephone call is answered, or a conversation is created via the API.
	//   "CONVERSATION_FINISHED" - An existing conversation has closed. This is
	// fired when a telephone call is terminated, or a conversation is closed via
	// the API. The event is fired for every CompleteConversation call, even if the
	// conversation is already closed.
	//   "HUMAN_INTERVENTION_NEEDED" - An existing conversation has received
	// notification from Dialogflow that human intervention is required.
	//   "NEW_MESSAGE" - An existing conversation has received a new message,
	// either from API or telephony. It is configured in
	// ConversationProfile.new_message_event_notification_config
	//   "NEW_RECOGNITION_RESULT" - An existing conversation has received a new
	// speech recognition result. This is mainly for delivering intermediate
	// transcripts. The notification is configured in
	// ConversationProfile.new_recognition_event_notification_config.
	//   "UNRECOVERABLE_ERROR" - Unrecoverable error during a telephone call. In
	// general non-recoverable errors only occur if something was misconfigured in
	// the ConversationProfile corresponding to the call. After a non-recoverable
	// error, Dialogflow may stop responding. We don't fire this event: * in an API
	// call because we can directly return the error, or, * when we can recover
	// from an error.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationPhoneNumber: Represents a phone
// number for telephony integration. It allows for connecting a particular
// conversation over telephony.
type GoogleCloudDialogflowV2beta1ConversationPhoneNumber struct {
	// CountryCode: Output only. Desired country code for the phone number.
	CountryCode int64 `json:"countryCode,omitempty"`
	// PhoneNumber: Output only. The phone number to connect to this conversation.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CountryCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationPhoneNumber) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationPhoneNumber
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationProfile: Defines the services to
// connect to incoming Dialogflow conversations.
type GoogleCloudDialogflowV2beta1ConversationProfile struct {
	// AutomatedAgentConfig: Configuration for an automated agent to use with this
	// profile.
	AutomatedAgentConfig *GoogleCloudDialogflowV2beta1AutomatedAgentConfig `json:"automatedAgentConfig,omitempty"`
	// CreateTime: Output only. Create time of the conversation profile.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. Human readable name for this profile. Max length 1024
	// bytes.
	DisplayName string `json:"displayName,omitempty"`
	// HumanAgentAssistantConfig: Configuration for agent assistance to use with
	// this profile.
	HumanAgentAssistantConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig `json:"humanAgentAssistantConfig,omitempty"`
	// HumanAgentHandoffConfig: Configuration for connecting to a live agent.
	// Currently, this feature is not general available, please contact Google to
	// get access.
	HumanAgentHandoffConfig *GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig `json:"humanAgentHandoffConfig,omitempty"`
	// LanguageCode: Language code for the conversation profile. If not specified,
	// the language is en-US. Language at ConversationProfile should be set for all
	// non en-us languages. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// LoggingConfig: Configuration for logging conversation lifecycle events.
	LoggingConfig *GoogleCloudDialogflowV2beta1LoggingConfig `json:"loggingConfig,omitempty"`
	// Name: The unique identifier of this conversation profile. Format:
	// `projects//locations//conversationProfiles/`.
	Name string `json:"name,omitempty"`
	// NewMessageEventNotificationConfig: Configuration for publishing new message
	// events. Event will be sent in format of ConversationEvent
	NewMessageEventNotificationConfig *GoogleCloudDialogflowV2beta1NotificationConfig `json:"newMessageEventNotificationConfig,omitempty"`
	// NewRecognitionResultNotificationConfig: Optional. Configuration for
	// publishing transcription intermediate results. Event will be sent in format
	// of ConversationEvent. If configured, the following information will be
	// populated as ConversationEvent Pub/Sub message attributes: -
	// "participant_id" - "participant_role" - "message_id"
	NewRecognitionResultNotificationConfig *GoogleCloudDialogflowV2beta1NotificationConfig `json:"newRecognitionResultNotificationConfig,omitempty"`
	// NotificationConfig: Configuration for publishing conversation lifecycle
	// events.
	NotificationConfig *GoogleCloudDialogflowV2beta1NotificationConfig `json:"notificationConfig,omitempty"`
	// SecuritySettings: Name of the CX SecuritySettings reference for the agent.
	// Format: `projects//locations//securitySettings/`.
	SecuritySettings string `json:"securitySettings,omitempty"`
	// SttConfig: Settings for speech transcription.
	SttConfig *GoogleCloudDialogflowV2beta1SpeechToTextConfig `json:"sttConfig,omitempty"`
	// TimeZone: The time zone of this conversational profile from the time zone
	// database (https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris. Defaults to America/New_York.
	TimeZone string `json:"timeZone,omitempty"`
	// TtsConfig: Configuration for Text-to-Speech synthesization. Used by Phone
	// Gateway to specify synthesization options. If agent defines synthesization
	// options as well, agent settings overrides the option here.
	TtsConfig *GoogleCloudDialogflowV2beta1SynthesizeSpeechConfig `json:"ttsConfig,omitempty"`
	// UpdateTime: Output only. Update time of the conversation profile.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutomatedAgentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomatedAgentConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo: The
// information about phone calls connected via phone gateway to the
// conversation.
type GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo struct {
	// DialedNumber: Output only. The number dialed to connect this call in E.164
	// format.
	DialedNumber string `json:"dialedNumber,omitempty"`
	// ExtraMimeContents: Output only. The mime content from the initial SIP
	// INVITE.
	ExtraMimeContents []*GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent `json:"extraMimeContents,omitempty"`
	// Sdp: Optional. SDP of the call. It's initially the SDP answer to the
	// incoming call, but maybe later updated for the purpose of making the link
	// active, etc.
	Sdp string `json:"sdp,omitempty"`
	// SipHeaders: Output only. The SIP headers from the initial SIP INVITE.
	SipHeaders []*GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader `json:"sipHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialedNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialedNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent:
// The mime content from the initial SIP INVITE.
type GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent struct {
	// Content: Optional. The content payload.
	Content string `json:"content,omitempty"`
	// MimeType: Optional. The mime type of the content.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader:
// The SIP headers from the initial SIP INVITE.
type GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader struct {
	// Name: Optional. The name of the header.
	Name string `json:"name,omitempty"`
	// Value: Optional. The value of the header.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1CreateMessageRequest: The request message to
// create one Message. Currently it is only used in BatchCreateMessagesRequest.
type GoogleCloudDialogflowV2beta1CreateMessageRequest struct {
	// Message: Required. The message to create. Message.participant is required.
	Message *GoogleCloudDialogflowV2beta1Message `json:"message,omitempty"`
	// Parent: Required. Resource identifier of the conversation to create message.
	// Format: `projects//locations//conversations/`.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1CreateMessageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1CreateMessageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1CustomPronunciationParams: Pronunciation
// customization for a phrase.
type GoogleCloudDialogflowV2beta1CustomPronunciationParams struct {
	// PhoneticEncoding: The phonetic encoding of the phrase.
	//
	// Possible values:
	//   "PHONETIC_ENCODING_UNSPECIFIED" - Not specified.
	//   "PHONETIC_ENCODING_IPA" - IPA, such as apple -> ˈæpəl.
	// https://en.wikipedia.org/wiki/International_Phonetic_Alphabet
	//   "PHONETIC_ENCODING_X_SAMPA" - X-SAMPA, such as apple -> "{p@l".
	// https://en.wikipedia.org/wiki/X-SAMPA
	PhoneticEncoding string `json:"phoneticEncoding,omitempty"`
	// Phrase: The phrase to which the customization is applied. The phrase can be
	// multiple words, such as proper nouns, but shouldn't span the length of the
	// sentence.
	Phrase string `json:"phrase,omitempty"`
	// Pronunciation: The pronunciation of the phrase. This must be in the phonetic
	// encoding specified above.
	Pronunciation string `json:"pronunciation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneticEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneticEncoding") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1CustomPronunciationParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1CustomPronunciationParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1DetectIntentRequest: The request to detect
// user's intent.
type GoogleCloudDialogflowV2beta1DetectIntentRequest struct {
	// InputAudio: The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config. A
	// single request can contain up to 1 minute of speech audio data.
	InputAudio string `json:"inputAudio,omitempty"`
	// OutputAudioConfig: Instructs the speech synthesizer how to generate the
	// output audio. If this field is not set and agent-level speech synthesizer is
	// not configured, no output audio is generated.
	OutputAudioConfig *GoogleCloudDialogflowV2beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// OutputAudioConfigMask: Mask for output_audio_config indicating which
	// settings in this request-level config should override speech synthesizer
	// settings defined at agent-level. If unspecified or empty,
	// output_audio_config replaces the agent-level config in its entirety.
	OutputAudioConfigMask string `json:"outputAudioConfigMask,omitempty"`
	// QueryInput: Required. The input specification. It can be set to: 1. an audio
	// config which instructs the speech recognizer how to process the speech
	// audio, 2. a conversational query in the form of text, or 3. an event that
	// specifies which intent to trigger.
	QueryInput *GoogleCloudDialogflowV2beta1QueryInput `json:"queryInput,omitempty"`
	// QueryParams: The parameters of this query.
	QueryParams *GoogleCloudDialogflowV2beta1QueryParameters `json:"queryParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputAudio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputAudio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1DetectIntentResponse: The message returned from
// the DetectIntent method.
type GoogleCloudDialogflowV2beta1DetectIntentResponse struct {
	// AlternativeQueryResults: If Knowledge Connectors are enabled, there could be
	// more than one result returned for a given query or event, and this field
	// will contain all results except for the top one, which is captured in
	// query_result. The alternative results are ordered by decreasing
	// `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
	// disabled, this field will be empty until multiple responses for regular
	// intents are supported, at which point those additional results will be
	// surfaced here.
	AlternativeQueryResults []*GoogleCloudDialogflowV2beta1QueryResult `json:"alternativeQueryResults,omitempty"`
	// OutputAudio: The audio data bytes encoded as specified in the request. Note:
	// The output audio is generated based on the values of default platform text
	// responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the generated
	// audio content will be empty. In some scenarios, multiple output audio fields
	// may be present in the response structure. In these cases, only the
	// top-most-level audio output has content.
	OutputAudio string `json:"outputAudio,omitempty"`
	// OutputAudioConfig: The config used by the speech synthesizer to generate the
	// output audio.
	OutputAudioConfig *GoogleCloudDialogflowV2beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// QueryResult: The selected results of the conversational query or event
	// processing. See `alternative_query_results` for additional potential
	// results.
	QueryResult *GoogleCloudDialogflowV2beta1QueryResult `json:"queryResult,omitempty"`
	// ResponseId: The unique identifier of the response. It can be used to locate
	// a response in the training example set or for reporting issues.
	ResponseId string `json:"responseId,omitempty"`
	// WebhookStatus: Specifies the status of the webhook request.
	WebhookStatus *GoogleRpcStatus `json:"webhookStatus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternativeQueryResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativeQueryResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DetectIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DetectIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1DialogflowAssistAnswer: Represents a Dialogflow
// assist answer.
type GoogleCloudDialogflowV2beta1DialogflowAssistAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// IntentSuggestion: An intent suggestion generated from conversation.
	IntentSuggestion *GoogleCloudDialogflowV2beta1IntentSuggestion `json:"intentSuggestion,omitempty"`
	// QueryResult: Result from v2 agent.
	QueryResult *GoogleCloudDialogflowV2beta1QueryResult `json:"queryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DialogflowAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DialogflowAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Document: A knowledge document to be used by a
// KnowledgeBase. For more information, see the knowledge base guide
// (https://cloud.google.com/dialogflow/docs/how/knowledge-bases). Note: The
// `projects.agent.knowledgeBases.documents` resource is deprecated; only use
// `projects.knowledgeBases.documents`.
type GoogleCloudDialogflowV2beta1Document struct {
	// Content: The raw content of the document. This field is only permitted for
	// EXTRACTIVE_QA and FAQ knowledge types. Note: This field is in the process of
	// being deprecated, please use raw_content instead.
	Content string `json:"content,omitempty"`
	// ContentUri: The URI where the file content is located. For documents stored
	// in Google Cloud Storage, these URIs must have the form `gs:///`. NOTE:
	// External URLs must correspond to public webpages, i.e., they must be indexed
	// by Google Search. In particular, URLs for showing documents in Google Cloud
	// Storage (i.e. the URL in your browser) are not supported. Instead use the
	// `gs://` format URI described above.
	ContentUri string `json:"contentUri,omitempty"`
	// DisplayName: Required. The display name of the document. The name must be
	// 1024 bytes or less; otherwise, the creation request fails.
	DisplayName string `json:"displayName,omitempty"`
	// EnableAutoReload: Optional. If true, we try to automatically reload the
	// document every day (at a time picked by the system). If false or
	// unspecified, we don't try to automatically reload the document. Currently
	// you can only enable automatic reload for documents sourced from a public
	// url, see `source` field for the source types. Reload status can be tracked
	// in `latest_reload_status`. If a reload fails, we will keep the document
	// unchanged. If a reload fails with internal errors, the system will try to
	// reload the document on the next day. If a reload fails with non-retriable
	// errors (e.g. PERMISSION_DENIED), the system will not try to reload the
	// document anymore. You need to manually reload the document successfully by
	// calling `ReloadDocument` and clear the errors.
	EnableAutoReload bool `json:"enableAutoReload,omitempty"`
	// KnowledgeTypes: Required. The knowledge type of document content.
	//
	// Possible values:
	//   "KNOWLEDGE_TYPE_UNSPECIFIED" - The type is unspecified or arbitrary.
	//   "FAQ" - The document content contains question and answer pairs as either
	// HTML or CSV. Typical FAQ HTML formats are parsed accurately, but unusual
	// formats may fail to be parsed. CSV must have questions in the first column
	// and answers in the second, with no header. Because of this explicit format,
	// they are always parsed accurately.
	//   "EXTRACTIVE_QA" - Documents for which unstructured text is extracted and
	// used for question answering.
	//   "ARTICLE_SUGGESTION" - The entire document content as a whole can be used
	// for query results. Only for Contact Center Solutions on Dialogflow.
	//   "AGENT_FACING_SMART_REPLY" - The document contains agent-facing Smart
	// Reply entries.
	//   "SMART_REPLY" - The legacy enum for agent-facing smart reply feature.
	KnowledgeTypes []string `json:"knowledgeTypes,omitempty"`
	// LatestReloadStatus: Output only. The time and status of the latest reload.
	// This reload may have been triggered automatically or manually and may not
	// have succeeded.
	LatestReloadStatus *GoogleCloudDialogflowV2beta1DocumentReloadStatus `json:"latestReloadStatus,omitempty"`
	// Metadata: Optional. Metadata for the document. The metadata supports
	// arbitrary key-value pairs. Suggested use cases include storing a document's
	// title, an external URL distinct from the document's content_uri, etc. The
	// max size of a `key` or a `value` of the metadata is 1024 bytes.
	Metadata map[string]string `json:"metadata,omitempty"`
	// MimeType: Required. The MIME type of this document.
	MimeType string `json:"mimeType,omitempty"`
	// Name: Optional. The document resource name. The name must be empty when
	// creating a document. Format:
	// `projects//locations//knowledgeBases//documents/`.
	Name string `json:"name,omitempty"`
	// RawContent: The raw content of the document. This field is only permitted
	// for EXTRACTIVE_QA and FAQ knowledge types.
	RawContent string `json:"rawContent,omitempty"`
	// State: Output only. The current state of the document.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The document state is unspecified.
	//   "CREATING" - The document creation is in progress.
	//   "ACTIVE" - The document is active and ready to use.
	//   "UPDATING" - The document updation is in progress.
	//   "RELOADING" - The document is reloading.
	//   "DELETING" - The document deletion is in progress.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Document) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Document
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1DocumentReloadStatus: The status of a reload
// attempt.
type GoogleCloudDialogflowV2beta1DocumentReloadStatus struct {
	// Status: Output only. The status of a reload attempt or the initial load.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// Time: Output only. The time of a reload attempt. This reload may have been
	// triggered automatically or manually and may not have succeeded.
	Time string `json:"time,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DocumentReloadStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DocumentReloadStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1DtmfParameters: The message in the response that
// indicates the parameters of DTMF.
type GoogleCloudDialogflowV2beta1DtmfParameters struct {
	// AcceptsDtmfInput: Indicates whether DTMF input can be handled in the next
	// request.
	AcceptsDtmfInput bool `json:"acceptsDtmfInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptsDtmfInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptsDtmfInput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DtmfParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DtmfParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EncryptionSpec: A customer-managed encryption
// key specification that can be applied to all created resources (e.g.
// Conversation).
type GoogleCloudDialogflowV2beta1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by the default Google encryption key. Only the key in the same
	// location as this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EntityType: Each intent parameter has a type,
// called the entity type, which dictates exactly how data from an end-user
// expression is extracted. Dialogflow provides predefined system entities that
// can match many common types of data. For example, there are system entities
// for matching dates, times, colors, email addresses, and so on. You can also
// create your own custom entities for matching custom data. For example, you
// could define a vegetable entity that can match the types of vegetables
// available for purchase with a grocery store agent. For more information, see
// the Entity guide
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowV2beta1EntityType struct {
	// AutoExpansionMode: Optional. Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values that
	// have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`
	// DisplayName: Required. The name of the entity type.
	DisplayName string `json:"displayName,omitempty"`
	// EnableFuzzyExtraction: Optional. Enables fuzzy entity extraction during
	// classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`
	// Entities: Optional. The collection of entity entries associated with the
	// entity type.
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms to a
	// reference value.
	//   "KIND_LIST" - List entity types contain a set of entries that do not map
	// to reference values. However, list entity types can contain references to
	// other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular expressions
	// in entries values.
	Kind string `json:"kind,omitempty"`
	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes methods.
	// Supported formats: - `projects//agent/entityTypes/` -
	// `projects//locations//agent/entityTypes/`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EntityTypeBatch: This message is a wrapper
// around a collection of entity types.
type GoogleCloudDialogflowV2beta1EntityTypeBatch struct {
	// EntityTypes: A collection of entity types.
	EntityTypes []*GoogleCloudDialogflowV2beta1EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityTypeBatch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityTypeBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EntityTypeEntity: An **entity entry** for an
// associated entity type.
type GoogleCloudDialogflowV2beta1EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if the
	// entity type is *vegetable*, and `value` is *scallions*, a synonym could be
	// *green onions*. For `KIND_LIST` entity types: * This collection must contain
	// exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`
	// Value: Required. The primary value associated with this entity entry. For
	// example, if the entity type is *vegetable*, the value could be *scallions*.
	// For `KIND_MAP` entity types: * A reference value to be used in place of
	// synonyms. For `KIND_LIST` entity types: * A string that can contain
	// references to other entity types (with or without aliases).
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Environment: You can create multiple versions of
// your agent and publish them to separate environments. When you edit an
// agent, you are editing the draft agent. At any point, you can save the draft
// agent as an agent version, which is an immutable snapshot of your agent.
// When you save the draft agent, it is published to the default environment.
// When you create agent versions, you can publish them to custom environments.
// You can create a variety of custom environments for: - testing - development
// - production - etc. For more information, see the versions and environments
// guide (https://cloud.google.com/dialogflow/docs/agents-versions).
type GoogleCloudDialogflowV2beta1Environment struct {
	// AgentVersion: Optional. The agent version loaded into this environment.
	// Supported formats: - `projects//agent/versions/` -
	// `projects//locations//agent/versions/`
	AgentVersion string `json:"agentVersion,omitempty"`
	// Description: Optional. The developer-provided description for this
	// environment. The maximum length is 500 characters. If exceeded, the request
	// is rejected.
	Description string `json:"description,omitempty"`
	// Fulfillment: Optional. The fulfillment settings to use for this environment.
	Fulfillment *GoogleCloudDialogflowV2beta1Fulfillment `json:"fulfillment,omitempty"`
	// Name: Output only. The unique identifier of this agent environment.
	// Supported formats: - `projects//agent/environments/` -
	// `projects//locations//agent/environments/`
	Name string `json:"name,omitempty"`
	// State: Output only. The state of this environment. This field is read-only,
	// i.e., it cannot be set by create and update methods.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not specified. This value is not used.
	//   "STOPPED" - Stopped.
	//   "LOADING" - Loading.
	//   "RUNNING" - Running.
	State string `json:"state,omitempty"`
	// TextToSpeechSettings: Optional. Text to speech settings for this
	// environment.
	TextToSpeechSettings *GoogleCloudDialogflowV2beta1TextToSpeechSettings `json:"textToSpeechSettings,omitempty"`
	// UpdateTime: Output only. The last update time of this environment. This
	// field is read-only, i.e., it cannot be set by create and update methods.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EnvironmentHistory: The response message for
// Environments.GetEnvironmentHistory.
type GoogleCloudDialogflowV2beta1EnvironmentHistory struct {
	// Entries: Output only. The list of agent environments. There will be a
	// maximum number of items returned based on the page_size field in the
	// request.
	Entries []*GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry `json:"entries,omitempty"`
	// NextPageToken: Output only. Token to retrieve the next page of results, or
	// empty if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Parent: Output only. The name of the environment this history is for.
	// Supported formats: - `projects//agent/environments/` -
	// `projects//locations//agent/environments/`
	Parent string `json:"parent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EnvironmentHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EnvironmentHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry: Represents an
// environment history entry.
type GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry struct {
	// AgentVersion: The agent version loaded into this environment history entry.
	AgentVersion string `json:"agentVersion,omitempty"`
	// CreateTime: The creation time of this environment history entry.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The developer-provided description for this environment history
	// entry.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EvaluationStatus: A common evalaution pipeline
// status.
type GoogleCloudDialogflowV2beta1EvaluationStatus struct {
	// Done: Output only. If the value is `false`, it means the evaluation is still
	// in progress. If `true`, the operation is completed, and either `error` or
	// `response` is available.
	Done bool `json:"done,omitempty"`
	// PipelineStatus: Output only. The error result of the evaluation in case of
	// failure in evaluation pipeline.
	PipelineStatus *GoogleRpcStatus `json:"pipelineStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EvaluationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EvaluationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1EventInput: Events allow for matching intents by
// event name instead of the natural language input. For instance, input “ can
// trigger a personalized welcome response. The parameter `name` may be used by
// the agent in the response: "Hello #welcome_event.name! What can I do for
// you today?".
type GoogleCloudDialogflowV2beta1EventInput struct {
	// LanguageCode: Required. The language of this query. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language. This field is
	// ignored when used in the context of a WebhookResponse.followup_event_input
	// field, because the language was already defined in the originating detect
	// intent request.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Required. The unique identifier of the event.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the event.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ExportAgentRequest: The request message for
// Agents.ExportAgent.
type GoogleCloudDialogflowV2beta1ExportAgentRequest struct {
	// AgentUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the agent to. The
	// format of this URI must be `gs:///`. If left unspecified, the serialized
	// agent is returned inline. Dialogflow performs a write operation for the
	// Cloud Storage object on the caller's behalf, so your request authentication
	// must have write permissions for the object. For more information, see
	// Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowV2beta1ExportAgentResponse struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated only if `agent_uri` is specified in `ExportAgentRequest`.
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ExportOperationMetadata: Metadata related to the
// Export Data Operations (e.g. ExportDocument).
type GoogleCloudDialogflowV2beta1ExportOperationMetadata struct {
	// ExportedGcsDestination: Cloud Storage file path of the exported data.
	ExportedGcsDestination *GoogleCloudDialogflowV2beta1GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FaqAnswer: Represents answer from "frequently
// asked questions".
type GoogleCloudDialogflowV2beta1FaqAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The system's confidence score that this Knowledge answer is a
	// good match for this conversational query, range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects//locations//agent/knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2beta1FewShotExample: Providing examples in the
// generator (i.e. building a few-shot generator) helps convey the desired
// format of the LLM response.
type GoogleCloudDialogflowV2beta1FewShotExample struct {
	// ConversationContext: Optional. Conversation transcripts.
	ConversationContext *GoogleCloudDialogflowV2beta1ConversationContext `json:"conversationContext,omitempty"`
	// ExtraInfo: Optional. Key is the placeholder field name in input, value is
	// the value of the placeholder. E.g. instruction contains "@price", and
	// ingested data has <"price", "10">
	ExtraInfo map[string]string `json:"extraInfo,omitempty"`
	// Output: Required. Example output of the model.
	Output *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"output,omitempty"`
	// SummarizationSectionList: Summarization sections.
	SummarizationSectionList *GoogleCloudDialogflowV2beta1SummarizationSectionList `json:"summarizationSectionList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FewShotExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FewShotExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FreeFormContext: Free form generator context
// that customer can configure.
type GoogleCloudDialogflowV2beta1FreeFormContext struct {
	// Text: Optional. Free form text input to LLM.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FreeFormContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FreeFormContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FreeFormSuggestion: Suggestion generated using
// free form generator.
type GoogleCloudDialogflowV2beta1FreeFormSuggestion struct {
	// Response: Required. Free form suggestion.
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Fulfillment: By default, your agent responds to
// a matched intent with a static response. As an alternative, you can provide
// a more dynamic response by using fulfillment. When you enable fulfillment
// for an intent, Dialogflow responds to that intent by calling a service that
// you define. For example, if an end-user wants to schedule a haircut on
// Friday, your service can check your database and respond to the end-user
// with availability information for Friday. For more information, see the
// fulfillment guide
// (https://cloud.google.com/dialogflow/docs/fulfillment-overview).
type GoogleCloudDialogflowV2beta1Fulfillment struct {
	// DisplayName: The human-readable name of the fulfillment, unique within the
	// agent. This field is not used for Fulfillment in an Environment.
	DisplayName string `json:"displayName,omitempty"`
	// Enabled: Whether fulfillment is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Features: The field defines whether the fulfillment is enabled for certain
	// features.
	Features []*GoogleCloudDialogflowV2beta1FulfillmentFeature `json:"features,omitempty"`
	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowV2beta1FulfillmentGenericWebService `json:"genericWebService,omitempty"`
	// Name: Required. The unique identifier of the fulfillment. Supported formats:
	// - `projects//agent/fulfillment` - `projects//locations//agent/fulfillment`
	// This field is not used for Fulfillment in an Environment.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FulfillmentFeature: Whether fulfillment is
// enabled for the specific feature.
type GoogleCloudDialogflowV2beta1FulfillmentFeature struct {
	// Type: The type of the feature that enabled for fulfillment.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Feature type not specified.
	//   "SMALLTALK" - Fulfillment is enabled for SmallTalk.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FulfillmentFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FulfillmentFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1FulfillmentGenericWebService: Represents
// configuration for a generic web service. Dialogflow supports two mechanisms
// for authentications: - Basic authentication with username and password. -
// Authentication with additional authentication headers. More information
// could be found at:
// https://cloud.google.com/dialogflow/docs/fulfillment-configure.
type GoogleCloudDialogflowV2beta1FulfillmentGenericWebService struct {
	// IsCloudFunction: Optional. Indicates if generic web service is created
	// through Cloud Functions integration. Defaults to false. is_cloud_function is
	// deprecated. Cloud functions can be configured by its uri as a regular web
	// service now.
	IsCloudFunction bool `json:"isCloudFunction,omitempty"`
	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`
	// RequestHeaders: The HTTP request headers to send together with fulfillment
	// requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`
	// Uri: Required. The fulfillment URI for receiving POST requests. It must use
	// https protocol.
	Uri string `json:"uri,omitempty"`
	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsCloudFunction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsCloudFunction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FulfillmentGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FulfillmentGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GcsDestination: Google Cloud Storage location
// for the output.
type GoogleCloudDialogflowV2beta1GcsDestination struct {
	// Uri: Required. The Google Cloud Storage URIs for the output. A URI is of the
	// form: `gs://bucket/object-prefix-or-name` Whether a prefix or name is used
	// depends on the use case. The requesting user must have "write-permission" to
	// the bucket.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GcsSource: Google Cloud Storage location for
// single input.
type GoogleCloudDialogflowV2beta1GcsSource struct {
	// Uri: Required. The Google Cloud Storage URIs for the inputs. A URI is of the
	// form: `gs://bucket/object-prefix-or-name` Whether a prefix or name is used
	// depends on the use case.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GcsSources: Google Cloud Storage locations for
// the inputs.
type GoogleCloudDialogflowV2beta1GcsSources struct {
	// Uris: Required. Google Cloud Storage URIs for the inputs. A URI is of the
	// form: `gs://bucket/object-prefix-or-name` Whether a prefix or name is used
	// depends on the use case.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GcsSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GcsSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionRequest: The request
// message for Conversations.GenerateStatelessSuggestion.
type GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionRequest struct {
	// ContextReferences: Optional. A section of ingested context information. The
	// key is the name of the context reference and the value contains the contents
	// of the context reference. The key is used to incorporate ingested context
	// references to enhance the generator.
	ContextReferences map[string]GoogleCloudDialogflowV2beta1ConversationContextReference `json:"contextReferences,omitempty"`
	// ConversationContext: Optional. Context of the conversation, including
	// transcripts.
	ConversationContext *GoogleCloudDialogflowV2beta1ConversationContext `json:"conversationContext,omitempty"`
	// Generator: Uncreated generator. It should be a complete generator that
	// includes all information about the generator.
	Generator *GoogleCloudDialogflowV2beta1Generator `json:"generator,omitempty"`
	// GeneratorName: The resource name of the existing created generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// SecuritySettings: Optional. Name of the CX SecuritySettings which is used to
	// redact generated response. If this field is empty, try to fetch v2
	// security_settings, which is a project level setting. If this field is empty
	// and no v2 security_settings set up in this project, no redaction will be
	// done. Format: `projects//locations//securitySettings/`.
	SecuritySettings string `json:"securitySettings,omitempty"`
	// TriggerEvents: Optional. A list of trigger events. Generator will be
	// triggered only if it's trigger event is included here.
	//
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED" - Default value for TriggerEvent.
	//   "END_OF_UTTERANCE" - Triggers when each chat message or voice utterance
	// ends.
	//   "MANUAL_CALL" - Triggers on the conversation manually by API calls, such
	// as Conversations.GenerateStatelessSuggestion and
	// Conversations.GenerateSuggestions.
	//   "CUSTOMER_MESSAGE" - Triggers after each customer message only.
	//   "AGENT_MESSAGE" - Triggers after each agent message only.
	TriggerEvents []string `json:"triggerEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferences") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionResponse: The
// response message for Conversations.GenerateStatelessSuggestion.
type GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionResponse struct {
	// GeneratorSuggestion: Required. Generated suggestion for a conversation.
	GeneratorSuggestion *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"generatorSuggestion,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequest: The request
// message for Conversations.GenerateStatelessSummary.
type GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequest struct {
	// ConversationProfile: Required. A ConversationProfile containing information
	// required for Summary generation. Required fields: {language_code,
	// security_settings} Optional fields: {agent_assistant_config}
	ConversationProfile *GoogleCloudDialogflowV2beta1ConversationProfile `json:"conversationProfile,omitempty"`
	// LatestMessage: Optional. The name of the latest conversation message used as
	// context for generating a Summary. If empty, the latest message of the
	// conversation will be used. The format is specific to the user and the names
	// of the messages provided.
	LatestMessage string `json:"latestMessage,omitempty"`
	// MaxContextSize: Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the suggestion. By default
	// 500 and at most 1000.
	MaxContextSize int64 `json:"maxContextSize,omitempty"`
	// StatelessConversation: Required. The conversation to suggest a summary for.
	StatelessConversation *GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation `json:"statelessConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversatio
// n: The minimum amount of information required to generate a Summary without
// having a Conversation resource created.
type GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation struct {
	// Messages: Required. The messages that the Summary will be generated from. It
	// is expected that this message content is already redacted and does not
	// contain any PII. Required fields: {content, language_code, participant,
	// participant_role} Optional fields: {send_time} If send_time is not provided,
	// then the messages must be provided in chronological order.
	Messages []*GoogleCloudDialogflowV2beta1Message `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponse: The response
// message for Conversations.GenerateStatelessSummary.
type GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponse struct {
	// ContextSize: Number of messages prior to and including
	// last_conversation_message used to compile the suggestion. It may be smaller
	// than the GenerateStatelessSummaryRequest.context_size field in the request
	// if there weren't that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used as context
	// for compiling suggestion. The format is specific to the user and the names
	// of the messages provided.
	LatestMessage string `json:"latestMessage,omitempty"`
	// Summary: Generated summary.
	Summary *GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary `json:"summary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary:
// Generated summary for a conversation.
type GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary struct {
	// BaselineModelVersion: The baseline model version used to generate this
	// summary. It is empty if a baseline model was not used to generate this
	// summary.
	BaselineModelVersion string `json:"baselineModelVersion,omitempty"`
	// Text: The summary content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summary content that is divided into sections. The key is
	// the section's name and the value is the section's content. There is no
	// specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaselineModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaselineModelVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest: The request message
// for Conversations.GenerateSuggestions.
type GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest struct {
	// LatestMessage: Optional. The name of the latest conversation message for
	// which the request is triggered. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// TriggerEvents: Optional. A list of trigger events. Only generators
	// configured in the conversation_profile whose trigger_event is listed here
	// will be triggered.
	//
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED" - Default value for TriggerEvent.
	//   "END_OF_UTTERANCE" - Triggers when each chat message or voice utterance
	// ends.
	//   "MANUAL_CALL" - Triggers on the conversation manually by API calls, such
	// as Conversations.GenerateStatelessSuggestion and
	// Conversations.GenerateSuggestions.
	//   "CUSTOMER_MESSAGE" - Triggers after each customer message only.
	//   "AGENT_MESSAGE" - Triggers after each agent message only.
	TriggerEvents []string `json:"triggerEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse: The response
// message for Conversations.GenerateSuggestions.
type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse struct {
	// GeneratorSuggestionAnswers: The answers generated for the conversation based
	// on context.
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	// LatestMessage: The name of the latest conversation message used as context
	// for compiling suggestion. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAns
// wer: A GeneratorSuggestion answer.
type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	// AnswerRecord: Answer record that uniquely identifies the suggestion. This
	// can be used to provide suggestion feedback.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// GeneratorSuggestion: Suggestion details.
	GeneratorSuggestion *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	// SourceGenerator: The name of the generator used to generate this suggestion.
	// Format: `projects//locations//generators/`.
	SourceGenerator string `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Generator: LLM generator.
type GoogleCloudDialogflowV2beta1Generator struct {
	// AgentCoachingContext: Input of Agent Coaching feature.
	AgentCoachingContext *GoogleCloudDialogflowV2beta1AgentCoachingContext `json:"agentCoachingContext,omitempty"`
	// CreateTime: Output only. Creation time of this generator.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Human readable description of the generator.
	Description string `json:"description,omitempty"`
	// FreeFormContext: Input of free from generator to LLM.
	FreeFormContext *GoogleCloudDialogflowV2beta1FreeFormContext `json:"freeFormContext,omitempty"`
	// InferenceParameter: Optional. Inference parameters for this generator.
	InferenceParameter *GoogleCloudDialogflowV2beta1InferenceParameter `json:"inferenceParameter,omitempty"`
	// Name: Output only. Identifier. The resource name of the generator. Format:
	// `projects//locations//generators/`
	Name string `json:"name,omitempty"`
	// PublishedModel: Optional. The published Large Language Model name. * To use
	// the latest model version, specify the model name without version number.
	// Example: `text-bison` * To use a stable model version, specify the version
	// number as well. Example: `text-bison@002`.
	PublishedModel string `json:"publishedModel,omitempty"`
	// SuggestionDedupingConfig: Optional. Configuration for suggestion deduping.
	// This is only applicable to AI Coach feature.
	SuggestionDedupingConfig *GoogleCloudDialogflowV2beta1SuggestionDedupingConfig `json:"suggestionDedupingConfig,omitempty"`
	// SummarizationContext: Input of Summarization feature.
	SummarizationContext *GoogleCloudDialogflowV2beta1SummarizationContext `json:"summarizationContext,omitempty"`
	// Tools: Optional. Resource names of the tools that the generator can choose
	// from. Format: `projects//locations//tools/`.
	Tools []string `json:"tools,omitempty"`
	// TriggerEvent: Optional. The trigger event of the generator. It defines when
	// the generator is triggered in a conversation.
	//
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED" - Default value for TriggerEvent.
	//   "END_OF_UTTERANCE" - Triggers when each chat message or voice utterance
	// ends.
	//   "MANUAL_CALL" - Triggers on the conversation manually by API calls, such
	// as Conversations.GenerateStatelessSuggestion and
	// Conversations.GenerateSuggestions.
	//   "CUSTOMER_MESSAGE" - Triggers after each customer message only.
	//   "AGENT_MESSAGE" - Triggers after each agent message only.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// UpdateTime: Output only. Update time of this generator.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Generator) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Generator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluation: Represents evaluation
// result of a generator.
type GoogleCloudDialogflowV2beta1GeneratorEvaluation struct {
	// CompleteTime: Output only. Completion time of this generator evaluation.
	CompleteTime string `json:"completeTime,omitempty"`
	// CreateTime: Output only. Creation time of this generator evaluation.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. The display name of the generator evaluation. At most
	// 64 bytes long.
	DisplayName string `json:"displayName,omitempty"`
	// EvaluationStatus: Output only. The result status of the evaluation pipeline.
	// Provides the status information including if the evaluation is still in
	// progress, completed or failed with certain error and user actionable
	// message.
	EvaluationStatus *GoogleCloudDialogflowV2beta1EvaluationStatus `json:"evaluationStatus,omitempty"`
	// GeneratorEvaluationConfig: Required. The configuration of the evaluation
	// task.
	GeneratorEvaluationConfig *GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig `json:"generatorEvaluationConfig,omitempty"`
	// InitialGenerator: Required. The initial generator that was used when
	// creating this evaluation. This is a copy of the generator read from storage
	// when creating the evaluation.
	InitialGenerator *GoogleCloudDialogflowV2beta1Generator `json:"initialGenerator,omitempty"`
	// Name: Output only. Identifier. The resource name of the evaluation. Format:
	// `projects//locations//generators// evaluations/`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. A read only boolean field reflecting Zone
	// Isolation status of the model. The field is an aggregated value of ZI status
	// of its underlying dependencies. See more details in
	// go/zicy-resource-placement#resource-status
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. A read only boolean field reflecting Zone
	// Separation status of the model. The field is an aggregated value of ZS
	// status of its underlying dependencies. See more details in
	// go/zicy-resource-placement#resource-status
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SummarizationMetrics: Output only. Only available when the summarization
	// generator is provided.
	SummarizationMetrics *GoogleCloudDialogflowV2beta1SummarizationEvaluationMetrics `json:"summarizationMetrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig: Generator evaluation
// input config.
type GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig struct {
	// InputDataConfig: Required. The config/source of input data.
	InputDataConfig *GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig `json:"inputDataConfig,omitempty"`
	// OutputGcsBucketPath: Required. The output Cloud Storage bucket path to store
	// eval files, e.g. per_summary_accuracy_score report. This path is provided by
	// customer and files stored in it are visible to customer, no internal data
	// should be stored in this path.
	OutputGcsBucketPath string `json:"outputGcsBucketPath,omitempty"`
	// SummarizationConfig: Evaluation configs for summarization generator.
	SummarizationConfig *GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputDataConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputDataConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConf
// ig: The distinctive configs for Agent Assist conversations as the
// conversation source.
type GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig struct {
	// EndTime: Required. The end of the time range for conversations to be
	// evaluated. Only conversations ended at or before this timestamp will be
	// sampled.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Required. The start of the time range for conversations to be
	// evaluated. Only conversations created at or after this timestamp will be
	// sampled.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig:
// The distinctive configs for dataset as the conversation source.
type GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig struct {
	// Dataset: Required. The identifier of the dataset to be evaluated. Format:
	// `projects//locations//datasets/`.
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig: Input
// data config details
type GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig struct {
	// AgentAssistInputDataConfig: The distinctive configs for Agent Assist
	// conversations as the conversation source.
	AgentAssistInputDataConfig *GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig `json:"agentAssistInputDataConfig,omitempty"`
	// DatasetInputDataConfig: The distinctive configs for dataset as the
	// conversation source.
	DatasetInputDataConfig *GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig `json:"datasetInputDataConfig,omitempty"`
	// EndTime: Optional. The end timestamp to fetch conversation data.
	EndTime string `json:"endTime,omitempty"`
	// InputDataSourceType: Required. The source type of input data.
	//
	// Possible values:
	//   "INPUT_DATA_SOURCE_TYPE_UNSPECIFIED" - Unspecified InputDataSourceType.
	// Should not be used.
	//   "AGENT_ASSIST_CONVERSATIONS" - Fetch data from Agent Assist storage. If
	// this source type is chosen, input_data_config.start_time and
	// input_data_config.end_timestamp must be provided.
	//   "INSIGHTS_CONVERSATIONS" - Fetch data from Insights storage. If this
	// source type is chosen, input_data_config.start_time and
	// input_data_config.end_timestamp must be provided.
	InputDataSourceType string `json:"inputDataSourceType,omitempty"`
	// IsSummaryGenerationAllowed: Optional. Whether the summary generation is
	// allowed when the pre-existing qualified summaries are insufficient to cover
	// the sample size.
	IsSummaryGenerationAllowed bool `json:"isSummaryGenerationAllowed,omitempty"`
	// SampleSize: Optional. Desired number of conversation-summary pairs to be
	// evaluated.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// StartTime: Optional. The start timestamp to fetch conversation data.
	StartTime string `json:"startTime,omitempty"`
	// SummaryGenerationOption: Optional. Option to control whether summaries are
	// generated during evaluation.
	//
	// Possible values:
	//   "SUMMARY_GENERATION_OPTION_UNSPECIFIED" - Default option will not be used
	//   "ALWAYS_GENERATE" - Always Generate summary for all conversations.
	//   "GENERATE_IF_MISSING" - Gnerate only missing summaries.
	//   "DO_NOT_GENERATE" - Do not generate new summaries. Only use existing
	// summaries found.
	SummaryGenerationOption string `json:"summaryGenerationOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAssistInputDataConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAssistInputDataConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig:
// Evaluation configs for summarization generator.
type GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig struct {
	// AccuracyEvaluationVersion: Optional. Version for summarization accuracy.
	// This will determine the prompt and model used at backend.
	AccuracyEvaluationVersion string `json:"accuracyEvaluationVersion,omitempty"`
	// CompletenessEvaluationVersion: Optional. Version for summarization
	// completeness. This will determine the prompt and model used at backend.
	CompletenessEvaluationVersion string `json:"completenessEvaluationVersion,omitempty"`
	// EnableAccuracyEvaluation: Optional. Enable accuracy evaluation.
	EnableAccuracyEvaluation bool `json:"enableAccuracyEvaluation,omitempty"`
	// EnableCompletenessEvaluation: Optional. Enable completeness evaluation.
	EnableCompletenessEvaluation bool `json:"enableCompletenessEvaluation,omitempty"`
	// EvaluatorVersion: Optional. Version for summarization evaluation.
	EvaluatorVersion string `json:"evaluatorVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccuracyEvaluationVersion")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccuracyEvaluationVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorSuggestion: Suggestion generated using
// a Generator.
type GoogleCloudDialogflowV2beta1GeneratorSuggestion struct {
	// AgentCoachingSuggestion: Optional. Suggestion to coach the agent.
	AgentCoachingSuggestion *GoogleCloudDialogflowV2beta1AgentCoachingSuggestion `json:"agentCoachingSuggestion,omitempty"`
	// FreeFormSuggestion: Optional. Free form suggestion.
	FreeFormSuggestion *GoogleCloudDialogflowV2beta1FreeFormSuggestion `json:"freeFormSuggestion,omitempty"`
	// SummarySuggestion: Optional. Suggested summary.
	SummarySuggestion *GoogleCloudDialogflowV2beta1SummarySuggestion `json:"summarySuggestion,omitempty"`
	// ToolCallInfo: Optional. List of request and response for tool calls
	// executed.
	ToolCallInfo []*GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo: Request and
// response for a tool call.
type GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo struct {
	// ToolCall: Required. Request for a tool call.
	ToolCall *GoogleCloudDialogflowV2beta1ToolCall `json:"toolCall,omitempty"`
	// ToolCallResult: Required. Response for a tool call.
	ToolCallResult *GoogleCloudDialogflowV2beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig: Defines the Human
// Agent Assistant to connect to a conversation.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig struct {
	// EndUserSuggestionConfig: Configuration for agent assistance of end user
	// participant. Currently, this feature is not general available, please
	// contact Google to get access.
	EndUserSuggestionConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig `json:"endUserSuggestionConfig,omitempty"`
	// HumanAgentSuggestionConfig: Configuration for agent assistance of human
	// agent participant.
	HumanAgentSuggestionConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig `json:"humanAgentSuggestionConfig,omitempty"`
	// MessageAnalysisConfig: Configuration for message analysis.
	MessageAnalysisConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig `json:"messageAnalysisConfig,omitempty"`
	// NotificationConfig: Pub/Sub topic on which to publish new agent assistant
	// events.
	NotificationConfig *GoogleCloudDialogflowV2beta1NotificationConfig `json:"notificationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndUserSuggestionConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndUserSuggestionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig:
//
//	Custom conversation models used in agent assist feature. Supported feature:
//
// ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY, CONVERSATION_SUMMARIZATION.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig struct {
	// BaselineModelVersion: Version of current baseline model. It will be ignored
	// if model is set. Valid versions are: - Article Suggestion baseline model: -
	// 0.9 - 1.0 (default) - Summarization baseline model: - 1.0
	BaselineModelVersion string `json:"baselineModelVersion,omitempty"`
	// Model: Conversation model resource name. Format:
	// `projects//conversationModels/`.
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaselineModelVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaselineModelVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfi
// g: Config to process conversation.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig struct {
	// RecentSentencesCount: Number of recent non-small-talk sentences to use as
	// context for article and FAQ suggestion
	RecentSentencesCount int64 `json:"recentSentencesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecentSentencesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecentSentencesCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig:
// Configuration for analyses to run on each conversation message.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig struct {
	// EnableEntityExtraction: Enable entity extraction in conversation messages on
	// agent assist stage
	// (https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
	// If unspecified, defaults to false. Currently, this feature is not general
	// available, please contact Google to get access.
	EnableEntityExtraction bool `json:"enableEntityExtraction,omitempty"`
	// EnableSentimentAnalysis: Enable sentiment analysis in conversation messages
	// on agent assist stage
	// (https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
	// If unspecified, defaults to false. Sentiment analysis inspects user input
	// and identifies the prevailing subjective opinion, especially to determine a
	// user's attitude as positive, negative, or neutral:
	// https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For
	// Participants.StreamingAnalyzeContent method, result will be in
	// StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For
	// Participants.AnalyzeContent method, result will be in
	// AnalyzeContentResponse.message.SentimentAnalysisResult For
	// Conversations.ListMessages method, result will be in
	// ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub
	// notification is configured, result will be in
	// ConversationEvent.new_message_payload.SentimentAnalysisResult.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableEntityExtraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableEntityExtraction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig:
// Detail human agent assistant config.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig struct {
	// DisableHighLatencyFeaturesSyncDelivery: Optional. When
	// disable_high_latency_features_sync_delivery is true and using the
	// AnalyzeContent API, we will not deliver the responses from high latency
	// features in the API response. The
	// human_agent_assistant_config.notification_config must be configured and
	// enable_event_based_suggestion must be set to true to receive the responses
	// from high latency features in Pub/Sub. High latency feature(s):
	// KNOWLEDGE_ASSIST
	DisableHighLatencyFeaturesSyncDelivery bool `json:"disableHighLatencyFeaturesSyncDelivery,omitempty"`
	// EnableAsyncToolCall: Optional. If true, enable asynchronous execution of
	// tools.
	EnableAsyncToolCall bool `json:"enableAsyncToolCall,omitempty"`
	// FeatureConfigs: Configuration of different suggestion features. One feature
	// can have only one config.
	FeatureConfigs []*GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig `json:"featureConfigs,omitempty"`
	// Generators: Optional. List of various generator resource names used in the
	// conversation profile.
	Generators []string `json:"generators,omitempty"`
	// GroupSuggestionResponses: If `group_suggestion_responses` is false, and
	// there are multiple `feature_configs` in `event based suggestion` or
	// StreamingAnalyzeContent, we will try to deliver suggestions to customers as
	// soon as we get new suggestion. Different type of suggestions based on the
	// same context will be in separate Pub/Sub event or
	// `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to
	// true. All the suggestions to the same participant based on the same context
	// will be grouped into a single Pub/Sub event or
	// StreamingAnalyzeContentResponse.
	GroupSuggestionResponses bool `json:"groupSuggestionResponses,omitempty"`
	// SkipEmptyEventBasedSuggestion: Optional. Enable skipping event based
	// suggestion if the suggestion is empty. For example, with this field
	// disabled, Knowledge Assist feature sends a Pub/Sub message when there are no
	// suggestions. Enabling this field will change the behavior to skip the
	// Pub/Sub message in this situation.
	SkipEmptyEventBasedSuggestion bool `json:"skipEmptyEventBasedSuggestion,omitempty"`
	// UseUnredactedConversationData: Optional. If true, use unredacted transcript
	// data (Supported features: AI_COACH) and use unredacted ingested context
	// (Supported features: All Agent Assist features)
	UseUnredactedConversationData bool `json:"useUnredactedConversationData,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DisableHighLatencyFeaturesSyncDelivery") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "DisableHighLatencyFeaturesSyncDelivery") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig:
//
//	Config for suggestion features.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig struct {
	// ConversationModelConfig: Configs of custom conversation model.
	ConversationModelConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig `json:"conversationModelConfig,omitempty"`
	// ConversationProcessConfig: Configs for processing conversation.
	ConversationProcessConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig `json:"conversationProcessConfig,omitempty"`
	// DisableAgentQueryLogging: Optional. Disable the logging of search queries
	// sent by human agents. It can prevent those queries from being stored at
	// answer records. Supported features: KNOWLEDGE_SEARCH.
	DisableAgentQueryLogging bool `json:"disableAgentQueryLogging,omitempty"`
	// EnableConversationAugmentedQuery: Optional. Enable including conversation
	// context during query answer generation. Supported features:
	// KNOWLEDGE_SEARCH.
	EnableConversationAugmentedQuery bool `json:"enableConversationAugmentedQuery,omitempty"`
	// EnableEventBasedSuggestion: Automatically iterates all participants and
	// tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ,
	// DIALOGFLOW_ASSIST, ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
	EnableEventBasedSuggestion bool `json:"enableEventBasedSuggestion,omitempty"`
	// EnableQuerySuggestionOnly: Optional. Enable query suggestion only. Supported
	// features: KNOWLEDGE_ASSIST
	EnableQuerySuggestionOnly bool `json:"enableQuerySuggestionOnly,omitempty"`
	// EnableQuerySuggestionWhenNoAnswer: Optional. Enable query suggestion even if
	// we can't find its answer. By default, queries are suggested only if we find
	// its answer. Supported features: KNOWLEDGE_ASSIST
	EnableQuerySuggestionWhenNoAnswer bool `json:"enableQuerySuggestionWhenNoAnswer,omitempty"`
	// EnableResponseDebugInfo: Optional. Enable returning detailed reasons for
	// suggestion results. For example, with this field disabled, Knowledge Search
	// feature returns NotFound error when no answer is found for the input query.
	// Enabling this field will change the behavior to return an OK response with
	// detailed information indicating the lack of results. Supported features:
	// KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST
	EnableResponseDebugInfo bool `json:"enableResponseDebugInfo,omitempty"`
	// QueryConfig: Configs of query.
	QueryConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig `json:"queryConfig,omitempty"`
	// RaiSettings: Optional. Settings for Responsible AI checks. Supported
	// features: KNOWLEDGE_ASSIST
	RaiSettings *GoogleCloudDialogflowV2beta1RaiSettings `json:"raiSettings,omitempty"`
	// SuggestionFeature: The suggestion feature.
	SuggestionFeature *GoogleCloudDialogflowV2beta1SuggestionFeature `json:"suggestionFeature,omitempty"`
	// SuggestionTriggerSettings: Settings of suggestion trigger. Currently, only
	// ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use this field.
	SuggestionTriggerSettings *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings `json:"suggestionTriggerSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModelConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModelConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig:
// Config for suggestion query.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig struct {
	// ConfidenceThreshold: Confidence threshold of query result. Agent Assist
	// gives each suggestion a score in the range [0.0, 1.0], based on the
	// relevance between the suggestion and the current conversation context. A
	// score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only
	// suggestions with a score greater than or equal to the value of this field
	// are included in the results. For a baseline model (the default), the
	// recommended value is in the range [0.05, 0.1]. For a custom model, there is
	// no recommended value. Tune this value by starting from a very low value and
	// slowly increasing until you have desired results. If this field is not set,
	// it is default to 0.0, which means that all suggestions are returned.
	// Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
	// KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
	ConfidenceThreshold float64 `json:"confidenceThreshold,omitempty"`
	// ContextFilterSettings: Determines how recent conversation context is
	// filtered when generating suggestions. If unspecified, no messages will be
	// dropped.
	ContextFilterSettings *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings `json:"contextFilterSettings,omitempty"`
	// ContextSize: Optional. The number of recent messages to include in the
	// context. Supported features: KNOWLEDGE_ASSIST.
	ContextSize int64 `json:"contextSize,omitempty"`
	// DialogflowQuerySource: Query from Dialogflow agent. It is used by
	// DIALOGFLOW_ASSIST, ENTITY_EXTRACTION.
	DialogflowQuerySource *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource `json:"dialogflowQuerySource,omitempty"`
	// DocumentQuerySource: Query from knowledge base document. It is used by:
	// SMART_REPLY, SMART_COMPOSE.
	DocumentQuerySource *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource `json:"documentQuerySource,omitempty"`
	// KnowledgeBaseQuerySource: Query from knowledgebase. It is used by:
	// ARTICLE_SUGGESTION, FAQ.
	KnowledgeBaseQuerySource *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource `json:"knowledgeBaseQuerySource,omitempty"`
	// MaxResults: Maximum number of results to return. Currently, if unset,
	// defaults to 10. And the max number is 20.
	MaxResults int64 `json:"maxResults,omitempty"`
	// Sections: Optional. The customized sections chosen to return when requesting
	// a summary of a conversation.
	Sections *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections `json:"sections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceThreshold") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig
	var s1 struct {
		ConfidenceThreshold gensupport.JSONFloat64 `json:"confidenceThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceThreshold = float64(s1.ConfidenceThreshold)
	return nil
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigCon
// textFilterSettings: Settings that determine how to filter recent
// conversation context when generating suggestions.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings struct {
	// DropHandoffMessages: If set to true, the last message from virtual agent
	// (hand off message) and the message before it (trigger message of hand off)
	// are dropped.
	DropHandoffMessages bool `json:"dropHandoffMessages,omitempty"`
	// DropIvrMessages: If set to true, all messages from ivr stage are dropped.
	DropIvrMessages bool `json:"dropIvrMessages,omitempty"`
	// DropVirtualAgentMessages: If set to true, all messages from virtual agent
	// are dropped.
	DropVirtualAgentMessages bool `json:"dropVirtualAgentMessages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DropHandoffMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DropHandoffMessages") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDia
// logflowQuerySource: Dialogflow source setting. Supported feature:
// DIALOGFLOW_ASSIST, ENTITY_EXTRACTION.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource struct {
	// Agent: Required. The name of a dialogflow virtual agent used for end user
	// side intent detection and suggestion. Format: `projects//locations//agent`.
	// When multiple agents are allowed in the same Dialogflow project.
	Agent string `json:"agent,omitempty"`
	// HumanAgentSideConfig: The Dialogflow assist configuration for human agent.
	HumanAgentSideConfig *GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig `json:"humanAgentSideConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDia
// logflowQuerySourceHumanAgentSideConfig: The configuration used for human
// agent side Dialogflow assist suggestion.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig struct {
	// Agent: Optional. The name of a dialogflow virtual agent used for intent
	// detection and suggestion triggered by human agent. Format:
	// `projects//locations//agent`.
	Agent string `json:"agent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDoc
// umentQuerySource: Document source settings. Supported features: SMART_REPLY,
// SMART_COMPOSE.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource struct {
	// Documents: Required. Knowledge documents to query from. Format:
	// `projects//locations//knowledgeBases//documents/`. Currently, only one
	// document is supported.
	Documents []string `json:"documents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Documents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKno
// wledgeBaseQuerySource: Knowledge base source settings. Supported features:
// ARTICLE_SUGGESTION, FAQ.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource struct {
	// KnowledgeBases: Required. Knowledge bases to query. Format:
	// `projects//locations//knowledgeBases/`. Currently, only one knowledge base
	// is supported.
	KnowledgeBases []string `json:"knowledgeBases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KnowledgeBases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KnowledgeBases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSec
// tions: Custom sections to return when requesting a summary of a
// conversation. This is only supported when `baseline_model_version` == '2.0'.
// Supported features: CONVERSATION_SUMMARIZATION,
// CONVERSATION_SUMMARIZATION_VOICE.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections struct {
	// SectionTypes: The selected sections chosen to return when requesting a
	// summary of a conversation. A duplicate selected section will be treated as a
	// single selected section. If section types are not provided, the default will
	// be {SITUATION, ACTION, RESULT}.
	//
	// Possible values:
	//   "SECTION_TYPE_UNSPECIFIED" - Undefined section type, does not return
	// anything.
	//   "SITUATION" - What the customer needs help with or has question about.
	// Section name: "situation".
	//   "ACTION" - What the agent does to help the customer. Section name:
	// "action".
	//   "RESOLUTION" - Result of the customer service. A single word describing
	// the result of the conversation. Section name: "resolution".
	//   "REASON_FOR_CANCELLATION" - Reason for cancellation if the customer
	// requests for a cancellation. "N/A" otherwise. Section name:
	// "reason_for_cancellation".
	//   "CUSTOMER_SATISFACTION" - "Unsatisfied" or "Satisfied" depending on the
	// customer's feelings at the end of the conversation. Section name:
	// "customer_satisfaction".
	//   "ENTITIES" - Key entities extracted from the conversation, such as ticket
	// number, order number, dollar amount, etc. Section names are prefixed by
	// "entities/".
	SectionTypes []string `json:"sectionTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SectionTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SectionTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSetting
// s: Settings of suggestion trigger.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings struct {
	// NoSmallTalk: Do not trigger if last utterance is small talk.
	NoSmallTalk bool `json:"noSmallTalk,omitempty"`
	// OnlyEndUser: Only trigger suggestion if participant role of last utterance
	// is END_USER.
	OnlyEndUser bool `json:"onlyEndUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoSmallTalk") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoSmallTalk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent: Output only.
// Represents a notification sent to Pub/Sub subscribers for agent assistant
// events in a specific conversation.
type GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent struct {
	// Conversation: The conversation this notification refers to. Format:
	// `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// Participant: The participant that the suggestion is compiled for. And This
	// field is used to call Participants.ListSuggestions API. Format:
	// `projects//conversations//participants/`. It will not be set in legacy
	// workflow. HumanAgentAssistantConfig.name for more information.
	Participant string `json:"participant,omitempty"`
	// SuggestionResults: The suggestion results payload that this notification
	// refers to. It will only be set when
	// HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses sets
	// to true.
	SuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig: Defines the hand off to
// a live agent, typically on which external agent service provider to connect
// to a conversation. Currently, this feature is not general available, please
// contact Google to get access.
type GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig struct {
	// LivePersonConfig: Uses LivePerson (https://www.liveperson.com).
	LivePersonConfig *GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig `json:"livePersonConfig,omitempty"`
	// SalesforceLiveAgentConfig: Uses Salesforce Live Agent.
	SalesforceLiveAgentConfig *GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig `json:"salesforceLiveAgentConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LivePersonConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LivePersonConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig:
// Configuration specific to LivePerson (https://www.liveperson.com).
type GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig struct {
	// AccountNumber: Required. Account number of the LivePerson account to
	// connect. This is the account number you input at the login page.
	AccountNumber string `json:"accountNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig:
//
//	Configuration specific to Salesforce Live Agent.
type GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig struct {
	// ButtonId: Required. Live Agent chat button ID.
	ButtonId string `json:"buttonId,omitempty"`
	// DeploymentId: Required. Live Agent deployment ID.
	DeploymentId string `json:"deploymentId,omitempty"`
	// EndpointDomain: Required. Domain of the Live Agent endpoint for this agent.
	// You can find the endpoint URL in the `Live Agent settings` page. For example
	// if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you
	// should fill in d.la4-c2-phx.salesforceliveagent.com.
	EndpointDomain string `json:"endpointDomain,omitempty"`
	// OrganizationId: Required. The organization ID of the Salesforce account.
	OrganizationId string `json:"organizationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ButtonId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ButtonId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ImportAgentRequest: The request message for
// Agents.ImportAgent.
type GoogleCloudDialogflowV2beta1ImportAgentRequest struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a Google Cloud Storage file containing the agent to
	// import. Note: The URI must start with "gs://". Dialogflow performs a read
	// operation for the Cloud Storage object on the caller's behalf, so your
	// request authentication must have read permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ImportDocumentTemplate: The template used for
// importing documents.
type GoogleCloudDialogflowV2beta1ImportDocumentTemplate struct {
	// KnowledgeTypes: Required. The knowledge type of document content.
	//
	// Possible values:
	//   "KNOWLEDGE_TYPE_UNSPECIFIED" - The type is unspecified or arbitrary.
	//   "FAQ" - The document content contains question and answer pairs as either
	// HTML or CSV. Typical FAQ HTML formats are parsed accurately, but unusual
	// formats may fail to be parsed. CSV must have questions in the first column
	// and answers in the second, with no header. Because of this explicit format,
	// they are always parsed accurately.
	//   "EXTRACTIVE_QA" - Documents for which unstructured text is extracted and
	// used for question answering.
	//   "ARTICLE_SUGGESTION" - The entire document content as a whole can be used
	// for query results. Only for Contact Center Solutions on Dialogflow.
	//   "AGENT_FACING_SMART_REPLY" - The document contains agent-facing Smart
	// Reply entries.
	//   "SMART_REPLY" - The legacy enum for agent-facing smart reply feature.
	KnowledgeTypes []string `json:"knowledgeTypes,omitempty"`
	// Metadata: Metadata for the document. The metadata supports arbitrary
	// key-value pairs. Suggested use cases include storing a document's title, an
	// external URL distinct from the document's content_uri, etc. The max size of
	// a `key` or a `value` of the metadata is 1024 bytes.
	Metadata map[string]string `json:"metadata,omitempty"`
	// MimeType: Required. The MIME type of the document.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KnowledgeTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KnowledgeTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportDocumentTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ImportDocumentsRequest: Request message for
// Documents.ImportDocuments.
type GoogleCloudDialogflowV2beta1ImportDocumentsRequest struct {
	// DocumentTemplate: Required. Document template used for importing all the
	// documents.
	DocumentTemplate *GoogleCloudDialogflowV2beta1ImportDocumentTemplate `json:"documentTemplate,omitempty"`
	// GcsSource: Optional. The Google Cloud Storage location for the documents.
	// The path can include a wildcard. These URIs may have the forms `gs:///`.
	// `gs:////*.`.
	GcsSource *GoogleCloudDialogflowV2beta1GcsSources `json:"gcsSource,omitempty"`
	// ImportGcsCustomMetadata: Whether to import custom metadata from Google Cloud
	// Storage. Only valid when the document source is Google Cloud Storage URI.
	ImportGcsCustomMetadata bool `json:"importGcsCustomMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ImportDocumentsResponse: Response message for
// Documents.ImportDocuments.
type GoogleCloudDialogflowV2beta1ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1InferenceParameter: The parameters of inference.
type GoogleCloudDialogflowV2beta1InferenceParameter struct {
	// MaxOutputTokens: Optional. Maximum number of the output tokens for the
	// generator.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// Temperature: Optional. Controls the randomness of LLM predictions. Low
	// temperature = less random. High temperature = more random. If unset (or 0),
	// uses a default value of 0.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. Top-k changes how the model selects tokens for output. A
	// top-k of 1 means the selected token is the most probable among all tokens in
	// the model's vocabulary (also called greedy decoding), while a top-k of 3
	// means that the next token is selected from among the 3 most probable tokens
	// (using temperature). For each token selection step, the top K tokens with
	// the highest probabilities are sampled. Then tokens are further filtered
	// based on topP with the final token selected using temperature sampling.
	// Specify a lower value for less random responses and a higher value for more
	// random responses. Acceptable value is [1, 40], default to 40.
	TopK int64 `json:"topK,omitempty"`
	// TopP: Optional. Top-p changes how the model selects tokens for output.
	// Tokens are selected from most K (see topK parameter) probable to least until
	// the sum of their probabilities equals the top-p value. For example, if
	// tokens A, B, and C have a probability of 0.3, 0.2, and 0.1 and the top-p
	// value is 0.5, then the model will select either A or B as the next token
	// (using temperature) and doesn't consider C. The default top-p value is 0.95.
	// Specify a lower value for less random responses and a higher value for more
	// random responses. Acceptable value is [0.0, 1.0], default to 0.95.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxOutputTokens") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxOutputTokens") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InferenceParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InferenceParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1InferenceParameter) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1InferenceParameter
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudDialogflowV2beta1IngestContextReferencesRequest: The request
// message for ConversationsService.IngestContextReferences.
type GoogleCloudDialogflowV2beta1IngestContextReferencesRequest struct {
	// ContextReferences: Required. The context references to ingest. The key is
	// the name of the context reference and the value contains the contents of the
	// context reference. The key is used to incorporate ingested context
	// references to enhance the generator.
	ContextReferences map[string]GoogleCloudDialogflowV2beta1ConversationContextReference `json:"contextReferences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferences") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestContextReferencesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestContextReferencesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IngestContextReferencesResponse: The response
// message for ConversationsService.IngestContextReferences.
type GoogleCloudDialogflowV2beta1IngestContextReferencesResponse struct {
	// IngestedContextReferences: All context references ingested.
	IngestedContextReferences map[string]GoogleCloudDialogflowV2beta1ConversationContextReference `json:"ingestedContextReferences,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IngestedContextReferences")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestedContextReferences") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestContextReferencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestContextReferencesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata: Metadata for
// initializing a location-level encryption specification.
type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata struct {
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest: The request to
// initialize a location-level encryption specification.
type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the kms_key_name is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudDialogflowV2beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1InputAudioConfig: Instructs the speech
// recognizer on how to process the audio content.
type GoogleCloudDialogflowV2beta1InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed little-endian
	// samples (Linear PCM).
	//   "AUDIO_ENCODING_FLAC" - [`FLAC`](https://xiph.org/flac/documentation.html)
	// (Free Lossless Audio Codec) is the recommended encoding because it is
	// lossless (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio samples
	// using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must be
	// 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is required,
	// `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has a
	// header byte in each block, as in MIME type `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in [RFC
	// 5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence of
	// blocks, one block per RTP packet. Each block starts with a byte containing
	// the length of the block, in bytes, followed by one or more frames of Speex
	// data, padded to an integral number of bytes (octets) as specified in RFC
	// 5574. In other words, each RTP header is replaced with a single byte
	// containing the block length. Only Speex wideband is supported.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio samples
	// using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// BargeInConfig: Configuration of barge-in behavior during the streaming of
	// input audio.
	BargeInConfig *GoogleCloudDialogflowV2beta1BargeInConfig `json:"bargeInConfig,omitempty"`
	// DefaultNoSpeechTimeout: If set, use this no-speech timeout when the agent
	// does not provide a no-speech timeout itself.
	DefaultNoSpeechTimeout string `json:"defaultNoSpeechTimeout,omitempty"`
	// DisableNoSpeechRecognizedEvent: Only used in Participants.AnalyzeContent and
	// Participants.StreamingAnalyzeContent. If `false` and recognition doesn't
	// return any result, trigger `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
	DisableNoSpeechRecognizedEvent bool `json:"disableNoSpeechRecognizedEvent,omitempty"`
	// EnableAutomaticPunctuation: Enable automatic punctuation option at the
	// speech backend.
	EnableAutomaticPunctuation bool `json:"enableAutomaticPunctuation,omitempty"`
	// EnableWordInfo: If `true`, Dialogflow returns SpeechWordInfo in
	// StreamingRecognitionResult with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`
	// LanguageCode: Required. The language of the supplied audio. Dialogflow does
	// not do translations. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language. If not set,
	// the language is inferred from the ConversationProfile.stt_config.
	LanguageCode string `json:"languageCode,omitempty"`
	// Model: Optional. Which Speech model to select for the given request. For
	// more information, see Speech models
	// (https://cloud.google.com/dialogflow/es/docs/speech-models).
	Model string `json:"model,omitempty"`
	// ModelVariant: Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In this
	// case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech model
	// that the caller is eligible for. Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for how to make
	// your project eligible for enhanced models.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced model is
	// available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced variant
	// does not exist for the given model and request language, Dialogflow falls
	// back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// describes which models have enhanced variants. * If the API caller isn't
	// eligible for enhanced models, Dialogflow returns an error. Please see the
	// [Dialogflow docs](https://cloud.google.com/dialogflow/docs/data-logging) for
	// how to make your project eligible.
	ModelVariant string `json:"modelVariant,omitempty"`
	// OptOutConformerModelMigration: If `true`, the request will opt out for STT
	// conformer model migration. This field will be deprecated once force
	// migration takes place in June 2024. Please refer to Dialogflow ES Speech
	// model migration
	// (https://cloud.google.com/dialogflow/es/docs/speech-model-migration).
	OptOutConformerModelMigration bool `json:"optOutConformerModelMigration,omitempty"`
	// PhraseHints: A list of strings containing words and phrases that the speech
	// recognizer should recognize with higher likelihood. See the Cloud Speech
	// documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details. This field is deprecated. Please use `speech_contexts` () instead.
	// If you specify both `phrase_hints` () and `speech_contexts` (), Dialogflow
	// will treat the `phrase_hints` () as a single additional `SpeechContext` ().
	PhraseHints []string `json:"phraseHints,omitempty"`
	// PhraseSets: A collection of phrase set resources to use for speech
	// adaptation.
	PhraseSets []string `json:"phraseSets,omitempty"`
	// SampleRateHertz: Required. Sample rate (in Hertz) of the audio content sent
	// in the query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SingleUtterance: If `false` (default), recognition does not cease until the
	// client closes the stream. If `true`, the recognizer will detect a single
	// spoken utterance in input audio. Recognition ceases when it detects the
	// audio's voice has stopped or paused. In this case, once a detected intent is
	// received, the client should close the stream and start a new request with a
	// new stream as needed. Note: This setting is relevant only for streaming
	// methods. Note: When specified, InputAudioConfig.single_utterance takes
	// precedence over StreamingDetectIntentRequest.single_utterance.
	SingleUtterance bool `json:"singleUtterance,omitempty"`
	// SpeechContexts: Context information to assist speech recognition. See the
	// Cloud Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details.
	SpeechContexts []*GoogleCloudDialogflowV2beta1SpeechContext `json:"speechContexts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1Intent: An intent categorizes an end-user's
// intention for one conversation turn. For each agent, you define many
// intents, where your combined intents can handle a complete conversation.
// When an end-user writes or says something, referred to as an end-user
// expression or end-user input, Dialogflow matches the end-user input to the
// best intent in your agent. Matching an intent is also known as intent
// classification. For more information, see the intent guide
// (https://cloud.google.com/dialogflow/docs/intents-overview).
type GoogleCloudDialogflowV2beta1Intent struct {
	// Action: Optional. The name of the action associated with the intent. Note:
	// The action name must not contain whitespaces.
	Action string `json:"action,omitempty"`
	// DefaultResponsePlatforms: Optional. The list of platforms for which the
	// first responses will be copied from the messages in PLATFORM_UNSPECIFIED
	// (i.e. default platform).
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Not specified.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "TELEPHONY" - Telephony Gateway.
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	DefaultResponsePlatforms []string `json:"defaultResponsePlatforms,omitempty"`
	// DisplayName: Required. The name of this intent.
	DisplayName string `json:"displayName,omitempty"`
	// EndInteraction: Optional. Indicates that this intent ends an interaction.
	// Some integrations (e.g., Actions on Google or Dialogflow phone gateway) use
	// this information to close interaction with an end user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`
	// Events: Optional. The collection of event names that trigger the intent. If
	// the collection of input contexts is not empty, all of the contexts must be
	// present in the active user session for an event to trigger this intent.
	// Event names are limited to 150 characters.
	Events []string `json:"events,omitempty"`
	// FollowupIntentInfo: Output only. Information about all followup intents that
	// have this intent as a direct or indirect parent. We populate this field only
	// in the output.
	FollowupIntentInfo []*GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	// InputContextNames: Optional. The list of context names required for this
	// intent to be triggered. Formats: - `projects//agent/sessions/-/contexts/` -
	// `projects//locations//agent/sessions/-/contexts/`
	InputContextNames []string `json:"inputContextNames,omitempty"`
	// IsFallback: Optional. Indicates whether this is a fallback intent.
	IsFallback bool `json:"isFallback,omitempty"`
	// LiveAgentHandoff: Optional. Indicates that a live agent should be brought in
	// to handle the interaction with the user. In most cases, when you set this
	// flag to true, you would also want to set end_interaction to true as well.
	// Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`
	// Messages: Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*GoogleCloudDialogflowV2beta1IntentMessage `json:"messages,omitempty"`
	// MlDisabled: Optional. Indicates whether Machine Learning is disabled for the
	// intent. Note: If `ml_disabled` setting is set to true, then this intent is
	// not taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `json:"mlDisabled,omitempty"`
	// MlEnabled: Optional. Indicates whether Machine Learning is enabled for the
	// intent. Note: If `ml_enabled` setting is set to false, then this intent is
	// not taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off. DEPRECATED! Please use `ml_disabled`
	// field instead. NOTE: If both `ml_enabled` and `ml_disabled` are either not
	// set or false, then the default value is determined as follows: - Before
	// April 15th, 2018 the default is: ml_enabled = false / ml_disabled = true. -
	// After April 15th, 2018 the default is: ml_enabled = true / ml_disabled =
	// false.
	MlEnabled bool `json:"mlEnabled,omitempty"`
	// Name: Optional. The unique identifier of this intent. Required for
	// Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Supported
	// formats: - `projects//agent/intents/` -
	// `projects//locations//agent/intents/`
	Name string `json:"name,omitempty"`
	// OutputContexts: Optional. The collection of contexts that are activated when
	// the intent is matched. Context messages in this collection should not set
	// the parameters field. Setting the `lifespan_count` to 0 will reset the
	// context when the intent is matched. Format:
	// `projects//agent/sessions/-/contexts/`.
	OutputContexts []*GoogleCloudDialogflowV2beta1Context `json:"outputContexts,omitempty"`
	// Parameters: Optional. The collection of parameters associated with the
	// intent.
	Parameters []*GoogleCloudDialogflowV2beta1IntentParameter `json:"parameters,omitempty"`
	// ParentFollowupIntentName: Optional. The unique identifier of the parent
	// intent in the chain of followup intents. You can set this field when
	// creating an intent, for example with CreateIntent or BatchUpdateIntents, in
	// order to make this intent a followup intent. It identifies the parent
	// followup intent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// Priority: Optional. The priority of this intent. Higher numbers represent
	// higher priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// ResetContexts: Optional. Indicates whether to delete all contexts in the
	// current session when this intent is matched.
	ResetContexts bool `json:"resetContexts,omitempty"`
	// RootFollowupIntentName: Output only. The unique identifier of the root
	// intent in the chain of followup intents. It identifies the correct followup
	// intents chain for this intent. Format: `projects//agent/intents/`.
	RootFollowupIntentName string `json:"rootFollowupIntentName,omitempty"`
	// TrainingPhrases: Optional. The collection of examples that the agent is
	// trained on.
	TrainingPhrases []*GoogleCloudDialogflowV2beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// WebhookState: Optional. Indicates whether webhooks are enabled for the
	// intent.
	//
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED" - Webhook is disabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED" - Webhook is enabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING" - Webhook is enabled in the agent
	// and in the intent. Also, each slot filling prompt is forwarded to the
	// webhook.
	WebhookState string `json:"webhookState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentBatch: This message is a wrapper around a
// collection of intents.
type GoogleCloudDialogflowV2beta1IntentBatch struct {
	// Intents: A collection of intents.
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentBatch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo: Represents a single
// followup intent in the chain.
type GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo struct {
	// FollowupIntentName: The unique identifier of the followup intent. Format:
	// `projects//agent/intents/`.
	FollowupIntentName string `json:"followupIntentName,omitempty"`
	// ParentFollowupIntentName: The unique identifier of the followup intent's
	// parent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentInput: Represents the intent to trigger
// programmatically rather than as a result of natural language processing. The
// intent input is only used for V3 agent.
type GoogleCloudDialogflowV2beta1IntentInput struct {
	// Intent: Required. The unique identifier of the intent in V3 agent. Format:
	// `projects//locations//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// LanguageCode: Required. The language of this conversational query. See
	// Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessage: Corresponds to the `Response`
// field in the Dialogflow console.
type GoogleCloudDialogflowV2beta1IntentMessage struct {
	// BasicCard: Displays a basic card for Actions on Google.
	BasicCard *GoogleCloudDialogflowV2beta1IntentMessageBasicCard `json:"basicCard,omitempty"`
	// BrowseCarouselCard: Browse carousel card for Actions on Google.
	BrowseCarouselCard *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	// Card: Displays a card.
	Card *GoogleCloudDialogflowV2beta1IntentMessageCard `json:"card,omitempty"`
	// CarouselSelect: Displays a carousel card for Actions on Google.
	CarouselSelect *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect `json:"carouselSelect,omitempty"`
	// Image: Displays an image.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// LinkOutSuggestion: Displays a link out suggestion chip for Actions on
	// Google.
	LinkOutSuggestion *GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion `json:"linkOutSuggestion,omitempty"`
	// ListSelect: Displays a list card for Actions on Google.
	ListSelect *GoogleCloudDialogflowV2beta1IntentMessageListSelect `json:"listSelect,omitempty"`
	// MediaContent: The media content card for Actions on Google.
	MediaContent *GoogleCloudDialogflowV2beta1IntentMessageMediaContent `json:"mediaContent,omitempty"`
	// Payload: A custom platform-specific response.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Platform: Optional. The platform that this message is intended for.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Not specified.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "TELEPHONY" - Telephony Gateway.
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	Platform string `json:"platform,omitempty"`
	// QuickReplies: Displays quick replies.
	QuickReplies *GoogleCloudDialogflowV2beta1IntentMessageQuickReplies `json:"quickReplies,omitempty"`
	// RbmCarouselRichCard: Rich Business Messaging (RBM) carousel rich card
	// response.
	RbmCarouselRichCard *GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard `json:"rbmCarouselRichCard,omitempty"`
	// RbmStandaloneRichCard: Standalone Rich Business Messaging (RBM) rich card
	// response.
	RbmStandaloneRichCard *GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard `json:"rbmStandaloneRichCard,omitempty"`
	// RbmText: Rich Business Messaging (RBM) text response. RBM allows businesses
	// to send enriched and branded versions of SMS. See
	// https://jibe.google.com/business-messaging.
	RbmText *GoogleCloudDialogflowV2beta1IntentMessageRbmText `json:"rbmText,omitempty"`
	// SimpleResponses: Returns a voice or text-only response for Actions on
	// Google.
	SimpleResponses *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`
	// Suggestions: Displays suggestion chips for Actions on Google.
	Suggestions *GoogleCloudDialogflowV2beta1IntentMessageSuggestions `json:"suggestions,omitempty"`
	// TableCard: Table card for Actions on Google.
	TableCard *GoogleCloudDialogflowV2beta1IntentMessageTableCard `json:"tableCard,omitempty"`
	// TelephonyPlayAudio: Plays audio from a file in Telephony Gateway.
	TelephonyPlayAudio *GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio `json:"telephonyPlayAudio,omitempty"`
	// TelephonySynthesizeSpeech: Synthesizes speech in Telephony Gateway.
	TelephonySynthesizeSpeech *GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech `json:"telephonySynthesizeSpeech,omitempty"`
	// TelephonyTransferCall: Transfers the call in Telephony Gateway.
	TelephonyTransferCall *GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	// Text: Returns a text response.
	Text *GoogleCloudDialogflowV2beta1IntentMessageText `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCard: The basic card message.
// Useful for displaying information.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// FormattedText: Required, unless image is present. The body text of the card.
	FormattedText string `json:"formattedText,omitempty"`
	// Image: Optional. The image for the card.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton: The button object
// that appears at the bottom of a card.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton struct {
	// OpenUriAction: Required. Action to take when a user taps on the button.
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	// Title: Required. The title of the button.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction: Opens
// the given URI.
type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction struct {
	// Uri: Required. The HTTP or HTTPS scheme URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard: Browse Carousel
// Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard struct {
	// ImageDisplayOptions: Optional. Settings for displaying the image. Applies to
	// every image in items.
	//
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED" - Fill the gaps between the image and
	// the image container with gray bars.
	//   "GRAY" - Fill the gaps between the image and the image container with gray
	// bars.
	//   "WHITE" - Fill the gaps between the image and the image container with
	// white bars.
	//   "CROPPED" - Image is scaled such that the image width and height match or
	// exceed the container dimensions. This may crop the top and bottom of the
	// image if the scaled image height is greater than the container height, or
	// crop the left and right of the image if the scaled image width is greater
	// than the container width. This is similar to "Zoom Mode" on a widescreen TV
	// when playing a 4:3 video.
	//   "BLURRED_BACKGROUND" - Pad the gaps between image and image frame with a
	// blurred copy of the same image.
	ImageDisplayOptions string `json:"imageDisplayOptions,omitempty"`
	// Items: Required. List of items in the Browse Carousel Card. Minimum of two
	// items, maximum of ten.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCard
// Item: Browsing carousel tile
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	// Description: Optional. Description of the carousel item. Maximum of four
	// lines of text.
	Description string `json:"description,omitempty"`
	// Footer: Optional. Text that appears at the bottom of the Browse Carousel
	// Card. Maximum of one line of text.
	Footer string `json:"footer,omitempty"`
	// Image: Optional. Hero image for the carousel item.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// OpenUriAction: Required. Action to present to the user.
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	// Title: Required. Title of the carousel item. Maximum of two lines of text.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCard
// ItemOpenUrlAction: Actions on Google action to open a given url.
type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	// Url: Required. URL
	Url string `json:"url,omitempty"`
	// UrlTypeHint: Optional. Specifies the type of viewer that is used when
	// opening the URL. Defaults to opening via web browser.
	//
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED" - Unspecified
	//   "AMP_ACTION" - Url would be an amp action
	//   "AMP_CONTENT" - URL that points directly to AMP content, or to a canonical
	// URL which refers to AMP content via .
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCard: The card response message.
type GoogleCloudDialogflowV2beta1IntentMessageCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageCardButton `json:"buttons,omitempty"`
	// ImageUri: Optional. The public URI to an image file for the card.
	ImageUri string `json:"imageUri,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCardButton: Optional. Contains
// information about a button.
type GoogleCloudDialogflowV2beta1IntentMessageCardButton struct {
	// Postback: Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback string `json:"postback,omitempty"`
	// Text: Optional. The text to show on the button.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect: The card for
// presenting a carousel of options to select from.
type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect struct {
	// Items: Required. Carousel items.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem: An item in the
// carousel.
type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem struct {
	// Description: Optional. The body text of the card.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional info about the option item.
	Info *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. Title of the carousel item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageColumnProperties: Column properties
// for TableCard.
type GoogleCloudDialogflowV2beta1IntentMessageColumnProperties struct {
	// Header: Required. Column heading.
	Header string `json:"header,omitempty"`
	// HorizontalAlignment: Optional. Defines text alignment for all cells in this
	// column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Text is aligned to the leading edge
	// of the column.
	//   "LEADING" - Text is aligned to the leading edge of the column.
	//   "CENTER" - Text is centered in the column.
	//   "TRAILING" - Text is aligned to the trailing edge of the column.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageImage: The image response message.
type GoogleCloudDialogflowV2beta1IntentMessageImage struct {
	// AccessibilityText: A text description of the image to be used for
	// accessibility, e.g., screen readers. Required if image_uri is set for
	// CarouselSelect.
	AccessibilityText string `json:"accessibilityText,omitempty"`
	// ImageUri: Optional. The public URI to an image file.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion: The suggestion
// chip message that allows the user to jump out to the app or website
// associated with this agent.
type GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion struct {
	// DestinationName: Required. The name of the app or site this chip is linking
	// to.
	DestinationName string `json:"destinationName,omitempty"`
	// Uri: Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageListSelect: The card for presenting
// a list of options to select from.
type GoogleCloudDialogflowV2beta1IntentMessageListSelect struct {
	// Items: Required. List items.
	Items []*GoogleCloudDialogflowV2beta1IntentMessageListSelectItem `json:"items,omitempty"`
	// Subtitle: Optional. Subtitle of the list.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The overall title of the list.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageListSelectItem: An item in the
// list.
type GoogleCloudDialogflowV2beta1IntentMessageListSelectItem struct {
	// Description: Optional. The main text describing the item.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional information about this option.
	Info *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. The title of the list item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageMediaContent: The media content
// card for Actions on Google.
type GoogleCloudDialogflowV2beta1IntentMessageMediaContent struct {
	// MediaObjects: Required. List of media objects.
	MediaObjects []*GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// MediaType: Optional. What type of media is the content (ie "audio").
	//
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED" - Unspecified.
	//   "AUDIO" - Response media type is audio.
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject:
// Response media object for media content card.
type GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject struct {
	// ContentUrl: Required. Url where the media is stored.
	ContentUrl string `json:"contentUrl,omitempty"`
	// Description: Optional. Description of media card.
	Description string `json:"description,omitempty"`
	// Icon: Optional. Icon to display above media content.
	Icon *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"icon,omitempty"`
	// LargeImage: Optional. Image to display above media content.
	LargeImage *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"largeImage,omitempty"`
	// Name: Required. Name of media card.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageQuickReplies: The quick replies
// response message.
type GoogleCloudDialogflowV2beta1IntentMessageQuickReplies struct {
	// QuickReplies: Optional. The collection of quick replies.
	QuickReplies []string `json:"quickReplies,omitempty"`
	// Title: Optional. The title of the collection of quick replies.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent: Rich Business
// Messaging (RBM) Card content
type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent struct {
	// Description: Optional. Description of the card (at most 2000 bytes). At
	// least one of the title, description or media must be set.
	Description string `json:"description,omitempty"`
	// Media: Optional. However at least one of the title, description or media
	// must be set. Media (image, GIF or a video) to include in the card.
	Media *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia `json:"media,omitempty"`
	// Suggestions: Optional. List of suggestions to include in the card.
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"suggestions,omitempty"`
	// Title: Optional. Title of the card (at most 200 bytes). At least one of the
	// title, description or media must be set.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia: Rich
// Business Messaging (RBM) Media displayed in Cards The following media-types
// are currently supported: Image Types * image/jpeg * image/jpg' * image/gif *
// image/png Video Types * video/h263 * video/m4v * video/mp4 * video/mpeg *
// video/mpeg4 * video/webm
type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia struct {
	// FileUri: Required. Publicly reachable URI of the file. The RBM platform
	// determines the MIME type of the file from the content-type field in the HTTP
	// headers when the platform fetches the file. The content-type field must be
	// present and accurate in the HTTP response from the URL.
	FileUri string `json:"fileUri,omitempty"`
	// Height: Required for cards with vertical orientation. The height of the
	// media within a rich card with a vertical layout. For a standalone card with
	// horizontal layout, height is not customizable, and this field is ignored.
	//
	// Possible values:
	//   "HEIGHT_UNSPECIFIED" - Not specified.
	//   "SHORT" - 112 DP.
	//   "MEDIUM" - 168 DP.
	//   "TALL" - 264 DP. Not available for rich card carousels when the card width
	// is set to small.
	Height string `json:"height,omitempty"`
	// ThumbnailUri: Optional. Publicly reachable URI of the thumbnail.If you don't
	// provide a thumbnail URI, the RBM platform displays a blank placeholder
	// thumbnail until the user's device downloads the file. Depending on the
	// user's setting, the file may not download automatically and may require the
	// user to tap a download button.
	ThumbnailUri string `json:"thumbnailUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard: Carousel Rich
// Business Messaging (RBM) rich card. Rich cards allow you to respond to users
// with more vivid content, e.g. with media and suggestions. If you want to
// show a single card with more control over the layout, please use
// RbmStandaloneCard instead.
type GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard struct {
	// CardContents: Required. The cards in the carousel. A carousel must have at
	// least 2 cards and at most 10.
	CardContents []*GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContents,omitempty"`
	// CardWidth: Required. The width of the cards in the carousel.
	//
	// Possible values:
	//   "CARD_WIDTH_UNSPECIFIED" - Not specified.
	//   "SMALL" - 120 DP. Note that tall media cannot be used.
	//   "MEDIUM" - 232 DP.
	CardWidth string `json:"cardWidth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard: Standalone Rich
// Business Messaging (RBM) rich card. Rich cards allow you to respond to users
// with more vivid content, e.g. with media and suggestions. You can group
// multiple rich cards into one using RbmCarouselCard but carousel cards will
// give you less control over the card layout.
type GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard struct {
	// CardContent: Required. Card content.
	CardContent *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContent,omitempty"`
	// CardOrientation: Required. Orientation of the card.
	//
	// Possible values:
	//   "CARD_ORIENTATION_UNSPECIFIED" - Not specified.
	//   "HORIZONTAL" - Horizontal layout.
	//   "VERTICAL" - Vertical layout.
	CardOrientation string `json:"cardOrientation,omitempty"`
	// ThumbnailImageAlignment: Required if orientation is horizontal. Image
	// preview alignment for standalone cards with horizontal layout.
	//
	// Possible values:
	//   "THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED" - Not specified.
	//   "LEFT" - Thumbnail preview is left-aligned.
	//   "RIGHT" - Thumbnail preview is right-aligned.
	ThumbnailImageAlignment string `json:"thumbnailImageAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction: Rich Business
// Messaging (RBM) suggested client-side action that the user can choose from
// the card.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction struct {
	// Dial: Suggested client side action: Dial a phone number
	Dial *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial `json:"dial,omitempty"`
	// OpenUrl: Suggested client side action: Open a URI on device
	OpenUrl *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri `json:"openUrl,omitempty"`
	// PostbackData: Opaque payload that the Dialogflow receives in a user event
	// when the user taps the suggested action. This data will be also forwarded to
	// webhook to allow performing custom business logic.
	PostbackData string `json:"postbackData,omitempty"`
	// ShareLocation: Suggested client side action: Share user location
	ShareLocation *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation `json:"shareLocation,omitempty"`
	// Text: Text to display alongside the action.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dial") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dial") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedAction
// Dial: Opens the user's default dialer app with the specified phone number
// but does not dial automatically.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial struct {
	// PhoneNumber: Required. The phone number to fill in the default dialer app.
	// This field should be in E.164 (https://en.wikipedia.org/wiki/E.164) format.
	// An example of a correctly formatted phone number: +15556767888.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedAction
// OpenUri: Opens the user's default web browser app to the specified uri If
// the user has an app installed that is registered as the default handler for
// the URL, then this app will be opened instead, and its icon will be used in
// the suggested action UI.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri struct {
	// Uri: Required. The uri to open on the user device
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedAction
// ShareLocation: Opens the device's location chooser so the user can pick a
// location to send back to the agent.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation struct {
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply: Rich Business
// Messaging (RBM) suggested reply that the user can click instead of typing in
// their own response.
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply struct {
	// PostbackData: Opaque payload that the Dialogflow receives in a user event
	// when the user taps the suggested reply. This data will be also forwarded to
	// webhook to allow performing custom business logic.
	PostbackData string `json:"postbackData,omitempty"`
	// Text: Suggested reply text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostbackData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostbackData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion: Rich Business
// Messaging (RBM) suggestion. Suggestions allow user to easily select/click a
// predefined response or perform an action (like opening a web uri).
type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion struct {
	// Action: Predefined client side actions that user can choose
	Action *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction `json:"action,omitempty"`
	// Reply: Predefined replies for user to select instead of typing
	Reply *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageRbmText: Rich Business Messaging
// (RBM) text response with suggestions.
type GoogleCloudDialogflowV2beta1IntentMessageRbmText struct {
	// RbmSuggestion: Optional. One or more suggestions to show to the user.
	RbmSuggestion []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"rbmSuggestion,omitempty"`
	// Text: Required. Text sent and displayed to the user.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RbmSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RbmSuggestion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo: Additional info
// about the select item for when it is triggered in a dialog.
type GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo struct {
	// Key: Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `json:"key,omitempty"`
	// Synonyms: Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse: The simple response
// message containing speech or text.
type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse struct {
	// DisplayText: Optional. The text to display.
	DisplayText string `json:"displayText,omitempty"`
	// Ssml: One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `json:"ssml,omitempty"`
	// TextToSpeech: One of text_to_speech or ssml must be provided. The plain text
	// of the speech output. Mutually exclusive with ssml.
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses: The collection of
// simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses struct {
	// SimpleResponses: Required. The list of simple responses.
	SimpleResponses []*GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSuggestion: The suggestion chip
// message that the user can tap to quickly post a reply to the conversation.
type GoogleCloudDialogflowV2beta1IntentMessageSuggestion struct {
	// Title: Required. The text shown the in the suggestion chip.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageSuggestions: The collection of
// suggestions.
type GoogleCloudDialogflowV2beta1IntentMessageSuggestions struct {
	// Suggestions: Required. The list of suggested replies.
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCard: Table card for Actions
// on Google.
type GoogleCloudDialogflowV2beta1IntentMessageTableCard struct {
	// Buttons: Optional. List of buttons for the card.
	Buttons []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// ColumnProperties: Optional. Display properties for the columns in this
	// table.
	ColumnProperties []*GoogleCloudDialogflowV2beta1IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	// Image: Optional. Image which should be displayed on the card.
	Image *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"image,omitempty"`
	// Rows: Optional. Rows in this table of data.
	Rows []*GoogleCloudDialogflowV2beta1IntentMessageTableCardRow `json:"rows,omitempty"`
	// Subtitle: Optional. Subtitle to the title.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Required. Title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCardCell: Cell of
// TableCardRow.
type GoogleCloudDialogflowV2beta1IntentMessageTableCardCell struct {
	// Text: Required. Text in this cell.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTableCardRow: Row of TableCard.
type GoogleCloudDialogflowV2beta1IntentMessageTableCardRow struct {
	// Cells: Optional. List of cells that make up this row.
	Cells []*GoogleCloudDialogflowV2beta1IntentMessageTableCardCell `json:"cells,omitempty"`
	// DividerAfter: Optional. Whether to add a visual divider after this row.
	DividerAfter bool `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio: Plays audio
// from a file in Telephony Gateway.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio struct {
	// AudioUri: Required. URI to a Google Cloud Storage object containing the
	// audio to play, e.g., "gs://bucket/object". The object must contain a single
	// channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz. This object
	// must be readable by the `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`
	// service account where is the number of the Telephony Gateway project
	// (usually the same as the Dialogflow agent project). If the Google Cloud
	// Storage bucket is in the Telephony Gateway project, this permission is added
	// by default when enabling the Dialogflow V2 API. For audio from other
	// sources, consider using the `TelephonySynthesizeSpeech` message with SSML.
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech:
// Synthesizes speech and plays back the synthesized audio to the caller in
// Telephony Gateway. Telephony Gateway takes the synthesizer settings from
// `DetectIntentResponse.output_audio_config` which can either be set at
// request-level or can come from the agent-level synthesizer config.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech struct {
	// Ssml: The SSML to be synthesized. For more information, see SSML
	// (https://developers.google.com/actions/reference/ssml).
	Ssml string `json:"ssml,omitempty"`
	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ssml") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ssml") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall: Transfers
// the call in Telephony Gateway.
type GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall struct {
	// PhoneNumber: Required. The phone number to transfer the call to in E.164
	// format (https://en.wikipedia.org/wiki/E.164). We currently only allow
	// transferring to US numbers (+1xxxyyyzzzz).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentMessageText: The text response message.
type GoogleCloudDialogflowV2beta1IntentMessageText struct {
	// Text: Optional. The collection of the agent's responses.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentParameter: Represents intent parameters.
type GoogleCloudDialogflowV2beta1IntentParameter struct {
	// DefaultValue: Optional. The default value to use when the `value` yields an
	// empty result. Default values can be extracted from contexts by using the
	// following syntax: `#context_name.parameter_name`.
	DefaultValue string `json:"defaultValue,omitempty"`
	// DisplayName: Required. The name of the parameter.
	DisplayName string `json:"displayName,omitempty"`
	// EntityTypeDisplayName: Optional. The name of the entity type, prefixed with
	// `@`, that describes values of the parameter. If the parameter is required,
	// this must be provided.
	EntityTypeDisplayName string `json:"entityTypeDisplayName,omitempty"`
	// IsList: Optional. Indicates whether the parameter represents a list of
	// values.
	IsList bool `json:"isList,omitempty"`
	// Mandatory: Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `json:"mandatory,omitempty"`
	// Name: The unique identifier of this parameter.
	Name string `json:"name,omitempty"`
	// Prompts: Optional. The collection of prompts that the agent can present to
	// the user in order to collect a value for the parameter.
	Prompts []string `json:"prompts,omitempty"`
	// Value: Optional. The definition of the parameter value. It can be: - a
	// constant string, - a parameter value defined as `$parameter_name`, - an
	// original parameter value defined as `$parameter_name.original`, - a
	// parameter value from some context defined as `#context_name.parameter_name`.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentSuggestion: Represents an intent
// suggestion.
type GoogleCloudDialogflowV2beta1IntentSuggestion struct {
	// Description: Human readable description for better understanding an intent
	// like its scope, content, result etc. Maximum character limit: 140
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: The display name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// IntentV2: The unique identifier of this intent. Format:
	// `projects//locations//agent/intents/`.
	IntentV2 string `json:"intentV2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentTrainingPhrase: Represents an example that
// the agent is trained on.
type GoogleCloudDialogflowV2beta1IntentTrainingPhrase struct {
	// Name: Output only. The unique identifier of this training phrase.
	Name string `json:"name,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `entity_type`, `alias`, and
	// `user_defined` fields are all set.
	Parts []*GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	// TimesAddedCount: Optional. Indicates how many times this example was added
	// to the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount int64 `json:"timesAddedCount,omitempty"`
	// Type: Required. The type of the training phrase.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be used.
	//   "EXAMPLE" - Examples do not contain @-prefixed entity type names, but
	// example parts can be annotated with entity types.
	//   "TEMPLATE" - Templates are not annotated with entity types, but they can
	// contain @-prefixed entity type names as substrings. Note: Template mode has
	// been deprecated. Example mode is the only supported way to create new
	// training phrases. If you have existing training phrases in template mode,
	// they will be removed during training and it can cause a drop in agent
	// performance.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart: Represents a part of a
// training phrase.
type GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart struct {
	// Alias: Optional. The parameter name for the value extracted from the
	// annotated part of the example. This field is required for annotated parts of
	// the training phrase.
	Alias string `json:"alias,omitempty"`
	// EntityType: Optional. The entity type name prefixed with `@`. This field is
	// required for annotated parts of the training phrase.
	EntityType string `json:"entityType,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// UserDefined: Optional. Indicates whether the text was manually annotated.
	// This field is set to true when the Dialogflow Console is used to manually
	// annotate the part. When creating an annotated part with the API, you must
	// set this to true.
	UserDefined bool `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAnswers: Represents the result of
// querying a Knowledge base.
type GoogleCloudDialogflowV2beta1KnowledgeAnswers struct {
	// Answers: A list of answers from Knowledge Connector.
	Answers []*GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer: An answer from Knowledge
// Connector.
type GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document that
	// answers this conversational query.
	Answer string `json:"answer,omitempty"`
	// FaqQuestion: The corresponding FAQ question if the answer was extracted from
	// a FAQ Document, empty otherwise.
	FaqQuestion string `json:"faqQuestion,omitempty"`
	// MatchConfidence: The system's confidence score that this Knowledge answer is
	// a good match for this conversational query. The range is from 0.0
	// (completely uncertain) to 1.0 (completely certain). Note: The confidence
	// score is likely to vary somewhat (possibly even for identical requests), as
	// the underlying model is under constant improvement. It may be deprecated in
	// the future. We recommend using `match_confidence_level` which should be
	// generally more stable.
	MatchConfidence float64 `json:"matchConfidence,omitempty"`
	// MatchConfidenceLevel: The system's confidence level that this knowledge
	// answer is a good match for this conversational query. NOTE: The confidence
	// level for a given `` pair may change without notice, as it depends on models
	// that are constantly being improved. However, it will change less frequently
	// than the confidence score below, and should be preferred for referencing the
	// quality of an answer.
	//
	// Possible values:
	//   "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED" - Not specified.
	//   "LOW" - Indicates that the confidence is low.
	//   "MEDIUM" - Indicates our confidence is medium.
	//   "HIGH" - Indicates our confidence is high.
	MatchConfidenceLevel string `json:"matchConfidenceLevel,omitempty"`
	// Source: Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects//knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	var s1 struct {
		MatchConfidence gensupport.JSONFloat64 `json:"matchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchConfidence = float64(s1.MatchConfidence)
	return nil
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer: Represents a Knowledge
// Assist answer.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer struct {
	// AnswerRecord: The name of the answer record. Format:
	// `projects//locations//answer Records/`.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SuggestedQuery: The query suggested based on the context. Suggestion is made
	// only if it is different from the previous suggestion.
	SuggestedQuery *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery `json:"suggestedQuery,omitempty"`
	// SuggestedQueryAnswer: The answer generated for the suggested query. Whether
	// or not an answer is generated depends on how confident we are about the
	// generated query.
	SuggestedQueryAnswer *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer: Represents
// an answer from Knowledge. Currently supports FAQ and Generative answers.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer struct {
	// AnswerText: The piece of text from the `source` that answers this suggested
	// query.
	AnswerText string `json:"answerText,omitempty"`
	// FaqSource: Populated if the prediction came from FAQ.
	FaqSource *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource `json:"faqSource,omitempty"`
	// GenerativeSource: Populated if the prediction was Generative.
	GenerativeSource *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource:
// Details about source of FAQ answer.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSou
// rce: Details about source of Generative answer.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	// Snippets: All snippets used for this Generative Prediction, with their
	// source URI and data.
	Snippets []*GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSou
// rceSnippet: Snippet Source for a Generative Prediction.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	// Metadata: Metadata of the document.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Text: Text taken from that URI.
	Text string `json:"text,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: URI the data is sourced from.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery: Represents
// a suggested query.
type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery struct {
	// QueryText: Suggested query text.
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeBase: A knowledge base represents a
// collection of knowledge documents that you provide to Dialogflow. Your
// knowledge documents contain information that may be useful during
// conversations with end-users. Some Dialogflow features use knowledge bases
// when looking for a response to an end-user input. For more information, see
// the knowledge base guide
// (https://cloud.google.com/dialogflow/docs/how/knowledge-bases). Note: The
// `projects.agent.knowledgeBases` resource is deprecated; only use
// `projects.knowledgeBases`.
type GoogleCloudDialogflowV2beta1KnowledgeBase struct {
	// DisplayName: Required. The display name of the knowledge base. The name must
	// be 1024 bytes or less; otherwise, the creation request fails.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: Language which represents the KnowledgeBase. When the
	// KnowledgeBase is created/updated, this is populated for all non en-us
	// languages. If not populated, the default language en-us applies.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: The knowledge base resource name. The name must be empty when creating
	// a knowledge base. Format: `projects//locations//knowledgeBases/`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeBase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeBase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata: Metadata in
// google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata struct {
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ExportOperationMetadata: Metadata for the Export Data Operation such as the
	// destination of export.
	ExportOperationMetadata *GoogleCloudDialogflowV2beta1ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	// KnowledgeBase: The name of the knowledge base interacted with during the
	// operation.
	KnowledgeBase string `json:"knowledgeBase,omitempty"`
	// State: Required. Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse: Response message for
// AnswerRecords.ListAnswerRecords.
type GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse struct {
	// AnswerRecords: The list of answer records.
	AnswerRecords []*GoogleCloudDialogflowV2beta1AnswerRecord `json:"answerRecords,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Or empty if there
	// are no more results. Pass this value in the
	// ListAnswerRecordsRequest.page_token field in the subsequent call to
	// `ListAnswerRecords` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a