// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/video/livestream/v1/resources.proto

package livestreampb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the input.
type Input_Type int32

const (
	// Input type is not specified.
	Input_TYPE_UNSPECIFIED Input_Type = 0
	// Input will take an rtmp input stream.
	Input_RTMP_PUSH Input_Type = 1
	// Input will take an srt (Secure Reliable Transport) input stream.
	Input_SRT_PUSH Input_Type = 2
)

// Enum value maps for Input_Type.
var (
	Input_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "RTMP_PUSH",
		2: "SRT_PUSH",
	}
	Input_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"RTMP_PUSH":        1,
		"SRT_PUSH":         2,
	}
)

func (x Input_Type) Enum() *Input_Type {
	p := new(Input_Type)
	*p = x
	return p
}

func (x Input_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Input_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Input_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[0]
}

func (x Input_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Input_Type.Descriptor instead.
func (Input_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// Tier of the input specification.
type Input_Tier int32

const (
	// Tier is not specified.
	Input_TIER_UNSPECIFIED Input_Tier = 0
	// Resolution < 1280x720. Bitrate <= 6 Mbps. FPS <= 60.
	Input_SD Input_Tier = 1
	// Resolution <= 1920x1080. Bitrate <= 25 Mbps. FPS <= 60.
	Input_HD Input_Tier = 2
	// Resolution <= 4096x2160. Not supported yet.
	Input_UHD Input_Tier = 3
)

// Enum value maps for Input_Tier.
var (
	Input_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "SD",
		2: "HD",
		3: "UHD",
	}
	Input_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"SD":               1,
		"HD":               2,
		"UHD":              3,
	}
)

func (x Input_Tier) Enum() *Input_Tier {
	p := new(Input_Tier)
	*p = x
	return p
}

func (x Input_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Input_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Input_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[1]
}

func (x Input_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Input_Tier.Descriptor instead.
func (Input_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// State of streaming operation that the channel is running.
type Channel_StreamingState int32

const (
	// Streaming state is not specified.
	Channel_STREAMING_STATE_UNSPECIFIED Channel_StreamingState = 0
	// Channel is getting the input stream, generating the live streams to the
	// specified output location.
	Channel_STREAMING Channel_StreamingState = 1
	// Channel is waiting for the input stream through the input.
	Channel_AWAITING_INPUT Channel_StreamingState = 2
	// Channel is running, but has trouble publishing the live streams onto the
	// specified output location (for example, the specified Cloud Storage
	// bucket is not writable).
	Channel_STREAMING_ERROR Channel_StreamingState = 4
	// Channel is generating live streams with no input stream. Live streams are
	// filled out with black screen, while input stream is missing.
	// Not supported yet.
	Channel_STREAMING_NO_INPUT Channel_StreamingState = 5
	// Channel is stopped, finishing live streams.
	Channel_STOPPED Channel_StreamingState = 6
	// Channel is starting.
	Channel_STARTING Channel_StreamingState = 7
	// Channel is stopping.
	Channel_STOPPING Channel_StreamingState = 8
)

// Enum value maps for Channel_StreamingState.
var (
	Channel_StreamingState_name = map[int32]string{
		0: "STREAMING_STATE_UNSPECIFIED",
		1: "STREAMING",
		2: "AWAITING_INPUT",
		4: "STREAMING_ERROR",
		5: "STREAMING_NO_INPUT",
		6: "STOPPED",
		7: "STARTING",
		8: "STOPPING",
	}
	Channel_StreamingState_value = map[string]int32{
		"STREAMING_STATE_UNSPECIFIED": 0,
		"STREAMING":                   1,
		"AWAITING_INPUT":              2,
		"STREAMING_ERROR":             4,
		"STREAMING_NO_INPUT":          5,
		"STOPPED":                     6,
		"STARTING":                    7,
		"STOPPING":                    8,
	}
)

func (x Channel_StreamingState) Enum() *Channel_StreamingState {
	p := new(Channel_StreamingState)
	*p = x
	return p
}

func (x Channel_StreamingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Channel_StreamingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Channel_StreamingState) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[2]
}

func (x Channel_StreamingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Channel_StreamingState.Descriptor instead.
func (Channel_StreamingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// Input switch mode.
type InputConfig_InputSwitchMode int32

const (
	// The input switch mode is not specified.
	InputConfig_INPUT_SWITCH_MODE_UNSPECIFIED InputConfig_InputSwitchMode = 0
	// Automatic failover is enabled. The primary input stream is always
	// preferred over its backup input streams configured using the
	// [AutomaticFailover][google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover]
	// field.
	InputConfig_FAILOVER_PREFER_PRIMARY InputConfig_InputSwitchMode = 1
	// Automatic failover is disabled. You must use the
	// [inputSwitch][google.cloud.video.livestream.v1.Event.input_switch] event
	// to switch the active input source for the channel to stream from. When
	// this mode is chosen, the
	// [AutomaticFailover][google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover]
	// field is ignored.
	InputConfig_MANUAL InputConfig_InputSwitchMode = 3
)

// Enum value maps for InputConfig_InputSwitchMode.
var (
	InputConfig_InputSwitchMode_name = map[int32]string{
		0: "INPUT_SWITCH_MODE_UNSPECIFIED",
		1: "FAILOVER_PREFER_PRIMARY",
		3: "MANUAL",
	}
	InputConfig_InputSwitchMode_value = map[string]int32{
		"INPUT_SWITCH_MODE_UNSPECIFIED": 0,
		"FAILOVER_PREFER_PRIMARY":       1,
		"MANUAL":                        3,
	}
)

func (x InputConfig_InputSwitchMode) Enum() *InputConfig_InputSwitchMode {
	p := new(InputConfig_InputSwitchMode)
	*p = x
	return p
}

func (x InputConfig_InputSwitchMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InputConfig_InputSwitchMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[3].Descriptor()
}

func (InputConfig_InputSwitchMode) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[3]
}

func (x InputConfig_InputSwitchMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InputConfig_InputSwitchMode.Descriptor instead.
func (InputConfig_InputSwitchMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

// The severity level of platform logging for this channel. Logs with a
// severity level higher than or equal to the chosen severity level will be
// logged and can be viewed through Cloud Logging.
// The severity level of a log is ranked as followed from low to high: DEBUG <
// INFO < NOTICE < WARNING < ERROR < CRITICAL < ALERT < EMERGENCY.
// See
// [LogSeverity](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry#logseverity)
// for more information.
type LogConfig_LogSeverity int32

const (
	// Log severity is not specified. This is the same as log severity is OFF.
	LogConfig_LOG_SEVERITY_UNSPECIFIED LogConfig_LogSeverity = 0
	// Log is turned off.
	LogConfig_OFF LogConfig_LogSeverity = 1
	// Log with severity higher than or equal to DEBUG are logged.
	LogConfig_DEBUG LogConfig_LogSeverity = 100
	// Logs with severity higher than or equal to INFO are logged.
	LogConfig_INFO LogConfig_LogSeverity = 200
	// Logs with severity higher than or equal to WARNING are logged.
	LogConfig_WARNING LogConfig_LogSeverity = 400
	// Logs with severity higher than or equal to ERROR are logged.
	LogConfig_ERROR LogConfig_LogSeverity = 500
)

// Enum value maps for LogConfig_LogSeverity.
var (
	LogConfig_LogSeverity_name = map[int32]string{
		0:   "LOG_SEVERITY_UNSPECIFIED",
		1:   "OFF",
		100: "DEBUG",
		200: "INFO",
		400: "WARNING",
		500: "ERROR",
	}
	LogConfig_LogSeverity_value = map[string]int32{
		"LOG_SEVERITY_UNSPECIFIED": 0,
		"OFF":                      1,
		"DEBUG":                    100,
		"INFO":                     200,
		"WARNING":                  400,
		"ERROR":                    500,
	}
)

func (x LogConfig_LogSeverity) Enum() *LogConfig_LogSeverity {
	p := new(LogConfig_LogSeverity)
	*p = x
	return p
}

func (x LogConfig_LogSeverity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfig_LogSeverity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[4].Descriptor()
}

func (LogConfig_LogSeverity) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[4]
}

func (x LogConfig_LogSeverity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfig_LogSeverity.Descriptor instead.
func (LogConfig_LogSeverity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{6, 0}
}

// State of the event
type Event_State int32

const (
	// Event state is not specified.
	Event_STATE_UNSPECIFIED Event_State = 0
	// Event is scheduled but not executed yet.
	Event_SCHEDULED Event_State = 1
	// Event is being executed.
	Event_RUNNING Event_State = 2
	// Event has been successfully executed.
	Event_SUCCEEDED Event_State = 3
	// Event fails to be executed.
	Event_FAILED Event_State = 4
	// Event has been created but not scheduled yet.
	Event_PENDING Event_State = 5
	// Event was stopped before running for its full duration.
	Event_STOPPED Event_State = 6
)

// Enum value maps for Event_State.
var (
	Event_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SCHEDULED",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "PENDING",
		6: "STOPPED",
	}
	Event_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SCHEDULED":         1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"PENDING":           5,
		"STOPPED":           6,
	}
)

func (x Event_State) Enum() *Event_State {
	p := new(Event_State)
	*p = x
	return p
}

func (x Event_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[5].Descriptor()
}

func (Event_State) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[5]
}

func (x Event_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_State.Descriptor instead.
func (Event_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 0}
}

// State of clipping operation.
type Clip_State int32

const (
	// State is not specified.
	Clip_STATE_UNSPECIFIED Clip_State = 0
	// The operation is pending to be picked up by the server.
	Clip_PENDING Clip_State = 1
	// The server admitted this create clip request, and
	// outputs are under processing.
	Clip_CREATING Clip_State = 2
	// Outputs are available in the specified Cloud Storage bucket. For
	// additional information, see the `outputs` field.
	Clip_SUCCEEDED Clip_State = 3
	// The operation has failed. For additional information, see the `error`
	// field.
	Clip_FAILED Clip_State = 4
)

// Enum value maps for Clip_State.
var (
	Clip_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "CREATING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	Clip_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"CREATING":          2,
		"SUCCEEDED":         3,
		"FAILED":            4,
	}
)

func (x Clip_State) Enum() *Clip_State {
	p := new(Clip_State)
	*p = x
	return p
}

func (x Clip_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Clip_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[6].Descriptor()
}

func (Clip_State) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[6]
}

func (x Clip_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Clip_State.Descriptor instead.
func (Clip_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{15, 0}
}

// State of the asset resource.
type Asset_State int32

const (
	// State is not specified.
	Asset_STATE_UNSPECIFIED Asset_State = 0
	// The asset is being created.
	Asset_CREATING Asset_State = 1
	// The asset is ready for use.
	Asset_ACTIVE Asset_State = 2
	// The asset is being deleted.
	Asset_DELETING Asset_State = 3
	// The asset has an error.
	Asset_ERROR Asset_State = 4
)

// Enum value maps for Asset_State.
var (
	Asset_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "ERROR",
	}
	Asset_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"ERROR":             4,
	}
)

func (x Asset_State) Enum() *Asset_State {
	p := new(Asset_State)
	*p = x
	return p
}

func (x Asset_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Asset_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[7].Descriptor()
}

func (Asset_State) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[7]
}

func (x Asset_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Asset_State.Descriptor instead.
func (Asset_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{16, 0}
}

// Input resource represents the endpoint from which the channel ingests
// the input stream.
type Input struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the input, in the form of:
	// `projects/{project}/locations/{location}/inputs/{inputId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Source type.
	Type Input_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.video.livestream.v1.Input_Type" json:"type,omitempty"`
	// Tier defines the maximum input specification that is accepted by the
	// video pipeline. The billing is charged based on the tier specified here.
	// See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
	// The default is `HD`.
	Tier Input_Tier `protobuf:"varint,14,opt,name=tier,proto3,enum=google.cloud.video.livestream.v1.Input_Tier" json:"tier,omitempty"`
	// Output only. URI to push the input stream to.
	// Its format depends on the input
	// [type][google.cloud.video.livestream.v1.Input.type], for example:
	//
	// *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
	// *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
	Uri string `protobuf:"bytes,6,opt,name=uri,proto3" json:"uri,omitempty"`
	// Preprocessing configurations.
	PreprocessingConfig *PreprocessingConfig `protobuf:"bytes,9,opt,name=preprocessing_config,json=preprocessingConfig,proto3" json:"preprocessing_config,omitempty"`
	// Security rule for access control.
	SecurityRules *Input_SecurityRule `protobuf:"bytes,12,opt,name=security_rules,json=securityRules,proto3" json:"security_rules,omitempty"`
	// Output only. The information for the input stream. This field will be
	// present only when this input receives the input stream.
	InputStreamProperty *InputStreamProperty `protobuf:"bytes,15,opt,name=input_stream_property,json=inputStreamProperty,proto3" json:"input_stream_property,omitempty"`
}

func (x *Input) Reset() {
	*x = Input{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Input) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Input) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Input) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Input) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Input) GetType() Input_Type {
	if x != nil {
		return x.Type
	}
	return Input_TYPE_UNSPECIFIED
}

func (x *Input) GetTier() Input_Tier {
	if x != nil {
		return x.Tier
	}
	return Input_TIER_UNSPECIFIED
}

func (x *Input) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Input) GetPreprocessingConfig() *PreprocessingConfig {
	if x != nil {
		return x.PreprocessingConfig
	}
	return nil
}

func (x *Input) GetSecurityRules() *Input_SecurityRule {
	if x != nil {
		return x.SecurityRules
	}
	return nil
}

func (x *Input) GetInputStreamProperty() *InputStreamProperty {
	if x != nil {
		return x.InputStreamProperty
	}
	return nil
}

// Channel resource represents the processor that does a user-defined
// "streaming" operation, which includes getting an input stream through an
// input, transcoding it to multiple renditions, and publishing output live
// streams in certain formats (for example, HLS or DASH) to the specified
// location.
type Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the channel, in the form of:
	// `projects/{project}/locations/{location}/channels/{channelId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of input attachments that this channel uses.
	// One channel can have multiple inputs as the input sources. Only one
	// input can be selected as the input source at one time.
	InputAttachments []*InputAttachment `protobuf:"bytes,16,rep,name=input_attachments,json=inputAttachments,proto3" json:"input_attachments,omitempty"`
	// Output only. The
	// [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key]
	// that serves as the current input source. The first input in the
	// [input_attachments][google.cloud.video.livestream.v1.Channel.input_attachments]
	// is the initial input source.
	ActiveInput string `protobuf:"bytes,6,opt,name=active_input,json=activeInput,proto3" json:"active_input,omitempty"`
	// Required. Information about the output (that is, the Cloud Storage bucket
	// to store the generated live stream).
	Output *Channel_Output `protobuf:"bytes,9,opt,name=output,proto3" json:"output,omitempty"`
	// List of elementary streams.
	ElementaryStreams []*ElementaryStream `protobuf:"bytes,10,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// List of multiplexing settings for output streams.
	MuxStreams []*MuxStream `protobuf:"bytes,11,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// List of output manifests.
	Manifests []*Manifest `protobuf:"bytes,12,rep,name=manifests,proto3" json:"manifests,omitempty"`
	// List of output sprite sheets.
	SpriteSheets []*SpriteSheet `protobuf:"bytes,13,rep,name=sprite_sheets,json=spriteSheets,proto3" json:"sprite_sheets,omitempty"`
	// Output only. State of the streaming operation.
	StreamingState Channel_StreamingState `protobuf:"varint,14,opt,name=streaming_state,json=streamingState,proto3,enum=google.cloud.video.livestream.v1.Channel_StreamingState" json:"streaming_state,omitempty"`
	// Output only. A description of the reason for the streaming error. This
	// property is always present when
	// [streaming_state][google.cloud.video.livestream.v1.Channel.streaming_state]
	// is
	// [STREAMING_ERROR][google.cloud.video.livestream.v1.Channel.StreamingState.STREAMING_ERROR].
	StreamingError *status.Status `protobuf:"bytes,18,opt,name=streaming_error,json=streamingError,proto3" json:"streaming_error,omitempty"`
	// Configuration of platform logs for this channel.
	LogConfig *LogConfig `protobuf:"bytes,19,opt,name=log_config,json=logConfig,proto3" json:"log_config,omitempty"`
	// Configuration of timecode for this channel.
	TimecodeConfig *TimecodeConfig `protobuf:"bytes,21,opt,name=timecode_config,json=timecodeConfig,proto3" json:"timecode_config,omitempty"`
	// Encryption configurations for this channel. Each configuration has an ID
	// which is referred to by each MuxStream to indicate which configuration is
	// used for that output.
	Encryptions []*Encryption `protobuf:"bytes,24,rep,name=encryptions,proto3" json:"encryptions,omitempty"`
	// The configuration for input sources defined in
	// [input_attachments][google.cloud.video.livestream.v1.Channel.input_attachments].
	InputConfig *InputConfig `protobuf:"bytes,25,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Optional. Configuration for retention of output files for this channel.
	RetentionConfig *RetentionConfig `protobuf:"bytes,26,opt,name=retention_config,json=retentionConfig,proto3" json:"retention_config,omitempty"`
	// Optional. List of static overlay images. Those images display over the
	// output content for the whole duration of the live stream.
	StaticOverlays []*StaticOverlay `protobuf:"bytes,27,rep,name=static_overlays,json=staticOverlays,proto3" json:"static_overlays,omitempty"`
}

func (x *Channel) Reset() {
	*x = Channel{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel) ProtoMessage() {}

func (x *Channel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel.ProtoReflect.Descriptor instead.
func (*Channel) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Channel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Channel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Channel) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Channel) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Channel) GetInputAttachments() []*InputAttachment {
	if x != nil {
		return x.InputAttachments
	}
	return nil
}

func (x *Channel) GetActiveInput() string {
	if x != nil {
		return x.ActiveInput
	}
	return ""
}

func (x *Channel) GetOutput() *Channel_Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *Channel) GetElementaryStreams() []*ElementaryStream {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *Channel) GetMuxStreams() []*MuxStream {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (x *Channel) GetManifests() []*Manifest {
	if x != nil {
		return x.Manifests
	}
	return nil
}

func (x *Channel) GetSpriteSheets() []*SpriteSheet {
	if x != nil {
		return x.SpriteSheets
	}
	return nil
}

func (x *Channel) GetStreamingState() Channel_StreamingState {
	if x != nil {
		return x.StreamingState
	}
	return Channel_STREAMING_STATE_UNSPECIFIED
}

func (x *Channel) GetStreamingError() *status.Status {
	if x != nil {
		return x.StreamingError
	}
	return nil
}

func (x *Channel) GetLogConfig() *LogConfig {
	if x != nil {
		return x.LogConfig
	}
	return nil
}

func (x *Channel) GetTimecodeConfig() *TimecodeConfig {
	if x != nil {
		return x.TimecodeConfig
	}
	return nil
}

func (x *Channel) GetEncryptions() []*Encryption {
	if x != nil {
		return x.Encryptions
	}
	return nil
}

func (x *Channel) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *Channel) GetRetentionConfig() *RetentionConfig {
	if x != nil {
		return x.RetentionConfig
	}
	return nil
}

func (x *Channel) GetStaticOverlays() []*StaticOverlay {
	if x != nil {
		return x.StaticOverlays
	}
	return nil
}

// 2D normalized coordinates.
type NormalizedCoordinate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Normalized x coordinate. Valid range is [0.0, 1.0]. Default is 0.
	X float64 `protobuf:"fixed64,1,opt,name=x,proto3" json:"x,omitempty"`
	// Optional. Normalized y coordinate. Valid range is [0.0, 1.0]. Default is 0.
	Y float64 `protobuf:"fixed64,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *NormalizedCoordinate) Reset() {
	*x = NormalizedCoordinate{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NormalizedCoordinate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedCoordinate) ProtoMessage() {}

func (x *NormalizedCoordinate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedCoordinate.ProtoReflect.Descriptor instead.
func (*NormalizedCoordinate) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *NormalizedCoordinate) GetX() float64 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *NormalizedCoordinate) GetY() float64 {
	if x != nil {
		return x.Y
	}
	return 0
}

// Normalized resolution.
type NormalizedResolution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Normalized width. Valid range is [0.0, 1.0]. Default is 0.
	W float64 `protobuf:"fixed64,1,opt,name=w,proto3" json:"w,omitempty"`
	// Optional. Normalized height. Valid range is [0.0, 1.0]. Default is 0.
	H float64 `protobuf:"fixed64,2,opt,name=h,proto3" json:"h,omitempty"`
}

func (x *NormalizedResolution) Reset() {
	*x = NormalizedResolution{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NormalizedResolution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedResolution) ProtoMessage() {}

func (x *NormalizedResolution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedResolution.ProtoReflect.Descriptor instead.
func (*NormalizedResolution) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *NormalizedResolution) GetW() float64 {
	if x != nil {
		return x.W
	}
	return 0
}

func (x *NormalizedResolution) GetH() float64 {
	if x != nil {
		return x.H
	}
	return 0
}

// Configuration for the static overlay.
type StaticOverlay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Asset to use for the overlaid image.
	// The asset must be represented in the form of:
	// `projects/{project}/locations/{location}/assets/{assetId}`.
	// The asset's resource type must be image.
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// Optional. Normalized image resolution, based on output video resolution.
	// Valid values are [0.0, 1.0]. To respect the original image aspect ratio,
	// set either `w` or `h` to 0. To use the original image resolution, set both
	// `w` and `h` to 0. The default is {0, 0}.
	Resolution *NormalizedResolution `protobuf:"bytes,2,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Optional. Position of the image in terms of normalized coordinates of the
	// upper-left corner of the image, based on output video resolution. For
	// example, use the x and y coordinates {0, 0} to position the top-left corner
	// of the overlay animation in the top-left corner of the output video.
	Position *NormalizedCoordinate `protobuf:"bytes,3,opt,name=position,proto3" json:"position,omitempty"`
	// Optional. Target image opacity. Valid values are from `1.0` (solid,
	// default) to `0.0` (transparent), exclusive. Set this to a value greater
	// than `0.0`.
	Opacity float64 `protobuf:"fixed64,4,opt,name=opacity,proto3" json:"opacity,omitempty"`
}

func (x *StaticOverlay) Reset() {
	*x = StaticOverlay{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StaticOverlay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticOverlay) ProtoMessage() {}

func (x *StaticOverlay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticOverlay.ProtoReflect.Descriptor instead.
func (*StaticOverlay) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *StaticOverlay) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *StaticOverlay) GetResolution() *NormalizedResolution {
	if x != nil {
		return x.Resolution
	}
	return nil
}

func (x *StaticOverlay) GetPosition() *NormalizedCoordinate {
	if x != nil {
		return x.Position
	}
	return nil
}

func (x *StaticOverlay) GetOpacity() float64 {
	if x != nil {
		return x.Opacity
	}
	return 0
}

// Configuration for the input sources of a channel.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input switch mode. Default mode is `FAILOVER_PREFER_PRIMARY`.
	InputSwitchMode InputConfig_InputSwitchMode `protobuf:"varint,1,opt,name=input_switch_mode,json=inputSwitchMode,proto3,enum=google.cloud.video.livestream.v1.InputConfig_InputSwitchMode" json:"input_switch_mode,omitempty"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *InputConfig) GetInputSwitchMode() InputConfig_InputSwitchMode {
	if x != nil {
		return x.InputSwitchMode
	}
	return InputConfig_INPUT_SWITCH_MODE_UNSPECIFIED
}

// Configuration of platform logs.
// See [Using and managing platform
// logs](https://cloud.google.com/logging/docs/api/platform-logs#managing-logs)
// for more information about how to view platform logs through Cloud Logging.
type LogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The severity level of platform logging for this resource.
	LogSeverity LogConfig_LogSeverity `protobuf:"varint,1,opt,name=log_severity,json=logSeverity,proto3,enum=google.cloud.video.livestream.v1.LogConfig_LogSeverity" json:"log_severity,omitempty"`
}

func (x *LogConfig) Reset() {
	*x = LogConfig{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogConfig) ProtoMessage() {}

func (x *LogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogConfig.ProtoReflect.Descriptor instead.
func (*LogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *LogConfig) GetLogSeverity() LogConfig_LogSeverity {
	if x != nil {
		return x.LogSeverity
	}
	return LogConfig_LOG_SEVERITY_UNSPECIFIED
}

// Configuration for retention of output files.
type RetentionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum duration for which the output files from the channel will
	// remain in the output bucket. After this duration, output files are
	// deleted asynchronously.
	//
	// When the channel is deleted, all output files are deleted from the output
	// bucket asynchronously.
	//
	// If omitted or set to zero, output files will remain in the output bucket
	// based on
	// [Manifest.segment_keep_duration][google.cloud.video.livestream.v1.Manifest.segment_keep_duration],
	// which defaults to 60s.
	//
	// If both retention_window_duration and
	// [Manifest.segment_keep_duration][google.cloud.video.livestream.v1.Manifest.segment_keep_duration]
	// are set, retention_window_duration is used and
	// [Manifest.segment_keep_duration][google.cloud.video.livestream.v1.Manifest.segment_keep_duration]
	// is ignored.
	RetentionWindowDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=retention_window_duration,json=retentionWindowDuration,proto3" json:"retention_window_duration,omitempty"`
}

func (x *RetentionConfig) Reset() {
	*x = RetentionConfig{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetentionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetentionConfig) ProtoMessage() {}

func (x *RetentionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetentionConfig.ProtoReflect.Descriptor instead.
func (*RetentionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *RetentionConfig) GetRetentionWindowDuration() *durationpb.Duration {
	if x != nil {
		return x.RetentionWindowDuration
	}
	return nil
}

// Properties of the input stream.
type InputStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the current input stream is accepted and the connection is
	// established.
	LastEstablishTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_establish_time,json=lastEstablishTime,proto3" json:"last_establish_time,omitempty"`
	// Properties of the video streams.
	VideoStreams []*VideoStreamProperty `protobuf:"bytes,2,rep,name=video_streams,json=videoStreams,proto3" json:"video_streams,omitempty"`
	// Properties of the audio streams.
	AudioStreams []*AudioStreamProperty `protobuf:"bytes,3,rep,name=audio_streams,json=audioStreams,proto3" json:"audio_streams,omitempty"`
}

func (x *InputStreamProperty) Reset() {
	*x = InputStreamProperty{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputStreamProperty) ProtoMessage() {}

func (x *InputStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputStreamProperty.ProtoReflect.Descriptor instead.
func (*InputStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *InputStreamProperty) GetLastEstablishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastEstablishTime
	}
	return nil
}

func (x *InputStreamProperty) GetVideoStreams() []*VideoStreamProperty {
	if x != nil {
		return x.VideoStreams
	}
	return nil
}

func (x *InputStreamProperty) GetAudioStreams() []*AudioStreamProperty {
	if x != nil {
		return x.AudioStreams
	}
	return nil
}

// Properties of the video stream.
type VideoStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this video stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the video format.
	VideoFormat *VideoFormat `protobuf:"bytes,2,opt,name=video_format,json=videoFormat,proto3" json:"video_format,omitempty"`
}

func (x *VideoStreamProperty) Reset() {
	*x = VideoStreamProperty{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStreamProperty) ProtoMessage() {}

func (x *VideoStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStreamProperty.ProtoReflect.Descriptor instead.
func (*VideoStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *VideoStreamProperty) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *VideoStreamProperty) GetVideoFormat() *VideoFormat {
	if x != nil {
		return x.VideoFormat
	}
	return nil
}

// Properties of the video format.
type VideoFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video codec used in this video stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The width of the video stream in pixels.
	WidthPixels int32 `protobuf:"varint,2,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video stream in pixels.
	HeightPixels int32 `protobuf:"varint,3,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// The frame rate of the input video stream.
	FrameRate float64 `protobuf:"fixed64,4,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
}

func (x *VideoFormat) Reset() {
	*x = VideoFormat{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFormat) ProtoMessage() {}

func (x *VideoFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFormat.ProtoReflect.Descriptor instead.
func (*VideoFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *VideoFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *VideoFormat) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoFormat) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoFormat) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

// Properties of the audio stream.
type AudioStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this audio stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the audio format.
	AudioFormat *AudioFormat `protobuf:"bytes,2,opt,name=audio_format,json=audioFormat,proto3" json:"audio_format,omitempty"`
}

func (x *AudioStreamProperty) Reset() {
	*x = AudioStreamProperty{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStreamProperty) ProtoMessage() {}

func (x *AudioStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStreamProperty.ProtoReflect.Descriptor instead.
func (*AudioStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *AudioStreamProperty) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AudioStreamProperty) GetAudioFormat() *AudioFormat {
	if x != nil {
		return x.AudioFormat
	}
	return nil
}

// Properties of the audio format.
type AudioFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Audio codec used in this audio stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The number of audio channels.
	ChannelCount int32 `protobuf:"varint,2,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying the layout of the audio channels.
	ChannelLayout []string `protobuf:"bytes,3,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
}

func (x *AudioFormat) Reset() {
	*x = AudioFormat{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioFormat) ProtoMessage() {}

func (x *AudioFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioFormat.ProtoReflect.Descriptor instead.
func (*AudioFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *AudioFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioFormat) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioFormat) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

// A group of information for attaching an input resource to this channel.
type InputAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this input attachment. The key must be 1-63
	// characters in length. The key must begin and end with a letter (regardless
	// of case) or a number, but can contain dashes or underscores in between.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The resource name of an existing input, in the form of:
	// `projects/{project}/locations/{location}/inputs/{inputId}`.
	Input string `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// Automatic failover configurations.
	AutomaticFailover *InputAttachment_AutomaticFailover `protobuf:"bytes,3,opt,name=automatic_failover,json=automaticFailover,proto3" json:"automatic_failover,omitempty"`
}

func (x *InputAttachment) Reset() {
	*x = InputAttachment{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAttachment) ProtoMessage() {}

func (x *InputAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAttachment.ProtoReflect.Descriptor instead.
func (*InputAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *InputAttachment) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *InputAttachment) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

func (x *InputAttachment) GetAutomaticFailover() *InputAttachment_AutomaticFailover {
	if x != nil {
		return x.AutomaticFailover
	}
	return nil
}

// Event is a sub-resource of a channel, which can be scheduled by the user to
// execute operations on a channel resource without having to stop the channel.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the event, in the form of:
	// `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Operation to be executed by this event.
	//
	// Types that are assignable to Task:
	//
	//	*Event_InputSwitch
	//	*Event_AdBreak
	//	*Event_ReturnToProgram
	//	*Event_Slate
	//	*Event_Mute
	//	*Event_Unmute
	Task isEvent_Task `protobuf_oneof:"task"`
	// When this field is set to true, the event will be executed at the earliest
	// time that the server can schedule the event and
	// [execution_time][google.cloud.video.livestream.v1.Event.execution_time]
	// will be populated with the time that the server actually schedules the
	// event.
	ExecuteNow bool `protobuf:"varint,9,opt,name=execute_now,json=executeNow,proto3" json:"execute_now,omitempty"`
	// The time to execute the event. If you set
	// [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
	// `true`, then do not set this field in the `CreateEvent` request. In
	// this case, the server schedules the event and populates this field. If you
	// set [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
	// `false`, then you must set this field to at least 10 seconds in the future
	// or else the event can't be created.
	ExecutionTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=execution_time,json=executionTime,proto3" json:"execution_time,omitempty"`
	// Output only. The state of the event.
	State Event_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.video.livestream.v1.Event_State" json:"state,omitempty"`
	// Output only. An error object that describes the reason for the failure.
	// This property is always present when `state` is `FAILED`.
	Error *status.Status `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *Event) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Event) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Event) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Event) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *Event) GetTask() isEvent_Task {
	if m != nil {
		return m.Task
	}
	return nil
}

func (x *Event) GetInputSwitch() *Event_InputSwitchTask {
	if x, ok := x.GetTask().(*Event_InputSwitch); ok {
		return x.InputSwitch
	}
	return nil
}

func (x *Event) GetAdBreak() *Event_AdBreakTask {
	if x, ok := x.GetTask().(*Event_AdBreak); ok {
		return x.AdBreak
	}
	return nil
}

func (x *Event) GetReturnToProgram() *Event_ReturnToProgramTask {
	if x, ok := x.GetTask().(*Event_ReturnToProgram); ok {
		return x.ReturnToProgram
	}
	return nil
}

func (x *Event) GetSlate() *Event_SlateTask {
	if x, ok := x.GetTask().(*Event_Slate); ok {
		return x.Slate
	}
	return nil
}

func (x *Event) GetMute() *Event_MuteTask {
	if x, ok := x.GetTask().(*Event_Mute); ok {
		return x.Mute
	}
	return nil
}

func (x *Event) GetUnmute() *Event_UnmuteTask {
	if x, ok := x.GetTask().(*Event_Unmute); ok {
		return x.Unmute
	}
	return nil
}

func (x *Event) GetExecuteNow() bool {
	if x != nil {
		return x.ExecuteNow
	}
	return false
}

func (x *Event) GetExecutionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExecutionTime
	}
	return nil
}

func (x *Event) GetState() Event_State {
	if x != nil {
		return x.State
	}
	return Event_STATE_UNSPECIFIED
}

func (x *Event) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

type isEvent_Task interface {
	isEvent_Task()
}

type Event_InputSwitch struct {
	// Switches to another input stream.
	InputSwitch *Event_InputSwitchTask `protobuf:"bytes,5,opt,name=input_switch,json=inputSwitch,proto3,oneof"`
}

type Event_AdBreak struct {
	// Inserts a new ad opportunity.
	AdBreak *Event_AdBreakTask `protobuf:"bytes,6,opt,name=ad_break,json=adBreak,proto3,oneof"`
}

type Event_ReturnToProgram struct {
	// Stops any running ad break.
	ReturnToProgram *Event_ReturnToProgramTask `protobuf:"bytes,13,opt,name=return_to_program,json=returnToProgram,proto3,oneof"`
}

type Event_Slate struct {
	// Inserts a slate.
	Slate *Event_SlateTask `protobuf:"bytes,14,opt,name=slate,proto3,oneof"`
}

type Event_Mute struct {
	// Mutes the stream.
	Mute *Event_MuteTask `protobuf:"bytes,15,opt,name=mute,proto3,oneof"`
}

type Event_Unmute struct {
	// Unmutes the stream.
	Unmute *Event_UnmuteTask `protobuf:"bytes,16,opt,name=unmute,proto3,oneof"`
}

func (*Event_InputSwitch) isEvent_Task() {}

func (*Event_AdBreak) isEvent_Task() {}

func (*Event_ReturnToProgram) isEvent_Task() {}

func (*Event_Slate) isEvent_Task() {}

func (*Event_Mute) isEvent_Task() {}

func (*Event_Unmute) isEvent_Task() {}

// Clip is a sub-resource under channel. Each clip represents a clipping
// operation that generates a VOD playlist from its channel given a set of
// timestamp ranges.
type Clip struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the clip, in the following format:
	// `projects/{project}/locations/{location}/channels/{c}/clips/{clipId}`.
	// `{clipId}` is a user-specified resource id that conforms to the following
	// criteria:
	//
	// 1. 1 character minimum, 63 characters maximum
	// 2. Only contains letters, digits, underscores, and hyphens
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation timestamp of the clip resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the clip request starts to be processed.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The update timestamp of the clip resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels associated with this resource. Each label is a key-value pair.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The state of the clip.
	State Clip_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.video.livestream.v1.Clip_State" json:"state,omitempty"`
	// Specify the `output_uri` to determine where to place the clip segments and
	// clip manifest files in Cloud Storage. The manifests specified in
	// `clip_manifests` fields will be placed under this URI. The exact URI of the
	// generated manifests will be provided in `clip_manifests.output_uri` for
	// each manifest.
	// Example:
	// "output_uri": "gs://my-bucket/clip-outputs"
	// "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
	OutputUri string `protobuf:"bytes,7,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Output only. An error object that describes the reason for the failure.
	// This property only presents when `state` is `FAILED`.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// The specified ranges of segments to generate a clip.
	Slices []*Clip_Slice `protobuf:"bytes,10,rep,name=slices,proto3" json:"slices,omitempty"`
	// Required. A list of clip manifests. Currently only one clip manifest is
	// allowed.
	ClipManifests []*Clip_ClipManifest `protobuf:"bytes,12,rep,name=clip_manifests,json=clipManifests,proto3" json:"clip_manifests,omitempty"`
}

func (x *Clip) Reset() {
	*x = Clip{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Clip) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clip) ProtoMessage() {}

func (x *Clip) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clip.ProtoReflect.Descriptor instead.
func (*Clip) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *Clip) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Clip) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Clip) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Clip) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Clip) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Clip) GetState() Clip_State {
	if x != nil {
		return x.State
	}
	return Clip_STATE_UNSPECIFIED
}

func (x *Clip) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *Clip) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Clip) GetSlices() []*Clip_Slice {
	if x != nil {
		return x.Slices
	}
	return nil
}

func (x *Clip) GetClipManifests() []*Clip_ClipManifest {
	if x != nil {
		return x.ClipManifests
	}
	return nil
}

// An asset represents a video or an image.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the asset, in the form of:
	// `projects/{project}/locations/{location}/assets/{assetId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The reference to the asset.
	// The maximum size of the resource is 250 MB.
	//
	// Types that are assignable to Resource:
	//
	//	*Asset_Video
	//	*Asset_Image
	Resource isAsset_Resource `protobuf_oneof:"resource"`
	// Based64-encoded CRC32c checksum of the asset file. For more information,
	// see the crc32c checksum of the [Cloud Storage Objects
	// resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
	// If crc32c is omitted or left empty when the asset is created, this field is
	// filled by the crc32c checksum of the Cloud Storage object indicated by
	// [VideoAsset.uri][google.cloud.video.livestream.v1.Asset.VideoAsset.uri] or
	// [ImageAsset.uri][google.cloud.video.livestream.v1.Asset.ImageAsset.uri]. If
	// crc32c is set, the asset can't be created if the crc32c value does not
	// match with the crc32c checksum of the Cloud Storage object indicated by
	// [VideoAsset.uri][google.cloud.video.livestream.v1.Asset.VideoAsset.uri] or
	// [ImageAsset.uri][google.cloud.video.livestream.v1.Asset.ImageAsset.uri].
	Crc32C string `protobuf:"bytes,7,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Output only. The state of the asset resource.
	State Asset_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.video.livestream.v1.Asset_State" json:"state,omitempty"`
	// Output only. Only present when `state` is `ERROR`. The reason for the error
	// state of the asset.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{16}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Asset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *Asset) GetResource() isAsset_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (x *Asset) GetVideo() *Asset_VideoAsset {
	if x, ok := x.GetResource().(*Asset_Video); ok {
		return x.Video
	}
	return nil
}

func (x *Asset) GetImage() *Asset_ImageAsset {
	if x, ok := x.GetResource().(*Asset_Image); ok {
		return x.Image
	}
	return nil
}

func (x *Asset) GetCrc32C() string {
	if x != nil {
		return x.Crc32C
	}
	return ""
}

func (x *Asset) GetState() Asset_State {
	if x != nil {
		return x.State
	}
	return Asset_STATE_UNSPECIFIED
}

func (x *Asset) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

type isAsset_Resource interface {
	isAsset_Resource()
}

type Asset_Video struct {
	// VideoAsset represents a video.
	Video *Asset_VideoAsset `protobuf:"bytes,5,opt,name=video,proto3,oneof"`
}

type Asset_Image struct {
	// ImageAsset represents an image.
	Image *Asset_ImageAsset `protobuf:"bytes,6,opt,name=image,proto3,oneof"`
}

func (*Asset_Video) isAsset_Resource() {}

func (*Asset_Image) isAsset_Resource() {}

// Encryption settings.
type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier for this set of encryption options. The ID must be
	// 1-63 characters in length. The ID must begin and end with a letter
	// (regardless of case) or a number, but can contain dashes or underscores in
	// between.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Defines where content keys are stored.
	//
	// Types that are assignable to SecretSource:
	//
	//	*Encryption_SecretManagerKeySource
	SecretSource isEncryption_SecretSource `protobuf_oneof:"secret_source"`
	// Required. Configuration for DRM systems.
	DrmSystems *Encryption_DrmSystems `protobuf:"bytes,3,opt,name=drm_systems,json=drmSystems,proto3" json:"drm_systems,omitempty"`
	// Encryption modes for HLS and MPEG-Dash.
	//
	// Types that are assignable to EncryptionMode:
	//
	//	*Encryption_Aes128
	//	*Encryption_SampleAes
	//	*Encryption_MpegCenc
	EncryptionMode isEncryption_EncryptionMode `protobuf_oneof:"encryption_mode"`
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17}
}

func (x *Encryption) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *Encryption) GetSecretSource() isEncryption_SecretSource {
	if m != nil {
		return m.SecretSource
	}
	return nil
}

func (x *Encryption) GetSecretManagerKeySource() *Encryption_SecretManagerSource {
	if x, ok := x.GetSecretSource().(*Encryption_SecretManagerKeySource); ok {
		return x.SecretManagerKeySource
	}
	return nil
}

func (x *Encryption) GetDrmSystems() *Encryption_DrmSystems {
	if x != nil {
		return x.DrmSystems
	}
	return nil
}

func (m *Encryption) GetEncryptionMode() isEncryption_EncryptionMode {
	if m != nil {
		return m.EncryptionMode
	}
	return nil
}

func (x *Encryption) GetAes128() *Encryption_Aes128Encryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_Aes128); ok {
		return x.Aes128
	}
	return nil
}

func (x *Encryption) GetSampleAes() *Encryption_SampleAesEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_SampleAes); ok {
		return x.SampleAes
	}
	return nil
}

func (x *Encryption) GetMpegCenc() *Encryption_MpegCommonEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_MpegCenc); ok {
		return x.MpegCenc
	}
	return nil
}

type isEncryption_SecretSource interface {
	isEncryption_SecretSource()
}

type Encryption_SecretManagerKeySource struct {
	// For keys stored in Google Secret Manager.
	SecretManagerKeySource *Encryption_SecretManagerSource `protobuf:"bytes,7,opt,name=secret_manager_key_source,json=secretManagerKeySource,proto3,oneof"`
}

func (*Encryption_SecretManagerKeySource) isEncryption_SecretSource() {}

type isEncryption_EncryptionMode interface {
	isEncryption_EncryptionMode()
}

type Encryption_Aes128 struct {
	// Configuration for HLS AES-128 encryption.
	Aes128 *Encryption_Aes128Encryption `protobuf:"bytes,4,opt,name=aes128,proto3,oneof"`
}

type Encryption_SampleAes struct {
	// Configuration for HLS SAMPLE-AES encryption.
	SampleAes *Encryption_SampleAesEncryption `protobuf:"bytes,5,opt,name=sample_aes,json=sampleAes,proto3,oneof"`
}

type Encryption_MpegCenc struct {
	// Configuration for MPEG-Dash Common Encryption (MPEG-CENC).
	MpegCenc *Encryption_MpegCommonEncryption `protobuf:"bytes,6,opt,name=mpeg_cenc,json=mpegCenc,proto3,oneof"`
}

func (*Encryption_Aes128) isEncryption_EncryptionMode() {}

func (*Encryption_SampleAes) isEncryption_EncryptionMode() {}

func (*Encryption_MpegCenc) isEncryption_EncryptionMode() {}

// Pool resource defines the configuration of Live Stream pools for a specific
// location. Currently we support only one pool resource per project per
// location. After the creation of the first input, a default pool is created
// automatically at "projects/{project}/locations/{location}/pools/default".
type Pool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the pool, in the form of:
	// `projects/{project}/locations/{location}/pools/{poolId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Network configuration for the pool.
	NetworkConfig *Pool_NetworkConfig `protobuf:"bytes,5,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
}

func (x *Pool) Reset() {
	*x = Pool{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pool) ProtoMessage() {}

func (x *Pool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pool.ProtoReflect.Descriptor instead.
func (*Pool) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{18}
}

func (x *Pool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Pool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Pool) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Pool) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Pool) GetNetworkConfig() *Pool_NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

// Security rules for access control. Each field represents one security rule.
// Only when the source of the input stream satisfies all the fields, this
// input stream can be accepted.
type Input_SecurityRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// At least one ip range must match unless none specified. The IP range is
	// defined by CIDR block: for example, `192.0.1.0/24` for a range and
	// `192.0.1.0/32` for a single IP address.
	IpRanges []string `protobuf:"bytes,1,rep,name=ip_ranges,json=ipRanges,proto3" json:"ip_ranges,omitempty"`
}

func (x *Input_SecurityRule) Reset() {
	*x = Input_SecurityRule{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Input_SecurityRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input_SecurityRule) ProtoMessage() {}

func (x *Input_SecurityRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input_SecurityRule.ProtoReflect.Descriptor instead.
func (*Input_SecurityRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Input_SecurityRule) GetIpRanges() []string {
	if x != nil {
		return x.IpRanges
	}
	return nil
}

// Location of output file(s) in a Google Cloud Storage bucket.
type Channel_Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI for the output file(s). For example, `gs://my-bucket/outputs/`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Channel_Output) Reset() {
	*x = Channel_Output{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Channel_Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel_Output) ProtoMessage() {}

func (x *Channel_Output) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel_Output.ProtoReflect.Descriptor instead.
func (*Channel_Output) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Channel_Output) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Configurations to follow when automatic failover happens.
type InputAttachment_AutomaticFailover struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The
	// [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key]s
	// of inputs to failover to when this input is disconnected. Currently, only
	// up to one backup input is supported.
	InputKeys []string `protobuf:"bytes,1,rep,name=input_keys,json=inputKeys,proto3" json:"input_keys,omitempty"`
}

func (x *InputAttachment_AutomaticFailover) Reset() {
	*x = InputAttachment_AutomaticFailover{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputAttachment_AutomaticFailover) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAttachment_AutomaticFailover) ProtoMessage() {}

func (x *InputAttachment_AutomaticFailover) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAttachment_AutomaticFailover.ProtoReflect.Descriptor instead.
func (*InputAttachment_AutomaticFailover) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *InputAttachment_AutomaticFailover) GetInputKeys() []string {
	if x != nil {
		return x.InputKeys
	}
	return nil
}

// Switches to another input stream. Automatic failover is then disabled.
type Event_InputSwitchTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The
	// [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key]
	// of the input to switch to.
	InputKey string `protobuf:"bytes,1,opt,name=input_key,json=inputKey,proto3" json:"input_key,omitempty"`
}

func (x *Event_InputSwitchTask) Reset() {
	*x = Event_InputSwitchTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_InputSwitchTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_InputSwitchTask) ProtoMessage() {}

func (x *Event_InputSwitchTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_InputSwitchTask.ProtoReflect.Descriptor instead.
func (*Event_InputSwitchTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 0}
}

func (x *Event_InputSwitchTask) GetInputKey() string {
	if x != nil {
		return x.InputKey
	}
	return ""
}

// Inserts a new ad opportunity.
type Event_AdBreakTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of an ad opportunity. Must be greater than 0.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *Event_AdBreakTask) Reset() {
	*x = Event_AdBreakTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_AdBreakTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_AdBreakTask) ProtoMessage() {}

func (x *Event_AdBreakTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_AdBreakTask.ProtoReflect.Descriptor instead.
func (*Event_AdBreakTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 1}
}

func (x *Event_AdBreakTask) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Inserts a slate.
type Event_SlateTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Duration of the slate. Must be greater than 0 if specified.
	// Omit this field for a long running slate.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// Slate asset to use for the duration. If its duration is less than the
	// duration of the SlateTask, then the slate loops. The slate must be
	// represented in the form of:
	// `projects/{project}/locations/{location}/assets/{assetId}`.
	Asset string `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
}

func (x *Event_SlateTask) Reset() {
	*x = Event_SlateTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_SlateTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_SlateTask) ProtoMessage() {}

func (x *Event_SlateTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_SlateTask.ProtoReflect.Descriptor instead.
func (*Event_SlateTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 2}
}

func (x *Event_SlateTask) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Event_SlateTask) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

// Stops any events which are currently running. This only applies to events
// with a duration.
type Event_ReturnToProgramTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Event_ReturnToProgramTask) Reset() {
	*x = Event_ReturnToProgramTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_ReturnToProgramTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_ReturnToProgramTask) ProtoMessage() {}

func (x *Event_ReturnToProgramTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_ReturnToProgramTask.ProtoReflect.Descriptor instead.
func (*Event_ReturnToProgramTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 3}
}

// Mutes the stream.
type Event_MuteTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration for which the stream should be muted. If omitted, the stream
	// will be muted until an UnmuteTask event is sent.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *Event_MuteTask) Reset() {
	*x = Event_MuteTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_MuteTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_MuteTask) ProtoMessage() {}

func (x *Event_MuteTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_MuteTask.ProtoReflect.Descriptor instead.
func (*Event_MuteTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 4}
}

func (x *Event_MuteTask) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Unmutes the stream. The task fails if the stream is not currently muted.
type Event_UnmuteTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Event_UnmuteTask) Reset() {
	*x = Event_UnmuteTask{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event_UnmuteTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_UnmuteTask) ProtoMessage() {}

func (x *Event_UnmuteTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_UnmuteTask.ProtoReflect.Descriptor instead.
func (*Event_UnmuteTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{14, 5}
}

// TimeSlice represents a tuple of Unix epoch timestamps that specifies a time
// range.
type Clip_TimeSlice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mark-in Unix epoch time in the original live stream manifest.
	MarkinTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=markin_time,json=markinTime,proto3" json:"markin_time,omitempty"`
	// The mark-out Unix epoch time in the original live stream manifest.
	MarkoutTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=markout_time,json=markoutTime,proto3" json:"markout_time,omitempty"`
}

func (x *Clip_TimeSlice) Reset() {
	*x = Clip_TimeSlice{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Clip_TimeSlice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clip_TimeSlice) ProtoMessage() {}

func (x *Clip_TimeSlice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clip_TimeSlice.ProtoReflect.Descriptor instead.
func (*Clip_TimeSlice) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{15, 0}
}

func (x *Clip_TimeSlice) GetMarkinTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MarkinTime
	}
	return nil
}

func (x *Clip_TimeSlice) GetMarkoutTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MarkoutTime
	}
	return nil
}

// Slice represents a slice of the requested clip.
type Clip_Slice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlist forms of a slice.
	//
	// Types that are assignable to Kind:
	//
	//	*Clip_Slice_TimeSlice
	Kind isClip_Slice_Kind `protobuf_oneof:"kind"`
}

func (x *Clip_Slice) Reset() {
	*x = Clip_Slice{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Clip_Slice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clip_Slice) ProtoMessage() {}

func (x *Clip_Slice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clip_Slice.ProtoReflect.Descriptor instead.
func (*Clip_Slice) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{15, 1}
}

func (m *Clip_Slice) GetKind() isClip_Slice_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Clip_Slice) GetTimeSlice() *Clip_TimeSlice {
	if x, ok := x.GetKind().(*Clip_Slice_TimeSlice); ok {
		return x.TimeSlice
	}
	return nil
}

type isClip_Slice_Kind interface {
	isClip_Slice_Kind()
}

type Clip_Slice_TimeSlice struct {
	// A slice in form of a tuple of Unix epoch time.
	TimeSlice *Clip_TimeSlice `protobuf:"bytes,1,opt,name=time_slice,json=timeSlice,proto3,oneof"`
}

func (*Clip_Slice_TimeSlice) isClip_Slice_Kind() {}

// ClipManifest identifies a source manifest for the generated clip manifest.
type Clip_ClipManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique key that identifies a manifest config in the parent
	// channel. This key is the same as `channel.manifests.key` for the selected
	// manifest.
	ManifestKey string `protobuf:"bytes,1,opt,name=manifest_key,json=manifestKey,proto3" json:"manifest_key,omitempty"`
	// Output only. The output URI of the generated clip manifest. This field
	// will be populated when the CreateClip request is accepted. Current output
	// format is provided below but may change in the future. Please read this
	// field to get the uri to the generated clip manifest. Format:
	// {clip.output_uri}/{channel.manifest.fileName} Example:
	// gs://my-bucket/clip-outputs/main.m3u8
	OutputUri string `protobuf:"bytes,2,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *Clip_ClipManifest) Reset() {
	*x = Clip_ClipManifest{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Clip_ClipManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clip_ClipManifest) ProtoMessage() {}

func (x *Clip_ClipManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clip_ClipManifest.ProtoReflect.Descriptor instead.
func (*Clip_ClipManifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{15, 2}
}

func (x *Clip_ClipManifest) GetManifestKey() string {
	if x != nil {
		return x.ManifestKey
	}
	return ""
}

func (x *Clip_ClipManifest) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// VideoAsset represents a video. The supported formats are MP4, MPEG-TS, and
// FLV. The supported video codec is H264. The supported audio codecs are
// AAC, AC3, MP2, and MP3.
type Asset_VideoAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage URI of the video. The format is `gs://my-bucket/my-object`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Asset_VideoAsset) Reset() {
	*x = Asset_VideoAsset{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Asset_VideoAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_VideoAsset) ProtoMessage() {}

func (x *Asset_VideoAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_VideoAsset.ProtoReflect.Descriptor instead.
func (*Asset_VideoAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{16, 0}
}

func (x *Asset_VideoAsset) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Image represents an image. The supported formats are JPEG, PNG.
type Asset_ImageAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage URI of the image. The format is `gs://my-bucket/my-object`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Asset_ImageAsset) Reset() {
	*x = Asset_ImageAsset{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Asset_ImageAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_ImageAsset) ProtoMessage() {}

func (x *Asset_ImageAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_ImageAsset.ProtoReflect.Descriptor instead.
func (*Asset_ImageAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{16, 1}
}

func (x *Asset_ImageAsset) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Configuration for secrets stored in Google Secret Manager.
type Encryption_SecretManagerSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Secret Version containing the encryption key.
	// `projects/{project}/secrets/{secret_id}/versions/{version_number}`
	SecretVersion string `protobuf:"bytes,1,opt,name=secret_version,json=secretVersion,proto3" json:"secret_version,omitempty"`
}

func (x *Encryption_SecretManagerSource) Reset() {
	*x = Encryption_SecretManagerSource{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_SecretManagerSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_SecretManagerSource) ProtoMessage() {}

func (x *Encryption_SecretManagerSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_SecretManagerSource.ProtoReflect.Descriptor instead.
func (*Encryption_SecretManagerSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 0}
}

func (x *Encryption_SecretManagerSource) GetSecretVersion() string {
	if x != nil {
		return x.SecretVersion
	}
	return ""
}

// Widevine configuration.
type Encryption_Widevine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Widevine) Reset() {
	*x = Encryption_Widevine{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Widevine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Widevine) ProtoMessage() {}

func (x *Encryption_Widevine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Widevine.ProtoReflect.Descriptor instead.
func (*Encryption_Widevine) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 1}
}

// Fairplay configuration.
type Encryption_Fairplay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Fairplay) Reset() {
	*x = Encryption_Fairplay{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Fairplay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Fairplay) ProtoMessage() {}

func (x *Encryption_Fairplay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Fairplay.ProtoReflect.Descriptor instead.
func (*Encryption_Fairplay) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 2}
}

// Playready configuration.
type Encryption_Playready struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Playready) Reset() {
	*x = Encryption_Playready{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Playready) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Playready) ProtoMessage() {}

func (x *Encryption_Playready) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Playready.ProtoReflect.Descriptor instead.
func (*Encryption_Playready) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 3}
}

// Clearkey configuration.
type Encryption_Clearkey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Clearkey) Reset() {
	*x = Encryption_Clearkey{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Clearkey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Clearkey) ProtoMessage() {}

func (x *Encryption_Clearkey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Clearkey.ProtoReflect.Descriptor instead.
func (*Encryption_Clearkey) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 4}
}

// Defines configuration for DRM systems in use. If a field is omitted,
// that DRM system will be considered to be disabled.
type Encryption_DrmSystems struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Widevine configuration.
	Widevine *Encryption_Widevine `protobuf:"bytes,1,opt,name=widevine,proto3" json:"widevine,omitempty"`
	// Fairplay configuration.
	Fairplay *Encryption_Fairplay `protobuf:"bytes,2,opt,name=fairplay,proto3" json:"fairplay,omitempty"`
	// Playready configuration.
	Playready *Encryption_Playready `protobuf:"bytes,3,opt,name=playready,proto3" json:"playready,omitempty"`
	// Clearkey configuration.
	Clearkey *Encryption_Clearkey `protobuf:"bytes,4,opt,name=clearkey,proto3" json:"clearkey,omitempty"`
}

func (x *Encryption_DrmSystems) Reset() {
	*x = Encryption_DrmSystems{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_DrmSystems) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_DrmSystems) ProtoMessage() {}

func (x *Encryption_DrmSystems) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_DrmSystems.ProtoReflect.Descriptor instead.
func (*Encryption_DrmSystems) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 5}
}

func (x *Encryption_DrmSystems) GetWidevine() *Encryption_Widevine {
	if x != nil {
		return x.Widevine
	}
	return nil
}

func (x *Encryption_DrmSystems) GetFairplay() *Encryption_Fairplay {
	if x != nil {
		return x.Fairplay
	}
	return nil
}

func (x *Encryption_DrmSystems) GetPlayready() *Encryption_Playready {
	if x != nil {
		return x.Playready
	}
	return nil
}

func (x *Encryption_DrmSystems) GetClearkey() *Encryption_Clearkey {
	if x != nil {
		return x.Clearkey
	}
	return nil
}

// Configuration for HLS AES-128 encryption.
type Encryption_Aes128Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Aes128Encryption) Reset() {
	*x = Encryption_Aes128Encryption{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Aes128Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Aes128Encryption) ProtoMessage() {}

func (x *Encryption_Aes128Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Aes128Encryption.ProtoReflect.Descriptor instead.
func (*Encryption_Aes128Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 6}
}

// Configuration for HLS SAMPLE-AES encryption.
type Encryption_SampleAesEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_SampleAesEncryption) Reset() {
	*x = Encryption_SampleAesEncryption{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_SampleAesEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_SampleAesEncryption) ProtoMessage() {}

func (x *Encryption_SampleAesEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_SampleAesEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_SampleAesEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 7}
}

// Configuration for MPEG-Dash Common Encryption (MPEG-CENC).
type Encryption_MpegCommonEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify the encryption scheme, supported schemes:
	// - `cenc` - AES-CTR subsample
	// - `cbcs`- AES-CBC subsample pattern
	Scheme string `protobuf:"bytes,1,opt,name=scheme,proto3" json:"scheme,omitempty"`
}

func (x *Encryption_MpegCommonEncryption) Reset() {
	*x = Encryption_MpegCommonEncryption{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_MpegCommonEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_MpegCommonEncryption) ProtoMessage() {}

func (x *Encryption_MpegCommonEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_MpegCommonEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_MpegCommonEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{17, 8}
}

func (x *Encryption_MpegCommonEncryption) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

// Defines the network configuration for the pool.
type Pool_NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// peered_network is the network resource URL of the network that is peered
	// to the service provider network. Must be of the format
	// projects/NETWORK_PROJECT_NUMBER/global/networks/NETWORK_NAME, where
	// NETWORK_PROJECT_NUMBER is the project number of the Cloud project that
	// holds your VPC network and NETWORK_NAME is the name of your VPC network.
	// If peered_network is omitted or empty, the pool will use endpoints that
	// are publicly available.
	PeeredNetwork string `protobuf:"bytes,1,opt,name=peered_network,json=peeredNetwork,proto3" json:"peered_network,omitempty"`
}

func (x *Pool_NetworkConfig) Reset() {
	*x = Pool_NetworkConfig{}
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Pool_NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pool_NetworkConfig) ProtoMessage() {}

func (x *Pool_NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pool_NetworkConfig.ProtoReflect.Descriptor instead.
func (*Pool_NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{18, 0}
}

func (x *Pool_NetworkConfig) GetPeeredNetwork() string {
	if x != nil {
		return x.PeeredNetwork
	}
	return ""
}

var File_google_cloud_video_livestream_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_video_livestream_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x07, 0x0a, 0x05, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x74,
	0x69, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x68, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x70, 0x72, 0x65, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b,
	0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0d, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x15, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x1a, 0x2b, 0x0a, 0x0c, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69,
	0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x39, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x54, 0x4d, 0x50, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x52, 0x54, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x10, 0x02, 0x22, 0x35,
	0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02,
	0x53, 0x44, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x48, 0x44, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03,
	0x55, 0x48, 0x44, 0x10, 0x03, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x36, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x7d, 0x22, 0xb3, 0x0e, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d,
	0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x61, 0x0a,
	0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x11, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x75, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x48,
	0x0a, 0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x09, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x70, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65, 0x74, 0x52, 0x0c,
	0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x0f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4a, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x59, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x74,
	0x69, 0x6d, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a,
	0x0b, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a,
	0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x61, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5d, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x6f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79,
	0x73, 0x1a, 0x1a, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xaa, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41,
	0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e,
	0x47, 0x5f, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x10, 0x08, 0x3a, 0x62, 0xea, 0x41, 0x5f, 0x0a, 0x21, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f,
	0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x7d, 0x22, 0x3c, 0x0a, 0x14, 0x4e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x12, 0x11, 0x0a, 0x01, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x01, 0x78, 0x12, 0x11, 0x0a, 0x01, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x01, 0x79, 0x22, 0x3c, 0x0a, 0x14, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x11, 0x0a, 0x01, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x01, 0x77, 0x12, 0x11, 0x0a, 0x01, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x01, 0x68, 0x22, 0xa3, 0x02, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63,
	0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x5b, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07,
	0x6f, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x22, 0xd7, 0x01, 0x0a, 0x0b,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x11, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x5d, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53,
	0x77, 0x69, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x50,
	0x55, 0x54, 0x5f, 0x53, 0x57, 0x49, 0x54, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17,
	0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f,
	0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e,
	0x55, 0x41, 0x4c, 0x10, 0x03, 0x22, 0xcd, 0x01, 0x0a, 0x09, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22,
	0x64, 0x0a, 0x0b, 0x4c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1c,
	0x0a, 0x18, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x4f, 0x46, 0x46, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x64,
	0x12, 0x09, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0xc8, 0x01, 0x12, 0x0c, 0x0a, 0x07, 0x57,
	0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x90, 0x03, 0x12, 0x0a, 0x0a, 0x05, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0xf4, 0x03, 0x22, 0x68, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x19, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x99, 0x02, 0x0a, 0x13, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x4a, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12,
	0x5a, 0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0c, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0x7d, 0x0a, 0x13, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x50, 0x0a, 0x0c, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x8a, 0x01, 0x0a, 0x0b, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63,
	0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x22, 0x7d, 0x0a, 0x13, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x6f, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x22, 0x87, 0x02, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3a, 0x0a,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x72, 0x0a, 0x12, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x1a, 0x32, 0x0a,
	0x11, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0xc8, 0x0c, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x5c, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x54, 0x61, 0x73, 0x6b, 0x48,
	0x00, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x12, 0x50,
	0x0a, 0x08, 0x61, 0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x07, 0x61, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x12, 0x69, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x6f, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x54, 0x6f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x49, 0x0a, 0x05, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52,
	0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x75,
	0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x75, 0x74, 0x65, 0x12, 0x4c,
	0x0a, 0x06, 0x75, 0x6e, 0x6d, 0x75, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x55, 0x6e, 0x6d, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x73, 0x6b, 0x48, 0x00, 0x52, 0x06, 0x75, 0x6e, 0x6d, 0x75, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x4e, 0x6f, 0x77, 0x12, 0x41, 0x0a,
	0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x2e, 0x0a, 0x0f, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x1b, 0x0a, 0x09,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x1a, 0x44, 0x0a, 0x0b, 0x41, 0x64, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x7e, 0x0a, 0x09, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x35, 0x0a, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x1a,
	0x15, 0x0a, 0x13, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x6f, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x54, 0x61, 0x73, 0x6b, 0x1a, 0x41, 0x0a, 0x08, 0x4d, 0x75, 0x74, 0x65, 0x54, 0x61,
	0x73, 0x6b, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x0c, 0x0a, 0x0a, 0x55, 0x6e, 0x6d,
	0x75, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x6f, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45,
	0x44, 0x10, 0x06, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x22, 0xb1, 0x09, 0x0a,
	0x04, 0x43, 0x6c, 0x69, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x69, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x44, 0x0a, 0x06, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x52, 0x06,
	0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x70, 0x5f, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x70, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x6d, 0x61, 0x72, 0x6b, 0x6f, 0x75, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x6d, 0x61, 0x72, 0x6b, 0x6f, 0x75, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x62, 0x0a, 0x05, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x5a, 0x0a, 0x0c, 0x43, 0x6c, 0x69, 0x70, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x22, 0x0a,
	0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x1e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x69, 0x70, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x7d, 0x2f, 0x63, 0x6c, 0x69, 0x70, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x69, 0x70, 0x7d,
	0x22, 0xcd, 0x06, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x4a, 0x0a, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x48, 0x00, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x12, 0x4a, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x48, 0x00,
	0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32,
	0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x12,
	0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x1e, 0x0a, 0x0a, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x1e, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x36, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0xa2, 0x09, 0x0a, 0x0a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x7d, 0x0a, 0x19, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x16, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0b, 0x64, 0x72, 0x6d, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x72, 0x6d, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x72, 0x6d, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x57, 0x0a, 0x06, 0x61, 0x65, 0x73, 0x31, 0x32, 0x38, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x41, 0x65, 0x73, 0x31, 0x32, 0x38, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x01, 0x52, 0x06, 0x61, 0x65, 0x73, 0x31, 0x32, 0x38, 0x12, 0x61, 0x0a, 0x0a, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x61, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x01, 0x52, 0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x12, 0x60,
	0x0a, 0x09, 0x6d, 0x70, 0x65, 0x67, 0x5f, 0x63, 0x65, 0x6e, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x08, 0x6d, 0x70, 0x65, 0x67, 0x43, 0x65, 0x6e, 0x63,
	0x1a, 0x70, 0x0a, 0x13, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x59, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x1a, 0x0a, 0x0a, 0x08, 0x57, 0x69, 0x64, 0x65, 0x76, 0x69, 0x6e, 0x65, 0x1a, 0x0a,
	0x0a, 0x08, 0x46, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79, 0x1a, 0x0b, 0x0a, 0x09, 0x50, 0x6c,
	0x61, 0x79, 0x72, 0x65, 0x61, 0x64, 0x79, 0x1a, 0x0a, 0x0a, 0x08, 0x43, 0x6c, 0x65, 0x61, 0x72,
	0x6b, 0x65, 0x79, 0x1a, 0xdb, 0x02, 0x0a, 0x0a, 0x44, 0x72, 0x6d, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x77, 0x69, 0x64, 0x65, 0x76, 0x69, 0x6e, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x64, 0x65, 0x76, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x77, 0x69, 0x64,
	0x65, 0x76, 0x69, 0x6e, 0x65, 0x12, 0x51, 0x0a, 0x08, 0x66, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x08,
	0x66, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x54, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x79,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x72, 0x65,
	0x61, 0x64, 0x79, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x61, 0x64, 0x79, 0x12, 0x51,
	0x0a, 0x08, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79, 0x52, 0x08, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65,
	0x79, 0x1a, 0x12, 0x0a, 0x10, 0x41, 0x65, 0x73, 0x31, 0x32, 0x38, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x15, 0x0a, 0x13, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x41,
	0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x33, 0x0a, 0x14,
	0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xba, 0x04, 0x0a, 0x04, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x5b, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6f, 0x6c, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x5b, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x65, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x0d, 0x70,
	0x65, 0x65, 0x72, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x59, 0xea, 0x41, 0x56, 0x0a, 0x1e, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f,
	0x6c, 0x7d, 0x42, 0xeb, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x70, 0x62, 0x3b, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x5c, 0x4c, 0x69, 0x76, 0x65,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x3a, 0x3a, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_livestream_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_video_livestream_v1_resources_proto_rawDescData = file_google_cloud_video_livestream_v1_resources_proto_rawDesc
)

func file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_video_livestream_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_livestream_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_livestream_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescData
}

var file_google_cloud_video_livestream_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_video_livestream_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_video_livestream_v1_resources_proto_goTypes = []any{
	(Input_Type)(0),                           // 0: google.cloud.video.livestream.v1.Input.Type
	(Input_Tier)(0),                           // 1: google.cloud.video.livestream.v1.Input.Tier
	(Channel_StreamingState)(0),               // 2: google.cloud.video.livestream.v1.Channel.StreamingState
	(InputConfig_InputSwitchMode)(0),          // 3: google.cloud.video.livestream.v1.InputConfig.InputSwitchMode
	(LogConfig_LogSeverity)(0),                // 4: google.cloud.video.livestream.v1.LogConfig.LogSeverity
	(Event_State)(0),                          // 5: google.cloud.video.livestream.v1.Event.State
	(Clip_State)(0),                           // 6: google.cloud.video.livestream.v1.Clip.State
	(Asset_State)(0),                          // 7: google.cloud.video.livestream.v1.Asset.State
	(*Input)(nil),                             // 8: google.cloud.video.livestream.v1.Input
	(*Channel)(nil),                           // 9: google.cloud.video.livestream.v1.Channel
	(*NormalizedCoordinate)(nil),              // 10: google.cloud.video.livestream.v1.NormalizedCoordinate
	(*NormalizedResolution)(nil),              // 11: google.cloud.video.livestream.v1.NormalizedResolution
	(*StaticOverlay)(nil),                     // 12: google.cloud.video.livestream.v1.StaticOverlay
	(*InputConfig)(nil),                       // 13: google.cloud.video.livestream.v1.InputConfig
	(*LogConfig)(nil),                         // 14: google.cloud.video.livestream.v1.LogConfig
	(*RetentionConfig)(nil),                   // 15: google.cloud.video.livestream.v1.RetentionConfig
	(*InputStreamProperty)(nil),               // 16: google.cloud.video.livestream.v1.InputStreamProperty
	(*VideoStreamProperty)(nil),               // 17: google.cloud.video.livestream.v1.VideoStreamProperty
	(*VideoFormat)(nil),                       // 18: google.cloud.video.livestream.v1.VideoFormat
	(*AudioStreamProperty)(nil),               // 19: google.cloud.video.livestream.v1.AudioStreamProperty
	(*AudioFormat)(nil),                       // 20: google.cloud.video.livestream.v1.AudioFormat
	(*InputAttachment)(nil),                   // 21: google.cloud.video.livestream.v1.InputAttachment
	(*Event)(nil),                             // 22: google.cloud.video.livestream.v1.Event
	(*Clip)(nil),                              // 23: google.cloud.video.livestream.v1.Clip
	(*Asset)(nil),                             // 24: google.cloud.video.livestream.v1.Asset
	(*Encryption)(nil),                        // 25: google.cloud.video.livestream.v1.Encryption
	(*Pool)(nil),                              // 26: google.cloud.video.livestream.v1.Pool
	(*Input_SecurityRule)(nil),                // 27: google.cloud.video.livestream.v1.Input.SecurityRule
	nil,                                       // 28: google.cloud.video.livestream.v1.Input.LabelsEntry
	(*Channel_Output)(nil),                    // 29: google.cloud.video.livestream.v1.Channel.Output
	nil,                                       // 30: google.cloud.video.livestream.v1.Channel.LabelsEntry
	(*InputAttachment_AutomaticFailover)(nil), // 31: google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover
	(*Event_InputSwitchTask)(nil),             // 32: google.cloud.video.livestream.v1.Event.InputSwitchTask
	(*Event_AdBreakTask)(nil),                 // 33: google.cloud.video.livestream.v1.Event.AdBreakTask
	(*Event_SlateTask)(nil),                   // 34: google.cloud.video.livestream.v1.Event.SlateTask
	(*Event_ReturnToProgramTask)(nil),         // 35: google.cloud.video.livestream.v1.Event.ReturnToProgramTask
	(*Event_MuteTask)(nil),                    // 36: google.cloud.video.livestream.v1.Event.MuteTask
	(*Event_UnmuteTask)(nil),                  // 37: google.cloud.video.livestream.v1.Event.UnmuteTask
	nil,                                       // 38: google.cloud.video.livestream.v1.Event.LabelsEntry
	(*Clip_TimeSlice)(nil),                    // 39: google.cloud.video.livestream.v1.Clip.TimeSlice
	(*Clip_Slice)(nil),                        // 40: google.cloud.video.livestream.v1.Clip.Slice
	(*Clip_ClipManifest)(nil),                 // 41: google.cloud.video.livestream.v1.Clip.ClipManifest
	nil,                                       // 42: google.cloud.video.livestream.v1.Clip.LabelsEntry
	(*Asset_VideoAsset)(nil),                  // 43: google.cloud.video.livestream.v1.Asset.VideoAsset
	(*Asset_ImageAsset)(nil),                  // 44: google.cloud.video.livestream.v1.Asset.ImageAsset
	nil,                                       // 45: google.cloud.video.livestream.v1.Asset.LabelsEntry
	(*Encryption_SecretManagerSource)(nil),    // 46: google.cloud.video.livestream.v1.Encryption.SecretManagerSource
	(*Encryption_Widevine)(nil),               // 47: google.cloud.video.livestream.v1.Encryption.Widevine
	(*Encryption_Fairplay)(nil),               // 48: google.cloud.video.livestream.v1.Encryption.Fairplay
	(*Encryption_Playready)(nil),              // 49: google.cloud.video.livestream.v1.Encryption.Playready
	(*Encryption_Clearkey)(nil),               // 50: google.cloud.video.livestream.v1.Encryption.Clearkey
	(*Encryption_DrmSystems)(nil),             // 51: google.cloud.video.livestream.v1.Encryption.DrmSystems
	(*Encryption_Aes128Encryption)(nil),       // 52: google.cloud.video.livestream.v1.Encryption.Aes128Encryption
	(*Encryption_SampleAesEncryption)(nil),    // 53: google.cloud.video.livestream.v1.Encryption.SampleAesEncryption
	(*Encryption_MpegCommonEncryption)(nil),   // 54: google.cloud.video.livestream.v1.Encryption.MpegCommonEncryption
	(*Pool_NetworkConfig)(nil),                // 55: google.cloud.video.livestream.v1.Pool.NetworkConfig
	nil,                                       // 56: google.cloud.video.livestream.v1.Pool.LabelsEntry
	(*timestamppb.Timestamp)(nil),             // 57: google.protobuf.Timestamp
	(*PreprocessingConfig)(nil),               // 58: google.cloud.video.livestream.v1.PreprocessingConfig
	(*ElementaryStream)(nil),                  // 59: google.cloud.video.livestream.v1.ElementaryStream
	(*MuxStream)(nil),                         // 60: google.cloud.video.livestream.v1.MuxStream
	(*Manifest)(nil),                          // 61: google.cloud.video.livestream.v1.Manifest
	(*SpriteSheet)(nil),                       // 62: google.cloud.video.livestream.v1.SpriteSheet
	(*status.Status)(nil),                     // 63: google.rpc.Status
	(*TimecodeConfig)(nil),                    // 64: google.cloud.video.livestream.v1.TimecodeConfig
	(*durationpb.Duration)(nil),               // 65: google.protobuf.Duration
}
var file_google_cloud_video_livestream_v1_resources_proto_depIdxs = []int32{
	57, // 0: google.cloud.video.livestream.v1.Input.create_time:type_name -> google.protobuf.Timestamp
	57, // 1: google.cloud.video.livestream.v1.Input.update_time:type_name -> google.protobuf.Timestamp
	28, // 2: google.cloud.video.livestream.v1.Input.labels:type_name -> google.cloud.video.livestream.v1.Input.LabelsEntry
	0,  // 3: google.cloud.video.livestream.v1.Input.type:type_name -> google.cloud.video.livestream.v1.Input.Type
	1,  // 4: google.cloud.video.livestream.v1.Input.tier:type_name -> google.cloud.video.livestream.v1.Input.Tier
	58, // 5: google.cloud.video.livestream.v1.Input.preprocessing_config:type_name -> google.cloud.video.livestream.v1.PreprocessingConfig
	27, // 6: google.cloud.video.livestream.v1.Input.security_rules:type_name -> google.cloud.video.livestream.v1.Input.SecurityRule
	16, // 7: google.cloud.video.livestream.v1.Input.input_stream_property:type_name -> google.cloud.video.livestream.v1.InputStreamProperty
	57, // 8: google.cloud.video.livestream.v1.Channel.create_time:type_name -> google.protobuf.Timestamp
	57, // 9: google.cloud.video.livestream.v1.Channel.update_time:type_name -> google.protobuf.Timestamp
	30, // 10: google.cloud.video.livestream.v1.Channel.labels:type_name -> google.cloud.video.livestream.v1.Channel.LabelsEntry
	21, // 11: google.cloud.video.livestream.v1.Channel.input_attachments:type_name -> google.cloud.video.livestream.v1.InputAttachment
	29, // 12: google.cloud.video.livestream.v1.Channel.output:type_name -> google.cloud.video.livestream.v1.Channel.Output
	59, // 13: google.cloud.video.livestream.v1.Channel.elementary_streams:type_name -> google.cloud.video.livestream.v1.ElementaryStream
	60, // 14: google.cloud.video.livestream.v1.Channel.mux_streams:type_name -> google.cloud.video.livestream.v1.MuxStream
	61, // 15: google.cloud.video.livestream.v1.Channel.manifests:type_name -> google.cloud.video.livestream.v1.Manifest
	62, // 16: google.cloud.video.livestream.v1.Channel.sprite_sheets:type_name -> google.cloud.video.livestream.v1.SpriteSheet
	2,  // 17: google.cloud.video.livestream.v1.Channel.streaming_state:type_name -> google.cloud.video.livestream.v1.Channel.StreamingState
	63, // 18: google.cloud.video.livestream.v1.Channel.streaming_error:type_name -> google.rpc.Status
	14, // 19: google.cloud.video.livestream.v1.Channel.log_config:type_name -> google.cloud.video.livestream.v1.LogConfig
	64, // 20: google.cloud.video.livestream.v1.Channel.timecode_config:type_name -> google.cloud.video.livestream.v1.TimecodeConfig
	25, // 21: google.cloud.video.livestream.v1.Channel.encryptions:type_name -> google.cloud.video.livestream.v1.Encryption
	13, // 22: google.cloud.video.livestream.v1.Channel.input_config:type_name -> google.cloud.video.livestream.v1.InputConfig
	15, // 23: google.cloud.video.livestream.v1.Channel.retention_config:type_name -> google.cloud.video.livestream.v1.RetentionConfig
	12, // 24: google.cloud.video.livestream.v1.Channel.static_overlays:type_name -> google.cloud.video.livestream.v1.StaticOverlay
	11, // 25: google.cloud.video.livestream.v1.StaticOverlay.resolution:type_name -> google.cloud.video.livestream.v1.NormalizedResolution
	10, // 26: google.cloud.video.livestream.v1.StaticOverlay.position:type_name -> google.cloud.video.livestream.v1.NormalizedCoordinate
	3,  // 27: google.cloud.video.livestream.v1.InputConfig.input_switch_mode:type_name -> google.cloud.video.livestream.v1.InputConfig.InputSwitchMode
	4,  // 28: google.cloud.video.livestream.v1.LogConfig.log_severity:type_name -> google.cloud.video.livestream.v1.LogConfig.LogSeverity
	65, // 29: google.cloud.video.livestream.v1.RetentionConfig.retention_window_duration:type_name -> google.protobuf.Duration
	57, // 30: google.cloud.video.livestream.v1.InputStreamProperty.last_establish_time:type_name -> google.protobuf.Timestamp
	17, // 31: google.cloud.video.livestream.v1.InputStreamProperty.video_streams:type_name -> google.cloud.video.livestream.v1.VideoStreamProperty
	19, // 32: google.cloud.video.livestream.v1.InputStreamProperty.audio_streams:type_name -> google.cloud.video.livestream.v1.AudioStreamProperty
	18, // 33: google.cloud.video.livestream.v1.VideoStreamProperty.video_format:type_name -> google.cloud.video.livestream.v1.VideoFormat
	20, // 34: google.cloud.video.livestream.v1.AudioStreamProperty.audio_format:type_name -> google.cloud.video.livestream.v1.AudioFormat
	31, // 35: google.cloud.video.livestream.v1.InputAttachment.automatic_failover:type_name -> google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover
	57, // 36: google.cloud.video.livestream.v1.Event.create_time:type_name -> google.protobuf.Timestamp
	57, // 37: google.cloud.video.livestream.v1.Event.update_time:type_name -> google.protobuf.Timestamp
	38, // 38: google.cloud.video.livestream.v1.Event.labels:type_name -> google.cloud.video.livestream.v1.Event.LabelsEntry
	32, // 39: google.cloud.video.livestream.v1.Event.input_switch:type_name -> google.cloud.video.livestream.v1.Event.InputSwitchTask
	33, // 40: google.cloud.video.livestream.v1.Event.ad_break:type_name -> google.cloud.video.livestream.v1.Event.AdBreakTask
	35, // 41: google.cloud.video.livestream.v1.Event.return_to_program:type_name -> google.cloud.video.livestream.v1.Event.ReturnToProgramTask
	34, // 42: google.cloud.video.livestream.v1.Event.slate:type_name -> google.cloud.video.livestream.v1.Event.SlateTask
	36, // 43: google.cloud.video.livestream.v1.Event.mute:type_name -> google.cloud.video.livestream.v1.Event.MuteTask
	37, // 44: google.cloud.video.livestream.v1.Event.unmute:type_name -> google.cloud.video.livestream.v1.Event.UnmuteTask
	57, // 45: google.cloud.video.livestream.v1.Event.execution_time:type_name -> google.protobuf.Timestamp
	5,  // 46: google.cloud.video.livestream.v1.Event.state:type_name -> google.cloud.video.livestream.v1.Event.State
	63, // 47: google.cloud.video.livestream.v1.Event.error:type_name -> google.rpc.Status
	57, // 48: google.cloud.video.livestream.v1.Clip.create_time:type_name -> google.protobuf.Timestamp
	57, // 49: google.cloud.video.livestream.v1.Clip.start_time:type_name -> google.protobuf.Timestamp
	57, // 50: google.cloud.video.livestream.v1.Clip.update_time:type_name -> google.protobuf.Timestamp
	42, // 51: google.cloud.video.livestream.v1.Clip.labels:type_name -> google.cloud.video.livestream.v1.Clip.LabelsEntry
	6,  // 52: google.cloud.video.livestream.v1.Clip.state:type_name -> google.cloud.video.livestream.v1.Clip.State
	63, // 53: google.cloud.video.livestream.v1.Clip.error:type_name -> google.rpc.Status
	40, // 54: google.cloud.video.livestream.v1.Clip.slices:type_name -> google.cloud.video.livestream.v1.Clip.Slice
	41, // 55: google.cloud.video.livestream.v1.Clip.clip_manifests:type_name -> google.cloud.video.livestream.v1.Clip.ClipManifest
	57, // 56: google.cloud.video.livestream.v1.Asset.create_time:type_name -> google.protobuf.Timestamp
	57, // 57: google.cloud.video.livestream.v1.Asset.update_time:type_name -> google.protobuf.Timestamp
	45, // 58: google.cloud.video.livestream.v1.Asset.labels:type_name -> google.cloud.video.livestream.v1.Asset.LabelsEntry
	43, // 59: google.cloud.video.livestream.v1.Asset.video:type_name -> google.cloud.video.livestream.v1.Asset.VideoAsset
	44, // 60: google.cloud.video.livestream.v1.Asset.image:type_name -> google.cloud.video.livestream.v1.Asset.ImageAsset
	7,  // 61: google.cloud.video.livestream.v1.Asset.state:type_name -> google.cloud.video.livestream.v1.Asset.State
	63, // 62: google.cloud.video.livestream.v1.Asset.error:type_name -> google.rpc.Status
	46, // 63: google.cloud.video.livestream.v1.Encryption.secret_manager_key_source:type_name -> google.cloud.video.livestream.v1.Encryption.SecretManagerSource
	51, // 64: google.cloud.video.livestream.v1.Encryption.drm_systems:type_name -> google.cloud.video.livestream.v1.Encryption.DrmSystems
	52, // 65: google.cloud.video.livestream.v1.Encryption.aes128:type_name -> google.cloud.video.livestream.v1.Encryption.Aes128Encryption
	53, // 66: google.cloud.video.livestream.v1.Encryption.sample_aes:type_name -> google.cloud.video.livestream.v1.Encryption.SampleAesEncryption
	54, // 67: google.cloud.video.livestream.v1.Encryption.mpeg_cenc:type_name -> google.cloud.video.livestream.v1.Encryption.MpegCommonEncryption
	57, // 68: google.cloud.video.livestream.v1.Pool.create_time:type_name -> google.protobuf.Timestamp
	57, // 69: google.cloud.video.livestream.v1.Pool.update_time:type_name -> google.protobuf.Timestamp
	56, // 70: google.cloud.video.livestream.v1.Pool.labels:type_name -> google.cloud.video.livestream.v1.Pool.LabelsEntry
	55, // 71: google.cloud.video.livestream.v1.Pool.network_config:type_name -> google.cloud.video.livestream.v1.Pool.NetworkConfig
	65, // 72: google.cloud.video.livestream.v1.Event.AdBreakTask.duration:type_name -> google.protobuf.Duration
	65, // 73: google.cloud.video.livestream.v1.Event.SlateTask.duration:type_name -> google.protobuf.Duration
	65, // 74: google.cloud.video.livestream.v1.Event.MuteTask.duration:type_name -> google.protobuf.Duration
	57, // 75: google.cloud.video.livestream.v1.Clip.TimeSlice.markin_time:type_name -> google.protobuf.Timestamp
	57, // 76: google.cloud.video.livestream.v1.Clip.TimeSlice.markout_time:type_name -> google.protobuf.Timestamp
	39, // 77: google.cloud.video.livestream.v1.Clip.Slice.time_slice:type_name -> google.cloud.video.livestream.v1.Clip.TimeSlice
	47, // 78: google.cloud.video.livestream.v1.Encryption.DrmSystems.widevine:type_name -> google.cloud.video.livestream.v1.Encryption.Widevine
	48, // 79: google.cloud.video.livestream.v1.Encryption.DrmSystems.fairplay:type_name -> google.cloud.video.livestream.v1.Encryption.Fairplay
	49, // 80: google.cloud.video.livestream.v1.Encryption.DrmSystems.playready:type_name -> google.cloud.video.livestream.v1.Encryption.Playready
	50, // 81: google.cloud.video.livestream.v1.Encryption.DrmSystems.clearkey:type_name -> google.cloud.video.livestream.v1.Encryption.Clearkey
	82, // [82:82] is the sub-list for method output_type
	82, // [82:82] is the sub-list for method input_type
	82, // [82:82] is the sub-list for extension type_name
	82, // [82:82] is the sub-list for extension extendee
	0,  // [0:82] is the sub-list for field type_name
}

func init() { file_google_cloud_video_livestream_v1_resources_proto_init() }
func file_google_cloud_video_livestream_v1_resources_proto_init() {
	if File_google_cloud_video_livestream_v1_resources_proto != nil {
		return
	}
	file_google_cloud_video_livestream_v1_outputs_proto_init()
	file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14].OneofWrappers = []any{
		(*Event_InputSwitch)(nil),
		(*Event_AdBreak)(nil),
		(*Event_ReturnToProgram)(nil),
		(*Event_Slate)(nil),
		(*Event_Mute)(nil),
		(*Event_Unmute)(nil),
	}
	file_google_cloud_video_livestream_v1_resources_proto_msgTypes[16].OneofWrappers = []any{
		(*Asset_Video)(nil),
		(*Asset_Image)(nil),
	}
	file_google_cloud_video_livestream_v1_resources_proto_msgTypes[17].OneofWrappers = []any{
		(*Encryption_SecretManagerKeySource)(nil),
		(*Encryption_Aes128)(nil),
		(*Encryption_SampleAes)(nil),
		(*Encryption_MpegCenc)(nil),
	}
	file_google_cloud_video_livestream_v1_resources_proto_msgTypes[32].OneofWrappers = []any{
		(*Clip_Slice_TimeSlice)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_livestream_v1_resources_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_livestream_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_livestream_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_livestream_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_livestream_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_video_livestream_v1_resources_proto = out.File
	file_google_cloud_video_livestream_v1_resources_proto_rawDesc = nil
	file_google_cloud_video_livestream_v1_resources_proto_goTypes = nil
	file_google_cloud_video_livestream_v1_resources_proto_depIdxs = nil
}
