// Copyright 2018-2020 opcua authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

package ua

import (
	"testing"
	"time"
)

func TestWriteRequest(t *testing.T) {
	cases := []CodecTestCase{
		{
			Name: "single-writevalue",
			Struct: &WriteRequest{
				RequestHeader: &RequestHeader{
					AuthenticationToken: NewByteStringNodeID(0x00, []byte{
						0x08, 0x22, 0x87, 0x62, 0xba, 0x81, 0xe1, 0x11,
						0xa6, 0x43, 0xf8, 0x77, 0x7b, 0xc6, 0x2f, 0xc8,
					}),
					Timestamp:        time.Date(2018, time.August, 10, 23, 0, 0, 0, time.UTC),
					RequestHandle:    1,
					AdditionalHeader: NewExtensionObject(nil),
				},
				NodesToWrite: []*WriteValue{
					{
						NodeID:      NewFourByteNodeID(0, 2256),
						AttributeID: AttributeIDValue,
						Value: &DataValue{
							EncodingMask:    DataValueValue | DataValueSourceTimestamp | DataValueServerTimestamp,
							Value:           MustVariant(float32(2.50017)),
							SourceTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
							ServerTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
						},
					},
				},
			},
			Bytes: []byte{
				// RequestHeader
				// AuthenticationToken
				0x05, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08,
				0x22, 0x87, 0x62, 0xba, 0x81, 0xe1, 0x11, 0xa6,
				0x43, 0xf8, 0x77, 0x7b, 0xc6, 0x2f, 0xc8,
				// Timestamp
				0x00, 0x98, 0x67, 0xdd, 0xfd, 0x30, 0xd4, 0x01,
				// RequestHandle
				0x01, 0x00, 0x00, 0x00,
				// ReturnDiagnostics
				0x00, 0x00, 0x00, 0x00,
				// AuditEntryID
				0xff, 0xff, 0xff, 0xff,
				// TimeoutHint
				0x00, 0x00, 0x00, 0x00,
				// AdditionalHeader
				0x00, 0x00, 0x00,
				// NodesToWrite
				// ArraySize
				0x01, 0x00, 0x00, 0x00,
				// NodeID
				0x01, 0x00, 0xd0, 0x08,
				// AttributeID
				0x0d, 0x00, 0x00, 0x00,
				// IndexRange
				0xff, 0xff, 0xff, 0xff,
				// Value
				0x0d, 0x0a, 0xc9, 0x02, 0x20, 0x40, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01,
			},
		},
		{
			Name: "multiple-writevalue",
			Struct: &WriteRequest{
				RequestHeader: &RequestHeader{
					AuthenticationToken: NewByteStringNodeID(0x00, []byte{
						0x08, 0x22, 0x87, 0x62, 0xba, 0x81, 0xe1, 0x11,
						0xa6, 0x43, 0xf8, 0x77, 0x7b, 0xc6, 0x2f, 0xc8,
					}),
					Timestamp:        time.Date(2018, time.August, 10, 23, 0, 0, 0, time.UTC),
					RequestHandle:    1,
					AdditionalHeader: NewExtensionObject(nil),
				},
				NodesToWrite: []*WriteValue{
					{
						NodeID:      NewFourByteNodeID(0, 2256),
						AttributeID: AttributeIDValue,
						Value: &DataValue{
							EncodingMask:    DataValueValue | DataValueSourceTimestamp | DataValueServerTimestamp,
							Value:           MustVariant(float32(2.50017)),
							SourceTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
							ServerTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
						},
					},
					{
						NodeID:      NewFourByteNodeID(0, 2256),
						AttributeID: AttributeIDValue,
						Value: &DataValue{
							EncodingMask:    DataValueValue | DataValueSourceTimestamp | DataValueServerTimestamp,
							Value:           MustVariant(float32(2.50017)),
							SourceTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
							ServerTimestamp: time.Date(2018, time.September, 17, 14, 28, 29, 112000000, time.UTC),
						},
					},
				},
			},
			Bytes: []byte{
				// RequestHeader
				// AuthenticationToken
				0x05, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08,
				0x22, 0x87, 0x62, 0xba, 0x81, 0xe1, 0x11, 0xa6,
				0x43, 0xf8, 0x77, 0x7b, 0xc6, 0x2f, 0xc8,
				// Timestamp
				0x00, 0x98, 0x67, 0xdd, 0xfd, 0x30, 0xd4, 0x01,
				// RequestHandle
				0x01, 0x00, 0x00, 0x00,
				// ReturnDiagnostics
				0x00, 0x00, 0x00, 0x00,
				// AuditEntryID
				0xff, 0xff, 0xff, 0xff,
				// TimeoutHint
				0x00, 0x00, 0x00, 0x00,
				// AdditionalHeader
				0x00, 0x00, 0x00,
				// NodesToWrite
				// ArraySize
				0x02, 0x00, 0x00, 0x00,
				// NodeID
				0x01, 0x00, 0xd0, 0x08,
				// AttributeID
				0x0d, 0x00, 0x00, 0x00,
				// IndexRange
				0xff, 0xff, 0xff, 0xff,
				// Value
				0x0d, 0x0a, 0xc9, 0x02, 0x20, 0x40, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01,
				// NodeID
				0x01, 0x00, 0xd0, 0x08,
				// AttributeID
				0x0d, 0x00, 0x00, 0x00,
				// IndexRange
				0xff, 0xff, 0xff, 0xff,
				// Value
				0x0d, 0x0a, 0xc9, 0x02, 0x20, 0x40, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01, 0x80, 0x3b,
				0xe8, 0xb3, 0x92, 0x4e, 0xd4, 0x01,
			},
		},
	}
	RunCodecTest(t, cases)
}
