// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package chat

// schema: chat.bsky.convo.getMessages

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
)

// ConvoGetMessages_Output is the output of a chat.bsky.convo.getMessages call.
type ConvoGetMessages_Output struct {
	Cursor   *string                                  `json:"cursor,omitempty" cborgen:"cursor,omitempty"`
	Messages []*ConvoGetMessages_Output_Messages_Elem `json:"messages" cborgen:"messages"`
}

type ConvoGetMessages_Output_Messages_Elem struct {
	ConvoDefs_MessageView        *ConvoDefs_MessageView
	ConvoDefs_DeletedMessageView *ConvoDefs_DeletedMessageView
}

func (t *ConvoGetMessages_Output_Messages_Elem) MarshalJSON() ([]byte, error) {
	if t.ConvoDefs_MessageView != nil {
		t.ConvoDefs_MessageView.LexiconTypeID = "chat.bsky.convo.defs#messageView"
		return json.Marshal(t.ConvoDefs_MessageView)
	}
	if t.ConvoDefs_DeletedMessageView != nil {
		t.ConvoDefs_DeletedMessageView.LexiconTypeID = "chat.bsky.convo.defs#deletedMessageView"
		return json.Marshal(t.ConvoDefs_DeletedMessageView)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ConvoGetMessages_Output_Messages_Elem) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "chat.bsky.convo.defs#messageView":
		t.ConvoDefs_MessageView = new(ConvoDefs_MessageView)
		return json.Unmarshal(b, t.ConvoDefs_MessageView)
	case "chat.bsky.convo.defs#deletedMessageView":
		t.ConvoDefs_DeletedMessageView = new(ConvoDefs_DeletedMessageView)
		return json.Unmarshal(b, t.ConvoDefs_DeletedMessageView)

	default:
		return nil
	}
}

// ConvoGetMessages calls the XRPC method "chat.bsky.convo.getMessages".
func ConvoGetMessages(ctx context.Context, c util.LexClient, convoId string, cursor string, limit int64) (*ConvoGetMessages_Output, error) {
	var out ConvoGetMessages_Output

	params := map[string]interface{}{}
	params["convoId"] = convoId
	if cursor != "" {
		params["cursor"] = cursor
	}
	if limit != 0 {
		params["limit"] = limit
	}
	if err := c.LexDo(ctx, util.Query, "", "chat.bsky.convo.getMessages", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
