/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ByteVector {
    @Nonnull
    private byte[] data;
    @Nonnegative
    private int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(@Nonnegative int initialSize) {
        this.data = new byte[initialSize];
    }

    @Nonnull
    public byte[] getData() {
        return this.data;
    }

    @Nonnegative
    public int getLength() {
        return this.length;
    }

    public void setLength(@Nonnegative int length) {
        this.length = length;
    }

    @Nonnull
    public ByteVector putByte(int b) {
        int len = this.getLengthEnlargingIfNeeded(1);
        this.data[len++] = (byte)b;
        this.length = len;
        return this;
    }

    @Nonnegative
    private int getLengthEnlargingIfNeeded(@Nonnegative int bytesToAdd) {
        int len = this.length;
        if (len + bytesToAdd > this.data.length) {
            this.enlarge(bytesToAdd);
        }
        return len;
    }

    private void enlarge(@Nonnegative int size) {
        int length1 = 2 * this.data.length;
        int length2 = this.length + size;
        byte[] newData = new byte[length1 > length2 ? length1 : length2];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    @Nonnull
    public ByteVector put11(int b1, int b2) {
        int len = this.getLengthEnlargingIfNeeded(2);
        byte[] bytes = this.data;
        bytes[len++] = (byte)b1;
        bytes[len++] = (byte)b2;
        this.length = len;
        return this;
    }

    @Nonnull
    public ByteVector putShort(int s) {
        return this.put11(s >>> 8, s);
    }

    @Nonnull
    public ByteVector put12(int b, int s) {
        int len = this.getLengthEnlargingIfNeeded(3);
        byte[] bytes = this.data;
        bytes[len++] = (byte)b;
        bytes[len++] = (byte)(s >>> 8);
        bytes[len++] = (byte)s;
        this.length = len;
        return this;
    }

    @Nonnull
    public ByteVector putInt(int i) {
        int len = this.getLengthEnlargingIfNeeded(4);
        byte[] bytes = this.data;
        bytes[len++] = (byte)(i >>> 24);
        bytes[len++] = (byte)(i >>> 16);
        bytes[len++] = (byte)(i >>> 8);
        bytes[len++] = (byte)i;
        this.length = len;
        return this;
    }

    public void putLong(long l) {
        int i1 = (int)(l >>> 32);
        int i2 = (int)l;
        this.putInt(i1);
        this.putInt(i2);
    }

    public void putUTF8(@Nonnull String utf8String) {
        int charLength = utf8String.length();
        if (charLength > 65535) {
            throw new IllegalArgumentException("String too long: " + charLength);
        }
        int len = this.getLengthEnlargingIfNeeded(2 + charLength);
        byte[] characters = this.data;
        characters[len++] = (byte)(charLength >>> 8);
        characters[len++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            char c = utf8String.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                characters[len++] = (byte)c;
                continue;
            }
            this.length = len;
            this.encodeUTF8(utf8String, i);
        }
        this.length = len;
    }

    private void encodeUTF8(@Nonnull String utf8String, @Nonnegative int startIndex) {
        int byteLength = ByteVector.computeByteLength(utf8String, startIndex);
        if (byteLength > 65535) {
            throw new IllegalArgumentException("String too long for UTF8 encoding: " + byteLength);
        }
        int start = this.length - startIndex - 2;
        if (start >= 0) {
            this.data[start] = (byte)(byteLength >>> 8);
            this.data[start + 1] = (byte)byteLength;
        }
        if (this.length + byteLength - startIndex > this.data.length) {
            this.enlarge(byteLength - startIndex);
        }
        this.putEncodedCharacters(utf8String, startIndex);
    }

    @Nonnegative
    private static int computeByteLength(@Nonnull String utf8String, @Nonnegative int startIndex) {
        int byteLength = startIndex;
        int n = utf8String.length();
        for (int i = startIndex; i < n; ++i) {
            char c = utf8String.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++byteLength;
                continue;
            }
            if (c > '\u07ff') {
                byteLength += 3;
                continue;
            }
            byteLength += 2;
        }
        return byteLength;
    }

    private void putEncodedCharacters(@Nonnull String utf8String, @Nonnegative int startIndex) {
        byte[] characters = this.data;
        int len = this.length;
        int n = utf8String.length();
        for (int i = startIndex; i < n; ++i) {
            char c = utf8String.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                characters[len++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                characters[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                characters[len++] = (byte)(0x80 | c >> 6 & 0x3F);
            } else {
                characters[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
            }
            characters[len++] = (byte)(0x80 | c & 0x3F);
        }
        this.length = len;
    }

    public void putByteArray(@Nonnull byte[] bytes, @Nonnegative int offset, @Nonnegative int numBytes) {
        int len = this.getLengthEnlargingIfNeeded(numBytes);
        System.arraycopy(bytes, offset, this.data, len, numBytes);
        this.length += numBytes;
    }

    public void putByteVector(@Nonnull ByteVector another) {
        this.putByteArray(another.data, 0, another.length);
    }

    public void roundUpLength() {
        int newLength = (4 - this.length % 4) % 4;
        this.getLengthEnlargingIfNeeded(newLength);
        this.length += newLength;
    }
}

