/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4;

import javax.annotation.Nonnull;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.coverage.CodeCoverage;
import mockit.coverage.testRedundancy.JUnitListener;
import mockit.coverage.testRedundancy.TestCoverage;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.faking.FakeInvocation;
import mockit.internal.state.TestRun;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public final class FakeRunNotifier
extends MockUp<RunNotifier> {
    @Mock
    public static void fireTestRunStarted(Invocation invocation, Description description) {
        RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
        assert (it != null);
        if (TestCoverage.INSTANCE != null && CodeCoverage.active()) {
            it.addListener((RunListener)new JUnitListener());
        }
        FakeRunNotifier.prepareToProceed(invocation);
        it.fireTestRunStarted(description);
    }

    private static void prepareToProceed(@Nonnull Invocation invocation) {
        ((FakeInvocation)invocation).prepareToProceedFromNonRecursiveMock();
    }

    @Mock
    public static void fireTestStarted(Invocation invocation, Description description) {
        Class newTestClass;
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (!(currentTestClass == null || (newTestClass = description.getTestClass()) != null && currentTestClass.isAssignableFrom(newTestClass))) {
            TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
        }
        FakeRunNotifier.prepareToProceed(invocation);
        RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
        assert (it != null);
        it.fireTestStarted(description);
    }

    @Mock
    public static void fireTestRunFinished(Invocation invocation, Result result) {
        TestRun.enterNoMockingZone();
        try {
            TestRunnerDecorator.cleanUpAllMocks();
            FakeRunNotifier.prepareToProceed(invocation);
            RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
            assert (it != null);
            it.fireTestRunFinished(result);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }
}

