/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Invocation;
import mockit.internal.reflection.MethodReflection;

public abstract class BaseInvocation
extends Invocation {
    @Nullable
    protected Member realMember;
    @Nullable
    protected BaseInvocation previousInvocation;

    protected BaseInvocation(@Nullable Object invokedInstance, @Nonnull Object[] invokedArguments, @Nonnegative int invocationCount) {
        super(invokedInstance, invokedArguments, invocationCount);
    }

    @Nonnull
    public final Member getRealMember() {
        if (this.realMember == null) {
            this.realMember = this.findRealMember();
        }
        return this.realMember;
    }

    @Nonnull
    protected abstract Member findRealMember();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T doProceed(@Nullable Object[] replacementArguments) {
        Member memberToInvoke = this.getRealMember();
        if (memberToInvoke instanceof Constructor) {
            this.prepareToProceed();
            return null;
        }
        this.prepareToProceed();
        Method realMethod = (Method)memberToInvoke;
        Object[] actualArgs = this.getInvokedArguments();
        if (replacementArguments != null && replacementArguments.length > 0) {
            actualArgs = realMethod.isVarArgs() ? BaseInvocation.createArgumentsArrayWithVarargs(actualArgs.length, replacementArguments) : replacementArguments;
        }
        try {
            Object t = MethodReflection.invoke(this.getInvokedInstance(), realMethod, actualArgs);
            return t;
        }
        finally {
            this.cleanUpAfterProceed();
        }
    }

    @Nonnull
    private static Object[] createArgumentsArrayWithVarargs(@Nonnegative int numInvokedArgs, @Nonnull Object[] replacementArguments) {
        int m = numInvokedArgs - 1;
        Object[] actualArgs = new Object[numInvokedArgs];
        System.arraycopy(replacementArguments, 0, actualArgs, 0, m);
        Object[] replacementVarargs = new Object[replacementArguments.length - m];
        System.arraycopy(replacementArguments, m, replacementVarargs, 0, replacementVarargs.length);
        actualArgs[m] = replacementVarargs;
        return actualArgs;
    }

    public abstract void prepareToProceed();

    protected abstract void cleanUpAfterProceed();

    @Nullable
    public final BaseInvocation getPrevious() {
        return this.previousInvocation;
    }

    public final void setPrevious(@Nonnull BaseInvocation previous) {
        this.previousInvocation = previous;
    }

    public final boolean isMethodInSuperclass(@Nullable Object mock, @Nonnull String classDesc) {
        if (mock != null && mock == this.getInvokedInstance() && this.getInvokedMember() instanceof Method) {
            Method methodToInvoke = (Method)this.getInvokedMember();
            String invokedClassDesc = methodToInvoke.getDeclaringClass().getName().replace('.', '/');
            return !invokedClassDesc.equals(classDesc);
        }
        return this.previousInvocation != null && this.previousInvocation.isMethodInSuperclass(mock, classDesc);
    }
}

