/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;

public class EqualityMatcher
implements ArgumentMatcher<EqualityMatcher> {
    @Nullable
    final Object object;

    EqualityMatcher(@Nullable Object equalArg) {
        this.object = equalArg;
    }

    @Override
    public final boolean same(@Nonnull EqualityMatcher other) {
        return this.object == other.object;
    }

    @Override
    public boolean matches(@Nullable Object argValue) {
        return EqualityMatcher.areEqual(argValue, this.object);
    }

    @Override
    public void writeMismatchPhrase(@Nonnull ArgumentMismatch argumentMismatch) {
        argumentMismatch.appendFormatted(this.object);
    }

    public static boolean areEqual(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o2 != null && (o1 == o2 || EqualityMatcher.areEqualWhenNonNull(o1, o2));
    }

    public static boolean areEqualWhenNonNull(@Nonnull Object o1, @Nonnull Object o2) {
        if (EqualityMatcher.isArray(o1)) {
            return EqualityMatcher.isArray(o2) && EqualityMatcher.areArraysEqual(o1, o2);
        }
        return o1.equals(o2);
    }

    private static boolean isArray(@Nonnull Object o) {
        return o.getClass().isArray();
    }

    private static boolean areArraysEqual(@Nonnull Object array1, @Nonnull Object array2) {
        int length1 = Array.getLength(array1);
        if (length1 != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            Object value2;
            Object value1 = Array.get(array1, i);
            if (EqualityMatcher.areEqual(value1, value2 = Array.get(array2, i))) continue;
            return false;
        }
        return true;
    }
}

