/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.invocation.ExpectedInvocation;

public final class InvocationConstraints {
    public int minInvocations;
    private int maxInvocations;
    @Nonnegative
    public int invocationCount;

    public InvocationConstraints(boolean nonStrictInvocation) {
        this.setLimits(nonStrictInvocation ? 0 : 1, -1);
    }

    public void setLimits(int minInvocations, int maxInvocations) {
        this.minInvocations = minInvocations;
        this.maxInvocations = maxInvocations;
    }

    void adjustMaxInvocations(@Nonnegative int expectedInvocationCount) {
        if (this.maxInvocations > 0 && this.maxInvocations < expectedInvocationCount) {
            this.maxInvocations = expectedInvocationCount;
        }
    }

    void setUnlimitedMaxInvocations() {
        this.maxInvocations = -1;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    public boolean isInvocationCountLessThanMinimumExpected() {
        return this.invocationCount < this.minInvocations;
    }

    public boolean isInvocationCountMoreThanMaximumExpected() {
        return this.maxInvocations >= 0 && this.invocationCount > this.maxInvocations;
    }

    @Nullable
    public Error verifyLowerLimit(@Nonnull ExpectedInvocation invocation, int lowerLimit) {
        if (this.invocationCount < lowerLimit) {
            int missingInvocations = lowerLimit - this.invocationCount;
            return invocation.errorForMissingInvocations(missingInvocations, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    public Error verifyUpperLimit(@Nonnull ExpectedInvocation invocation, @Nonnull Object[] replayArgs, int upperLimit) {
        int unexpectedInvocations;
        if (upperLimit >= 0 && (unexpectedInvocations = this.invocationCount - upperLimit) > 0) {
            return invocation.errorForUnexpectedInvocations(replayArgs, unexpectedInvocations);
        }
        return null;
    }

    @Nonnull
    public Error errorForMissingExpectations(@Nonnull ExpectedInvocation invocation, @Nonnull List<ExpectedInvocation> nonMatchingInvocations) {
        return invocation.errorForMissingInvocations(this.minInvocations - this.invocationCount, nonMatchingInvocations);
    }
}

