/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
)

// Dialect Options for tabular data output. Default output is [annotated CSV]({{% INFLUXDB_DOCS_URL %}}/reference/syntax/annotated-csv/#csv-response-format) with headers.  For more information about tabular data **dialect**, see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-metadata-20151217/#dialect-descriptions).
type Dialect struct {
	// If true, the results contain a header row.
	Header *bool `json:"header,omitempty" yaml:"header,omitempty"`
	// The separator used between cells. Default is a comma (`,`).
	Delimiter *string `json:"delimiter,omitempty" yaml:"delimiter,omitempty"`
	// Annotation rows to include in the results. An _annotation_ is metadata associated with an object (column) in the data model.  #### Related guides  - See [Annotated CSV annotations]({{% INFLUXDB_DOCS_URL %}}/reference/syntax/annotated-csv/#annotations) for examples and more information.  For more information about **annotations** in tabular data, see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-data-model-20151217/#columns).
	Annotations *[]string `json:"annotations,omitempty" yaml:"annotations,omitempty"`
	// The character prefixed to comment strings. Default is a number sign (`#`).
	CommentPrefix *string `json:"commentPrefix,omitempty" yaml:"commentPrefix,omitempty"`
	// The format for timestamps in results. Default is [`RFC3339` date/time format]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#rfc3339-timestamp). To include nanoseconds in timestamps, use `RFC3339Nano`.  #### Example formatted date/time values  | Format      | Value                       | |:------------|:----------------------------| | `RFC3339`    | `\"2006-01-02T15:04:05Z07:00\"` | | `RFC3339Nano` | `\"2006-01-02T15:04:05.999999999Z07:00\"` |
	DateTimeFormat *string `json:"dateTimeFormat,omitempty" yaml:"dateTimeFormat,omitempty"`
}

// NewDialect instantiates a new Dialect object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDialect() *Dialect {
	this := Dialect{}
	var header bool = true
	this.Header = &header
	var delimiter string = ","
	this.Delimiter = &delimiter
	var commentPrefix string = "#"
	this.CommentPrefix = &commentPrefix
	var dateTimeFormat string = "RFC3339"
	this.DateTimeFormat = &dateTimeFormat
	return &this
}

// NewDialectWithDefaults instantiates a new Dialect object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDialectWithDefaults() *Dialect {
	this := Dialect{}
	var header bool = true
	this.Header = &header
	var delimiter string = ","
	this.Delimiter = &delimiter
	var commentPrefix string = "#"
	this.CommentPrefix = &commentPrefix
	var dateTimeFormat string = "RFC3339"
	this.DateTimeFormat = &dateTimeFormat
	return &this
}

// GetHeader returns the Header field value if set, zero value otherwise.
func (o *Dialect) GetHeader() bool {
	if o == nil || o.Header == nil {
		var ret bool
		return ret
	}
	return *o.Header
}

// GetHeaderOk returns a tuple with the Header field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Dialect) GetHeaderOk() (*bool, bool) {
	if o == nil || o.Header == nil {
		return nil, false
	}
	return o.Header, true
}

// HasHeader returns a boolean if a field has been set.
func (o *Dialect) HasHeader() bool {
	if o != nil && o.Header != nil {
		return true
	}

	return false
}

// SetHeader gets a reference to the given bool and assigns it to the Header field.
func (o *Dialect) SetHeader(v bool) {
	o.Header = &v
}

// GetDelimiter returns the Delimiter field value if set, zero value otherwise.
func (o *Dialect) GetDelimiter() string {
	if o == nil || o.Delimiter == nil {
		var ret string
		return ret
	}
	return *o.Delimiter
}

// GetDelimiterOk returns a tuple with the Delimiter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Dialect) GetDelimiterOk() (*string, bool) {
	if o == nil || o.Delimiter == nil {
		return nil, false
	}
	return o.Delimiter, true
}

// HasDelimiter returns a boolean if a field has been set.
func (o *Dialect) HasDelimiter() bool {
	if o != nil && o.Delimiter != nil {
		return true
	}

	return false
}

// SetDelimiter gets a reference to the given string and assigns it to the Delimiter field.
func (o *Dialect) SetDelimiter(v string) {
	o.Delimiter = &v
}

// GetAnnotations returns the Annotations field value if set, zero value otherwise.
func (o *Dialect) GetAnnotations() []string {
	if o == nil || o.Annotations == nil {
		var ret []string
		return ret
	}
	return *o.Annotations
}

// GetAnnotationsOk returns a tuple with the Annotations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Dialect) GetAnnotationsOk() (*[]string, bool) {
	if o == nil || o.Annotations == nil {
		return nil, false
	}
	return o.Annotations, true
}

// HasAnnotations returns a boolean if a field has been set.
func (o *Dialect) HasAnnotations() bool {
	if o != nil && o.Annotations != nil {
		return true
	}

	return false
}

// SetAnnotations gets a reference to the given []string and assigns it to the Annotations field.
func (o *Dialect) SetAnnotations(v []string) {
	o.Annotations = &v
}

// GetCommentPrefix returns the CommentPrefix field value if set, zero value otherwise.
func (o *Dialect) GetCommentPrefix() string {
	if o == nil || o.CommentPrefix == nil {
		var ret string
		return ret
	}
	return *o.CommentPrefix
}

// GetCommentPrefixOk returns a tuple with the CommentPrefix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Dialect) GetCommentPrefixOk() (*string, bool) {
	if o == nil || o.CommentPrefix == nil {
		return nil, false
	}
	return o.CommentPrefix, true
}

// HasCommentPrefix returns a boolean if a field has been set.
func (o *Dialect) HasCommentPrefix() bool {
	if o != nil && o.CommentPrefix != nil {
		return true
	}

	return false
}

// SetCommentPrefix gets a reference to the given string and assigns it to the CommentPrefix field.
func (o *Dialect) SetCommentPrefix(v string) {
	o.CommentPrefix = &v
}

// GetDateTimeFormat returns the DateTimeFormat field value if set, zero value otherwise.
func (o *Dialect) GetDateTimeFormat() string {
	if o == nil || o.DateTimeFormat == nil {
		var ret string
		return ret
	}
	return *o.DateTimeFormat
}

// GetDateTimeFormatOk returns a tuple with the DateTimeFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Dialect) GetDateTimeFormatOk() (*string, bool) {
	if o == nil || o.DateTimeFormat == nil {
		return nil, false
	}
	return o.DateTimeFormat, true
}

// HasDateTimeFormat returns a boolean if a field has been set.
func (o *Dialect) HasDateTimeFormat() bool {
	if o != nil && o.DateTimeFormat != nil {
		return true
	}

	return false
}

// SetDateTimeFormat gets a reference to the given string and assigns it to the DateTimeFormat field.
func (o *Dialect) SetDateTimeFormat(v string) {
	o.DateTimeFormat = &v
}

func (o Dialect) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Header != nil {
		toSerialize["header"] = o.Header
	}
	if o.Delimiter != nil {
		toSerialize["delimiter"] = o.Delimiter
	}
	if o.Annotations != nil {
		toSerialize["annotations"] = o.Annotations
	}
	if o.CommentPrefix != nil {
		toSerialize["commentPrefix"] = o.CommentPrefix
	}
	if o.DateTimeFormat != nil {
		toSerialize["dateTimeFormat"] = o.DateTimeFormat
	}
	return json.Marshal(toSerialize)
}

type NullableDialect struct {
	value *Dialect
	isSet bool
}

func (v NullableDialect) Get() *Dialect {
	return v.value
}

func (v *NullableDialect) Set(val *Dialect) {
	v.value = val
	v.isSet = true
}

func (v NullableDialect) IsSet() bool {
	return v.isSet
}

func (v *NullableDialect) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDialect(val *Dialect) *NullableDialect {
	return &NullableDialect{value: val, isSet: true}
}

func (v NullableDialect) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDialect) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
