// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/bigquery/datapolicies/v2/datapolicy.proto

package datapoliciespb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A list of supported data policy types.
type DataPolicy_DataPolicyType int32

const (
	// Default value for the data policy type. This should not be used.
	DataPolicy_DATA_POLICY_TYPE_UNSPECIFIED DataPolicy_DataPolicyType = 0
	// Used to create a data policy for data masking.
	DataPolicy_DATA_MASKING_POLICY DataPolicy_DataPolicyType = 1
	// Used to create a data policy for raw data access.
	DataPolicy_RAW_DATA_ACCESS_POLICY DataPolicy_DataPolicyType = 2
	// Used to create a data policy for column-level security, without data
	// masking. This is deprecated in V2 api and only present to support GET and
	// LIST operations for V1 data policies in V2 api.
	DataPolicy_COLUMN_LEVEL_SECURITY_POLICY DataPolicy_DataPolicyType = 3
)

// Enum value maps for DataPolicy_DataPolicyType.
var (
	DataPolicy_DataPolicyType_name = map[int32]string{
		0: "DATA_POLICY_TYPE_UNSPECIFIED",
		1: "DATA_MASKING_POLICY",
		2: "RAW_DATA_ACCESS_POLICY",
		3: "COLUMN_LEVEL_SECURITY_POLICY",
	}
	DataPolicy_DataPolicyType_value = map[string]int32{
		"DATA_POLICY_TYPE_UNSPECIFIED": 0,
		"DATA_MASKING_POLICY":          1,
		"RAW_DATA_ACCESS_POLICY":       2,
		"COLUMN_LEVEL_SECURITY_POLICY": 3,
	}
)

func (x DataPolicy_DataPolicyType) Enum() *DataPolicy_DataPolicyType {
	p := new(DataPolicy_DataPolicyType)
	*p = x
	return p
}

func (x DataPolicy_DataPolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataPolicy_DataPolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[0].Descriptor()
}

func (DataPolicy_DataPolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[0]
}

func (x DataPolicy_DataPolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataPolicy_DataPolicyType.Descriptor instead.
func (DataPolicy_DataPolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{8, 0}
}

// The supported versions for the Data Policy resource.
type DataPolicy_Version int32

const (
	// Default value for the data policy version. This should not be used.
	DataPolicy_VERSION_UNSPECIFIED DataPolicy_Version = 0
	// V1 data policy version. V1 Data Policies will be present in V2 List api
	// response, but can not be created/updated/deleted from V2 api.
	DataPolicy_V1 DataPolicy_Version = 1
	// V2 data policy version.
	DataPolicy_V2 DataPolicy_Version = 2
)

// Enum value maps for DataPolicy_Version.
var (
	DataPolicy_Version_name = map[int32]string{
		0: "VERSION_UNSPECIFIED",
		1: "V1",
		2: "V2",
	}
	DataPolicy_Version_value = map[string]int32{
		"VERSION_UNSPECIFIED": 0,
		"V1":                  1,
		"V2":                  2,
	}
)

func (x DataPolicy_Version) Enum() *DataPolicy_Version {
	p := new(DataPolicy_Version)
	*p = x
	return p
}

func (x DataPolicy_Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataPolicy_Version) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[1].Descriptor()
}

func (DataPolicy_Version) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[1]
}

func (x DataPolicy_Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataPolicy_Version.Descriptor instead.
func (DataPolicy_Version) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{8, 1}
}

// The available masking rules. Learn more here:
// https://cloud.google.com/bigquery/docs/column-data-masking-intro#masking_options.
type DataMaskingPolicy_PredefinedExpression int32

const (
	// Default, unspecified predefined expression. No masking will take place
	// since no expression is specified.
	DataMaskingPolicy_PREDEFINED_EXPRESSION_UNSPECIFIED DataMaskingPolicy_PredefinedExpression = 0
	// Masking expression to replace data with SHA-256 hash.
	DataMaskingPolicy_SHA256 DataMaskingPolicy_PredefinedExpression = 1
	// Masking expression to replace data with NULLs.
	DataMaskingPolicy_ALWAYS_NULL DataMaskingPolicy_PredefinedExpression = 2
	// Masking expression to replace data with their default masking values.
	// The default masking values for each type listed as below:
	//
	// * STRING: ""
	// * BYTES: b”
	// * INTEGER: 0
	// * FLOAT: 0.0
	// * NUMERIC: 0
	// * BOOLEAN: FALSE
	// * TIMESTAMP: 1970-01-01 00:00:00 UTC
	// * DATE: 1970-01-01
	// * TIME: 00:00:00
	// * DATETIME: 1970-01-01T00:00:00
	// * GEOGRAPHY: POINT(0 0)
	// * BIGNUMERIC: 0
	// * ARRAY: []
	// * STRUCT: NOT_APPLICABLE
	// * JSON: NULL
	DataMaskingPolicy_DEFAULT_MASKING_VALUE DataMaskingPolicy_PredefinedExpression = 3
	// Masking expression shows the last four characters of text.
	// The masking behavior is as follows:
	//
	// * If text length > 4 characters: Replace text with XXXXX, append last
	// four characters of original text.
	// * If text length <= 4 characters: Apply SHA-256 hash.
	DataMaskingPolicy_LAST_FOUR_CHARACTERS DataMaskingPolicy_PredefinedExpression = 4
	// Masking expression shows the first four characters of text.
	// The masking behavior is as follows:
	//
	// * If text length > 4 characters: Replace text with XXXXX, prepend first
	// four characters of original text.
	// * If text length <= 4 characters: Apply SHA-256 hash.
	DataMaskingPolicy_FIRST_FOUR_CHARACTERS DataMaskingPolicy_PredefinedExpression = 5
	// Masking expression for email addresses.
	// The masking behavior is as follows:
	//
	// * Syntax-valid email address: Replace username with XXXXX. For example,
	// cloudysanfrancisco@gmail.com becomes XXXXX@gmail.com.
	// * Syntax-invalid email address: Apply SHA-256 hash.
	//
	// For more information, see [Email
	// mask](https://cloud.google.com/bigquery/docs/column-data-masking-intro#masking_options).
	DataMaskingPolicy_EMAIL_MASK DataMaskingPolicy_PredefinedExpression = 6
	// Masking expression to only show the <i>year</i> of `Date`,
	// `DateTime` and `TimeStamp`. For example, with the
	// year 2076:
	//
	// * DATE         :  2076-01-01
	// * DATETIME     :  2076-01-01T00:00:00
	// * TIMESTAMP    :  2076-01-01 00:00:00 UTC
	//
	// Truncation occurs according to the UTC time zone. To change this, adjust
	// the default time zone using the `time_zone` system variable.
	// For more information, see [System variables
	// reference](https://cloud.google.com/bigquery/docs/reference/system-variables).
	DataMaskingPolicy_DATE_YEAR_MASK DataMaskingPolicy_PredefinedExpression = 7
	// Masking expression that uses hashing to mask column data.
	// It differs from SHA256 in that a unique random value is generated for
	// each query and is added to the hash input, resulting in the hash / masked
	// result to be different for each query. Hence the name "random hash".
	DataMaskingPolicy_RANDOM_HASH DataMaskingPolicy_PredefinedExpression = 8
)

// Enum value maps for DataMaskingPolicy_PredefinedExpression.
var (
	DataMaskingPolicy_PredefinedExpression_name = map[int32]string{
		0: "PREDEFINED_EXPRESSION_UNSPECIFIED",
		1: "SHA256",
		2: "ALWAYS_NULL",
		3: "DEFAULT_MASKING_VALUE",
		4: "LAST_FOUR_CHARACTERS",
		5: "FIRST_FOUR_CHARACTERS",
		6: "EMAIL_MASK",
		7: "DATE_YEAR_MASK",
		8: "RANDOM_HASH",
	}
	DataMaskingPolicy_PredefinedExpression_value = map[string]int32{
		"PREDEFINED_EXPRESSION_UNSPECIFIED": 0,
		"SHA256":                            1,
		"ALWAYS_NULL":                       2,
		"DEFAULT_MASKING_VALUE":             3,
		"LAST_FOUR_CHARACTERS":              4,
		"FIRST_FOUR_CHARACTERS":             5,
		"EMAIL_MASK":                        6,
		"DATE_YEAR_MASK":                    7,
		"RANDOM_HASH":                       8,
	}
)

func (x DataMaskingPolicy_PredefinedExpression) Enum() *DataMaskingPolicy_PredefinedExpression {
	p := new(DataMaskingPolicy_PredefinedExpression)
	*p = x
	return p
}

func (x DataMaskingPolicy_PredefinedExpression) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataMaskingPolicy_PredefinedExpression) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[2].Descriptor()
}

func (DataMaskingPolicy_PredefinedExpression) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes[2]
}

func (x DataMaskingPolicy_PredefinedExpression) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataMaskingPolicy_PredefinedExpression.Descriptor instead.
func (DataMaskingPolicy_PredefinedExpression) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{9, 0}
}

// Request message for the CreateDataPolicy method.
type CreateDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project that the data policy will belong to.
	// The format is `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User-assigned (human readable) ID of the data policy that needs
	// to be unique within a project. Used as {data_policy_id} in part of the
	// resource name.
	DataPolicyId string `protobuf:"bytes,2,opt,name=data_policy_id,json=dataPolicyId,proto3" json:"data_policy_id,omitempty"`
	// Required. The data policy to create. The `name` field does not need to be
	// provided for the data policy creation.
	DataPolicy *DataPolicy `protobuf:"bytes,3,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
}

func (x *CreateDataPolicyRequest) Reset() {
	*x = CreateDataPolicyRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataPolicyRequest) ProtoMessage() {}

func (x *CreateDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDataPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataPolicyRequest) GetDataPolicyId() string {
	if x != nil {
		return x.DataPolicyId
	}
	return ""
}

func (x *CreateDataPolicyRequest) GetDataPolicy() *DataPolicy {
	if x != nil {
		return x.DataPolicy
	}
	return nil
}

// Request message for the UpdateDataPolicy method.
type UpdateDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Update the data policy's metadata.
	//
	// The target data policy is determined by the `name` field.
	// Other fields are updated to the specified values based on the field masks.
	DataPolicy *DataPolicy `protobuf:"bytes,1,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
	// Optional. The update mask applies to the resource. For the `FieldMask`
	// definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If not set, defaults to all of the fields that are allowed to update.
	//
	// Updates to the `name` and `dataPolicyId` fields are not allowed.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. If set to true, and the data policy is not found, a new data
	// policy will be created. In this situation, update_mask is ignored.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateDataPolicyRequest) Reset() {
	*x = UpdateDataPolicyRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataPolicyRequest) ProtoMessage() {}

func (x *UpdateDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateDataPolicyRequest) GetDataPolicy() *DataPolicy {
	if x != nil {
		return x.DataPolicy
	}
	return nil
}

func (x *UpdateDataPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDataPolicyRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for the AddGrantees method.
type AddGranteesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of this data policy, in the format of
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	DataPolicy string `protobuf:"bytes,1,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
	// Required. IAM principal that should be granted Fine Grained Access to the
	// underlying data goverened by the data policy. The target data policy is
	// determined by the `data_policy` field.
	//
	// Uses the [IAM V2 principal
	// syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2).
	// Supported principal types:
	//
	// * User
	// * Group
	// * Service account
	Grantees []string `protobuf:"bytes,2,rep,name=grantees,proto3" json:"grantees,omitempty"`
}

func (x *AddGranteesRequest) Reset() {
	*x = AddGranteesRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddGranteesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddGranteesRequest) ProtoMessage() {}

func (x *AddGranteesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddGranteesRequest.ProtoReflect.Descriptor instead.
func (*AddGranteesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{2}
}

func (x *AddGranteesRequest) GetDataPolicy() string {
	if x != nil {
		return x.DataPolicy
	}
	return ""
}

func (x *AddGranteesRequest) GetGrantees() []string {
	if x != nil {
		return x.Grantees
	}
	return nil
}

// Request message for the RemoveGrantees method.
type RemoveGranteesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of this data policy, in the format of
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	DataPolicy string `protobuf:"bytes,1,opt,name=data_policy,json=dataPolicy,proto3" json:"data_policy,omitempty"`
	// Required. IAM principal that should be revoked from Fine Grained Access to
	// the underlying data goverened by the data policy. The target data policy is
	// determined by the `data_policy` field.
	//
	// Uses the [IAM V2 principal
	// syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2).
	// Supported principal types:
	//
	// * User
	// * Group
	// * Service account
	Grantees []string `protobuf:"bytes,2,rep,name=grantees,proto3" json:"grantees,omitempty"`
}

func (x *RemoveGranteesRequest) Reset() {
	*x = RemoveGranteesRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveGranteesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveGranteesRequest) ProtoMessage() {}

func (x *RemoveGranteesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveGranteesRequest.ProtoReflect.Descriptor instead.
func (*RemoveGranteesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{3}
}

func (x *RemoveGranteesRequest) GetDataPolicy() string {
	if x != nil {
		return x.DataPolicy
	}
	return ""
}

func (x *RemoveGranteesRequest) GetGrantees() []string {
	if x != nil {
		return x.Grantees
	}
	return nil
}

// Request message for the DeleteDataPolicy method.
type DeleteDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the data policy to delete. Format is
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataPolicyRequest) Reset() {
	*x = DeleteDataPolicyRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataPolicyRequest) ProtoMessage() {}

func (x *DeleteDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteDataPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the GetDataPolicy method.
type GetDataPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the requested data policy. Format is
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataPolicyRequest) Reset() {
	*x = GetDataPolicyRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDataPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataPolicyRequest) ProtoMessage() {}

func (x *GetDataPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetDataPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{5}
}

func (x *GetDataPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListDataPolicies method.
type ListDataPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project for which to list data policies.
	// Format is `projects/{project_number}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of data policies to return. Must be a value
	// between 1 and 1000. If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The `nextPageToken` value returned from a previous list request,
	// if any. If not set, defaults to an empty string.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filters the data policies by policy tags that they
	// are associated with. Currently filter only supports
	// "policy_tag" based filtering and OR based predicates. Sample
	// filter can be "policy_tag:
	// projects/1/locations/us/taxonomies/2/policyTags/3".
	// You may also use wildcard such as "policy_tag:
	// projects/1/locations/us/taxonomies/2*". Please note that OR predicates
	// cannot be used with wildcard filters.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListDataPoliciesRequest) Reset() {
	*x = ListDataPoliciesRequest{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataPoliciesRequest) ProtoMessage() {}

func (x *ListDataPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListDataPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{6}
}

func (x *ListDataPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDataPoliciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for the ListDataPolicies method.
type ListDataPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data policies that belong to the requested project.
	DataPolicies []*DataPolicy `protobuf:"bytes,1,rep,name=data_policies,json=dataPolicies,proto3" json:"data_policies,omitempty"`
	// Token used to retrieve the next page of results, or empty if there are no
	// more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataPoliciesResponse) Reset() {
	*x = ListDataPoliciesResponse{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDataPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataPoliciesResponse) ProtoMessage() {}

func (x *ListDataPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListDataPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{7}
}

func (x *ListDataPoliciesResponse) GetDataPolicies() []*DataPolicy {
	if x != nil {
		return x.DataPolicies
	}
	return nil
}

func (x *ListDataPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the label-policy binding.
type DataPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy that is bound to this data policy.
	//
	// Types that are assignable to Policy:
	//
	//	*DataPolicy_DataMaskingPolicy
	Policy isDataPolicy_Policy `protobuf_oneof:"policy"`
	// Identifier. Resource name of this data policy, in the format of
	// `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. User-assigned (human readable) ID of the data policy that
	// needs to be unique within a project. Used as {data_policy_id} in part of
	// the resource name.
	DataPolicyId string `protobuf:"bytes,2,opt,name=data_policy_id,json=dataPolicyId,proto3" json:"data_policy_id,omitempty"`
	// The etag for this Data Policy.
	// This field is used for UpdateDataPolicy calls. If Data Policy exists, this
	// field is required and must match the server's etag. It will also be
	// populated in the response of GetDataPolicy, CreateDataPolicy, and
	// UpdateDataPolicy calls.
	Etag *string `protobuf:"bytes,11,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// Required. Type of data policy.
	DataPolicyType DataPolicy_DataPolicyType `protobuf:"varint,3,opt,name=data_policy_type,json=dataPolicyType,proto3,enum=google.cloud.bigquery.datapolicies.v2.DataPolicy_DataPolicyType" json:"data_policy_type,omitempty"`
	// Output only. Policy tag resource name, in the format of
	// `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
	// policy_tag is supported only for V1 data policies.
	PolicyTag string `protobuf:"bytes,4,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
	// Optional. The list of IAM principals that have Fine Grained Access to the
	// underlying data goverened by this data policy.
	//
	// Uses the [IAM V2 principal
	// syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
	// supports principal types users, groups, serviceaccounts, cloudidentity.
	// This field is supported in V2 Data Policy only. In case of V1 data policies
	// (i.e. verion = 1 and policy_tag is set), this field is not populated.
	Grantees []string `protobuf:"bytes,8,rep,name=grantees,proto3" json:"grantees,omitempty"`
	// Output only. The version of the Data Policy resource.
	Version DataPolicy_Version `protobuf:"varint,9,opt,name=version,proto3,enum=google.cloud.bigquery.datapolicies.v2.DataPolicy_Version" json:"version,omitempty"`
}

func (x *DataPolicy) Reset() {
	*x = DataPolicy{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataPolicy) ProtoMessage() {}

func (x *DataPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataPolicy.ProtoReflect.Descriptor instead.
func (*DataPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{8}
}

func (m *DataPolicy) GetPolicy() isDataPolicy_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *DataPolicy) GetDataMaskingPolicy() *DataMaskingPolicy {
	if x, ok := x.GetPolicy().(*DataPolicy_DataMaskingPolicy); ok {
		return x.DataMaskingPolicy
	}
	return nil
}

func (x *DataPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataPolicy) GetDataPolicyId() string {
	if x != nil {
		return x.DataPolicyId
	}
	return ""
}

func (x *DataPolicy) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *DataPolicy) GetDataPolicyType() DataPolicy_DataPolicyType {
	if x != nil {
		return x.DataPolicyType
	}
	return DataPolicy_DATA_POLICY_TYPE_UNSPECIFIED
}

func (x *DataPolicy) GetPolicyTag() string {
	if x != nil {
		return x.PolicyTag
	}
	return ""
}

func (x *DataPolicy) GetGrantees() []string {
	if x != nil {
		return x.Grantees
	}
	return nil
}

func (x *DataPolicy) GetVersion() DataPolicy_Version {
	if x != nil {
		return x.Version
	}
	return DataPolicy_VERSION_UNSPECIFIED
}

type isDataPolicy_Policy interface {
	isDataPolicy_Policy()
}

type DataPolicy_DataMaskingPolicy struct {
	// Optional. The data masking policy that specifies the data masking rule to
	// use. It must be set if the data policy type is DATA_MASKING_POLICY.
	DataMaskingPolicy *DataMaskingPolicy `protobuf:"bytes,7,opt,name=data_masking_policy,json=dataMaskingPolicy,proto3,oneof"`
}

func (*DataPolicy_DataMaskingPolicy) isDataPolicy_Policy() {}

// The policy used to specify data masking rule.
type DataMaskingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A masking expression to bind to the data masking rule.
	//
	// Types that are assignable to MaskingExpression:
	//
	//	*DataMaskingPolicy_PredefinedExpression_
	//	*DataMaskingPolicy_Routine
	MaskingExpression isDataMaskingPolicy_MaskingExpression `protobuf_oneof:"masking_expression"`
}

func (x *DataMaskingPolicy) Reset() {
	*x = DataMaskingPolicy{}
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataMaskingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataMaskingPolicy) ProtoMessage() {}

func (x *DataMaskingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataMaskingPolicy.ProtoReflect.Descriptor instead.
func (*DataMaskingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP(), []int{9}
}

func (m *DataMaskingPolicy) GetMaskingExpression() isDataMaskingPolicy_MaskingExpression {
	if m != nil {
		return m.MaskingExpression
	}
	return nil
}

func (x *DataMaskingPolicy) GetPredefinedExpression() DataMaskingPolicy_PredefinedExpression {
	if x, ok := x.GetMaskingExpression().(*DataMaskingPolicy_PredefinedExpression_); ok {
		return x.PredefinedExpression
	}
	return DataMaskingPolicy_PREDEFINED_EXPRESSION_UNSPECIFIED
}

func (x *DataMaskingPolicy) GetRoutine() string {
	if x, ok := x.GetMaskingExpression().(*DataMaskingPolicy_Routine); ok {
		return x.Routine
	}
	return ""
}

type isDataMaskingPolicy_MaskingExpression interface {
	isDataMaskingPolicy_MaskingExpression()
}

type DataMaskingPolicy_PredefinedExpression_ struct {
	// Optional. A predefined masking expression.
	PredefinedExpression DataMaskingPolicy_PredefinedExpression `protobuf:"varint,1,opt,name=predefined_expression,json=predefinedExpression,proto3,enum=google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy_PredefinedExpression,oneof"`
}

type DataMaskingPolicy_Routine struct {
	// Optional. The name of the BigQuery routine that contains the custom
	// masking routine, in the format of
	// `projects/{project_number}/datasets/{dataset_id}/routines/{routine_id}`.
	Routine string `protobuf:"bytes,2,opt,name=routine,proto3,oneof"`
}

func (*DataMaskingPolicy_PredefinedExpression_) isDataMaskingPolicy_MaskingExpression() {}

func (*DataMaskingPolicy_Routine) isDataMaskingPolicy_MaskingExpression() {}

var File_google_cloud_bigquery_datapolicies_v2_datapolicy_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xeb, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x12, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x49, 0x64, 0x12, 0x57, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xde, 0x01, 0x0a, 0x17,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x8c, 0x01, 0x0a,
	0x12, 0x41, 0x64, 0x64, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e,
	0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x22, 0x8f, 0x01, 0x0a, 0x15,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x08,
	0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x22, 0x63, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x60, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e,
	0x0a, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0x9a, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56,
	0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf9,
	0x06, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6f, 0x0a,
	0x13, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x64, 0x61, 0x74,
	0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x88, 0x01, 0x01, 0x12, 0x6f, 0x0a, 0x10, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0a,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x09,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x65, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x02, 0x12, 0x20,
	0x0a, 0x1c, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x53,
	0x45, 0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x03,
	0x22, 0x32, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x13, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x31, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02,
	0x56, 0x32, 0x10, 0x02, 0x3a, 0x90, 0x01, 0xea, 0x41, 0x8c, 0x01, 0x0a, 0x2c, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2a, 0x0c, 0x64,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x32, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x65, 0x74, 0x61, 0x67, 0x22, 0xdc, 0x03, 0x0a, 0x11, 0x44,
	0x61, 0x74, 0x61, 0x4d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x89, 0x01, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x73,
	0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x14, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x07,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x65, 0x22, 0xdf, 0x01, 0x0a, 0x14, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x52,
	0x45, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x0f, 0x0a,
	0x0b, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x19,
	0x0a, 0x15, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x49, 0x4e,
	0x47, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x41, 0x53,
	0x54, 0x5f, 0x46, 0x4f, 0x55, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52,
	0x53, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52, 0x53, 0x10, 0x05, 0x12, 0x0e,
	0x0a, 0x0a, 0x45, 0x4d, 0x41, 0x49, 0x4c, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x10, 0x06, 0x12, 0x12,
	0x0a, 0x0e, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f, 0x4d, 0x41, 0x53, 0x4b,
	0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x5f, 0x48, 0x41, 0x53,
	0x48, 0x10, 0x08, 0x42, 0x14, 0x0a, 0x12, 0x6d, 0x61, 0x73, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0x82, 0x11, 0x0a, 0x11, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xe6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x5f, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x35, 0x3a, 0x01, 0x2a, 0x22, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xe2, 0x01, 0x0a, 0x0b, 0x41, 0x64, 0x64,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x64, 0x64, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x65, 0xda, 0x41, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x61, 0x64, 0x64, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0xeb, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x68, 0xda, 0x41, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2c, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b,
	0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0xf2, 0x01, 0x0a, 0x10,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x6b, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x32, 0x3c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xab, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc0,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x0c, 0x47,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01,
	0x2a, 0x22, 0x41, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x97, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xbd,
	0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x7e,
	0xca, 0x41, 0x21, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe7,
	0x03, 0xea, 0x41, 0x7d, 0x0a, 0x24, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x55, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x61, 0x67, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67,
	0x7d, 0xea, 0x41, 0x5b, 0x0a, 0x1f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x7d, 0x0a,
	0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x32, 0x42, 0x0f, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x25, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x29, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescData = file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDesc
)

func file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescData)
	})
	return file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDescData
}

var file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_goTypes = []any{
	(DataPolicy_DataPolicyType)(0),              // 0: google.cloud.bigquery.datapolicies.v2.DataPolicy.DataPolicyType
	(DataPolicy_Version)(0),                     // 1: google.cloud.bigquery.datapolicies.v2.DataPolicy.Version
	(DataMaskingPolicy_PredefinedExpression)(0), // 2: google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy.PredefinedExpression
	(*CreateDataPolicyRequest)(nil),             // 3: google.cloud.bigquery.datapolicies.v2.CreateDataPolicyRequest
	(*UpdateDataPolicyRequest)(nil),             // 4: google.cloud.bigquery.datapolicies.v2.UpdateDataPolicyRequest
	(*AddGranteesRequest)(nil),                  // 5: google.cloud.bigquery.datapolicies.v2.AddGranteesRequest
	(*RemoveGranteesRequest)(nil),               // 6: google.cloud.bigquery.datapolicies.v2.RemoveGranteesRequest
	(*DeleteDataPolicyRequest)(nil),             // 7: google.cloud.bigquery.datapolicies.v2.DeleteDataPolicyRequest
	(*GetDataPolicyRequest)(nil),                // 8: google.cloud.bigquery.datapolicies.v2.GetDataPolicyRequest
	(*ListDataPoliciesRequest)(nil),             // 9: google.cloud.bigquery.datapolicies.v2.ListDataPoliciesRequest
	(*ListDataPoliciesResponse)(nil),            // 10: google.cloud.bigquery.datapolicies.v2.ListDataPoliciesResponse
	(*DataPolicy)(nil),                          // 11: google.cloud.bigquery.datapolicies.v2.DataPolicy
	(*DataMaskingPolicy)(nil),                   // 12: google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy
	(*fieldmaskpb.FieldMask)(nil),               // 13: google.protobuf.FieldMask
	(*iampb.GetIamPolicyRequest)(nil),           // 14: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),           // 15: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),     // 16: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                       // 17: google.protobuf.Empty
	(*iampb.Policy)(nil),                        // 18: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil),    // 19: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_depIdxs = []int32{
	11, // 0: google.cloud.bigquery.datapolicies.v2.CreateDataPolicyRequest.data_policy:type_name -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	11, // 1: google.cloud.bigquery.datapolicies.v2.UpdateDataPolicyRequest.data_policy:type_name -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	13, // 2: google.cloud.bigquery.datapolicies.v2.UpdateDataPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 3: google.cloud.bigquery.datapolicies.v2.ListDataPoliciesResponse.data_policies:type_name -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	12, // 4: google.cloud.bigquery.datapolicies.v2.DataPolicy.data_masking_policy:type_name -> google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy
	0,  // 5: google.cloud.bigquery.datapolicies.v2.DataPolicy.data_policy_type:type_name -> google.cloud.bigquery.datapolicies.v2.DataPolicy.DataPolicyType
	1,  // 6: google.cloud.bigquery.datapolicies.v2.DataPolicy.version:type_name -> google.cloud.bigquery.datapolicies.v2.DataPolicy.Version
	2,  // 7: google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy.predefined_expression:type_name -> google.cloud.bigquery.datapolicies.v2.DataMaskingPolicy.PredefinedExpression
	3,  // 8: google.cloud.bigquery.datapolicies.v2.DataPolicyService.CreateDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v2.CreateDataPolicyRequest
	5,  // 9: google.cloud.bigquery.datapolicies.v2.DataPolicyService.AddGrantees:input_type -> google.cloud.bigquery.datapolicies.v2.AddGranteesRequest
	6,  // 10: google.cloud.bigquery.datapolicies.v2.DataPolicyService.RemoveGrantees:input_type -> google.cloud.bigquery.datapolicies.v2.RemoveGranteesRequest
	4,  // 11: google.cloud.bigquery.datapolicies.v2.DataPolicyService.UpdateDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v2.UpdateDataPolicyRequest
	7,  // 12: google.cloud.bigquery.datapolicies.v2.DataPolicyService.DeleteDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v2.DeleteDataPolicyRequest
	8,  // 13: google.cloud.bigquery.datapolicies.v2.DataPolicyService.GetDataPolicy:input_type -> google.cloud.bigquery.datapolicies.v2.GetDataPolicyRequest
	9,  // 14: google.cloud.bigquery.datapolicies.v2.DataPolicyService.ListDataPolicies:input_type -> google.cloud.bigquery.datapolicies.v2.ListDataPoliciesRequest
	14, // 15: google.cloud.bigquery.datapolicies.v2.DataPolicyService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	15, // 16: google.cloud.bigquery.datapolicies.v2.DataPolicyService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	16, // 17: google.cloud.bigquery.datapolicies.v2.DataPolicyService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	11, // 18: google.cloud.bigquery.datapolicies.v2.DataPolicyService.CreateDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	11, // 19: google.cloud.bigquery.datapolicies.v2.DataPolicyService.AddGrantees:output_type -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	11, // 20: google.cloud.bigquery.datapolicies.v2.DataPolicyService.RemoveGrantees:output_type -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	11, // 21: google.cloud.bigquery.datapolicies.v2.DataPolicyService.UpdateDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	17, // 22: google.cloud.bigquery.datapolicies.v2.DataPolicyService.DeleteDataPolicy:output_type -> google.protobuf.Empty
	11, // 23: google.cloud.bigquery.datapolicies.v2.DataPolicyService.GetDataPolicy:output_type -> google.cloud.bigquery.datapolicies.v2.DataPolicy
	10, // 24: google.cloud.bigquery.datapolicies.v2.DataPolicyService.ListDataPolicies:output_type -> google.cloud.bigquery.datapolicies.v2.ListDataPoliciesResponse
	18, // 25: google.cloud.bigquery.datapolicies.v2.DataPolicyService.GetIamPolicy:output_type -> google.iam.v1.Policy
	18, // 26: google.cloud.bigquery.datapolicies.v2.DataPolicyService.SetIamPolicy:output_type -> google.iam.v1.Policy
	19, // 27: google.cloud.bigquery.datapolicies.v2.DataPolicyService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	18, // [18:28] is the sub-list for method output_type
	8,  // [8:18] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_init() }
func file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_init() {
	if File_google_cloud_bigquery_datapolicies_v2_datapolicy_proto != nil {
		return
	}
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[8].OneofWrappers = []any{
		(*DataPolicy_DataMaskingPolicy)(nil),
	}
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes[9].OneofWrappers = []any{
		(*DataMaskingPolicy_PredefinedExpression_)(nil),
		(*DataMaskingPolicy_Routine)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_datapolicies_v2_datapolicy_proto = out.File
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_rawDesc = nil
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_goTypes = nil
	file_google_cloud_bigquery_datapolicies_v2_datapolicy_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataPolicyServiceClient is the client API for DataPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataPolicyServiceClient interface {
	// Creates a new data policy under a project with the given `data_policy_id`
	// (used as the display name), and data policy type.
	CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Adds new grantees to a data policy.
	// The new grantees will be added to the existing grantees.
	// If the request contains a duplicate grantee, the grantee will be ignored.
	// If the request contains a grantee that already exists, the grantee will be
	// ignored.
	AddGrantees(ctx context.Context, in *AddGranteesRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Removes grantees from a data policy.
	// The grantees will be removed from the existing grantees.
	// If the request contains a grantee that does not exist, the grantee will be
	// ignored.
	RemoveGrantees(ctx context.Context, in *RemoveGranteesRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type dataPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataPolicyServiceClient(cc grpc.ClientConnInterface) DataPolicyServiceClient {
	return &dataPolicyServiceClient{cc}
}

func (c *dataPolicyServiceClient) CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/CreateDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) AddGrantees(ctx context.Context, in *AddGranteesRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/AddGrantees", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) RemoveGrantees(ctx context.Context, in *RemoveGranteesRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/RemoveGrantees", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/UpdateDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/DeleteDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/GetDataPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error) {
	out := new(ListDataPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/ListDataPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataPolicyServiceServer is the server API for DataPolicyService service.
type DataPolicyServiceServer interface {
	// Creates a new data policy under a project with the given `data_policy_id`
	// (used as the display name), and data policy type.
	CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error)
	// Adds new grantees to a data policy.
	// The new grantees will be added to the existing grantees.
	// If the request contains a duplicate grantee, the grantee will be ignored.
	// If the request contains a grantee that already exists, the grantee will be
	// ignored.
	AddGrantees(context.Context, *AddGranteesRequest) (*DataPolicy, error)
	// Removes grantees from a data policy.
	// The grantees will be removed from the existing grantees.
	// If the request contains a grantee that does not exist, the grantee will be
	// ignored.
	RemoveGrantees(context.Context, *RemoveGranteesRequest) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedDataPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataPolicyServiceServer struct {
}

func (*UnimplementedDataPolicyServiceServer) CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) AddGrantees(context.Context, *AddGranteesRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddGrantees not implemented")
}
func (*UnimplementedDataPolicyServiceServer) RemoveGrantees(context.Context, *RemoveGranteesRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveGrantees not implemented")
}
func (*UnimplementedDataPolicyServiceServer) UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataPolicies not implemented")
}
func (*UnimplementedDataPolicyServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataPolicyServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataPolicyServiceServer(s *grpc.Server, srv DataPolicyServiceServer) {
	s.RegisterService(&_DataPolicyService_serviceDesc, srv)
}

func _DataPolicyService_CreateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/CreateDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, req.(*CreateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_AddGrantees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddGranteesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).AddGrantees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/AddGrantees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).AddGrantees(ctx, req.(*AddGranteesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_RemoveGrantees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveGranteesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).RemoveGrantees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/RemoveGrantees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).RemoveGrantees(ctx, req.(*RemoveGranteesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_UpdateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/UpdateDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, req.(*UpdateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_DeleteDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/DeleteDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, req.(*DeleteDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/GetDataPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, req.(*GetDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_ListDataPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/ListDataPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, req.(*ListDataPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datapolicies.v2.DataPolicyService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datapolicies.v2.DataPolicyService",
	HandlerType: (*DataPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataPolicy",
			Handler:    _DataPolicyService_CreateDataPolicy_Handler,
		},
		{
			MethodName: "AddGrantees",
			Handler:    _DataPolicyService_AddGrantees_Handler,
		},
		{
			MethodName: "RemoveGrantees",
			Handler:    _DataPolicyService_RemoveGrantees_Handler,
		},
		{
			MethodName: "UpdateDataPolicy",
			Handler:    _DataPolicyService_UpdateDataPolicy_Handler,
		},
		{
			MethodName: "DeleteDataPolicy",
			Handler:    _DataPolicyService_DeleteDataPolicy_Handler,
		},
		{
			MethodName: "GetDataPolicy",
			Handler:    _DataPolicyService_GetDataPolicy_Handler,
		},
		{
			MethodName: "ListDataPolicies",
			Handler:    _DataPolicyService_ListDataPolicies_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataPolicyService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataPolicyService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataPolicyService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datapolicies/v2/datapolicy.proto",
}
