// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/retail/v2/generative_question_service.proto

package retailpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for UpdateGenerativeQuestionsFeatureConfig method.
type UpdateGenerativeQuestionsFeatureConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The configuration managing the feature state.
	GenerativeQuestionsFeatureConfig *GenerativeQuestionsFeatureConfig `protobuf:"bytes,2,opt,name=generative_questions_feature_config,json=generativeQuestionsFeatureConfig,proto3" json:"generative_questions_feature_config,omitempty"`
	// Optional. Indicates which fields in the provided
	// [GenerativeQuestionsFeatureConfig][google.cloud.retail.v2.GenerativeQuestionsFeatureConfig]
	// to update. If not set or empty, all supported fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGenerativeQuestionsFeatureConfigRequest) Reset() {
	*x = UpdateGenerativeQuestionsFeatureConfigRequest{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGenerativeQuestionsFeatureConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGenerativeQuestionsFeatureConfigRequest) ProtoMessage() {}

func (x *UpdateGenerativeQuestionsFeatureConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGenerativeQuestionsFeatureConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateGenerativeQuestionsFeatureConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{0}
}

func (x *UpdateGenerativeQuestionsFeatureConfigRequest) GetGenerativeQuestionsFeatureConfig() *GenerativeQuestionsFeatureConfig {
	if x != nil {
		return x.GenerativeQuestionsFeatureConfig
	}
	return nil
}

func (x *UpdateGenerativeQuestionsFeatureConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for GetGenerativeQuestionsFeatureConfig method.
type GetGenerativeQuestionsFeatureConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent catalog.
	// Format: projects/{project}/locations/{location}/catalogs/{catalog}
	Catalog string `protobuf:"bytes,1,opt,name=catalog,proto3" json:"catalog,omitempty"`
}

func (x *GetGenerativeQuestionsFeatureConfigRequest) Reset() {
	*x = GetGenerativeQuestionsFeatureConfigRequest{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGenerativeQuestionsFeatureConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGenerativeQuestionsFeatureConfigRequest) ProtoMessage() {}

func (x *GetGenerativeQuestionsFeatureConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGenerativeQuestionsFeatureConfigRequest.ProtoReflect.Descriptor instead.
func (*GetGenerativeQuestionsFeatureConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetGenerativeQuestionsFeatureConfigRequest) GetCatalog() string {
	if x != nil {
		return x.Catalog
	}
	return ""
}

// Request for ListQuestions method.
type ListGenerativeQuestionConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent catalog.
	// Format: projects/{project}/locations/{location}/catalogs/{catalog}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListGenerativeQuestionConfigsRequest) Reset() {
	*x = ListGenerativeQuestionConfigsRequest{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGenerativeQuestionConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGenerativeQuestionConfigsRequest) ProtoMessage() {}

func (x *ListGenerativeQuestionConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGenerativeQuestionConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListGenerativeQuestionConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListGenerativeQuestionConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response for ListQuestions method.
type ListGenerativeQuestionConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All the questions for a given catalog.
	GenerativeQuestionConfigs []*GenerativeQuestionConfig `protobuf:"bytes,1,rep,name=generative_question_configs,json=generativeQuestionConfigs,proto3" json:"generative_question_configs,omitempty"`
}

func (x *ListGenerativeQuestionConfigsResponse) Reset() {
	*x = ListGenerativeQuestionConfigsResponse{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGenerativeQuestionConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGenerativeQuestionConfigsResponse) ProtoMessage() {}

func (x *ListGenerativeQuestionConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGenerativeQuestionConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListGenerativeQuestionConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListGenerativeQuestionConfigsResponse) GetGenerativeQuestionConfigs() []*GenerativeQuestionConfig {
	if x != nil {
		return x.GenerativeQuestionConfigs
	}
	return nil
}

// Request for UpdateGenerativeQuestionConfig method.
type UpdateGenerativeQuestionConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The question to update.
	GenerativeQuestionConfig *GenerativeQuestionConfig `protobuf:"bytes,3,opt,name=generative_question_config,json=generativeQuestionConfig,proto3" json:"generative_question_config,omitempty"`
	// Optional. Indicates which fields in the provided
	// [GenerativeQuestionConfig][google.cloud.retail.v2.GenerativeQuestionConfig]
	// to update. The following are NOT supported:
	//
	// * [GenerativeQuestionConfig.frequency][google.cloud.retail.v2.GenerativeQuestionConfig.frequency]
	//
	// If not set or empty, all supported fields are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGenerativeQuestionConfigRequest) Reset() {
	*x = UpdateGenerativeQuestionConfigRequest{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGenerativeQuestionConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGenerativeQuestionConfigRequest) ProtoMessage() {}

func (x *UpdateGenerativeQuestionConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGenerativeQuestionConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateGenerativeQuestionConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateGenerativeQuestionConfigRequest) GetGenerativeQuestionConfig() *GenerativeQuestionConfig {
	if x != nil {
		return x.GenerativeQuestionConfig
	}
	return nil
}

func (x *UpdateGenerativeQuestionConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for BatchUpdateGenerativeQuestionConfig method.
type BatchUpdateGenerativeQuestionConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of the parent catalog.
	// Format: projects/{project}/locations/{location}/catalogs/{catalog}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The updates question configs.
	Requests []*UpdateGenerativeQuestionConfigRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateGenerativeQuestionConfigsRequest) Reset() {
	*x = BatchUpdateGenerativeQuestionConfigsRequest{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchUpdateGenerativeQuestionConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateGenerativeQuestionConfigsRequest) ProtoMessage() {}

func (x *BatchUpdateGenerativeQuestionConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateGenerativeQuestionConfigsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateGenerativeQuestionConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchUpdateGenerativeQuestionConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateGenerativeQuestionConfigsRequest) GetRequests() []*UpdateGenerativeQuestionConfigRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Aggregated response for UpdateGenerativeQuestionConfig method.
type BatchUpdateGenerativeQuestionConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The updates question configs.
	GenerativeQuestionConfigs []*GenerativeQuestionConfig `protobuf:"bytes,1,rep,name=generative_question_configs,json=generativeQuestionConfigs,proto3" json:"generative_question_configs,omitempty"`
}

func (x *BatchUpdateGenerativeQuestionConfigsResponse) Reset() {
	*x = BatchUpdateGenerativeQuestionConfigsResponse{}
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchUpdateGenerativeQuestionConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateGenerativeQuestionConfigsResponse) ProtoMessage() {}

func (x *BatchUpdateGenerativeQuestionConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_generative_question_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateGenerativeQuestionConfigsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateGenerativeQuestionConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchUpdateGenerativeQuestionConfigsResponse) GetGenerativeQuestionConfigs() []*GenerativeQuestionConfig {
	if x != nil {
		return x.GenerativeQuestionConfigs
	}
	return nil
}

var File_google_cloud_retail_v2_generative_question_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2_generative_question_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x80, 0x02, 0x0a, 0x2d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8c, 0x01, 0x0a, 0x23,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6d, 0x0a, 0x2a,
	0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x07, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x22, 0x65, 0x0a, 0x24, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x22, 0x99, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70, 0x0a, 0x1b,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x19, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0xde,
	0x01, 0x0a, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x1a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x18, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xcc, 0x01, 0x0a, 0x2b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0xa5,
	0x01, 0x0a, 0x2c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x75, 0x0a, 0x1b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x32, 0xba, 0x0c, 0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xf9, 0x02, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xcd, 0x01, 0xda, 0x41, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x01, 0x3a, 0x23, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x32, 0x6d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x80, 0x02, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5b, 0xda, 0x41, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0xf1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xbe, 0x02, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xaa, 0x01, 0xda, 0x41,
	0x26, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7b, 0x3a, 0x1a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x5d, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9d, 0x02, 0x0a, 0x24, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0xda, 0x41,
	0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0xc9, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x42, 0x1e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49,
	0x4c, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2_generative_question_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2_generative_question_service_proto_rawDescData = file_google_cloud_retail_v2_generative_question_service_proto_rawDesc
)

func file_google_cloud_retail_v2_generative_question_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2_generative_question_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2_generative_question_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2_generative_question_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2_generative_question_service_proto_rawDescData
}

var file_google_cloud_retail_v2_generative_question_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_retail_v2_generative_question_service_proto_goTypes = []any{
	(*UpdateGenerativeQuestionsFeatureConfigRequest)(nil), // 0: google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest
	(*GetGenerativeQuestionsFeatureConfigRequest)(nil),    // 1: google.cloud.retail.v2.GetGenerativeQuestionsFeatureConfigRequest
	(*ListGenerativeQuestionConfigsRequest)(nil),          // 2: google.cloud.retail.v2.ListGenerativeQuestionConfigsRequest
	(*ListGenerativeQuestionConfigsResponse)(nil),         // 3: google.cloud.retail.v2.ListGenerativeQuestionConfigsResponse
	(*UpdateGenerativeQuestionConfigRequest)(nil),         // 4: google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest
	(*BatchUpdateGenerativeQuestionConfigsRequest)(nil),   // 5: google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsRequest
	(*BatchUpdateGenerativeQuestionConfigsResponse)(nil),  // 6: google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsResponse
	(*GenerativeQuestionsFeatureConfig)(nil),              // 7: google.cloud.retail.v2.GenerativeQuestionsFeatureConfig
	(*fieldmaskpb.FieldMask)(nil),                         // 8: google.protobuf.FieldMask
	(*GenerativeQuestionConfig)(nil),                      // 9: google.cloud.retail.v2.GenerativeQuestionConfig
}
var file_google_cloud_retail_v2_generative_question_service_proto_depIdxs = []int32{
	7,  // 0: google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest.generative_questions_feature_config:type_name -> google.cloud.retail.v2.GenerativeQuestionsFeatureConfig
	8,  // 1: google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 2: google.cloud.retail.v2.ListGenerativeQuestionConfigsResponse.generative_question_configs:type_name -> google.cloud.retail.v2.GenerativeQuestionConfig
	9,  // 3: google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest.generative_question_config:type_name -> google.cloud.retail.v2.GenerativeQuestionConfig
	8,  // 4: google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 5: google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsRequest.requests:type_name -> google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest
	9,  // 6: google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsResponse.generative_question_configs:type_name -> google.cloud.retail.v2.GenerativeQuestionConfig
	0,  // 7: google.cloud.retail.v2.GenerativeQuestionService.UpdateGenerativeQuestionsFeatureConfig:input_type -> google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest
	1,  // 8: google.cloud.retail.v2.GenerativeQuestionService.GetGenerativeQuestionsFeatureConfig:input_type -> google.cloud.retail.v2.GetGenerativeQuestionsFeatureConfigRequest
	2,  // 9: google.cloud.retail.v2.GenerativeQuestionService.ListGenerativeQuestionConfigs:input_type -> google.cloud.retail.v2.ListGenerativeQuestionConfigsRequest
	4,  // 10: google.cloud.retail.v2.GenerativeQuestionService.UpdateGenerativeQuestionConfig:input_type -> google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest
	5,  // 11: google.cloud.retail.v2.GenerativeQuestionService.BatchUpdateGenerativeQuestionConfigs:input_type -> google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsRequest
	7,  // 12: google.cloud.retail.v2.GenerativeQuestionService.UpdateGenerativeQuestionsFeatureConfig:output_type -> google.cloud.retail.v2.GenerativeQuestionsFeatureConfig
	7,  // 13: google.cloud.retail.v2.GenerativeQuestionService.GetGenerativeQuestionsFeatureConfig:output_type -> google.cloud.retail.v2.GenerativeQuestionsFeatureConfig
	3,  // 14: google.cloud.retail.v2.GenerativeQuestionService.ListGenerativeQuestionConfigs:output_type -> google.cloud.retail.v2.ListGenerativeQuestionConfigsResponse
	9,  // 15: google.cloud.retail.v2.GenerativeQuestionService.UpdateGenerativeQuestionConfig:output_type -> google.cloud.retail.v2.GenerativeQuestionConfig
	6,  // 16: google.cloud.retail.v2.GenerativeQuestionService.BatchUpdateGenerativeQuestionConfigs:output_type -> google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsResponse
	12, // [12:17] is the sub-list for method output_type
	7,  // [7:12] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2_generative_question_service_proto_init() }
func file_google_cloud_retail_v2_generative_question_service_proto_init() {
	if File_google_cloud_retail_v2_generative_question_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2_generative_question_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2_generative_question_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2_generative_question_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2_generative_question_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_retail_v2_generative_question_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2_generative_question_service_proto = out.File
	file_google_cloud_retail_v2_generative_question_service_proto_rawDesc = nil
	file_google_cloud_retail_v2_generative_question_service_proto_goTypes = nil
	file_google_cloud_retail_v2_generative_question_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GenerativeQuestionServiceClient is the client API for GenerativeQuestionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GenerativeQuestionServiceClient interface {
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	UpdateGenerativeQuestionsFeatureConfig(ctx context.Context, in *UpdateGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error)
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	GetGenerativeQuestionsFeatureConfig(ctx context.Context, in *GetGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error)
	// Returns all questions for a given catalog.
	ListGenerativeQuestionConfigs(ctx context.Context, in *ListGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*ListGenerativeQuestionConfigsResponse, error)
	// Allows management of individual questions.
	UpdateGenerativeQuestionConfig(ctx context.Context, in *UpdateGenerativeQuestionConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionConfig, error)
	// Allows management of multiple questions.
	BatchUpdateGenerativeQuestionConfigs(ctx context.Context, in *BatchUpdateGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*BatchUpdateGenerativeQuestionConfigsResponse, error)
}

type generativeQuestionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGenerativeQuestionServiceClient(cc grpc.ClientConnInterface) GenerativeQuestionServiceClient {
	return &generativeQuestionServiceClient{cc}
}

func (c *generativeQuestionServiceClient) UpdateGenerativeQuestionsFeatureConfig(ctx context.Context, in *UpdateGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error) {
	out := new(GenerativeQuestionsFeatureConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionsFeatureConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) GetGenerativeQuestionsFeatureConfig(ctx context.Context, in *GetGenerativeQuestionsFeatureConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionsFeatureConfig, error) {
	out := new(GenerativeQuestionsFeatureConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.GenerativeQuestionService/GetGenerativeQuestionsFeatureConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) ListGenerativeQuestionConfigs(ctx context.Context, in *ListGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*ListGenerativeQuestionConfigsResponse, error) {
	out := new(ListGenerativeQuestionConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.GenerativeQuestionService/ListGenerativeQuestionConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) UpdateGenerativeQuestionConfig(ctx context.Context, in *UpdateGenerativeQuestionConfigRequest, opts ...grpc.CallOption) (*GenerativeQuestionConfig, error) {
	out := new(GenerativeQuestionConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeQuestionServiceClient) BatchUpdateGenerativeQuestionConfigs(ctx context.Context, in *BatchUpdateGenerativeQuestionConfigsRequest, opts ...grpc.CallOption) (*BatchUpdateGenerativeQuestionConfigsResponse, error) {
	out := new(BatchUpdateGenerativeQuestionConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.GenerativeQuestionService/BatchUpdateGenerativeQuestionConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GenerativeQuestionServiceServer is the server API for GenerativeQuestionService service.
type GenerativeQuestionServiceServer interface {
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	UpdateGenerativeQuestionsFeatureConfig(context.Context, *UpdateGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error)
	// Manages overal generative question feature state -- enables toggling
	// feature on and off.
	GetGenerativeQuestionsFeatureConfig(context.Context, *GetGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error)
	// Returns all questions for a given catalog.
	ListGenerativeQuestionConfigs(context.Context, *ListGenerativeQuestionConfigsRequest) (*ListGenerativeQuestionConfigsResponse, error)
	// Allows management of individual questions.
	UpdateGenerativeQuestionConfig(context.Context, *UpdateGenerativeQuestionConfigRequest) (*GenerativeQuestionConfig, error)
	// Allows management of multiple questions.
	BatchUpdateGenerativeQuestionConfigs(context.Context, *BatchUpdateGenerativeQuestionConfigsRequest) (*BatchUpdateGenerativeQuestionConfigsResponse, error)
}

// UnimplementedGenerativeQuestionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGenerativeQuestionServiceServer struct {
}

func (*UnimplementedGenerativeQuestionServiceServer) UpdateGenerativeQuestionsFeatureConfig(context.Context, *UpdateGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerativeQuestionsFeatureConfig not implemented")
}
func (*UnimplementedGenerativeQuestionServiceServer) GetGenerativeQuestionsFeatureConfig(context.Context, *GetGenerativeQuestionsFeatureConfigRequest) (*GenerativeQuestionsFeatureConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGenerativeQuestionsFeatureConfig not implemented")
}
func (*UnimplementedGenerativeQuestionServiceServer) ListGenerativeQuestionConfigs(context.Context, *ListGenerativeQuestionConfigsRequest) (*ListGenerativeQuestionConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGenerativeQuestionConfigs not implemented")
}
func (*UnimplementedGenerativeQuestionServiceServer) UpdateGenerativeQuestionConfig(context.Context, *UpdateGenerativeQuestionConfigRequest) (*GenerativeQuestionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGenerativeQuestionConfig not implemented")
}
func (*UnimplementedGenerativeQuestionServiceServer) BatchUpdateGenerativeQuestionConfigs(context.Context, *BatchUpdateGenerativeQuestionConfigsRequest) (*BatchUpdateGenerativeQuestionConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateGenerativeQuestionConfigs not implemented")
}

func RegisterGenerativeQuestionServiceServer(s *grpc.Server, srv GenerativeQuestionServiceServer) {
	s.RegisterService(&_GenerativeQuestionService_serviceDesc, srv)
}

func _GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGenerativeQuestionsFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionsFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionsFeatureConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionsFeatureConfig(ctx, req.(*UpdateGenerativeQuestionsFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGenerativeQuestionsFeatureConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).GetGenerativeQuestionsFeatureConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.GenerativeQuestionService/GetGenerativeQuestionsFeatureConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).GetGenerativeQuestionsFeatureConfig(ctx, req.(*GetGenerativeQuestionsFeatureConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_ListGenerativeQuestionConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGenerativeQuestionConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).ListGenerativeQuestionConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.GenerativeQuestionService/ListGenerativeQuestionConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).ListGenerativeQuestionConfigs(ctx, req.(*ListGenerativeQuestionConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_UpdateGenerativeQuestionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGenerativeQuestionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.GenerativeQuestionService/UpdateGenerativeQuestionConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).UpdateGenerativeQuestionConfig(ctx, req.(*UpdateGenerativeQuestionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateGenerativeQuestionConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeQuestionServiceServer).BatchUpdateGenerativeQuestionConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.GenerativeQuestionService/BatchUpdateGenerativeQuestionConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeQuestionServiceServer).BatchUpdateGenerativeQuestionConfigs(ctx, req.(*BatchUpdateGenerativeQuestionConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GenerativeQuestionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2.GenerativeQuestionService",
	HandlerType: (*GenerativeQuestionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateGenerativeQuestionsFeatureConfig",
			Handler:    _GenerativeQuestionService_UpdateGenerativeQuestionsFeatureConfig_Handler,
		},
		{
			MethodName: "GetGenerativeQuestionsFeatureConfig",
			Handler:    _GenerativeQuestionService_GetGenerativeQuestionsFeatureConfig_Handler,
		},
		{
			MethodName: "ListGenerativeQuestionConfigs",
			Handler:    _GenerativeQuestionService_ListGenerativeQuestionConfigs_Handler,
		},
		{
			MethodName: "UpdateGenerativeQuestionConfig",
			Handler:    _GenerativeQuestionService_UpdateGenerativeQuestionConfig_Handler,
		},
		{
			MethodName: "BatchUpdateGenerativeQuestionConfigs",
			Handler:    _GenerativeQuestionService_BatchUpdateGenerativeQuestionConfigs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2/generative_question_service.proto",
}
