// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/firestore/v1/write.proto

package firestorepb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A value that is calculated by the server.
type DocumentTransform_FieldTransform_ServerValue int32

const (
	// Unspecified. This value must not be used.
	DocumentTransform_FieldTransform_SERVER_VALUE_UNSPECIFIED DocumentTransform_FieldTransform_ServerValue = 0
	// The time at which the server processed the request, with millisecond
	// precision. If used on multiple fields (same or different documents) in
	// a transaction, all the fields will get the same server timestamp.
	DocumentTransform_FieldTransform_REQUEST_TIME DocumentTransform_FieldTransform_ServerValue = 1
)

// Enum value maps for DocumentTransform_FieldTransform_ServerValue.
var (
	DocumentTransform_FieldTransform_ServerValue_name = map[int32]string{
		0: "SERVER_VALUE_UNSPECIFIED",
		1: "REQUEST_TIME",
	}
	DocumentTransform_FieldTransform_ServerValue_value = map[string]int32{
		"SERVER_VALUE_UNSPECIFIED": 0,
		"REQUEST_TIME":             1,
	}
)

func (x DocumentTransform_FieldTransform_ServerValue) Enum() *DocumentTransform_FieldTransform_ServerValue {
	p := new(DocumentTransform_FieldTransform_ServerValue)
	*p = x
	return p
}

func (x DocumentTransform_FieldTransform_ServerValue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DocumentTransform_FieldTransform_ServerValue) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_v1_write_proto_enumTypes[0].Descriptor()
}

func (DocumentTransform_FieldTransform_ServerValue) Type() protoreflect.EnumType {
	return &file_google_firestore_v1_write_proto_enumTypes[0]
}

func (x DocumentTransform_FieldTransform_ServerValue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DocumentTransform_FieldTransform_ServerValue.Descriptor instead.
func (DocumentTransform_FieldTransform_ServerValue) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{1, 0, 0}
}

// A write on a document.
type Write struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation to execute.
	//
	// Types that are assignable to Operation:
	//
	//	*Write_Update
	//	*Write_Delete
	//	*Write_Transform
	Operation isWrite_Operation `protobuf_oneof:"operation"`
	// The fields to update in this write.
	//
	// This field can be set only when the operation is `update`.
	// If the mask is not set for an `update` and the document exists, any
	// existing data will be overwritten.
	// If the mask is set and the document on the server has fields not covered by
	// the mask, they are left unchanged.
	// Fields referenced in the mask, but not present in the input document, are
	// deleted from the document on the server.
	// The field paths in this mask must not contain a reserved field name.
	UpdateMask *DocumentMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The transforms to perform after update.
	//
	// This field can be set only when the operation is `update`. If present, this
	// write is equivalent to performing `update` and `transform` to the same
	// document atomically and in order.
	UpdateTransforms []*DocumentTransform_FieldTransform `protobuf:"bytes,7,rep,name=update_transforms,json=updateTransforms,proto3" json:"update_transforms,omitempty"`
	// An optional precondition on the document.
	//
	// The write will fail if this is set and not met by the target document.
	CurrentDocument *Precondition `protobuf:"bytes,4,opt,name=current_document,json=currentDocument,proto3" json:"current_document,omitempty"`
}

func (x *Write) Reset() {
	*x = Write{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Write) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Write) ProtoMessage() {}

func (x *Write) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Write.ProtoReflect.Descriptor instead.
func (*Write) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{0}
}

func (m *Write) GetOperation() isWrite_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *Write) GetUpdate() *Document {
	if x, ok := x.GetOperation().(*Write_Update); ok {
		return x.Update
	}
	return nil
}

func (x *Write) GetDelete() string {
	if x, ok := x.GetOperation().(*Write_Delete); ok {
		return x.Delete
	}
	return ""
}

func (x *Write) GetTransform() *DocumentTransform {
	if x, ok := x.GetOperation().(*Write_Transform); ok {
		return x.Transform
	}
	return nil
}

func (x *Write) GetUpdateMask() *DocumentMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *Write) GetUpdateTransforms() []*DocumentTransform_FieldTransform {
	if x != nil {
		return x.UpdateTransforms
	}
	return nil
}

func (x *Write) GetCurrentDocument() *Precondition {
	if x != nil {
		return x.CurrentDocument
	}
	return nil
}

type isWrite_Operation interface {
	isWrite_Operation()
}

type Write_Update struct {
	// A document to write.
	Update *Document `protobuf:"bytes,1,opt,name=update,proto3,oneof"`
}

type Write_Delete struct {
	// A document name to delete. In the format:
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	Delete string `protobuf:"bytes,2,opt,name=delete,proto3,oneof"`
}

type Write_Transform struct {
	// Applies a transformation to a document.
	Transform *DocumentTransform `protobuf:"bytes,6,opt,name=transform,proto3,oneof"`
}

func (*Write_Update) isWrite_Operation() {}

func (*Write_Delete) isWrite_Operation() {}

func (*Write_Transform) isWrite_Operation() {}

// A transformation of a document.
type DocumentTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the document to transform.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The list of transformations to apply to the fields of the document, in
	// order.
	// This must not be empty.
	FieldTransforms []*DocumentTransform_FieldTransform `protobuf:"bytes,2,rep,name=field_transforms,json=fieldTransforms,proto3" json:"field_transforms,omitempty"`
}

func (x *DocumentTransform) Reset() {
	*x = DocumentTransform{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentTransform) ProtoMessage() {}

func (x *DocumentTransform) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentTransform.ProtoReflect.Descriptor instead.
func (*DocumentTransform) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{1}
}

func (x *DocumentTransform) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *DocumentTransform) GetFieldTransforms() []*DocumentTransform_FieldTransform {
	if x != nil {
		return x.FieldTransforms
	}
	return nil
}

// The result of applying a write.
type WriteResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The last update time of the document after applying the write. Not set
	// after a `delete`.
	//
	// If the write did not actually change the document, this will be the
	// previous update_time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The results of applying each
	// [DocumentTransform.FieldTransform][google.firestore.v1.DocumentTransform.FieldTransform],
	// in the same order.
	TransformResults []*Value `protobuf:"bytes,2,rep,name=transform_results,json=transformResults,proto3" json:"transform_results,omitempty"`
}

func (x *WriteResult) Reset() {
	*x = WriteResult{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResult) ProtoMessage() {}

func (x *WriteResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResult.ProtoReflect.Descriptor instead.
func (*WriteResult) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{2}
}

func (x *WriteResult) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *WriteResult) GetTransformResults() []*Value {
	if x != nil {
		return x.TransformResults
	}
	return nil
}

// A [Document][google.firestore.v1.Document] has changed.
//
// May be the result of multiple [writes][google.firestore.v1.Write], including
// deletes, that ultimately resulted in a new value for the
// [Document][google.firestore.v1.Document].
//
// Multiple [DocumentChange][google.firestore.v1.DocumentChange] messages may be
// returned for the same logical change, if multiple targets are affected.
type DocumentChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new state of the [Document][google.firestore.v1.Document].
	//
	// If `mask` is set, contains only fields that were updated or added.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// A set of target IDs of targets that match this document.
	TargetIds []int32 `protobuf:"varint,5,rep,packed,name=target_ids,json=targetIds,proto3" json:"target_ids,omitempty"`
	// A set of target IDs for targets that no longer match this document.
	RemovedTargetIds []int32 `protobuf:"varint,6,rep,packed,name=removed_target_ids,json=removedTargetIds,proto3" json:"removed_target_ids,omitempty"`
}

func (x *DocumentChange) Reset() {
	*x = DocumentChange{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentChange) ProtoMessage() {}

func (x *DocumentChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentChange.ProtoReflect.Descriptor instead.
func (*DocumentChange) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{3}
}

func (x *DocumentChange) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *DocumentChange) GetTargetIds() []int32 {
	if x != nil {
		return x.TargetIds
	}
	return nil
}

func (x *DocumentChange) GetRemovedTargetIds() []int32 {
	if x != nil {
		return x.RemovedTargetIds
	}
	return nil
}

// A [Document][google.firestore.v1.Document] has been deleted.
//
// May be the result of multiple [writes][google.firestore.v1.Write], including
// updates, the last of which deleted the
// [Document][google.firestore.v1.Document].
//
// Multiple [DocumentDelete][google.firestore.v1.DocumentDelete] messages may be
// returned for the same logical delete, if multiple targets are affected.
type DocumentDelete struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the [Document][google.firestore.v1.Document] that was
	// deleted.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// A set of target IDs for targets that previously matched this entity.
	RemovedTargetIds []int32 `protobuf:"varint,6,rep,packed,name=removed_target_ids,json=removedTargetIds,proto3" json:"removed_target_ids,omitempty"`
	// The read timestamp at which the delete was observed.
	//
	// Greater or equal to the `commit_time` of the delete.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *DocumentDelete) Reset() {
	*x = DocumentDelete{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentDelete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentDelete) ProtoMessage() {}

func (x *DocumentDelete) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentDelete.ProtoReflect.Descriptor instead.
func (*DocumentDelete) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{4}
}

func (x *DocumentDelete) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *DocumentDelete) GetRemovedTargetIds() []int32 {
	if x != nil {
		return x.RemovedTargetIds
	}
	return nil
}

func (x *DocumentDelete) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

// A [Document][google.firestore.v1.Document] has been removed from the view of
// the targets.
//
// Sent if the document is no longer relevant to a target and is out of view.
// Can be sent instead of a DocumentDelete or a DocumentChange if the server
// can not send the new value of the document.
//
// Multiple [DocumentRemove][google.firestore.v1.DocumentRemove] messages may be
// returned for the same logical write or delete, if multiple targets are
// affected.
type DocumentRemove struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the [Document][google.firestore.v1.Document] that has
	// gone out of view.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// A set of target IDs for targets that previously matched this document.
	RemovedTargetIds []int32 `protobuf:"varint,2,rep,packed,name=removed_target_ids,json=removedTargetIds,proto3" json:"removed_target_ids,omitempty"`
	// The read timestamp at which the remove was observed.
	//
	// Greater or equal to the `commit_time` of the change/delete/remove.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *DocumentRemove) Reset() {
	*x = DocumentRemove{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentRemove) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentRemove) ProtoMessage() {}

func (x *DocumentRemove) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentRemove.ProtoReflect.Descriptor instead.
func (*DocumentRemove) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{5}
}

func (x *DocumentRemove) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *DocumentRemove) GetRemovedTargetIds() []int32 {
	if x != nil {
		return x.RemovedTargetIds
	}
	return nil
}

func (x *DocumentRemove) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

// A digest of all the documents that match a given target.
type ExistenceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target ID to which this filter applies.
	TargetId int32 `protobuf:"varint,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The total count of documents that match
	// [target_id][google.firestore.v1.ExistenceFilter.target_id].
	//
	// If different from the count of documents in the client that match, the
	// client must manually determine which documents no longer match the target.
	//
	// The client can use the `unchanged_names` bloom filter to assist with
	// this determination by testing ALL the document names against the filter;
	// if the document name is NOT in the filter, it means the document no
	// longer matches the target.
	Count int32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// A bloom filter that, despite its name, contains the UTF-8 byte encodings of
	// the resource names of ALL the documents that match
	// [target_id][google.firestore.v1.ExistenceFilter.target_id], in the form
	// `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
	//
	// This bloom filter may be omitted at the server's discretion, such as if it
	// is deemed that the client will not make use of it or if it is too
	// computationally expensive to calculate or transmit. Clients must gracefully
	// handle this field being absent by falling back to the logic used before
	// this field existed; that is, re-add the target without a resume token to
	// figure out which documents in the client's cache are out of sync.
	UnchangedNames *BloomFilter `protobuf:"bytes,3,opt,name=unchanged_names,json=unchangedNames,proto3" json:"unchanged_names,omitempty"`
}

func (x *ExistenceFilter) Reset() {
	*x = ExistenceFilter{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExistenceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExistenceFilter) ProtoMessage() {}

func (x *ExistenceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExistenceFilter.ProtoReflect.Descriptor instead.
func (*ExistenceFilter) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{6}
}

func (x *ExistenceFilter) GetTargetId() int32 {
	if x != nil {
		return x.TargetId
	}
	return 0
}

func (x *ExistenceFilter) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *ExistenceFilter) GetUnchangedNames() *BloomFilter {
	if x != nil {
		return x.UnchangedNames
	}
	return nil
}

// A transformation of a field of the document.
type DocumentTransform_FieldTransform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of the field. See
	// [Document.fields][google.firestore.v1.Document.fields] for the field path
	// syntax reference.
	FieldPath string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
	// The transformation to apply on the field.
	//
	// Types that are assignable to TransformType:
	//
	//	*DocumentTransform_FieldTransform_SetToServerValue
	//	*DocumentTransform_FieldTransform_Increment
	//	*DocumentTransform_FieldTransform_Maximum
	//	*DocumentTransform_FieldTransform_Minimum
	//	*DocumentTransform_FieldTransform_AppendMissingElements
	//	*DocumentTransform_FieldTransform_RemoveAllFromArray
	TransformType isDocumentTransform_FieldTransform_TransformType `protobuf_oneof:"transform_type"`
}

func (x *DocumentTransform_FieldTransform) Reset() {
	*x = DocumentTransform_FieldTransform{}
	mi := &file_google_firestore_v1_write_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DocumentTransform_FieldTransform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentTransform_FieldTransform) ProtoMessage() {}

func (x *DocumentTransform_FieldTransform) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_v1_write_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentTransform_FieldTransform.ProtoReflect.Descriptor instead.
func (*DocumentTransform_FieldTransform) Descriptor() ([]byte, []int) {
	return file_google_firestore_v1_write_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DocumentTransform_FieldTransform) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

func (m *DocumentTransform_FieldTransform) GetTransformType() isDocumentTransform_FieldTransform_TransformType {
	if m != nil {
		return m.TransformType
	}
	return nil
}

func (x *DocumentTransform_FieldTransform) GetSetToServerValue() DocumentTransform_FieldTransform_ServerValue {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_SetToServerValue); ok {
		return x.SetToServerValue
	}
	return DocumentTransform_FieldTransform_SERVER_VALUE_UNSPECIFIED
}

func (x *DocumentTransform_FieldTransform) GetIncrement() *Value {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_Increment); ok {
		return x.Increment
	}
	return nil
}

func (x *DocumentTransform_FieldTransform) GetMaximum() *Value {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_Maximum); ok {
		return x.Maximum
	}
	return nil
}

func (x *DocumentTransform_FieldTransform) GetMinimum() *Value {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_Minimum); ok {
		return x.Minimum
	}
	return nil
}

func (x *DocumentTransform_FieldTransform) GetAppendMissingElements() *ArrayValue {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_AppendMissingElements); ok {
		return x.AppendMissingElements
	}
	return nil
}

func (x *DocumentTransform_FieldTransform) GetRemoveAllFromArray() *ArrayValue {
	if x, ok := x.GetTransformType().(*DocumentTransform_FieldTransform_RemoveAllFromArray); ok {
		return x.RemoveAllFromArray
	}
	return nil
}

type isDocumentTransform_FieldTransform_TransformType interface {
	isDocumentTransform_FieldTransform_TransformType()
}

type DocumentTransform_FieldTransform_SetToServerValue struct {
	// Sets the field to the given server value.
	SetToServerValue DocumentTransform_FieldTransform_ServerValue `protobuf:"varint,2,opt,name=set_to_server_value,json=setToServerValue,proto3,enum=google.firestore.v1.DocumentTransform_FieldTransform_ServerValue,oneof"`
}

type DocumentTransform_FieldTransform_Increment struct {
	// Adds the given value to the field's current value.
	//
	// This must be an integer or a double value.
	// If the field is not an integer or double, or if the field does not yet
	// exist, the transformation will set the field to the given value.
	// If either of the given value or the current field value are doubles,
	// both values will be interpreted as doubles. Double arithmetic and
	// representation of double values follow IEEE 754 semantics.
	// If there is positive/negative integer overflow, the field is resolved
	// to the largest magnitude positive/negative integer.
	Increment *Value `protobuf:"bytes,3,opt,name=increment,proto3,oneof"`
}

type DocumentTransform_FieldTransform_Maximum struct {
	// Sets the field to the maximum of its current value and the given value.
	//
	// This must be an integer or a double value.
	// If the field is not an integer or double, or if the field does not yet
	// exist, the transformation will set the field to the given value.
	// If a maximum operation is applied where the field and the input value
	// are of mixed types (that is - one is an integer and one is a double)
	// the field takes on the type of the larger operand. If the operands are
	// equivalent (e.g. 3 and 3.0), the field does not change.
	// 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
	// zero input value is always the stored value.
	// The maximum of any numeric value x and NaN is NaN.
	Maximum *Value `protobuf:"bytes,4,opt,name=maximum,proto3,oneof"`
}

type DocumentTransform_FieldTransform_Minimum struct {
	// Sets the field to the minimum of its current value and the given value.
	//
	// This must be an integer or a double value.
	// If the field is not an integer or double, or if the field does not yet
	// exist, the transformation will set the field to the input value.
	// If a minimum operation is applied where the field and the input value
	// are of mixed types (that is - one is an integer and one is a double)
	// the field takes on the type of the smaller operand. If the operands are
	// equivalent (e.g. 3 and 3.0), the field does not change.
	// 0, 0.0, and -0.0 are all zero. The minimum of a zero stored value and
	// zero input value is always the stored value.
	// The minimum of any numeric value x and NaN is NaN.
	Minimum *Value `protobuf:"bytes,5,opt,name=minimum,proto3,oneof"`
}

type DocumentTransform_FieldTransform_AppendMissingElements struct {
	// Append the given elements in order if they are not already present in
	// the current field value.
	// If the field is not an array, or if the field does not yet exist, it is
	// first set to the empty array.
	//
	// Equivalent numbers of different types (e.g. 3L and 3.0) are
	// considered equal when checking if a value is missing.
	// NaN is equal to NaN, and Null is equal to Null.
	// If the input contains multiple equivalent values, only the first will
	// be considered.
	//
	// The corresponding transform_result will be the null value.
	AppendMissingElements *ArrayValue `protobuf:"bytes,6,opt,name=append_missing_elements,json=appendMissingElements,proto3,oneof"`
}

type DocumentTransform_FieldTransform_RemoveAllFromArray struct {
	// Remove all of the given elements from the array in the field.
	// If the field is not an array, or if the field does not yet exist, it is
	// set to the empty array.
	//
	// Equivalent numbers of the different types (e.g. 3L and 3.0) are
	// considered equal when deciding whether an element should be removed.
	// NaN is equal to NaN, and Null is equal to Null.
	// This will remove all equivalent values if there are duplicates.
	//
	// The corresponding transform_result will be the null value.
	RemoveAllFromArray *ArrayValue `protobuf:"bytes,7,opt,name=remove_all_from_array,json=removeAllFromArray,proto3,oneof"`
}

func (*DocumentTransform_FieldTransform_SetToServerValue) isDocumentTransform_FieldTransform_TransformType() {
}

func (*DocumentTransform_FieldTransform_Increment) isDocumentTransform_FieldTransform_TransformType() {
}

func (*DocumentTransform_FieldTransform_Maximum) isDocumentTransform_FieldTransform_TransformType() {}

func (*DocumentTransform_FieldTransform_Minimum) isDocumentTransform_FieldTransform_TransformType() {}

func (*DocumentTransform_FieldTransform_AppendMissingElements) isDocumentTransform_FieldTransform_TransformType() {
}

func (*DocumentTransform_FieldTransform_RemoveAllFromArray) isDocumentTransform_FieldTransform_TransformType() {
}

var File_google_firestore_v1_write_proto protoreflect.FileDescriptor

var file_google_firestore_v1_write_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x6c, 0x6f, 0x6f,
	0x6d, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x03, 0x0a, 0x05, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12,
	0x37, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x48, 0x00, 0x52,
	0x09, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x42, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x62,
	0x0a, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x52, 0x10, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x73, 0x12, 0x4c, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x05,
	0x0a, 0x11, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x60, 0x0a, 0x10, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x52, 0x0f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x73, 0x1a, 0xd1, 0x04, 0x0a, 0x0e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x72, 0x0a, 0x13, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x74, 0x54, 0x6f, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3a, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x36, 0x0a, 0x07, 0x6d,
	0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x12, 0x59, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x15, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x54,
	0x0a, 0x15, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00,
	0x52, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x46, 0x72, 0x6f, 0x6d, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x22, 0x3d, 0x0a, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x56, 0x41,
	0x4c, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x0b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x47, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x0e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x39,
	0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x05, 0x52, 0x09, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x49, 0x64, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x0e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x05, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x49, 0x64, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a,
	0x0e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x72,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0f, 0x75, 0x6e, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x6f, 0x6f, 0x6d, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x42, 0xc2, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x42, 0x0a, 0x57, 0x72, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0x3b,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x04, 0x47, 0x43,
	0x46, 0x53, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x46, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x46, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_firestore_v1_write_proto_rawDescOnce sync.Once
	file_google_firestore_v1_write_proto_rawDescData = file_google_firestore_v1_write_proto_rawDesc
)

func file_google_firestore_v1_write_proto_rawDescGZIP() []byte {
	file_google_firestore_v1_write_proto_rawDescOnce.Do(func() {
		file_google_firestore_v1_write_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_v1_write_proto_rawDescData)
	})
	return file_google_firestore_v1_write_proto_rawDescData
}

var file_google_firestore_v1_write_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_firestore_v1_write_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_firestore_v1_write_proto_goTypes = []any{
	(DocumentTransform_FieldTransform_ServerValue)(0), // 0: google.firestore.v1.DocumentTransform.FieldTransform.ServerValue
	(*Write)(nil),                            // 1: google.firestore.v1.Write
	(*DocumentTransform)(nil),                // 2: google.firestore.v1.DocumentTransform
	(*WriteResult)(nil),                      // 3: google.firestore.v1.WriteResult
	(*DocumentChange)(nil),                   // 4: google.firestore.v1.DocumentChange
	(*DocumentDelete)(nil),                   // 5: google.firestore.v1.DocumentDelete
	(*DocumentRemove)(nil),                   // 6: google.firestore.v1.DocumentRemove
	(*ExistenceFilter)(nil),                  // 7: google.firestore.v1.ExistenceFilter
	(*DocumentTransform_FieldTransform)(nil), // 8: google.firestore.v1.DocumentTransform.FieldTransform
	(*Document)(nil),                         // 9: google.firestore.v1.Document
	(*DocumentMask)(nil),                     // 10: google.firestore.v1.DocumentMask
	(*Precondition)(nil),                     // 11: google.firestore.v1.Precondition
	(*timestamppb.Timestamp)(nil),            // 12: google.protobuf.Timestamp
	(*Value)(nil),                            // 13: google.firestore.v1.Value
	(*BloomFilter)(nil),                      // 14: google.firestore.v1.BloomFilter
	(*ArrayValue)(nil),                       // 15: google.firestore.v1.ArrayValue
}
var file_google_firestore_v1_write_proto_depIdxs = []int32{
	9,  // 0: google.firestore.v1.Write.update:type_name -> google.firestore.v1.Document
	2,  // 1: google.firestore.v1.Write.transform:type_name -> google.firestore.v1.DocumentTransform
	10, // 2: google.firestore.v1.Write.update_mask:type_name -> google.firestore.v1.DocumentMask
	8,  // 3: google.firestore.v1.Write.update_transforms:type_name -> google.firestore.v1.DocumentTransform.FieldTransform
	11, // 4: google.firestore.v1.Write.current_document:type_name -> google.firestore.v1.Precondition
	8,  // 5: google.firestore.v1.DocumentTransform.field_transforms:type_name -> google.firestore.v1.DocumentTransform.FieldTransform
	12, // 6: google.firestore.v1.WriteResult.update_time:type_name -> google.protobuf.Timestamp
	13, // 7: google.firestore.v1.WriteResult.transform_results:type_name -> google.firestore.v1.Value
	9,  // 8: google.firestore.v1.DocumentChange.document:type_name -> google.firestore.v1.Document
	12, // 9: google.firestore.v1.DocumentDelete.read_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.firestore.v1.DocumentRemove.read_time:type_name -> google.protobuf.Timestamp
	14, // 11: google.firestore.v1.ExistenceFilter.unchanged_names:type_name -> google.firestore.v1.BloomFilter
	0,  // 12: google.firestore.v1.DocumentTransform.FieldTransform.set_to_server_value:type_name -> google.firestore.v1.DocumentTransform.FieldTransform.ServerValue
	13, // 13: google.firestore.v1.DocumentTransform.FieldTransform.increment:type_name -> google.firestore.v1.Value
	13, // 14: google.firestore.v1.DocumentTransform.FieldTransform.maximum:type_name -> google.firestore.v1.Value
	13, // 15: google.firestore.v1.DocumentTransform.FieldTransform.minimum:type_name -> google.firestore.v1.Value
	15, // 16: google.firestore.v1.DocumentTransform.FieldTransform.append_missing_elements:type_name -> google.firestore.v1.ArrayValue
	15, // 17: google.firestore.v1.DocumentTransform.FieldTransform.remove_all_from_array:type_name -> google.firestore.v1.ArrayValue
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_firestore_v1_write_proto_init() }
func file_google_firestore_v1_write_proto_init() {
	if File_google_firestore_v1_write_proto != nil {
		return
	}
	file_google_firestore_v1_bloom_filter_proto_init()
	file_google_firestore_v1_common_proto_init()
	file_google_firestore_v1_document_proto_init()
	file_google_firestore_v1_write_proto_msgTypes[0].OneofWrappers = []any{
		(*Write_Update)(nil),
		(*Write_Delete)(nil),
		(*Write_Transform)(nil),
	}
	file_google_firestore_v1_write_proto_msgTypes[7].OneofWrappers = []any{
		(*DocumentTransform_FieldTransform_SetToServerValue)(nil),
		(*DocumentTransform_FieldTransform_Increment)(nil),
		(*DocumentTransform_FieldTransform_Maximum)(nil),
		(*DocumentTransform_FieldTransform_Minimum)(nil),
		(*DocumentTransform_FieldTransform_AppendMissingElements)(nil),
		(*DocumentTransform_FieldTransform_RemoveAllFromArray)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_v1_write_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_firestore_v1_write_proto_goTypes,
		DependencyIndexes: file_google_firestore_v1_write_proto_depIdxs,
		EnumInfos:         file_google_firestore_v1_write_proto_enumTypes,
		MessageInfos:      file_google_firestore_v1_write_proto_msgTypes,
	}.Build()
	File_google_firestore_v1_write_proto = out.File
	file_google_firestore_v1_write_proto_rawDesc = nil
	file_google_firestore_v1_write_proto_goTypes = nil
	file_google_firestore_v1_write_proto_depIdxs = nil
}
