// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists trust stores.
func (c *Client) ListTrustStores(ctx context.Context, params *ListTrustStoresInput, optFns ...func(*Options)) (*ListTrustStoresOutput, error) {
	if params == nil {
		params = &ListTrustStoresInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrustStores", params, optFns, c.addOperationListTrustStoresMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrustStoresOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrustStoresInput struct {

	// Use this field when paginating results to indicate where to begin in your list.
	// The response includes items in the list that occur after the marker. To get the
	// next page of the list, set this field's value to the value of NextMarker from
	// the current page's response.
	Marker *string

	// The maximum number of trust stores that you want returned in the response.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListTrustStoresOutput struct {

	// Indicates the next page of trust stores. To get the next page of the list, use
	// this value in the Marker field of your request.
	NextMarker *string

	// The trust store list.
	TrustStoreList []types.TrustStoreSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrustStoresMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListTrustStores{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListTrustStores{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrustStores"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrustStores(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrustStoresPaginatorOptions is the paginator options for ListTrustStores
type ListTrustStoresPaginatorOptions struct {
	// The maximum number of trust stores that you want returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrustStoresPaginator is a paginator for ListTrustStores
type ListTrustStoresPaginator struct {
	options   ListTrustStoresPaginatorOptions
	client    ListTrustStoresAPIClient
	params    *ListTrustStoresInput
	nextToken *string
	firstPage bool
}

// NewListTrustStoresPaginator returns a new ListTrustStoresPaginator
func NewListTrustStoresPaginator(client ListTrustStoresAPIClient, params *ListTrustStoresInput, optFns ...func(*ListTrustStoresPaginatorOptions)) *ListTrustStoresPaginator {
	if params == nil {
		params = &ListTrustStoresInput{}
	}

	options := ListTrustStoresPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrustStoresPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrustStoresPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrustStores page.
func (p *ListTrustStoresPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrustStoresOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrustStores(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrustStoresAPIClient is a client that implements the ListTrustStores
// operation.
type ListTrustStoresAPIClient interface {
	ListTrustStores(context.Context, *ListTrustStoresInput, ...func(*Options)) (*ListTrustStoresOutput, error)
}

var _ ListTrustStoresAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrustStores(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrustStores",
	}
}
