// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/style_preset_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	StylePresetService_Get_FullMethodName    = "/yandex.cloud.video.v1.StylePresetService/Get"
	StylePresetService_List_FullMethodName   = "/yandex.cloud.video.v1.StylePresetService/List"
	StylePresetService_Create_FullMethodName = "/yandex.cloud.video.v1.StylePresetService/Create"
	StylePresetService_Update_FullMethodName = "/yandex.cloud.video.v1.StylePresetService/Update"
	StylePresetService_Delete_FullMethodName = "/yandex.cloud.video.v1.StylePresetService/Delete"
)

// StylePresetServiceClient is the client API for StylePresetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// StylePreset management service.
// Provides methods for creating, retrieving, updating, and deleting style presets,
// which define the visual appearance and layout of video players and associated widgets.
type StylePresetServiceClient interface {
	// Retrieves detailed information about a specific style preset by its ID.
	// Returns all style preset properties, colors, layout settings, and widget configurations.
	Get(ctx context.Context, in *GetStylePresetRequest, opts ...grpc.CallOption) (*StylePreset, error)
	// Lists all style presets in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListStylePresetsRequest, opts ...grpc.CallOption) (*ListStylePresetsResponse, error)
	// Creates a new style preset in the specified channel with the provided visual settings.
	// Style presets define the appearance of players, including colors, spacing, borders, and widgets.
	Create(ctx context.Context, in *CreateStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates an existing style preset's properties and visual settings.
	// Only fields specified in the field_mask will be updated.
	Update(ctx context.Context, in *UpdateStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes a specific style preset by its ID.
	// This operation will fail if the style preset is currently in use by any videos, streams, or playlists.
	Delete(ctx context.Context, in *DeleteStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type stylePresetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStylePresetServiceClient(cc grpc.ClientConnInterface) StylePresetServiceClient {
	return &stylePresetServiceClient{cc}
}

func (c *stylePresetServiceClient) Get(ctx context.Context, in *GetStylePresetRequest, opts ...grpc.CallOption) (*StylePreset, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StylePreset)
	err := c.cc.Invoke(ctx, StylePresetService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stylePresetServiceClient) List(ctx context.Context, in *ListStylePresetsRequest, opts ...grpc.CallOption) (*ListStylePresetsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListStylePresetsResponse)
	err := c.cc.Invoke(ctx, StylePresetService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stylePresetServiceClient) Create(ctx context.Context, in *CreateStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StylePresetService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stylePresetServiceClient) Update(ctx context.Context, in *UpdateStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StylePresetService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *stylePresetServiceClient) Delete(ctx context.Context, in *DeleteStylePresetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StylePresetService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StylePresetServiceServer is the server API for StylePresetService service.
// All implementations should embed UnimplementedStylePresetServiceServer
// for forward compatibility.
//
// StylePreset management service.
// Provides methods for creating, retrieving, updating, and deleting style presets,
// which define the visual appearance and layout of video players and associated widgets.
type StylePresetServiceServer interface {
	// Retrieves detailed information about a specific style preset by its ID.
	// Returns all style preset properties, colors, layout settings, and widget configurations.
	Get(context.Context, *GetStylePresetRequest) (*StylePreset, error)
	// Lists all style presets in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListStylePresetsRequest) (*ListStylePresetsResponse, error)
	// Creates a new style preset in the specified channel with the provided visual settings.
	// Style presets define the appearance of players, including colors, spacing, borders, and widgets.
	Create(context.Context, *CreateStylePresetRequest) (*operation.Operation, error)
	// Updates an existing style preset's properties and visual settings.
	// Only fields specified in the field_mask will be updated.
	Update(context.Context, *UpdateStylePresetRequest) (*operation.Operation, error)
	// Deletes a specific style preset by its ID.
	// This operation will fail if the style preset is currently in use by any videos, streams, or playlists.
	Delete(context.Context, *DeleteStylePresetRequest) (*operation.Operation, error)
}

// UnimplementedStylePresetServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedStylePresetServiceServer struct{}

func (UnimplementedStylePresetServiceServer) Get(context.Context, *GetStylePresetRequest) (*StylePreset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedStylePresetServiceServer) List(context.Context, *ListStylePresetsRequest) (*ListStylePresetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedStylePresetServiceServer) Create(context.Context, *CreateStylePresetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedStylePresetServiceServer) Update(context.Context, *UpdateStylePresetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedStylePresetServiceServer) Delete(context.Context, *DeleteStylePresetRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedStylePresetServiceServer) testEmbeddedByValue() {}

// UnsafeStylePresetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StylePresetServiceServer will
// result in compilation errors.
type UnsafeStylePresetServiceServer interface {
	mustEmbedUnimplementedStylePresetServiceServer()
}

func RegisterStylePresetServiceServer(s grpc.ServiceRegistrar, srv StylePresetServiceServer) {
	// If the following call pancis, it indicates UnimplementedStylePresetServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&StylePresetService_ServiceDesc, srv)
}

func _StylePresetService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStylePresetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StylePresetServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StylePresetService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StylePresetServiceServer).Get(ctx, req.(*GetStylePresetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StylePresetService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStylePresetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StylePresetServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StylePresetService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StylePresetServiceServer).List(ctx, req.(*ListStylePresetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StylePresetService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStylePresetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StylePresetServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StylePresetService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StylePresetServiceServer).Create(ctx, req.(*CreateStylePresetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StylePresetService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStylePresetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StylePresetServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StylePresetService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StylePresetServiceServer).Update(ctx, req.(*UpdateStylePresetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StylePresetService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStylePresetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StylePresetServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StylePresetService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StylePresetServiceServer).Delete(ctx, req.(*DeleteStylePresetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StylePresetService_ServiceDesc is the grpc.ServiceDesc for StylePresetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StylePresetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.StylePresetService",
	HandlerType: (*StylePresetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _StylePresetService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _StylePresetService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _StylePresetService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _StylePresetService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _StylePresetService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/style_preset_service.proto",
}
