/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public abstract class AbstractCompareOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 1375799912336916036L;

    protected AbstractCompareOperator() {
    }

    public final TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type type1 = value1.getType();
        Type type2 = value2.getType();
        Object value1Raw = value1.getValue();
        Object value2Raw = value2.getValue();
        if (value1Raw == null || value2Raw == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        ExtendedComparator comparator = typeRegistry.getComparator(type1, type2);
        int result = comparator.compare(type1, value1Raw, type2, value2Raw);
        if (this.evaluate(result)) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    protected abstract boolean evaluate(int var1);
}

