// SPDX-License-Identifier: Apache-2.0

//go:build unit

package resources

import (
	"regexp"
	"strings"
	"testing"
)

func Test(t *testing.T) {
	tests := []struct {
		name    string
		source  string
		wantErr bool
	}{
		{
			name:    "legacy acceptable pattern apache project",
			source:  "Apache(?!.*license)[^.\\n\\r]*",
			wantErr: true,
		},
		{
			name:    "legacy primary pattern converted from license_CC-BY-SA-3.0.txt",
			source:  `creative commons ?(?:legal code ?)? ?(?:(attribution ?\-?\+? ?sharealike) ?) ?(?:license version ?)? ?(?:(3\.0:?) ?) ?(?:unported ?)? ?(?:creative commons corporation is not a law firm and does not provide legal services. distribution of this license does not create an attorney-client relationship. creative commons provides this information on an 'as-is' basis. creative commons makes no warranties regarding the information provided, and disclaims liability for damages resulting from its use. ?)? ?(?:license ?)?the work (as defined below) is provided under the terms of this creative commons public license ('ccpl' or 'license'). the work is protected by copyright and/or other applicable law. any use of the work other than as authorized under this license or copyright law is prohibited. by exercising any rights to the work provided here, you accept and agree to be bound by the terms of this license. to the extent this license may be considered to be a contract, the licensor grants you the rights contained here in consideration of your acceptance of such terms and conditions. definitions 'adaptation' means a work based upon the work, or upon the work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a collection will not be considered an adaptation for the purpose of this license. for the avoidance of doubt, where the work is a musical work, performance or phonogram, the synchronization of the work in timed-relation with a moving image ('synching') will be considered an adaptation for the purpose of this license. 'collection' means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. a work that constitutes a collection will not be considered an adaptation (as defined below) for the purposes of this license. 'creative commons compatible license' means a license that is listed at http://creativecommons.org/compatiblelicenses that has been approved by creative commons as being essentially equivalent to this license, including, at a minimum, because that license: ?(?:(i) ?)?contains terms that have the same purpose, meaning and effect as the license elements of this license; and, ?(?:(ii) ?)?explicitly permits the relicensing of adaptations of works made available under that license under this license or a creative commons jurisdiction license with the same license elements as this license. 'distribute' means to make available to the public the original and copies of the work or adaptation, as appropriate, through sale or other transfer of ownership. 'license elements' means the following high-level license attributes as selected by licensor and indicated in the title of this license: attribution, sharealike. 'licensor' means the individual, individuals, entity or entities that offer(s) the work under the terms of this license. 'original author' means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the work or if no individual or entity can be identified, the publisher; and in addition ?(?:(i) ?)?in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; ?(?:(ii) ?)?in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, ?(?:(iii) ?)?in the case of broadcasts, the organization that transmits the broadcast. 'work' means the literary and/or artistic work offered under the terms of this license including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work. 'you' means an individual or entity exercising rights under this license who has not previously violated the terms of this license with respect to the work, or who has received express permission from the licensor to exercise rights under this license despite a previous violation. 'publicly perform' means to perform public recitations of the work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public works in such a way that members of the public may access these works from a place and at a place individually chosen by them; to perform the work to the public by any means or process and the communication to the public of the performances of the work, including by public digital performance; to broadcast and rebroadcast the work by any means including signs, sounds or images. 'reproduce' means to make copies of the work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the work, including storage of a protected performance or phonogram in digital form or other electronic medium. fair dealing rights. nothing in this license is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws. license grant. subject to the terms and conditions of this license, licensor hereby grants you a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the work as stated below: to reproduce the work, to incorporate the work into one or more collections, and to reproduce the work as incorporated in the collections; to create and reproduce adaptations provided that any such adaptation, including any translation in any medium, takes reasonable steps to clearly label, demarcate or otherwise identify that changes were made to the original work. for example, a translation could be marked 'the original work was translated from english to spanish,' or a modification could indicate 'the original work has been modified.'; to distribute and publicly perform the work including as incorporated in collections; and, to distribute and publicly perform adaptations. for the avoidance of doubt: non-waivable compulsory license schemes. in those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the licensor reserves the exclusive right to collect such royalties for any exercise by you of the rights granted under this license; waivable compulsory license schemes. in those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the licensor waives the exclusive right to collect such royalties for any exercise by you of the rights granted under this license; and, voluntary license schemes. the licensor waives the right to collect royalties, whether individually or, in the event that the licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by you of the rights granted under this license. the above rights may be exercised in all media and formats whether now known or hereafter devised. the above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats. subject to section 8(f), all rights not expressly granted by licensor are hereby reserved. restrictions. the license granted in section 3 above is expressly made subject to and limited by the following restrictions: you may distribute or publicly perform the work only under the terms of this license. you must include a copy of, or the uniform resource identifier (uri) for, this license with every copy of the work you distribute or publicly perform. you may not offer or impose any terms on the work that restrict the terms of this license or the ability of the recipient of the work to exercise the rights granted to that recipient under the terms of the license. you may not sublicense the work. you must keep intact all notices that refer to this license and to the disclaimer of warranties with every copy of the work you distribute or publicly perform. when you distribute or publicly perform the work, you may not impose any effective technological measures on the work that restrict the ability of a recipient of the work from you to exercise the rights granted to that recipient under the terms of the license. this section 4(a) applies to the work as incorporated in a collection, but this does not require the collection apart from the work itself to be made subject to the terms of this license. if you create a collection, upon notice from any licensor you must, to the extent practicable, remove from the collection any credit as required by section 4copyright, as requested. if you create an adaptation, upon notice from any licensor you must, to the extent practicable, remove from the adaptation any credit as required by section 4copyright, as requested. you may distribute or publicly perform an adaptation only under the terms of: ?(?:(i) ?)?this license; ?(?:(ii) ?)?a later version of this license with the same license elements as this license; ?(?:(iii) ?)?a creative commons jurisdiction license (either this or a later license version) that contains the same license elements as this license (e.g., attribution-sharealike 3.0 us)); (iv) a creative commons compatible license. if you license the adaptation under one of the licenses mentioned in (iv), you must comply with the terms of that license. if you license the adaptation under the terms of any of the licenses mentioned in ?(?:(i) ?)?, ?(?:(ii) ?)?or ?(?:(iii) ?)?(the 'applicable license'), you must comply with the terms of the applicable license generally and the following provisions: ?(?:(i) ?)?you must include a copy of, or the uri for, the applicable license with every copy of each adaptation you distribute or publicly perform; ?(?:(ii) ?)?you may not offer or impose any terms on the adaptation that restrict the terms of the applicable license or the ability of the recipient of the adaptation to exercise the rights granted to that recipient under the terms of the applicable license; ?(?:(iii) ?)?you must keep intact all notices that refer to the applicable license and to the disclaimer of warranties with every copy of the work as included in the adaptation you distribute or publicly perform; (iv) when you distribute or publicly perform the adaptation, you may not impose any effective technological measures on the adaptation that restrict the ability of a recipient of the adaptation from you to exercise the rights granted to that recipient under the terms of the applicable license. this section 4(b) applies to the adaptation as incorporated in a collection, but this does not require the collection apart from the adaptation itself to be made subject to the terms of the applicable license. if you distribute, or publicly perform the work or any adaptations or collections, you must, unless a request has been made pursuant to section 4(a), keep intact all copyright notices for the work and provide, reasonable to the medium or means you are utilizing: ?(?:(i) ?)?the name of the original author (or pseudonym, if applicable) if supplied, and/or if the original author and/or licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution ('attribution parties') in licensor's copyright notice, terms of service or by other reasonable means, the name of such party or parties; ?(?:(ii) ?)?the title of the work if supplied; ?(?:(iii) ?)?to the extent reasonably practicable, the uri, if any, that licensor specifies to be associated with the work, unless such uri does not refer to the copyright notice or licensing information for the work; and (iv) , consistent with ssection 3(b), in the case of an adaptation, a credit identifying the use of the work in the adaptation (e.g., 'french translation of the work by original author,' or 'screenplay based on original work by original author'). the credit required by this section 4copyright may be implemented in any reasonable manner; provided, however, that in the case of a adaptation or collection, at a minimum such credit will appear, if a credit for all contributing authors of the adaptation or collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. for the avoidance of doubt, you may only use the credit required by this section for the purpose of attribution in the manner set out above and, by exercising your rights under this license, you may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the original author, licensor and/or attribution parties, as appropriate, of you or your use of the work, without the separate, express prior written permission of the original author, licensor and/or attribution parties. except as otherwise agreed in writing by the licensor or as may be otherwise permitted by applicable law, if you reproduce, distribute or publicly perform the work either by itself or as part of any adaptations or collections, you must not distort, mutilate, modify or take other derogatory action in relation to the work which would be prejudicial to the original author's honor or reputation. licensor agrees that in those jurisdictions (e.g. japan), in which any exercise of the right granted in section 3(b) of this license (the right to make adaptations) would be deemed to be a distortion, mutilation, modification or other derogatory action prejudicial to the original author's honor and reputation, the licensor will waive or not assert, as appropriate, this section, to the fullest extent permitted by the applicable national law, to enable you to reasonably exercise your right under section 3(b) of this license (right to make adaptations) but not otherwise. representations, warranties and disclaimer unless otherwise mutually agreed to by the parties in writing, licensor offers the work as-is and makes no representations or warranties of any kind concerning the work, express, implied, statutory or otherwise, including, without limitation, warranties of title, merchantibility, fitness for a particular purpose, noninfringement, or the absence of latent or other defects, accuracy, or the presence of absence of errors, whether or not discoverable. some jurisdictions do not allow the exclusion of implied warranties, so such exclusion may not apply to you. limitation on liability. except to the extent required by applicable law, in no event will licensor be liable to you on any legal theory for any special, incidental, consequential, punitive or exemplary damages arising out of this license or the use of the work, even if licensor has been advised of the possibility of such damages. termination this license and the rights granted hereunder will terminate automatically upon any breach by you of the terms of this license. individuals or entities who have received adaptations or collections from you under this license, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. sections 1, 2, 5, 6, 7, and 8 will survive any termination of this license. subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the work). notwithstanding the above, licensor reserves the right to release the work under different license terms or to stop distributing the work at any time; provided, however that any such election will not serve to withdraw this license (or any other license that has been, or is required to be, granted under the terms of this license), and this license will continue in full force and effect unless terminated as stated above. miscellaneous each time you distribute or publicly perform the work or a collection, the licensor offers to the recipient a license to the work on the same terms and conditions as the license granted to you under this license. each time you distribute or publicly perform an adaptation, licensor offers to the recipient a license to the original work on the same terms and conditions as the license granted to you under this license. if any provision of this license is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this license, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable. no term or provision of this license shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent. this license constitutes the entire agreement between the parties with respect to the work licensed here. there are no understandings, agreements or representations with respect to the work not specified here. licensor shall not be bound by any additional provisions that may appear in any communication from you. this license may not be modified without the mutual written agreement of the licensor and you. the rights granted under, and the subject matter referenced, in this license were drafted utilizing the terminology of the berne convention for the protection of literary and artistic works (as amended on september 28, 1979), the rome convention of 1961, the wipo copyright treaty of 1996, the wipo performances and phonograms treaty of 1996 and the universal copyright convention (as revised on july 24, 1971). these rights and subject matter take effect in the relevant jurisdiction in which the license terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. if the standard suite of rights granted under applicable copyright law includes additional rights not granted under this license, such additional rights are deemed to be included in the license; this license is not intended to restrict the license of any rights under applicable law. ?(?:creative commons notice creative commons is not a party to this license, and makes no warranty whatsoever in connection with the work. creative commons will not be liable to you or any party on any legal theory for any damages whatsoever, including without limitation any general, special, incidental or consequential damages arising in connection to this license. notwithstanding the foregoing two (2) sentences, if creative commons has expressly identified itself as the licensor hereunder, it shall have all rights and obligations of licensor. except for the limited purpose of indicating to the public that the work is licensed under the ccpl, creative commons does not authorize the use by either party of the trademark 'creative commons' or any related trademark or logo of creative commons without the prior written consent of creative commons. any permitted use will be in compliance with creative commons' then-current trademark usage guidelines, as may be published on its website or otherwise made available upon request from time to time. for the avoidance of doubt, this trademark restriction does not form part of the license. creative commons may be contacted at http://creativecommons.org/. ?)?`,
			wantErr: true,
		},
		{
			name:    "fixing legacy primary pattern converted from license_CC-BY-SA-3.0.txt",
			source:  `creative commons ?(?:legal code ?)? ?(?:(attribution ?\-?\+? ?sharealike) ?) ?(?:license version ?)? ?(?:(3\.0:?) ?) ?(?:unported ?)? ?(?:creative commons corporation is not a law firm and does not provide legal services. distribution of this license does not create an attorney-client relationship. creative commons provides this information on an 'as-is' basis. creative commons makes no warranties regarding the information provided, and disclaims liability for damages resulting from its use. ?)? ?(?:license ?)?the work (as defined below) is provided under the terms of this creative commons public license ('ccpl' or 'license'). the work is protected by copyright and/or other applicable law. any use of the work other than as authorized under this license or copyright law is prohibited. by exercising any rights to the work provided here, you accept and agree to be bound by the terms of this license. to the extent this license may be considered to be a contract, the licensor grants you the rights contained here in consideration of your acceptance of such terms and conditions. definitions 'adaptation' means a work based upon the work, or upon the work and other pre-existing works, such as a translation, adaptation, derivative work, arrangement of music or other alterations of a literary or artistic work, or phonogram or performance and includes cinematographic adaptations or any other form in which the work may be recast, transformed, or adapted including in any form recognizably derived from the original, except that a work that constitutes a collection will not be considered an adaptation for the purpose of this license. for the avoidance of doubt, where the work is a musical work, performance or phonogram, the synchronization of the work in timed-relation with a moving image ('synching') will be considered an adaptation for the purpose of this license. 'collection' means a collection of literary or artistic works, such as encyclopedias and anthologies, or performances, phonograms or broadcasts, or other works or subject matter other than works listed in section 1(f) below, which, by reason of the selection and arrangement of their contents, constitute intellectual creations, in which the work is included in its entirety in unmodified form along with one or more other contributions, each constituting separate and independent works in themselves, which together are assembled into a collective whole. a work that constitutes a collection will not be considered an adaptation (as defined below) for the purposes of this license. 'creative commons compatible license' means a license that is listed at http://creativecommons.org/compatiblelicenses that has been approved by creative commons as being essentially equivalent to this license, including, at a minimum, because that license: ?(?:(i) ?)?contains terms that have the same purpose, meaning and effect as the license elements of this license; and, ?(?:(ii) ?)?explicitly permits the relicensing of adaptations of works made available under that license under this license or a creative commons jurisdiction license with the same license elements as this license. 'distribute' means to make available to the public the original and copies of the work or adaptation, as appropriate, through sale or other transfer of ownership. 'license elements' means the following high-level license attributes as selected by licensor and indicated in the title of this license: attribution, sharealike. 'licensor' means the individual, individuals, entity or entities that offer(s) the work under the terms of this license. 'original author' means, in the case of a literary or artistic work, the individual, individuals, entity or entities who created the work or if no individual or entity can be identified, the publisher; and in addition ?(?:(i) ?)?in the case of a performance the actors, singers, musicians, dancers, and other persons who act, sing, deliver, declaim, play in, interpret or otherwise perform literary or artistic works or expressions of folklore; ?(?:(ii) ?)?in the case of a phonogram the producer being the person or legal entity who first fixes the sounds of a performance or other sounds; and, ?(?:(iii) ?)?in the case of broadcasts, the organization that transmits the broadcast. 'work' means the literary and/or artistic work offered under the terms of this license including without limitation any production in the literary, scientific and artistic domain, whatever may be the mode or form of its expression including digital form, such as a book, pamphlet and other writing; a lecture, address, sermon or other work of the same nature; a dramatic or dramatico-musical work; a choreographic work or entertainment in dumb show; a musical composition with or without words; a cinematographic work to which are assimilated works expressed by a process analogous to cinematography; a work of drawing, painting, architecture, sculpture, engraving or lithography; a photographic work to which are assimilated works expressed by a process analogous to photography; a work of applied art; an illustration, map, plan, sketch or three-dimensional work relative to geography, topography, architecture or science; a performance; a broadcast; a phonogram; a compilation of data to the extent it is protected as a copyrightable work; or a work performed by a variety or circus performer to the extent it is not otherwise considered a literary or artistic work. 'you' means an individual or entity exercising rights under this license who has not previously violated the terms of this license with respect to the work, or who has received express permission from the licensor to exercise rights under this license despite a previous violation. 'publicly perform' means to perform public recitations of the work and to communicate to the public those public recitations, by any means or process, including by wire or wireless means or public digital performances; to make available to the public works in such a way that members of the public may access these works from a place and at a place individually chosen by them; to perform the work to the public by any means or process and the communication to the public of the performances of the work, including by public digital performance; to broadcast and rebroadcast the work by any means including signs, sounds or images. 'reproduce' means to make copies of the work by any means including without limitation by sound or visual recordings and the right of fixation and reproducing fixations of the work, including storage of a protected performance or phonogram in digital form or other electronic medium. fair dealing rights. nothing in this license is intended to reduce, limit, or restrict any uses free from copyright or rights arising from limitations or exceptions that are provided for in connection with the copyright protection under copyright law or other applicable laws. license grant. subject to the terms and conditions of this license, licensor hereby grants you a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the work as stated below: to reproduce the work, to incorporate the work into one or more collections, and to reproduce the work as incorporated in the collections; to create and reproduce adaptations provided that any such adaptation, including any translation in any medium, takes reasonable steps to clearly label, demarcate or otherwise identify that changes were made to the original work. for example, a translation could be marked 'the original work was translated from english to spanish,' or a modification could indicate 'the original work has been modified.'; to distribute and publicly perform the work including as incorporated in collections; and, to distribute and publicly perform adaptations. for the avoidance of doubt: non-waivable compulsory license schemes. in those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme cannot be waived, the licensor reserves the exclusive right to collect such royalties for any exercise by you of the rights granted under this license; waivable compulsory license schemes. in those jurisdictions in which the right to collect royalties through any statutory or compulsory licensing scheme can be waived, the licensor waives the exclusive right to collect such royalties for any exercise by you of the rights granted under this license; and, voluntary license schemes. the licensor waives the right to collect royalties, whether individually or, in the event that the licensor is a member of a collecting society that administers voluntary licensing schemes, via that society, from any exercise by you of the rights granted under this license. the above rights may be exercised in all media and formats whether now known or hereafter devised. the above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats. subject to section 8(f), all rights not expressly granted by licensor are hereby reserved. restrictions. the license granted in section 3 above is expressly made subject to and limited by the following restrictions: you may distribute or publicly perform the work only under the terms of this license. you must include a copy of, or the uniform resource identifier (uri) for, this license with every copy of the work you distribute or publicly perform. you may not offer or impose any terms on the work that restrict the terms of this license or the ability of the recipient of the work to exercise the rights granted to that recipient under the terms of the license. you may not sublicense the work. you must keep intact all notices that refer to this license and to the disclaimer of warranties with every copy of the work you distribute or publicly perform. when you distribute or publicly perform the work, you may not impose any effective technological measures on the work that restrict the ability of a recipient of the work from you to exercise the rights granted to that recipient under the terms of the license. this section 4(a) applies to the work as incorporated in a collection, but this does not require the collection apart from the work itself to be made subject to the terms of this license. if you create a collection, upon notice from any licensor you must, to the extent practicable, remove from the collection any credit as required by section 4copyright, as requested. if you create an adaptation, upon notice from any licensor you must, to the extent practicable, remove from the adaptation any credit as required by section 4copyright, as requested. you may distribute or publicly perform an adaptation only under the terms of: ?(?:(i) ?)?this license; ?(?:(ii) ?)?a later version of this license with the same license elements as this license; ?(?:(iii) ?)?a creative commons jurisdiction license (either this or a later license version) that contains the same license elements as this license (e.g., attribution-sharealike 3.0 us); (iv) a creative commons compatible license. if you license the adaptation under one of the licenses mentioned in (iv), you must comply with the terms of that license. if you license the adaptation under the terms of any of the licenses mentioned in ?(?:(i) ?)?, ?(?:(ii) ?)?or ?(?:(iii) ?)?(the 'applicable license'), you must comply with the terms of the applicable license generally and the following provisions: ?(?:(i) ?)?you must include a copy of, or the uri for, the applicable license with every copy of each adaptation you distribute or publicly perform; ?(?:(ii) ?)?you may not offer or impose any terms on the adaptation that restrict the terms of the applicable license or the ability of the recipient of the adaptation to exercise the rights granted to that recipient under the terms of the applicable license; ?(?:(iii) ?)?you must keep intact all notices that refer to the applicable license and to the disclaimer of warranties with every copy of the work as included in the adaptation you distribute or publicly perform; (iv) when you distribute or publicly perform the adaptation, you may not impose any effective technological measures on the adaptation that restrict the ability of a recipient of the adaptation from you to exercise the rights granted to that recipient under the terms of the applicable license. this section 4(b) applies to the adaptation as incorporated in a collection, but this does not require the collection apart from the adaptation itself to be made subject to the terms of the applicable license. if you distribute, or publicly perform the work or any adaptations or collections, you must, unless a request has been made pursuant to section 4(a), keep intact all copyright notices for the work and provide, reasonable to the medium or means you are utilizing: ?(?:(i) ?)?the name of the original author (or pseudonym, if applicable) if supplied, and/or if the original author and/or licensor designate another party or parties (e.g., a sponsor institute, publishing entity, journal) for attribution ('attribution parties') in licensor's copyright notice, terms of service or by other reasonable means, the name of such party or parties; ?(?:(ii) ?)?the title of the work if supplied; ?(?:(iii) ?)?to the extent reasonably practicable, the uri, if any, that licensor specifies to be associated with the work, unless such uri does not refer to the copyright notice or licensing information for the work; and (iv) , consistent with ssection 3(b), in the case of an adaptation, a credit identifying the use of the work in the adaptation (e.g., 'french translation of the work by original author,' or 'screenplay based on original work by original author'). the credit required by this section 4copyright may be implemented in any reasonable manner; provided, however, that in the case of a adaptation or collection, at a minimum such credit will appear, if a credit for all contributing authors of the adaptation or collection appears, then as part of these credits and in a manner at least as prominent as the credits for the other contributing authors. for the avoidance of doubt, you may only use the credit required by this section for the purpose of attribution in the manner set out above and, by exercising your rights under this license, you may not implicitly or explicitly assert or imply any connection with, sponsorship or endorsement by the original author, licensor and/or attribution parties, as appropriate, of you or your use of the work, without the separate, express prior written permission of the original author, licensor and/or attribution parties. except as otherwise agreed in writing by the licensor or as may be otherwise permitted by applicable law, if you reproduce, distribute or publicly perform the work either by itself or as part of any adaptations or collections, you must not distort, mutilate, modify or take other derogatory action in relation to the work which would be prejudicial to the original author's honor or reputation. licensor agrees that in those jurisdictions (e.g. japan), in which any exercise of the right granted in section 3(b) of this license (the right to make adaptations) would be deemed to be a distortion, mutilation, modification or other derogatory action prejudicial to the original author's honor and reputation, the licensor will waive or not assert, as appropriate, this section, to the fullest extent permitted by the applicable national law, to enable you to reasonably exercise your right under section 3(b) of this license (right to make adaptations) but not otherwise. representations, warranties and disclaimer unless otherwise mutually agreed to by the parties in writing, licensor offers the work as-is and makes no representations or warranties of any kind concerning the work, express, implied, statutory or otherwise, including, without limitation, warranties of title, merchantibility, fitness for a particular purpose, noninfringement, or the absence of latent or other defects, accuracy, or the presence of absence of errors, whether or not discoverable. some jurisdictions do not allow the exclusion of implied warranties, so such exclusion may not apply to you. limitation on liability. except to the extent required by applicable law, in no event will licensor be liable to you on any legal theory for any special, incidental, consequential, punitive or exemplary damages arising out of this license or the use of the work, even if licensor has been advised of the possibility of such damages. termination this license and the rights granted hereunder will terminate automatically upon any breach by you of the terms of this license. individuals or entities who have received adaptations or collections from you under this license, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses. sections 1, 2, 5, 6, 7, and 8 will survive any termination of this license. subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the work). notwithstanding the above, licensor reserves the right to release the work under different license terms or to stop distributing the work at any time; provided, however that any such election will not serve to withdraw this license (or any other license that has been, or is required to be, granted under the terms of this license), and this license will continue in full force and effect unless terminated as stated above. miscellaneous each time you distribute or publicly perform the work or a collection, the licensor offers to the recipient a license to the work on the same terms and conditions as the license granted to you under this license. each time you distribute or publicly perform an adaptation, licensor offers to the recipient a license to the original work on the same terms and conditions as the license granted to you under this license. if any provision of this license is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this license, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable. no term or provision of this license shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent. this license constitutes the entire agreement between the parties with respect to the work licensed here. there are no understandings, agreements or representations with respect to the work not specified here. licensor shall not be bound by any additional provisions that may appear in any communication from you. this license may not be modified without the mutual written agreement of the licensor and you. the rights granted under, and the subject matter referenced, in this license were drafted utilizing the terminology of the berne convention for the protection of literary and artistic works (as amended on september 28, 1979), the rome convention of 1961, the wipo copyright treaty of 1996, the wipo performances and phonograms treaty of 1996 and the universal copyright convention (as revised on july 24, 1971). these rights and subject matter take effect in the relevant jurisdiction in which the license terms are sought to be enforced according to the corresponding provisions of the implementation of those treaty provisions in the applicable national law. if the standard suite of rights granted under applicable copyright law includes additional rights not granted under this license, such additional rights are deemed to be included in the license; this license is not intended to restrict the license of any rights under applicable law. ?(?:creative commons notice creative commons is not a party to this license, and makes no warranty whatsoever in connection with the work. creative commons will not be liable to you or any party on any legal theory for any damages whatsoever, including without limitation any general, special, incidental or consequential damages arising in connection to this license. notwithstanding the foregoing two (2) sentences, if creative commons has expressly identified itself as the licensor hereunder, it shall have all rights and obligations of licensor. except for the limited purpose of indicating to the public that the work is licensed under the ccpl, creative commons does not authorize the use by either party of the trademark 'creative commons' or any related trademark or logo of creative commons without the prior written consent of creative commons. any permitted use will be in compliance with creative commons' then-current trademark usage guidelines, as may be published on its website or otherwise made available upon request from time to time. for the avoidance of doubt, this trademark restriction does not form part of the license. creative commons may be contacted at http://creativecommons.org/. ?)?`,
			wantErr: false,
		},
	}
	for _, test := range tests {
		test := test
		t.Run(test.name, func(t *testing.T) {
			t.Parallel()

			test.source = strings.TrimSpace(test.source)
			_, err := regexp.Compile("(?i)" + test.source)
			if test.wantErr {
				if err == nil {
					t.Errorf("Wanted err, but err==nil")
				} else {
					t.Logf("Wanted err, and got one: err==%v", err)
				}
			} else if err != nil {
				t.Errorf("Did not want err, but got one: err==%v", err)
			} else {
				// The intention was that additional tests with fixes and !wantErr would be validated here
			}
		})
	}
}
