/*
Package ctestschema is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was true
in this case).

This package was generated by /usr/local/google/home/wenbli/gocode/src/github.com/openconfig/ygot/genutil/names.go
using the following YANG input files:
  - ../yang/ctestschema.yang
  - ../yang/ctestschema-rootmod.yang

Imported modules were sourced from:
  - ...
*/
package ctestschema

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

// UnionInt8 is an int8 type assignable to unions of which it is a subtype.
type UnionInt8 int8

// UnionInt16 is an int16 type assignable to unions of which it is a subtype.
type UnionInt16 int16

// UnionInt32 is an int32 type assignable to unions of which it is a subtype.
type UnionInt32 int32

// UnionInt64 is an int64 type assignable to unions of which it is a subtype.
type UnionInt64 int64

// UnionUint8 is a uint8 type assignable to unions of which it is a subtype.
type UnionUint8 uint8

// UnionUint16 is a uint16 type assignable to unions of which it is a subtype.
type UnionUint16 uint16

// UnionUint32 is a uint32 type assignable to unions of which it is a subtype.
type UnionUint32 uint32

// UnionUint64 is a uint64 type assignable to unions of which it is a subtype.
type UnionUint64 uint64

// UnionFloat64 is a float64 type assignable to unions of which it is a subtype.
type UnionFloat64 float64

// UnionString is a string type assignable to unions of which it is a subtype.
type UnionString string

// UnionBool is a bool type assignable to unions of which it is a subtype.
type UnionBool bool

// UnionUnsupported is an interface{} wrapper type for unsupported types. It is
// assignable to unions of which it is a subtype.
type UnionUnsupported struct {
	Value interface{}
}

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Device represents the /device YANG schema element.
type Device struct {
	ΛMetadata              []ygot.Annotation                 `path:"@" ygotAnnotation:"true"`
	OrderedList            *OrderedList_OrderedMap           `path:"ordered-lists/ordered-list" module:"ctestschema/ctestschema"`
	ΛOrderedList           []ygot.Annotation                 `path:"ordered-lists/@ordered-list" ygotAnnotation:"true"`
	OrderedMultikeyedList  *OrderedMultikeyedList_OrderedMap `path:"ordered-multikeyed-lists/ordered-multikeyed-list" module:"ctestschema-rootmod/ctestschema"`
	ΛOrderedMultikeyedList []ygot.Annotation                 `path:"ordered-multikeyed-lists/@ordered-multikeyed-list" ygotAnnotation:"true"`
	OtherData              *OtherData                        `path:"other-data" module:"ctestschema"`
	ΛOtherData             []ygot.Annotation                 `path:"@other-data" ygotAnnotation:"true"`
	UnorderedList          map[string]*UnorderedList         `path:"unordered-lists/unordered-list" module:"ctestschema/ctestschema"`
	ΛUnorderedList         []ygot.Annotation                 `path:"unordered-lists/@unordered-list" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// OrderedMultikeyedList_Key represents the key for list OrderedMultikeyedList of element /device.
type OrderedMultikeyedList_Key struct {
	Key1 string `path:"key1"`
	Key2 uint64 `path:"key2"`
}

// IsYANGGoKeyStruct ensures that OrderedMultikeyedList_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OrderedMultikeyedList_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OrderedMultikeyedList_Key key struct.
func (t OrderedMultikeyedList_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"key1": t.Key1,
		"key2": t.Key2,
	}, nil
}

// NewUnorderedList creates a new entry in the UnorderedList list of the
// Device struct. The keys of the list are populated from the input
// arguments.
func (t *Device) NewUnorderedList(Key string) (*UnorderedList, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*UnorderedList)
	}

	key := Key

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnorderedList[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnorderedList", key)
	}

	t.UnorderedList[key] = &UnorderedList{
		Key: &Key,
	}

	return t.UnorderedList[key], nil
}

// RenameUnorderedList renames an entry in the list UnorderedList within
// the Device struct. The entry with key oldK is renamed to newK updating
// the key within the value.
func (t *Device) RenameUnorderedList(oldK, newK string) error {
	if _, ok := t.UnorderedList[newK]; ok {
		return fmt.Errorf("key %v already exists in UnorderedList", newK)
	}

	e, ok := t.UnorderedList[oldK]
	if !ok {
		return fmt.Errorf("key %v not found in UnorderedList", oldK)
	}
	e.Key = &newK

	t.UnorderedList[newK] = e
	delete(t.UnorderedList, oldK)
	return nil
}

// GetOrCreateUnorderedListMap returns the list (map) from Device.
//
// It initializes the field if not already initialized.
func (t *Device) GetOrCreateUnorderedListMap() map[string]*UnorderedList {
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*UnorderedList)
	}
	return t.UnorderedList
}

// GetOrCreateUnorderedList retrieves the value with the specified keys from
// the receiver Device. If the entry does not exist, then it is created.
// It returns the existing or new list member.
func (t *Device) GetOrCreateUnorderedList(Key string) *UnorderedList {

	key := Key

	if v, ok := t.UnorderedList[key]; ok {
		return v
	}
	// Panic if we receive an error, since we should have retrieved an existing
	// list member. This allows chaining of GetOrCreate methods.
	v, err := t.NewUnorderedList(Key)
	if err != nil {
		panic(fmt.Sprintf("GetOrCreateUnorderedList got unexpected error: %v", err))
	}
	return v
}

// GetUnorderedList retrieves the value with the specified key from
// the UnorderedList map field of Device. If the receiver is nil, or
// the specified key is not present in the list, nil is returned such that Get*
// methods may be safely chained.
func (t *Device) GetUnorderedList(Key string) *UnorderedList {

	if t == nil {
		return nil
	}

	key := Key

	if lm, ok := t.UnorderedList[key]; ok {
		return lm
	}
	return nil
}

// AppendUnorderedList appends the supplied UnorderedList struct to the
// list UnorderedList of Device. If the key value(s) specified in
// the supplied UnorderedList already exist in the list, an error is
// returned.
func (t *Device) AppendUnorderedList(v *UnorderedList) error {
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnorderedList == nil {
		t.UnorderedList = make(map[string]*UnorderedList)
	}

	if _, ok := t.UnorderedList[key]; ok {
		return fmt.Errorf("duplicate key for list UnorderedList %v", key)
	}

	t.UnorderedList[key] = v
	return nil
}

// GetOrCreateOtherData retrieves the value of the OtherData field
// or returns the existing field if it already exists.
func (t *Device) GetOrCreateOtherData() *OtherData {
	if t.OtherData != nil {
		return t.OtherData
	}
	t.OtherData = &OtherData{}
	return t.OtherData
}

// GetOtherData returns the value of the OtherData struct pointer
// from Device. If the receiver or the field OtherData is nil, nil
// is returned such that the Get* methods can be safely chained.
func (t *Device) GetOtherData() *OtherData {
	if t != nil && t.OtherData != nil {
		return t.OtherData
	}
	return nil
}

// GetOrCreateOrderedListMap returns the ordered map field
// OrderedList from Device.
//
// It initializes the field if not already initialized.
func (s *Device) GetOrCreateOrderedListMap() *OrderedList_OrderedMap {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedMap{}
	}
	return s.OrderedList
}

// AppendNewOrderedList creates a new entry in the OrderedList
// ordered map of the Device struct. The keys of the list are
// populated from the input arguments.
func (s *Device) AppendNewOrderedList(Key string) (*OrderedList, error) {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedMap{}
	}
	return s.OrderedList.AppendNew(Key)
}

// AppendOrderedList appends the supplied OrderedList struct
// to the list OrderedList of Device. If the key value(s)
// specified in the supplied OrderedList already exist in the list, an
// error is returned.
func (s *Device) AppendOrderedList(v *OrderedList) error {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedMap{}
	}
	return s.OrderedList.Append(v)
}

// GetOrderedList retrieves the value with the specified key from the
// OrderedList map field of Device. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *Device) GetOrderedList(Key string) *OrderedList {
	if s == nil {
		return nil
	}
	key := Key
	return s.OrderedList.Get(key)
}

// DeleteOrderedList deletes the value with the specified keys from
// the receiver Device. If there is no such element, the
// function is a no-op.
func (s *Device) DeleteOrderedList(Key string) bool {
	key := Key
	return s.OrderedList.Delete(key)
}

// OrderedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema/ordered-lists/ordered-list.
type OrderedList_OrderedMap struct {
	keys     []string
	valueMap map[string]*OrderedList
}

// IsYANGOrderedList ensures that OrderedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*OrderedList_OrderedMap) IsYANGOrderedList() {}

// init initializes any uninitialized values.
func (o *OrderedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[string]*OrderedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *OrderedList_OrderedMap) Keys() []string {
	if o == nil {
		return nil
	}
	return append([]string{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *OrderedList_OrderedMap) Values() []*OrderedList {
	if o == nil {
		return nil
	}
	var values []*OrderedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of OrderedList_OrderedMap
func (o *OrderedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *OrderedList_OrderedMap) Get(key string) *OrderedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *OrderedList_OrderedMap) Delete(key string) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a OrderedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *OrderedList_OrderedMap) Append(v *OrderedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append OrderedList")
	}
	if v == nil {
		return fmt.Errorf("nil OrderedList")
	}
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new OrderedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *OrderedList_OrderedMap) AppendNew(Key string) (*OrderedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append OrderedList")
	}
	key := Key

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &OrderedList{
		Key: &Key,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// GetOrCreateOrderedMultikeyedListMap returns the ordered map field
// OrderedMultikeyedList from Device.
//
// It initializes the field if not already initialized.
func (s *Device) GetOrCreateOrderedMultikeyedListMap() *OrderedMultikeyedList_OrderedMap {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList
}

// AppendNewOrderedMultikeyedList creates a new entry in the OrderedMultikeyedList
// ordered map of the Device struct. The keys of the list are
// populated from the input arguments.
func (s *Device) AppendNewOrderedMultikeyedList(Key1 string, Key2 uint64) (*OrderedMultikeyedList, error) {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList.AppendNew(Key1, Key2)
}

// AppendOrderedMultikeyedList appends the supplied OrderedMultikeyedList struct
// to the list OrderedMultikeyedList of Device. If the key value(s)
// specified in the supplied OrderedMultikeyedList already exist in the list, an
// error is returned.
func (s *Device) AppendOrderedMultikeyedList(v *OrderedMultikeyedList) error {
	if s.OrderedMultikeyedList == nil {
		s.OrderedMultikeyedList = &OrderedMultikeyedList_OrderedMap{}
	}
	return s.OrderedMultikeyedList.Append(v)
}

// GetOrderedMultikeyedList retrieves the value with the specified key from the
// OrderedMultikeyedList map field of Device. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *Device) GetOrderedMultikeyedList(Key1 string, Key2 uint64) *OrderedMultikeyedList {
	if s == nil {
		return nil
	}
	key := OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}
	return s.OrderedMultikeyedList.Get(key)
}

// DeleteOrderedMultikeyedList deletes the value with the specified keys from
// the receiver Device. If there is no such element, the
// function is a no-op.
func (s *Device) DeleteOrderedMultikeyedList(Key1 string, Key2 uint64) bool {
	key := OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}
	return s.OrderedMultikeyedList.Delete(key)
}

// OrderedMultikeyedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list.
type OrderedMultikeyedList_OrderedMap struct {
	keys     []OrderedMultikeyedList_Key
	valueMap map[OrderedMultikeyedList_Key]*OrderedMultikeyedList
}

// IsYANGOrderedList ensures that OrderedMultikeyedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*OrderedMultikeyedList_OrderedMap) IsYANGOrderedList() {}

// init initializes any uninitialized values.
func (o *OrderedMultikeyedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[OrderedMultikeyedList_Key]*OrderedMultikeyedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *OrderedMultikeyedList_OrderedMap) Keys() []OrderedMultikeyedList_Key {
	if o == nil {
		return nil
	}
	return append([]OrderedMultikeyedList_Key{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *OrderedMultikeyedList_OrderedMap) Values() []*OrderedMultikeyedList {
	if o == nil {
		return nil
	}
	var values []*OrderedMultikeyedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of OrderedMultikeyedList_OrderedMap
func (o *OrderedMultikeyedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *OrderedMultikeyedList_OrderedMap) Get(key OrderedMultikeyedList_Key) *OrderedMultikeyedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *OrderedMultikeyedList_OrderedMap) Delete(key OrderedMultikeyedList_Key) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a OrderedMultikeyedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *OrderedMultikeyedList_OrderedMap) Append(v *OrderedMultikeyedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append OrderedMultikeyedList")
	}
	if v == nil {
		return fmt.Errorf("nil OrderedMultikeyedList")
	}
	if v.Key1 == nil {
		return fmt.Errorf("invalid nil key for Key1")
	}
	if v.Key2 == nil {
		return fmt.Errorf("invalid nil key for Key2")
	}
	key := OrderedMultikeyedList_Key{
		Key1: *v.Key1,
		Key2: *v.Key2,
	}

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new OrderedMultikeyedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *OrderedMultikeyedList_OrderedMap) AppendNew(Key1 string, Key2 uint64) (*OrderedMultikeyedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append OrderedMultikeyedList")
	}
	key := OrderedMultikeyedList_Key{
		Key1: Key1,
		Key2: Key2,
	}

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &OrderedMultikeyedList{
		Key1: &Key1,
		Key2: &Key2,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// PopulateDefaults recursively populates unset leaf fields in the Device
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *Device) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	t.OtherData.PopulateDefaults()
	for _, e := range t.UnorderedList {
		e.PopulateDefaults()
	}
	for _, e := range t.OrderedList.Values() {
		e.PopulateDefaults()
	}
	for _, e := range t.OrderedMultikeyedList.Values() {
		e.PopulateDefaults()
	}
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}

// OrderedList represents the /ctestschema/ordered-lists/ordered-list YANG schema element.
type OrderedList struct {
	ΛMetadata    []ygot.Annotation                   `path:"@" ygotAnnotation:"true"`
	Key          *string                             `path:"config/key|key" module:"ctestschema/ctestschema|ctestschema" shadow-path:"state/key|key" shadow-module:"ctestschema/ctestschema|ctestschema"`
	ΛKey         []ygot.Annotation                   `path:"config/@key|@key" ygotAnnotation:"true"`
	OrderedList  *OrderedList_OrderedList_OrderedMap `path:"ordered-lists/ordered-list" module:"ctestschema/ctestschema"`
	ΛOrderedList []ygot.Annotation                   `path:"ordered-lists/@ordered-list" ygotAnnotation:"true"`
	ParentKey    *string                             `path:"state/parent-key" module:"ctestschema/ctestschema"`
	ΛParentKey   []ygot.Annotation                   `path:"state/@parent-key" ygotAnnotation:"true"`
	RoValue      *string                             `path:"state/ro-value" module:"ctestschema/ctestschema"`
	ΛRoValue     []ygot.Annotation                   `path:"state/@ro-value" ygotAnnotation:"true"`
	Value        *string                             `path:"config/value" module:"ctestschema/ctestschema" shadow-path:"state/value" shadow-module:"ctestschema/ctestschema"`
	ΛValue       []ygot.Annotation                   `path:"config/@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OrderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OrderedList) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *OrderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetParentKey retrieves the value of the leaf ParentKey from the OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ParentKey is set, it can
// safely use t.GetParentKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ParentKey == nil' before retrieving the leaf's value.
func (t *OrderedList) GetParentKey() string {
	if t == nil || t.ParentKey == nil {
		return ""
	}
	return *t.ParentKey
}

// GetRoValue retrieves the value of the leaf RoValue from the OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RoValue is set, it can
// safely use t.GetRoValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RoValue == nil' before retrieving the leaf's value.
func (t *OrderedList) GetRoValue() string {
	if t == nil || t.RoValue == nil {
		return ""
	}
	return *t.RoValue
}

// GetValue retrieves the value of the leaf Value from the OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *OrderedList) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// GetOrCreateOrderedListMap returns the ordered map field
// OrderedList from OrderedList.
//
// It initializes the field if not already initialized.
func (s *OrderedList) GetOrCreateOrderedListMap() *OrderedList_OrderedList_OrderedMap {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedList_OrderedMap{}
	}
	return s.OrderedList
}

// AppendNewOrderedList creates a new entry in the OrderedList
// ordered map of the OrderedList struct. The keys of the list are
// populated from the input arguments.
func (s *OrderedList) AppendNewOrderedList(Key string) (*OrderedList_OrderedList, error) {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedList_OrderedMap{}
	}
	return s.OrderedList.AppendNew(Key)
}

// AppendOrderedList appends the supplied OrderedList_OrderedList struct
// to the list OrderedList of OrderedList. If the key value(s)
// specified in the supplied OrderedList_OrderedList already exist in the list, an
// error is returned.
func (s *OrderedList) AppendOrderedList(v *OrderedList_OrderedList) error {
	if s.OrderedList == nil {
		s.OrderedList = &OrderedList_OrderedList_OrderedMap{}
	}
	return s.OrderedList.Append(v)
}

// GetOrderedList retrieves the value with the specified key from the
// OrderedList map field of OrderedList. If the receiver
// is nil, or the specified key is not present in the list, nil is returned
// such that Get* methods may be safely chained.
func (s *OrderedList) GetOrderedList(Key string) *OrderedList_OrderedList {
	if s == nil {
		return nil
	}
	key := Key
	return s.OrderedList.Get(key)
}

// DeleteOrderedList deletes the value with the specified keys from
// the receiver OrderedList. If there is no such element, the
// function is a no-op.
func (s *OrderedList) DeleteOrderedList(Key string) bool {
	key := Key
	return s.OrderedList.Delete(key)
}

// OrderedList_OrderedList_OrderedMap is an ordered map that represents the "ordered-by user"
// list elements at /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list.
type OrderedList_OrderedList_OrderedMap struct {
	keys     []string
	valueMap map[string]*OrderedList_OrderedList
}

// IsYANGOrderedList ensures that OrderedList_OrderedList_OrderedMap implements the
// ygot.GoOrderedMap interface.
func (*OrderedList_OrderedList_OrderedMap) IsYANGOrderedList() {}

// init initializes any uninitialized values.
func (o *OrderedList_OrderedList_OrderedMap) init() {
	if o == nil {
		return
	}
	if o.valueMap == nil {
		o.valueMap = map[string]*OrderedList_OrderedList{}
	}
}

// Keys returns a copy of the list's keys.
func (o *OrderedList_OrderedList_OrderedMap) Keys() []string {
	if o == nil {
		return nil
	}
	return append([]string{}, o.keys...)
}

// Values returns the current set of the list's values in order.
func (o *OrderedList_OrderedList_OrderedMap) Values() []*OrderedList_OrderedList {
	if o == nil {
		return nil
	}
	var values []*OrderedList_OrderedList
	for _, key := range o.keys {
		values = append(values, o.valueMap[key])
	}
	return values
}

// Len returns a size of OrderedList_OrderedList_OrderedMap
func (o *OrderedList_OrderedList_OrderedMap) Len() int {
	if o == nil {
		return 0
	}
	return len(o.keys)
}

// Get returns the value corresponding to the key. If the key is not found, nil
// is returned.
func (o *OrderedList_OrderedList_OrderedMap) Get(key string) *OrderedList_OrderedList {
	if o == nil {
		return nil
	}
	val, _ := o.valueMap[key]
	return val
}

// Delete deletes an element.
func (o *OrderedList_OrderedList_OrderedMap) Delete(key string) bool {
	if o == nil {
		return false
	}
	if _, ok := o.valueMap[key]; !ok {
		return false
	}
	for i, k := range o.keys {
		if k == key {
			o.keys = append(o.keys[:i], o.keys[i+1:]...)
			delete(o.valueMap, key)
			return true
		}
	}
	return false
}

// Append appends a OrderedList_OrderedList, returning an error if the key
// already exists in the ordered list or if the key is unspecified.
func (o *OrderedList_OrderedList_OrderedMap) Append(v *OrderedList_OrderedList) error {
	if o == nil {
		return fmt.Errorf("nil ordered map, cannot append OrderedList_OrderedList")
	}
	if v == nil {
		return fmt.Errorf("nil OrderedList_OrderedList")
	}
	if v.Key == nil {
		return fmt.Errorf("invalid nil key received for Key")
	}

	key := *v.Key

	if _, ok := o.valueMap[key]; ok {
		return fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	o.init()
	o.valueMap[key] = v
	return nil
}

// AppendNew creates and appends a new OrderedList_OrderedList, returning the
// newly-initialized v. It returns an error if the v already exists.
func (o *OrderedList_OrderedList_OrderedMap) AppendNew(Key string) (*OrderedList_OrderedList, error) {
	if o == nil {
		return nil, fmt.Errorf("nil ordered map, cannot append OrderedList_OrderedList")
	}
	key := Key

	if _, ok := o.valueMap[key]; ok {
		return nil, fmt.Errorf("duplicate key for list Statement %v", key)
	}
	o.keys = append(o.keys, key)
	newElement := &OrderedList_OrderedList{
		Key: &Key,
	}
	o.init()
	o.valueMap[key] = newElement
	return newElement, nil
}

// PopulateDefaults recursively populates unset leaf fields in the OrderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OrderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
	for _, e := range t.OrderedList.Values() {
		e.PopulateDefaults()
	}
}

// ΛListKeyMap returns the keys of the OrderedList struct, which is a YANG list entry.
func (t *OrderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OrderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OrderedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OrderedList.
func (*OrderedList) ΛBelongingModule() string {
	return "ctestschema"
}

// OrderedList_OrderedList represents the /ctestschema/ordered-lists/ordered-list/ordered-lists/ordered-list YANG schema element.
type OrderedList_OrderedList struct {
	ΛMetadata  []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key        *string           `path:"config/key|key" module:"ctestschema/ctestschema|ctestschema" shadow-path:"state/key|key" shadow-module:"ctestschema/ctestschema|ctestschema"`
	ΛKey       []ygot.Annotation `path:"config/@key|@key" ygotAnnotation:"true"`
	ParentKey  *string           `path:"state/parent-key" module:"ctestschema/ctestschema"`
	ΛParentKey []ygot.Annotation `path:"state/@parent-key" ygotAnnotation:"true"`
	Value      *string           `path:"config/value" module:"ctestschema/ctestschema" shadow-path:"state/value" shadow-module:"ctestschema/ctestschema"`
	ΛValue     []ygot.Annotation `path:"config/@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OrderedList_OrderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OrderedList_OrderedList) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the OrderedList_OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *OrderedList_OrderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetParentKey retrieves the value of the leaf ParentKey from the OrderedList_OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if ParentKey is set, it can
// safely use t.GetParentKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.ParentKey == nil' before retrieving the leaf's value.
func (t *OrderedList_OrderedList) GetParentKey() string {
	if t == nil || t.ParentKey == nil {
		return ""
	}
	return *t.ParentKey
}

// GetValue retrieves the value of the leaf Value from the OrderedList_OrderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *OrderedList_OrderedList) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the OrderedList_OrderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OrderedList_OrderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// ΛListKeyMap returns the keys of the OrderedList_OrderedList struct, which is a YANG list entry.
func (t *OrderedList_OrderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedList_OrderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OrderedList_OrderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedList_OrderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OrderedList_OrderedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OrderedList_OrderedList.
func (*OrderedList_OrderedList) ΛBelongingModule() string {
	return "ctestschema"
}

// OrderedMultikeyedList represents the /ctestschema-rootmod/ordered-multikeyed-lists/ordered-multikeyed-list YANG schema element.
type OrderedMultikeyedList struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key1      *string           `path:"config/key1|key1" module:"ctestschema/ctestschema|ctestschema" shadow-path:"state/key1|key1" shadow-module:"ctestschema/ctestschema|ctestschema"`
	ΛKey1     []ygot.Annotation `path:"config/@key1|@key1" ygotAnnotation:"true"`
	Key2      *uint64           `path:"config/key2|key2" module:"ctestschema/ctestschema|ctestschema" shadow-path:"state/key2|key2" shadow-module:"ctestschema/ctestschema|ctestschema"`
	ΛKey2     []ygot.Annotation `path:"config/@key2|@key2" ygotAnnotation:"true"`
	RoValue   *string           `path:"state/ro-value" module:"ctestschema/ctestschema"`
	ΛRoValue  []ygot.Annotation `path:"state/@ro-value" ygotAnnotation:"true"`
	Value     *string           `path:"config/value" module:"ctestschema/ctestschema" shadow-path:"state/value" shadow-module:"ctestschema/ctestschema"`
	ΛValue    []ygot.Annotation `path:"config/@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OrderedMultikeyedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OrderedMultikeyedList) IsYANGGoStruct() {}

// GetKey1 retrieves the value of the leaf Key1 from the OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key1 is set, it can
// safely use t.GetKey1() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key1 == nil' before retrieving the leaf's value.
func (t *OrderedMultikeyedList) GetKey1() string {
	if t == nil || t.Key1 == nil {
		return ""
	}
	return *t.Key1
}

// GetKey2 retrieves the value of the leaf Key2 from the OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key2 is set, it can
// safely use t.GetKey2() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key2 == nil' before retrieving the leaf's value.
func (t *OrderedMultikeyedList) GetKey2() uint64 {
	if t == nil || t.Key2 == nil {
		return 0
	}
	return *t.Key2
}

// GetRoValue retrieves the value of the leaf RoValue from the OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if RoValue is set, it can
// safely use t.GetRoValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.RoValue == nil' before retrieving the leaf's value.
func (t *OrderedMultikeyedList) GetRoValue() string {
	if t == nil || t.RoValue == nil {
		return ""
	}
	return *t.RoValue
}

// GetValue retrieves the value of the leaf Value from the OrderedMultikeyedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *OrderedMultikeyedList) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-multikeyed-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the OrderedMultikeyedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OrderedMultikeyedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-multikeyed-value"
		t.Value = &v
	}
}

// ΛListKeyMap returns the keys of the OrderedMultikeyedList struct, which is a YANG list entry.
func (t *OrderedMultikeyedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key1 == nil {
		return nil, fmt.Errorf("nil value for key Key1")
	}

	if t.Key2 == nil {
		return nil, fmt.Errorf("nil value for key Key2")
	}

	return map[string]interface{}{
		"key1": *t.Key1,
		"key2": *t.Key2,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedMultikeyedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OrderedMultikeyedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OrderedMultikeyedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OrderedMultikeyedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OrderedMultikeyedList.
func (*OrderedMultikeyedList) ΛBelongingModule() string {
	return "ctestschema"
}

// OtherData represents the /ctestschema/other-data YANG schema element.
type OtherData struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Motd      *string           `path:"config/motd" module:"ctestschema/ctestschema" shadow-path:"state/motd" shadow-module:"ctestschema/ctestschema"`
	ΛMotd     []ygot.Annotation `path:"config/@motd" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that OtherData implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OtherData) IsYANGGoStruct() {}

// GetMotd retrieves the value of the leaf Motd from the OtherData
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Motd is set, it can
// safely use t.GetMotd() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Motd == nil' before retrieving the leaf's value.
func (t *OtherData) GetMotd() string {
	if t == nil || t.Motd == nil {
		return ""
	}
	return *t.Motd
}

// PopulateDefaults recursively populates unset leaf fields in the OtherData
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *OtherData) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OtherData) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OtherData"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OtherData) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OtherData) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OtherData.
func (*OtherData) ΛBelongingModule() string {
	return "ctestschema"
}

// UnorderedList represents the /ctestschema/unordered-lists/unordered-list YANG schema element.
type UnorderedList struct {
	ΛMetadata []ygot.Annotation `path:"@" ygotAnnotation:"true"`
	Key       *string           `path:"config/key|key" module:"ctestschema/ctestschema|ctestschema" shadow-path:"state/key|key" shadow-module:"ctestschema/ctestschema|ctestschema"`
	ΛKey      []ygot.Annotation `path:"config/@key|@key" ygotAnnotation:"true"`
	Value     *string           `path:"config/value" module:"ctestschema/ctestschema" shadow-path:"state/value" shadow-module:"ctestschema/ctestschema"`
	ΛValue    []ygot.Annotation `path:"config/@value" ygotAnnotation:"true"`
}

// IsYANGGoStruct ensures that UnorderedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*UnorderedList) IsYANGGoStruct() {}

// GetKey retrieves the value of the leaf Key from the UnorderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Key is set, it can
// safely use t.GetKey() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Key == nil' before retrieving the leaf's value.
func (t *UnorderedList) GetKey() string {
	if t == nil || t.Key == nil {
		return ""
	}
	return *t.Key
}

// GetValue retrieves the value of the leaf Value from the UnorderedList
// struct. If the field is unset but has a default value in the YANG schema,
// then the default value will be returned.
// Caution should be exercised whilst using this method since when without a
// default value, it will return the Go zero value if the field is explicitly
// unset. If the caller explicitly does not care if Value is set, it can
// safely use t.GetValue() to retrieve the value. In the case that the
// caller has different actions based on whether the leaf is set or unset, it
// should use 'if t.Value == nil' before retrieving the leaf's value.
func (t *UnorderedList) GetValue() string {
	if t == nil || t.Value == nil {
		return "default-value"
	}
	return *t.Value
}

// PopulateDefaults recursively populates unset leaf fields in the UnorderedList
// with default values as specified in the YANG schema, instantiating any nil
// container fields.
func (t *UnorderedList) PopulateDefaults() {
	if t == nil {
		return
	}
	ygot.BuildEmptyTree(t)
	if t.Value == nil {
		var v string = "default-value"
		t.Value = &v
	}
}

// ΛListKeyMap returns the keys of the UnorderedList struct, which is a YANG list entry.
func (t *UnorderedList) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Key == nil {
		return nil, fmt.Errorf("nil value for key Key")
	}

	return map[string]interface{}{
		"key": *t.Key,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *UnorderedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["UnorderedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *UnorderedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *UnorderedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of UnorderedList.
func (*UnorderedList) ΛBelongingModule() string {
	return "ctestschema"
}

var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5d, 0x4d, 0x6f, 0xdb, 0x46,
		0x13, 0xbe, 0xfb, 0x57, 0x10, 0x3c, 0x47, 0xb1, 0xa5, 0xd7, 0x89, 0xf3, 0xfa, 0x96, 0xc6, 0x0d,
		0x0a, 0xa4, 0x6e, 0x83, 0xa4, 0xe9, 0xa5, 0x30, 0x0a, 0x46, 0x5a, 0x29, 0x84, 0x25, 0xd2, 0x20,
		0x97, 0xae, 0x85, 0x42, 0xff, 0xbd, 0xa0, 0x28, 0x31, 0x22, 0xc5, 0x8f, 0x99, 0xd9, 0xa5, 0x4c,
		0x45, 0x4f, 0xd1, 0x43, 0x2c, 0xed, 0x6a, 0xb9, 0xf3, 0xb5, 0x33, 0xcf, 0xec, 0x0c, 0xff, 0x3d,
		0x73, 0x1c, 0xc7, 0x71, 0x7f, 0xf3, 0x16, 0xca, 0xbd, 0x76, 0xdc, 0x89, 0x7a, 0xf4, 0xc7, 0xca,
		0x7d, 0x91, 0x7d, 0xfa, 0xc1, 0x0f, 0x26, 0xee, 0xb5, 0x33, 0xdc, 0xfc, 0xf9, 0x2e, 0x0c, 0xa6,
		0xfe, 0xcc, 0xbd, 0x76, 0x2e, 0x36, 0x1f, 0xdc, 0xf8, 0x91, 0x7b, 0xed, 0x64, 0x3f, 0xb1, 0xfe,
		0x20, 0x8c, 0x26, 0x2a, 0x52, 0x93, 0xc1, 0xdc, 0x8f, 0x75, 0x5c, 0xf8, 0xaa, 0xb0, 0x4a, 0x71,
		0xd8, 0x8b, 0xe2, 0xa0, 0xe2, 0xa2, 0xf9, 0xc7, 0xe5, 0xc5, 0xf3, 0x2f, 0x3e, 0x46, 0x6a, 0xea,
		0x3f, 0xed, 0x2d, 0x56, 0x58, 0x70, 0xbc, 0xb7, 0xcc, 0xfa, 0xeb, 0xcf, 0x61, 0x12, 0x8d, 0x55,
		0xe5, 0xd4, 0xec, 0x51, 0xd4, 0xf2, 0x9f, 0x30, 0x4a, 0x9f, 0xc6, 0x7d, 0xc8, 0x56, 0x79, 0x51,
		0x3d, 0xf0, 0x17, 0x2f, 0x7e, 0x1b, 0xcd, 0x92, 0x85, 0x0a, 0xb4, 0x7b, 0xed, 0xe8, 0x28, 0x51,
		0x35, 0x03, 0x77, 0x46, 0xad, 0x1f, 0x6a, 0x6f, 0xd4, 0xaa, 0xf0, 0xc9, 0xaa, 0xb4, 0xd7, 0x32,
		0xc1, 0x2b, 0x09, 0x5f, 0xbf, 0x9f, 0x2a, 0xfa, 0xd7, 0x6d, 0xa9, 0x9a, 0x0d, 0xad, 0xec, 0xa0,
		0xb0, 0x85, 0xc8, 0x1e, 0x2a, 0x9b, 0xd8, 0xec, 0x62, 0xb3, 0x8d, 0xce, 0xbe, 0x6a, 0x36, 0xd6,
		0xb0, 0xb3, 0x95, 0xad, 0xf9, 0x80, 0xf1, 0x96, 0xda, 0x2d, 0x14, 0xc8, 0x09, 0x9a, 0x8d, 0x6f,
		0xd9, 0x4d, 0x33, 0x8b, 0xc9, 0xac, 0xe6, 0xb0, 0x9c, 0xc9, 0x7a, 0xae, 0x08, 0x88, 0x45, 0x41,
		0x2c, 0x12, 0x7c, 0xd1, 0x68, 0x16, 0x91, 0x16, 0x51, 0x21, 0x8b, 0x4c, 0x3e, 0xf0, 0x5e, 0x2d,
		0xe9, 0x64, 0xdb, 0x72, 0x25, 0x9d, 0x44, 0xdc, 0xf7, 0x46, 0x88, 0x2e, 0x88, 0xc3, 0xa9, 0xc2,
		0x24, 0x11, 0x2a, 0xa1, 0x70, 0x49, 0x85, 0xcc, 0x58, 0xd8, 0x8c, 0x85, 0x4e, 0x2e, 0x7c, 0x34,
		0x21, 0x24, 0x0a, 0x63, 0xfe, 0x18, 0x7f, 0x2c, 0x1f, 0x94, 0x8c, 0x53, 0xb1, 0x8e, 0xfc, 0x60,
		0xc6, 0x61, 0xd6, 0xd6, 0x78, 0xbd, 0xb1, 0xba, 0x83, 0xb7, 0x41, 0x10, 0x6a, 0x4f, 0xfb, 0x61,
		0xc0, 0xdb, 0xc7, 0x72, 0x16, 0xea, 0x41, 0x38, 0x1e, 0x8c, 0xc3, 0xc5, 0x43, 0xa4, 0xe2, 0x38,
		0x3d, 0x5c, 0x95, 0x37, 0x4d, 0x7f, 0x84, 0x48, 0xe2, 0x33, 0x0b, 0x5b, 0x70, 0x1f, 0xbd, 0x79,
		0xa2, 0xf8, 0xea, 0x9e, 0x4d, 0x23, 0x92, 0xe8, 0x46, 0x4d, 0xbd, 0x64, 0x9e, 0x8a, 0xda, 0x5f,
		0x74, 0xfa, 0x4c, 0xb2, 0x49, 0x83, 0x6c, 0x25, 0xd2, 0xbc, 0x3b, 0x18, 0x20, 0x18, 0x20, 0x18,
		0xa0, 0x1e, 0x19, 0x20, 0x23, 0x87, 0x85, 0xb9, 0x31, 0x37, 0x1e, 0x7f, 0x53, 0x0b, 0xef, 0xc1,
		0xd3, 0xdf, 0x52, 0xf6, 0x9c, 0x8f, 0xb5, 0x8a, 0x75, 0xf6, 0xd9, 0x79, 0x21, 0x7c, 0x2c, 0xfc,
		0x75, 0xbe, 0x71, 0x7c, 0xcf, 0x64, 0xfb, 0x68, 0xd8, 0x03, 0xc9, 0x8f, 0x62, 0xf8, 0x4f, 0x44,
		0xb3, 0x05, 0xe7, 0xbb, 0x8f, 0xce, 0x37, 0xd9, 0xcc, 0xe4, 0x94, 0x4e, 0x75, 0x31, 0x52, 0x53,
		0x0a, 0xb5, 0xb7, 0x76, 0xe5, 0x8a, 0x30, 0xf6, 0xe3, 0x46, 0x3d, 0x5e, 0xbe, 0xdc, 0x48, 0xfe,
		0x79, 0x2a, 0x79, 0x1d, 0x48, 0x7f, 0x33, 0xb0, 0x43, 0x02, 0x1a, 0x62, 0x84, 0xa3, 0x08, 0x47,
		0x69, 0x40, 0x95, 0x09, 0x70, 0x25, 0x14, 0x2b, 0xf8, 0x87, 0xa7, 0xe0, 0x1f, 0x52, 0xc5, 0x94,
		0x0b, 0xbc, 0x99, 0x01, 0x71, 0x86, 0x22, 0x2b, 0x16, 0x5d, 0x13, 0x11, 0x36, 0x14, 0x65, 0x53,
		0x91, 0xb6, 0x26, 0xda, 0xd6, 0x44, 0xdc, 0x5c, 0xd4, 0x79, 0x22, 0xcf, 0x14, 0x7d, 0xb1, 0x0a,
		0x88, 0x80, 0x44, 0x0b, 0xc0, 0xa2, 0x61, 0x9c, 0x6f, 0x4d, 0x39, 0x6c, 0x28, 0x89, 0x25, 0x65,
		0xb1, 0xa5, 0x34, 0xd6, 0x95, 0xc7, 0xba, 0x12, 0xd9, 0x53, 0x26, 0x99, 0x52, 0x09, 0x95, 0x4b,
		0x8e, 0x43, 0xd8, 0xc3, 0x25, 0x0c, 0x71, 0x0a, 0x5b, 0x14, 0x10, 0xe2, 0x18, 0xf6, 0x71, 0x0d,
		0x73, 0x41, 0x10, 0x90, 0x80, 0x09, 0xc4, 0x5a, 0x01, 0x66, 0xad, 0x00, 0xb5, 0x36, 0x80, 0x5b,
		0x21, 0x90, 0x0b, 0x83, 0x0f, 0x83, 0x0f, 0x83, 0x0f, 0x83, 0xdf, 0x03, 0x83, 0xdf, 0xa9, 0x03,
		0x6e, 0x48, 0x28, 0x21, 0x30, 0x6e, 0x88, 0x99, 0xcb, 0x49, 0xc4, 0x20, 0x8f, 0x28, 0xc4, 0x30,
		0x08, 0x2d, 0x84, 0x27, 0x0c, 0xe2, 0x6c, 0xc4, 0xd9, 0x1d, 0x9e, 0x08, 0x82, 0x9c, 0x41, 0xed,
		0x11, 0x70, 0x25, 0x98, 0x2b, 0xc8, 0x29, 0x1c, 0xc6, 0x3a, 0xc4, 0xda, 0xd3, 0x4a, 0x6e, 0x1f,
		0xb2, 0xe9, 0x07, 0x46, 0xe2, 0x46, 0xb0, 0x10, 0xb0, 0x10, 0x40, 0xe2, 0x10, 0x98, 0x21, 0x30,
		0x43, 0x60, 0x66, 0x18, 0x98, 0x1d, 0x04, 0xb8, 0x7a, 0xf0, 0x22, 0x15, 0xe8, 0x81, 0x15, 0x13,
		0xb3, 0xf3, 0x5b, 0xb0, 0x34, 0xb0, 0x34, 0xb0, 0x34, 0x9d, 0x3b, 0xfe, 0x36, 0x02, 0x80, 0xaa,
		0x40, 0x20, 0xff, 0x5f, 0x1a, 0x11, 0x1c, 0xd6, 0x88, 0x01, 0x7d, 0xff, 0xfe, 0x1f, 0xd0, 0x77,
		0x98, 0x5e, 0x98, 0xde, 0x1f, 0xd8, 0xc9, 0x3b, 0x2d, 0xb0, 0x3a, 0x43, 0x71, 0xba, 0x42, 0xa3,
		0xac, 0x5e, 0x36, 0xfb, 0xb0, 0xf6, 0xa1, 0x39, 0xb5, 0x74, 0xbf, 0xfa, 0xb1, 0x7e, 0xab, 0x35,
		0xf3, 0x8e, 0xda, 0xad, 0x1f, 0xfc, 0x3c, 0x57, 0xa9, 0xda, 0xc6, 0x3c, 0x7b, 0xeb, 0xde, 0x7a,
		0x4f, 0x3b, 0x33, 0x87, 0x6f, 0x2e, 0x2f, 0x5f, 0x5f, 0x5d, 0x5e, 0x5e, 0x5c, 0xfd, 0xef, 0xea,
		0xe2, 0xff, 0xaf, 0x5e, 0x0d, 0x5f, 0x0f, 0x5f, 0x31, 0x7e, 0xec, 0xf7, 0x8c, 0x4d, 0x3f, 0x19,
		0x40, 0xf8, 0x49, 0xac, 0x22, 0x2e, 0x42, 0x67, 0x60, 0x9c, 0x77, 0x0d, 0xf2, 0x56, 0xc8, 0xbe,
		0x4a, 0x62, 0x15, 0x2b, 0x86, 0xb8, 0x60, 0x7c, 0xd7, 0x94, 0xe8, 0x01, 0xe6, 0x9a, 0x33, 0xf5,
		0x4b, 0xfa, 0x40, 0xd9, 0xd6, 0xac, 0x2a, 0x89, 0x7a, 0xd2, 0x91, 0x37, 0x48, 0x82, 0x58, 0x7b,
		0x5f, 0xe7, 0xcc, 0xda, 0x9d, 0x1d, 0x9e, 0x71, 0xbd, 0x2c, 0x03, 0x78, 0x55, 0x20, 0xa4, 0xb6,
		0xf1, 0x55, 0x23, 0x61, 0xed, 0x0e, 0x63, 0xe5, 0x0b, 0xad, 0xe0, 0x00, 0x23, 0x8f, 0xbe, 0xeb,
		0x45, 0x5d, 0x96, 0xed, 0x03, 0xd0, 0x65, 0x25, 0x4c, 0xa2, 0x64, 0xac, 0x83, 0x8d, 0xdc, 0x6e,
		0x54, 0x39, 0x3d, 0x63, 0xfe, 0xde, 0xf9, 0xb7, 0x7b, 0x42, 0xd5, 0x61, 0xc5, 0x72, 0x94, 0x0e,
		0xca, 0x64, 0x68, 0x29, 0x2a, 0x56, 0x4a, 0x8a, 0x5d, 0x16, 0x33, 0x42, 0x59, 0x8c, 0xc5, 0x00,
		0x07, 0x5d, 0x1a, 0xba, 0x8a, 0xd6, 0x51, 0x04, 0x83, 0x22, 0x69, 0xfe, 0x29, 0x43, 0xb0, 0x42,
		0x82, 0x14, 0x86, 0x3c, 0x65, 0x01, 0xcd, 0x82, 0x66, 0x59, 0xd0, 0x2c, 0x3e, 0xe4, 0x2f, 0x81,
		0xf8, 0xf7, 0x21, 0xfd, 0x82, 0x7b, 0x44, 0x46, 0xf5, 0xed, 0xe8, 0x69, 0x14, 0x0e, 0x84, 0xfd,
		0x4a, 0xf2, 0x99, 0xd0, 0x51, 0xe8, 0x28, 0x4e, 0xbf, 0xc2, 0x9a, 0x68, 0x01, 0x04, 0xfd, 0x86,
		0x7e, 0x1f, 0xa9, 0x7e, 0x1f, 0x01, 0x86, 0x42, 0x48, 0xc0, 0xac, 0x2c, 0xb5, 0xc5, 0x6c, 0x4d,
		0xa0, 0xd0, 0x12, 0x26, 0xf4, 0x04, 0x49, 0x29, 0x21, 0xd2, 0x90, 0xfd, 0x60, 0x64, 0x3b, 0x38,
		0xc0, 0x31, 0x47, 0xfd, 0xc5, 0x80, 0xb0, 0x48, 0xd5, 0x99, 0x40, 0xaf, 0x0c, 0x3e, 0x23, 0x67,
		0x1b, 0xea, 0x24, 0x86, 0x91, 0x4d, 0xe0, 0x64, 0x0f, 0x18, 0x48, 0x19, 0x31, 0x3b, 0x60, 0x02,
		0x95, 0xb1, 0xd1, 0x7f, 0x3b, 0x70, 0x19, 0x0d, 0xdd, 0x5f, 0x09, 0xc5, 0xe2, 0x8e, 0xc5, 0x67,
		0xa2, 0xa9, 0x93, 0x99, 0x38, 0xb7, 0x11, 0xe0, 0xad, 0x81, 0xd4, 0xab, 0x29, 0xb3, 0x62, 0xf6,
		0x77, 0x6e, 0xd9, 0x17, 0x79, 0x3f, 0xc5, 0xa7, 0xf9, 0xbe, 0xe6, 0xce, 0x7a, 0xb9, 0x18, 0x2d,
		0x92, 0xb9, 0xf6, 0xef, 0xd5, 0x92, 0xde, 0xb6, 0x7b, 0x6f, 0xc6, 0x61, 0x3a, 0x78, 0x47, 0xbd,
		0x6c, 0xe1, 0x1d, 0x59, 0xef, 0xe1, 0x5d, 0x22, 0x2f, 0xbd, 0x9d, 0x77, 0x79, 0x22, 0x3a, 0x7b,
		0xa3, 0xb3, 0xb7, 0x95, 0x40, 0x08, 0x39, 0xa3, 0x9e, 0xe6, 0x8c, 0x86, 0xa2, 0xa4, 0xd1, 0x10,
		0xb8, 0x19, 0xe2, 0xea, 0x1f, 0x28, 0xae, 0x3e, 0x8d, 0xde, 0xde, 0xf7, 0x6a, 0x39, 0x12, 0xa9,
		0xfb, 0x08, 0xea, 0x0e, 0x75, 0x3f, 0x9c, 0xba, 0x27, 0x7e, 0xa0, 0x5f, 0x5f, 0x0a, 0xd4, 0xfd,
		0x0d, 0x63, 0xca, 0x27, 0x2f, 0x98, 0xa9, 0x43, 0xdc, 0xfa, 0xbb, 0xf5, 0xe5, 0xfd, 0x4c, 0xdc,
		0x3f, 0x37, 0x58, 0xbc, 0xb4, 0x06, 0xe2, 0x7d, 0xe4, 0x8d, 0x53, 0x7b, 0x75, 0xe3, 0xcf, 0x7c,
		0xee, 0xe5, 0xde, 0x22, 0x6f, 0xd4, 0xcc, 0xd3, 0xfe, 0x63, 0xfa, 0x2c, 0x53, 0x6f, 0x1e, 0xab,
		0x83, 0x54, 0xe1, 0xdc, 0x7a, 0x4f, 0xe6, 0xa4, 0x33, 0xbb, 0x94, 0xdc, 0x57, 0x6a, 0xfe, 0xd0,
		0x57, 0x1e, 0xf1, 0x2e, 0x8c, 0xe6, 0x49, 0xdb, 0x44, 0xd8, 0x4e, 0xb8, 0x8e, 0x9c, 0x18, 0x0e,
		0x73, 0xf8, 0xee, 0x47, 0x6a, 0x8b, 0x7a, 0x92, 0xb4, 0x1b, 0x44, 0x61, 0xa8, 0x17, 0xe1, 0xe4,
		0xbc, 0x0e, 0xa6, 0xad, 0xfb, 0xa2, 0xdb, 0x97, 0x66, 0x0c, 0x59, 0x6f, 0xcd, 0x18, 0xe2, 0xb5,
		0x19, 0x78, 0x6d, 0xc6, 0xf3, 0xbc, 0x36, 0x63, 0xd8, 0x91, 0x02, 0x8c, 0x58, 0x0a, 0x30, 0x82,
		0x02, 0x40, 0x01, 0x9e, 0x47, 0x01, 0x46, 0xa8, 0x88, 0x81, 0x0a, 0x20, 0xbb, 0x81, 0x08, 0x09,
		0x11, 0x52, 0x9f, 0x22, 0x24, 0x24, 0x0f, 0xa0, 0x4d, 0x27, 0xa3, 0x4d, 0x48, 0x1e, 0xec, 0x21,
		0xe0, 0x48, 0x1e, 0x88, 0x49, 0x87, 0xe4, 0x81, 0xfd, 0xe4, 0x01, 0x4a, 0xbf, 0x70, 0x2c, 0xc1,
		0xc9, 0xeb, 0xa5, 0x93, 0x87, 0x8c, 0x17, 0x54, 0x1d, 0xaa, 0xee, 0xa0, 0x0a, 0xec, 0xb9, 0x13,
		0x4a, 0xcf, 0x52, 0x23, 0x36, 0x74, 0x1a, 0xc2, 0xd5, 0x8e, 0x2b, 0xc5, 0x78, 0x8e, 0x26, 0x8a,
		0xc7, 0x50, 0x3c, 0x26, 0x65, 0xb2, 0x83, 0xe2, 0x31, 0x6a, 0xe8, 0xd2, 0x5d, 0xf1, 0x98, 0xd8,
		0x32, 0xb2, 0x4b, 0xcb, 0x6e, 0xf3, 0xf9, 0x16, 0x8b, 0xcc, 0x92, 0x59, 0xca, 0x16, 0x35, 0xa9,
		0x14, 0xdd, 0x96, 0x5a, 0xa3, 0xf3, 0x68, 0x71, 0x4d, 0xac, 0x03, 0xdb, 0x3b, 0x20, 0x51, 0x70,
		0x24, 0x71, 0x94, 0x2c, 0x17, 0x1c, 0x71, 0xab, 0xcc, 0xf6, 0x28, 0xcc, 0x17, 0x6d, 0x07, 0x25,
		0x49, 0x1d, 0x9a, 0xd6, 0x03, 0x24, 0xed, 0x88, 0x4e, 0x16, 0xcf, 0xd9, 0xe2, 0x3b, 0x5d, 0x56,
		0x9c, 0x2f, 0x81, 0x13, 0x26, 0x3d, 0xa7, 0xa5, 0xa1, 0x9c, 0x71, 0xab, 0x57, 0xa3, 0x30, 0x4e,
		0xd8, 0xd2, 0xd5, 0x0e, 0x84, 0xc1, 0xee, 0x37, 0xdc, 0x26, 0xba, 0x82, 0xfe, 0xc2, 0x92, 0xbe,
		0xc2, 0x92, 0x54, 0x07, 0xaf, 0x8f, 0xb0, 0x0d, 0x4c, 0x40, 0xdc, 0x37, 0xd8, 0x2e, 0x2e, 0xc0,
		0xeb, 0x13, 0x6c, 0xeb, 0x9e, 0xe6, 0x9d, 0xdd, 0x78, 0xb4, 0xc5, 0xe9, 0xba, 0xb3, 0x56, 0xd9,
		0xdf, 0xea, 0x6c, 0x92, 0x8a, 0xfd, 0xf5, 0x37, 0x15, 0x0d, 0x26, 0x9e, 0xf6, 0x1a, 0xca, 0xfb,
		0xbf, 0x8f, 0x39, 0x4c, 0x41, 0x7f, 0x2f, 0xeb, 0xf9, 0xad, 0x95, 0xf3, 0xb7, 0x54, 0x76, 0xd3,
		0x2a, 0xba, 0xe1, 0x3b, 0xf7, 0xc9, 0x77, 0x5e, 0x84, 0x7a, 0x42, 0x77, 0x94, 0xd7, 0xa3, 0x71,
		0x9b, 0x13, 0xb7, 0x39, 0xf9, 0xd8, 0x32, 0x11, 0x53, 0xb6, 0x8d, 0x05, 0x8b, 0xab, 0x25, 0x6c,
		0xa1, 0xb9, 0x36, 0xfa, 0xfa, 0xe4, 0xa7, 0x58, 0x63, 0x5d, 0x43, 0xc5, 0xf9, 0x5d, 0x71, 0x1a,
		0x35, 0xdf, 0x5e, 0x25, 0xdd, 0x5a, 0x25, 0x5b, 0xf0, 0x11, 0x2c, 0x38, 0x2c, 0x38, 0x2c, 0xf8,
		0x89, 0x59, 0xf0, 0x5e, 0x1a, 0xce, 0x86, 0xfc, 0xdd, 0x21, 0x3b, 0x9a, 0xd5, 0xc5, 0x23, 0x55,
		0x70, 0x79, 0x3a, 0xf6, 0x26, 0x1d, 0x4a, 0x08, 0x86, 0x92, 0xa0, 0xd8, 0x2c, 0xad, 0x36, 0x22,
		0x2a, 0x0f, 0x44, 0x58, 0x64, 0x1e, 0x16, 0x15, 0x69, 0xda, 0x7e, 0xb6, 0x96, 0xc6, 0x23, 0x4c,
		0x42, 0x4f, 0x33, 0x1c, 0xb4, 0xc7, 0x76, 0xd0, 0xe2, 0x3d, 0x38, 0xd6, 0x84, 0xcb, 0x26, 0x1e,
		0x8c, 0x3b, 0x62, 0xe8, 0x8a, 0x80, 0x0e, 0x2d, 0xfb, 0x93, 0xf0, 0xaa, 0x02, 0x18, 0x20, 0x18,
		0xa0, 0x23, 0x37, 0x40, 0x7d, 0x79, 0x97, 0x42, 0x29, 0x88, 0x2c, 0xfd, 0xdd, 0x6d, 0xf3, 0x15,
		0x56, 0xeb, 0x09, 0x20, 0x5d, 0x40, 0xba, 0x9e, 0xa7, 0xf3, 0x04, 0x1a, 0x4f, 0x40, 0x03, 0x10,
		0x82, 0xc2, 0x03, 0x84, 0x07, 0xd8, 0x1f, 0x0f, 0x10, 0x11, 0x1e, 0x22, 0x3c, 0xe8, 0xf7, 0x29,
		0xeb, 0xf7, 0x91, 0x04, 0x50, 0x27, 0xf4, 0x42, 0x3a, 0x83, 0x32, 0xc3, 0x20, 0x99, 0xcf, 0x19,
		0xc5, 0x73, 0xf5, 0xad, 0x29, 0x3a, 0xcc, 0x40, 0x37, 0x33, 0x9a, 0x5e, 0x3b, 0xf5, 0x65, 0x3b,
		0xaf, 0x17, 0x2f, 0xe6, 0x2a, 0x27, 0x91, 0xeb, 0x12, 0xd4, 0x67, 0x3b, 0xeb, 0xd6, 0xad, 0xe7,
		0xfa, 0xf1, 0xbb, 0x1c, 0x32, 0xf9, 0xbc, 0xfe, 0xfd, 0x3d, 0xfb, 0xe8, 0xfa, 0xf1, 0x7b, 0xef,
		0x5e, 0x7d, 0x0a, 0xc3, 0x7d, 0xdb, 0x59, 0x7e, 0x4e, 0x77, 0xf7, 0xab, 0x02, 0x0d, 0x6f, 0xd4,
		0xa3, 0x3f, 0xde, 0xa8, 0xd5, 0xea, 0x6c, 0xf5, 0x1f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00,
		0x00, 0xff, 0xff, 0x4b, 0xb8, 0x23, 0xfa, 0x27, 0xc8, 0x00, 0x00,
	}
)

// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
func initΛEnumTypes() {
	ΛEnumTypes = map[string][]reflect.Type{}
}
