/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.teleport;

import com.ubnt.data.Site;
import com.ubnt.model.api.teleport.ImmutableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.ModifiableTeleportTokenListParameter;
import com.ubnt.model.api.teleport.TeleportAccessRequestDto;
import com.ubnt.model.api.teleport.TeleportAccessResponseDto;
import com.ubnt.model.api.teleport.TeleportInvitationDto;
import com.ubnt.model.api.teleport.TeleportInvitationListDto;
import com.ubnt.model.api.teleport.TeleportTokenDto;
import com.ubnt.model.api.teleport.TeleportTokenListDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.config.security.annotation.RequireConsoleOwner;
import com.ubnt.net.v2.config.security.annotation.RequireWritePrivileges;
import com.ubnt.service.teleport.A;
import com.ubnt.service.teleport.OO0o;
import com.ubnt.service.teleport.TeleportTokenDocument;
import com.ubnt.service.teleport.float;
import com.ubnt.service.teleport.int;
import com.ubnt.service.teleport.nullsuper;
import com.ubnt.service.teleport.o0o0;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Teleport")
public class TeleportController {
    private static final String \u00d200000 = "https://teleport.ui.link/";
    private static final String \u00d300000 = "********-****-****-****-********";
    private final o0o0 super;

    public TeleportController(o0o0 o0o02) {
        this.super = o0o02;
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/token"})
    @Operation(summary="Create new Teleport short-term token")
    @AllowUCoreLocal
    public Publisher<TeleportTokenDto> createNewToken(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d600000(site.getId()).map(o0o0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO -> {
            String string = this.\u00d600000(o0o0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.\u00d300000());
            return TeleportTokenDto.ofDocument(o0o0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.new(), string);
        });
    }

    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @Operation(summary="Return paginated list of Teleport invitation history", description="Since 7.2.67")
    @AllowUCoreLocal
    public TeleportInvitationListDto searchInvitationHistory(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        OO0o oO0o2 = this.super(modifiableTeleportTokenListParameter, site);
        int intVal = this.super.\u00f800000(oO0o2);
        return TeleportInvitationListDto.builder().totalElementCount(intVal.\u00d300000()).totalPageCount(intVal.\u00d400000()).pageNumber(intVal.super()).data(this.\u00f400000(intVal.\u00d200000())).build();
    }

    @RequireWritePrivileges
    @PostMapping(value={"/api/site/{siteName}/teleport/invitation-history"})
    @Operation(summary="Return paginated list of Teleport invitation history", description="Since 8.0.22")
    @AllowUCoreLocal
    public TeleportInvitationListDto postSearchInvitationHistory(@PathVariable(value="siteName") Site site, @RequestBody @Valid ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        return this.searchInvitationHistory(site, modifiableTeleportTokenListParameter);
    }

    @Deprecated
    @RequireWritePrivileges
    @GetMapping(value={"/api/site/{siteName}/teleport/token"})
    @Operation(summary="Return paginated list of Teleport active short-term tokens", description="Since 7.1.2")
    public TeleportTokenListDto searchActiveShortTermTokens(@PathVariable(value="siteName") Site site, ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter) {
        OO0o oO0o2 = this.super(modifiableTeleportTokenListParameter, site);
        A a2 = this.super.\u00f500000(oO0o2);
        return TeleportTokenListDto.builder().totalElementCount(a2.\u00d300000()).totalPageCount(a2.\u00d400000()).pageNumber(a2.super()).data(this.\u00d400000(a2.\u00d200000())).build();
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/token/{tokenId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Remove Teleport short-term token", description="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> removeShortTermToken(@PathVariable(value="siteName") Site site, @PathVariable(value="tokenId") String string) {
        return this.super.for(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/disconnect-client/{clientId}"})
    @Operation(summary="Disconnect Teleport client", description="Since 7.1.2")
    @AllowUCoreLocal
    public Publisher<Void> disconnectClient(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.super.o00000(site.getId(), string).flatMap(teleportClientDocument -> Mono.empty());
    }

    @DeleteMapping(value={"/api/site/{siteName}/teleport/client/{clientId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Remove client and their token")
    @AllowUCoreLocal
    public Publisher<Void> removeClientAndToken(@PathVariable(value="siteName") Site site, @PathVariable(value="clientId") String string) {
        return this.super.\u00d500000(site.getId(), string).flatMap(teleportTokenDocument -> Mono.empty());
    }

    @PostMapping(value={"/api/site/{siteName}/teleport/access-request"})
    @Operation(summary="Create new Teleport long-term token", description="Since 7.2.6")
    @RequireConsoleOwner
    public Publisher<TeleportAccessResponseDto> createNewLongTermTokenForOwner(@PathVariable(value="siteName") Site site, @Valid @RequestBody TeleportAccessRequestDto teleportAccessRequestDto) {
        return this.super.\u00d300000(site.getId(), float.super(teleportAccessRequestDto)).map(TeleportAccessResponseDto::ofDocument);
    }

    private OO0o super(ModifiableTeleportTokenListParameter modifiableTeleportTokenListParameter, Site site) {
        ImmutableTeleportTokenListParameter immutableTeleportTokenListParameter = modifiableTeleportTokenListParameter.toImmutable();
        return OO0o.o00000().\u00d800000(site.getId()).\u00d200000(immutableTeleportTokenListParameter.getPageNumber()).String(immutableTeleportTokenListParameter.getPageSize()).\u00d300000();
    }

    private String \u00d600000(String string) {
        return \u00d200000 + string;
    }

    private List<TeleportTokenDto> \u00d400000(List<TeleportTokenDocument> list) {
        return list.stream().map(this::class).collect(Collectors.toList());
    }

    private TeleportTokenDto class(TeleportTokenDocument teleportTokenDocument) {
        String string = this.\u00d200000(teleportTokenDocument.getSecretIdentifier());
        return TeleportTokenDto.ofDocument(teleportTokenDocument, string);
    }

    private List<TeleportInvitationDto> \u00f400000(List<nullsuper> list) {
        return list.stream().map(nullsuper2 -> TeleportInvitationDto.builder().client(nullsuper2.\u00f400000()).creationTimestamp(nullsuper2.\u00d600000()).expirationTimestamp(nullsuper2.\u00d400000()).invitationStatus(nullsuper2.\u00d800000()).invitationTokenId(nullsuper2.\u00d300000()).invitationUrl(this.\u00d200000(nullsuper2.super())).tokenId(nullsuper2.class()).build()).collect(Collectors.toList());
    }

    private String \u00d200000(String string) {
        return "https://teleport.ui.link/********-****-****-****-********" + string;
    }
}

