/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Device;
import com.ubnt.data.Model;
import com.ubnt.data.X;

public class WirelessStats {
    @JsonProperty(value="accessPointModel")
    private final Model accessPointModel;
    @JsonProperty(value="accessPointFwVersion")
    private final String accessPointFwVersion;
    @JsonProperty(value="accessPointAnonymousId")
    private final String accessPointAnonymousId;
    @JsonProperty(value="radio")
    private final String radio;
    @JsonProperty(value="radioProtocol")
    private final String radioProtocol;
    @JsonProperty(value="dailyAvgSatisfaction")
    private Double dailyAvgSatisfaction;

    private WirelessStats(Builder builder) {
        this.accessPointModel = builder.accessPointModel;
        this.accessPointFwVersion = builder.accessPointFwVersion;
        this.accessPointAnonymousId = builder.accessPointAnonymousId;
        this.radio = builder.radio;
        this.radioProtocol = builder.radioProtocol;
        this.dailyAvgSatisfaction = builder.dailyAvgSatisfaction;
    }

    public Model getAccessPointModel() {
        return this.accessPointModel;
    }

    public String getAccessPointFwVersion() {
        return this.accessPointFwVersion;
    }

    public String getAccessPointAnonymousId() {
        return this.accessPointAnonymousId;
    }

    public String getRadio() {
        return this.radio;
    }

    public String getRadioProtocol() {
        return this.radioProtocol;
    }

    public Double getDailyAvgSatisfaction() {
        return this.dailyAvgSatisfaction;
    }

    public static Builder buildFrom(X x2) {
        return new Builder().setWirelessClientStats(x2);
    }

    public static class Builder {
        private Model accessPointModel;
        private String accessPointFwVersion;
        private String accessPointAnonymousId;
        private String radio;
        private String radioProtocol;
        private Double dailyAvgSatisfaction;

        private Builder() {
        }

        public Builder setAccessPointStats(Device device) {
            if (device != null) {
                this.accessPointModel = device.getModel();
                this.accessPointFwVersion = device.getFirmwareVersion();
                this.accessPointAnonymousId = device.getAnonymousDeviceId();
            }
            return this;
        }

        public Builder setWirelessClientStats(X x2) {
            this.radio = x2.getString("radio");
            this.radioProtocol = x2.getString("radio_proto");
            return this;
        }

        public Builder setDailyAvgSatisfaction(Double d2) {
            this.dailyAvgSatisfaction = d2;
            return this;
        }

        public WirelessStats build() {
            return new WirelessStats(this);
        }
    }
}

