/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.util.RandomRegistry;

public enum BitGene implements Gene<Boolean, BitGene>,
Comparable<BitGene>
{
    FALSE(false),
    TRUE(true);

    private static final long serialVersionUID = 3L;
    public static final BitGene ZERO;
    public static final BitGene ONE;
    private final boolean _value;

    private BitGene(boolean value) {
        this._value = value;
    }

    public final boolean getBit() {
        return this._value;
    }

    public boolean booleanValue() {
        return this._value;
    }

    @Override
    public Boolean getAllele() {
        return this._value;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public BitGene newInstance() {
        return RandomRegistry.getRandom().nextBoolean() ? TRUE : FALSE;
    }

    @Override
    public BitGene newInstance(Boolean value) {
        return BitGene.of(value);
    }

    public String toString() {
        return Boolean.toString(this._value);
    }

    public static BitGene of(boolean value) {
        return value ? TRUE : FALSE;
    }

    static {
        ZERO = FALSE;
        ONE = TRUE;
    }
}

