/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.tokenizer.text.buffered;

import java.io.IOException;
import java.io.Reader;
import lombok.NonNull;
import org.vinniks.parsla.tokenizer.text.CharacterIterator;
import org.vinniks.parsla.tokenizer.text.buffered.CharacterBufferProvider;

public class BufferedCharacterIterator
implements CharacterIterator {
    private final Reader source;
    private final CharacterBufferProvider characterBufferProvider;
    private final char[] buffer;
    private int charactersRead = 0;
    private int i;

    public BufferedCharacterIterator(@NonNull Reader source, @NonNull CharacterBufferProvider characterBufferProvider) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (characterBufferProvider == null) {
            throw new NullPointerException("characterBufferProvider is marked non-null but is null");
        }
        this.source = source;
        this.characterBufferProvider = characterBufferProvider;
        this.buffer = characterBufferProvider.acquireBuffer();
        if (this.buffer.length == 0) {
            throw new IllegalArgumentException("buffer size can not be 0");
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        this.ensureNext();
        return this.charactersRead != -1;
    }

    @Override
    public char next() throws IOException {
        this.ensureNext();
        return this.buffer[this.i++];
    }

    @Override
    public void close() {
        this.characterBufferProvider.releaseBuffer(this.buffer);
    }

    private void ensureNext() throws IOException {
        if (this.charactersRead == 0 || this.charactersRead > 0 && this.i >= this.charactersRead) {
            this.charactersRead = this.source.read(this.buffer);
            this.i = 0;
        }
    }
}

