/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public final class NetworkActivityWidgetData {
    private final TrafficStatData trafficStatTotal;
    private final List<TrafficHistoryEntry> trafficHistory;

    @ConstructorProperties(value={"trafficStatTotal", "trafficHistory"})
    @Generated
    NetworkActivityWidgetData(TrafficStatData trafficStatData, List<TrafficHistoryEntry> list) {
        this.trafficStatTotal = trafficStatData;
        this.trafficHistory = list;
    }

    @Generated
    public static NetworkActivityWidgetDataBuilder builder() {
        return new NetworkActivityWidgetDataBuilder();
    }

    @Generated
    public TrafficStatData getTrafficStatTotal() {
        return this.trafficStatTotal;
    }

    @Generated
    public List<TrafficHistoryEntry> getTrafficHistory() {
        return this.trafficHistory;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NetworkActivityWidgetData)) {
            return false;
        }
        NetworkActivityWidgetData networkActivityWidgetData = (NetworkActivityWidgetData)object;
        TrafficStatData trafficStatData = this.getTrafficStatTotal();
        TrafficStatData trafficStatData2 = networkActivityWidgetData.getTrafficStatTotal();
        if (trafficStatData == null ? trafficStatData2 != null : !((Object)trafficStatData).equals(trafficStatData2)) {
            return false;
        }
        List<TrafficHistoryEntry> list = this.getTrafficHistory();
        List<TrafficHistoryEntry> list2 = networkActivityWidgetData.getTrafficHistory();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        TrafficStatData trafficStatData = this.getTrafficStatTotal();
        n2 = n2 * 59 + (trafficStatData == null ? 43 : ((Object)trafficStatData).hashCode());
        List<TrafficHistoryEntry> list = this.getTrafficHistory();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "NetworkActivityWidgetData(trafficStatTotal=" + String.valueOf(this.getTrafficStatTotal()) + ", trafficHistory=" + String.valueOf(this.getTrafficHistory()) + ")";
    }

    public static final class TrafficStatData {
        private final long rxBytes;
        private final long txBytes;
        private final long duration;

        public static TrafficStatData empty() {
            return new TrafficStatData(0L, 0L, 0L);
        }

        public long getBytes() {
            return this.rxBytes + this.txBytes;
        }

        public long getRxRate() {
            return this.o00000(this.rxBytes);
        }

        public long getTxRate() {
            return this.o00000(this.txBytes);
        }

        public boolean hasTraffic() {
            return this.rxBytes > 0L || this.txBytes > 0L;
        }

        public TrafficStatData add(TrafficStatData trafficStatData) {
            return new TrafficStatData(this.rxBytes + trafficStatData.rxBytes, this.txBytes + trafficStatData.txBytes, this.duration + trafficStatData.duration);
        }

        private long o00000(long l2) {
            return this.duration > 0L ? l2 / this.duration : 0L;
        }

        @ConstructorProperties(value={"rxBytes", "txBytes", "duration"})
        @Generated
        TrafficStatData(long l2, long l3, long l4) {
            this.rxBytes = l2;
            this.txBytes = l3;
            this.duration = l4;
        }

        @Generated
        public static TrafficStatDataBuilder builder() {
            return new TrafficStatDataBuilder();
        }

        @Generated
        public long getRxBytes() {
            return this.rxBytes;
        }

        @Generated
        public long getTxBytes() {
            return this.txBytes;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TrafficStatData)) {
                return false;
            }
            TrafficStatData trafficStatData = (TrafficStatData)object;
            if (this.getRxBytes() != trafficStatData.getRxBytes()) {
                return false;
            }
            if (this.getTxBytes() != trafficStatData.getTxBytes()) {
                return false;
            }
            return this.getDuration() == trafficStatData.getDuration();
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            long l2 = this.getRxBytes();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getTxBytes();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getDuration();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            return n2;
        }

        @Generated
        public String toString() {
            return "NetworkActivityWidgetData.TrafficStatData(rxBytes=" + this.getRxBytes() + ", txBytes=" + this.getTxBytes() + ", duration=" + this.getDuration() + ")";
        }

        @Generated
        public static class TrafficStatDataBuilder {
            @Generated
            private long rxBytes;
            @Generated
            private long txBytes;
            @Generated
            private long duration;

            @Generated
            TrafficStatDataBuilder() {
            }

            @Generated
            public TrafficStatDataBuilder rxBytes(long l2) {
                this.rxBytes = l2;
                return this;
            }

            @Generated
            public TrafficStatDataBuilder txBytes(long l2) {
                this.txBytes = l2;
                return this;
            }

            @Generated
            public TrafficStatDataBuilder duration(long l2) {
                this.duration = l2;
                return this;
            }

            @Generated
            public TrafficStatData build() {
                return new TrafficStatData(this.rxBytes, this.txBytes, this.duration);
            }

            @Generated
            public String toString() {
                return "NetworkActivityWidgetData.TrafficStatData.TrafficStatDataBuilder(rxBytes=" + this.rxBytes + ", txBytes=" + this.txBytes + ", duration=" + this.duration + ")";
            }
        }
    }

    @Generated
    public static class NetworkActivityWidgetDataBuilder {
        @Generated
        private TrafficStatData trafficStatTotal;
        @Generated
        private List<TrafficHistoryEntry> trafficHistory;

        @Generated
        NetworkActivityWidgetDataBuilder() {
        }

        @Generated
        public NetworkActivityWidgetDataBuilder trafficStatTotal(TrafficStatData trafficStatData) {
            this.trafficStatTotal = trafficStatData;
            return this;
        }

        @Generated
        public NetworkActivityWidgetDataBuilder trafficHistory(List<TrafficHistoryEntry> list) {
            this.trafficHistory = list;
            return this;
        }

        @Generated
        public NetworkActivityWidgetData build() {
            return new NetworkActivityWidgetData(this.trafficStatTotal, this.trafficHistory);
        }

        @Generated
        public String toString() {
            return "NetworkActivityWidgetData.NetworkActivityWidgetDataBuilder(trafficStatTotal=" + String.valueOf(this.trafficStatTotal) + ", trafficHistory=" + String.valueOf(this.trafficHistory) + ")";
        }
    }

    public static final class TrafficHistoryEntry {
        private final long timestamp;
        private final long clientCount;
        private final TrafficStatData total;

        public static TrafficHistoryEntry empty(long l2) {
            return TrafficHistoryEntry.builder().timestamp(l2).total(TrafficStatData.empty()).build();
        }

        @ConstructorProperties(value={"timestamp", "clientCount", "total"})
        @Generated
        TrafficHistoryEntry(long l2, long l3, TrafficStatData trafficStatData) {
            this.timestamp = l2;
            this.clientCount = l3;
            this.total = trafficStatData;
        }

        @Generated
        public static TrafficHistoryEntryBuilder builder() {
            return new TrafficHistoryEntryBuilder();
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getClientCount() {
            return this.clientCount;
        }

        @Generated
        public TrafficStatData getTotal() {
            return this.total;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TrafficHistoryEntry)) {
                return false;
            }
            TrafficHistoryEntry trafficHistoryEntry = (TrafficHistoryEntry)object;
            if (this.getTimestamp() != trafficHistoryEntry.getTimestamp()) {
                return false;
            }
            if (this.getClientCount() != trafficHistoryEntry.getClientCount()) {
                return false;
            }
            TrafficStatData trafficStatData = this.getTotal();
            TrafficStatData trafficStatData2 = trafficHistoryEntry.getTotal();
            return !(trafficStatData == null ? trafficStatData2 != null : !((Object)trafficStatData).equals(trafficStatData2));
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            long l2 = this.getTimestamp();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getClientCount();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            TrafficStatData trafficStatData = this.getTotal();
            n2 = n2 * 59 + (trafficStatData == null ? 43 : ((Object)trafficStatData).hashCode());
            return n2;
        }

        @Generated
        public String toString() {
            return "NetworkActivityWidgetData.TrafficHistoryEntry(timestamp=" + this.getTimestamp() + ", clientCount=" + this.getClientCount() + ", total=" + String.valueOf(this.getTotal()) + ")";
        }

        @Generated
        public static class TrafficHistoryEntryBuilder {
            @Generated
            private long timestamp;
            @Generated
            private long clientCount;
            @Generated
            private TrafficStatData total;

            @Generated
            TrafficHistoryEntryBuilder() {
            }

            @Generated
            public TrafficHistoryEntryBuilder timestamp(long l2) {
                this.timestamp = l2;
                return this;
            }

            @Generated
            public TrafficHistoryEntryBuilder clientCount(long l2) {
                this.clientCount = l2;
                return this;
            }

            @Generated
            public TrafficHistoryEntryBuilder total(TrafficStatData trafficStatData) {
                this.total = trafficStatData;
                return this;
            }

            @Generated
            public TrafficHistoryEntry build() {
                return new TrafficHistoryEntry(this.timestamp, this.clientCount, this.total);
            }

            @Generated
            public String toString() {
                return "NetworkActivityWidgetData.TrafficHistoryEntry.TrafficHistoryEntryBuilder(timestamp=" + this.timestamp + ", clientCount=" + this.clientCount + ", total=" + String.valueOf(this.total) + ")";
            }
        }
    }
}

